function zakekeDesigner(config) {
    if (window.zakekeDesignerFirstRun) {
        return;
    }
    window.zakekeDesignerFirstRun = true;

    function cleanParams(params) {
        let updatedParams = Object.assign({}, params);
        delete updatedParams['save-account-details-nonce'];
        return updatedParams;
    }
    
    var productDataCache = {},
        pendingProductDataRequests = [],
        container = document.getElementById('zakeke-container'),
        iframe = container.querySelector('iframe'),
        productAttributes = function (promiseId) {
            jQuery.ajax({
                url: config.wc_ajax_url.replace('%%endpoint%%', 'zakeke_get_attributes'),
                type: 'POST',
                data: cleanParams(config.params)
            })
            .done(function (product) {
                if (typeof product === 'string' || product instanceof String) {
                    product = JSON.parse(product.trim());
                }

                product.promiseId = promiseId;

                iframe.contentWindow.postMessage({
                    data: product,
                    zakekeMessageType: 2
                }, '*');
            });
        },
        productPrice = function (data) {
            var promiseId = data.promiseId;
            delete data['promiseId'];

            var params = cleanParams(Object.assign({}, config.params, data)),
                queryString = jQuery.param(params),
                cached = productDataCache[queryString];

            delete params['save-account-details-nonce'];

            if (cached !== undefined) {
                var productData = Object.assign({}, cached);
                productData.promiseId = promiseId;

                iframe.contentWindow.postMessage({
                    data: productData,
                    zakekeMessageType: 3
                }, '*');
                return;
            }

            jQuery.ajax({
                url: config.wc_ajax_url.replace('%%endpoint%%', 'zakeke_get_price'),
                type: 'POST',
                data: params
            })
                .done(function (product) {
                    if (typeof product === 'string' || product instanceof String) {
                        product = JSON.parse(product.trim());
                    }

                    var productData = {
                        isOutOfStock: !(product.is_purchasable && product.is_in_stock),
                        finalPrice: product.price_including_tax
                    };
                    productDataCache[queryString] = Object.assign({}, productData);

                    productData.promiseId = promiseId;

                    iframe.contentWindow.postMessage({
                        data: productData,
                        zakekeMessageType: 3
                    }, '*');
                });
        },
        updatedParams = function (color, zakekeOptions) {
            if (color == null) {
                throw new Error('color param is null');
            }

            var params = jQuery.extend({}, config.params),
                colorObj = JSON.parse(color);

            colorObj.forEach(function (val) {
                params['attribute_' + val.Id] = val.Value.Id;
            });

            if (zakekeOptions != null) {
                params = jQuery.extend(params, zakekeOptions);
            }

            return params;
        },
        emitProductDataEvent = function (productData) {
            iframe.contentWindow.postMessage({
                data: productData,
                zakekeMessageType: 1
            }, '*');
        },
        productData = function (color, zakekeOptions) {
            var params = cleanParams(updatedParams(color, zakekeOptions)),
                queryString = jQuery.param(params),
                cached = productDataCache[queryString];

            if (cached !== undefined) {
                emitProductDataEvent(cached);
                return;
            }

            if (pendingProductDataRequests.indexOf(queryString) !== -1) {
                return;
            }

            pendingProductDataRequests.push(queryString);

            jQuery.ajax({
                url: config.wc_ajax_url.replace('%%endpoint%%', 'zakeke_get_price'),
                type: 'POST',
                data: params
            })
            .done(function (product) {
                if (typeof product === 'string' || product instanceof String) {
                    product = JSON.parse(product.trim());
                }

                var productData = {
                    color: color,
                    isOutOfStock: !(product.is_purchasable && product.is_in_stock),
                    finalPrice: product.price_including_tax
                };
                productDataCache[queryString] = productData;
                emitProductDataEvent(productData);
            })
            .fail(function (request, status, error) {
                console.log(request + ' ' + status + ' ' + error);
                var productData = {
                    color: color,
                    isOutOfStock: true
                };
                productDataCache[queryString] = productData;
                emitProductDataEvent(productData);
            })
            .always(function () {
                var index = pendingProductDataRequests.indexOf(queryString);
                if (index !== -1) {
                    pendingProductDataRequests.splice(index, 1);
                }
            });
        },
        createCartSubInput = function (form, value, key, prevKey) {
            if (value instanceof String || typeof(value) !== 'object') {
                createCartInput(form, prevKey ? prevKey + '[' + key + ']' : key, value);
            } else {
                Object.keys(value).forEach(function (subKey) {
                    createCartSubInput(form, value[subKey], subKey, prevKey ? prevKey + '[' + key + ']' : key);
                });
            }
        },
        createCartInput = function (form, key, value) {
            var input = document.createElement('INPUT');
            input.type = 'hidden';
            input.name = key.replace('zakeke_tmp_prefix_', '');
            input.value = value.toString().replace(/\\/g, '');
            form.appendChild(input);
        },
        addToCart = function (color, design, model) {
            var zakekeOptions = {};
            zakekeOptions['zakeke_design'] = design;
            zakekeOptions['zakeke_model'] = model;
            var params = updatedParams(color, zakekeOptions),
                form = document.getElementById('zakeke-addtocart');

            form.method = 'POST';

            delete params['variation_id'];
            Object.keys(params).filter(function (x) {
                return params[x] != null;
            }).forEach(function (key) {
                createCartSubInput(form, params[key], key);
            });
            jQuery(form).submit();
        },
        addToCartAjax = function (data) {
            var params = cleanParams(Object.assign({}, config.params, data));
            var form = document.getElementById('zakeke-addtocart');
            var formData = new FormData(form);

            delete params['variation_id'];

            Object.keys(params).filter(function (x) {
                return params[x] != null;
            }).forEach(function (key) {
                formData.set(key.replace('zakeke_tmp_prefix_', ''), params[key]);
            });

            formData.delete('add-to-cart');

            return jQuery.ajax({
                url: form.action,
                data: formData,
                processData: false,
                contentType: false,
                type: 'POST'
            });
        },
        updateCart = function () {
            return jQuery.ajax(
                config.wc_ajax_url.replace('%%endpoint%%', 'zakeke_update_cart')
            ).then(function (data) {
                if (data && data.return_url) {
                    window.location.href = data.return_url;
                }
            });
        };

    window.addEventListener('message', function (event) {
        if (event.origin !== (config || window.zakekeDesignerConfig).zakekeUrl) {
            return;
        }

        if (event.data.zakekeMessageType === 0) {
            if (config.params.zakeke_design_edit) {
                updateCart();
            } else {
                addToCart(event.data.colorId, event.data.designId, event.data.modelId);
            }
        } else if (event.data.zakekeMessageType === 1) {
            var zakekeOptions = {};
            if (event.data.design.price !== undefined) {
                zakekeOptions['zakeke-price'] = event.data.design.price;
            }
            if (event.data.design.percentPrice !== undefined) {
                zakekeOptions['zakeke-percent-price'] = event.data.design.percentPrice;
            }
            productData(event.data.design.color, zakekeOptions);
        } else if (event.data.zakekeMessageType === 2) {
            productAttributes(event.data.data.promiseId);
        } else if (event.data.zakekeMessageType === 3) {
            var zakekeOptions = {
                promiseId: event.data.data.promiseId,
                quantity: event.data.data.quantity
            };

            event.data.data.attributes.forEach(function (attribute) {
                zakekeOptions['attribute_' + attribute.Id] = attribute.Value.Id;
            });

            if (event.data.data.price !== undefined) {
                zakekeOptions['zakeke-price'] = event.data.data.price;
            }
            if (event.data.data.percentPrice !== undefined) {
                zakekeOptions['zakeke-percent-price'] = event.data.data.percentPrice;
            }
            productPrice(zakekeOptions);
        } else if (event.data.zakekeMessageType === 4) {
            return addToCartAjax({
                zakeke_design: event.data.data.designID,
                zakeke_selections: JSON.stringify(event.data.data.attributes)
            }).then(() => {
                window.location.href = config.wc_cart_url;
            });
        }
    }, false);

    if (window.matchMedia('(min-width: 769px)').matches) {
        iframe.src = config.customizerLargeUrl;
    } else {
        document.body.appendChild(container);
        iframe.src = config.customizerSmallUrl;
        window.addEventListener('resize', function () {
            iframe.style.minHeight = window.innerHeight + 'px';
            document.body.style.overflow = 'hidden';
        });
    }
}

if (window.zakekeDesignerConfig
    && (document.readyState === 'complete'
    || document.readyState === 'loaded'
    || document.readyState === 'interactive')) {
    zakekeDesigner(window.zakekeDesignerConfig);
} else {
    document.addEventListener('DOMContentLoaded', function () {
        zakekeDesigner(window.zakekeDesignerConfig);
    });
}
