<?php
//get theme options
$options = get_option( 'classy_theme_settings' ); ?>
<?php get_header(''); ?>
	<div id="post" class="full-width clearfix">
	<?php
    if (have_posts()) :
	while (have_posts()) : the_post();
	
	//get single portfolio images
	$portfolio_url = get_post_meta($post->ID, 'classy_portfolio_url', true);
	$portfolio_url_text = get_post_meta($post->ID, 'classy_portfolio_url_text', true);
	$portfolio_below_right = get_post_meta($post->ID, 'classy_portfolio_below_right', true);
	
	//get featured image data
	$single_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single-portfolio' );
	
	//get portfolio video
	$portfolio_video_embed = get_post_meta($post->ID, 'classy_portfolio_video_embed', true);
	?>
    
    <div id="portfolio-single-left">
    
        <h1 id="post-title"><?php the_title(); ?></h1>
		<div class="post-meta clearfix">
    	<?php _e('Posted Under:','classy') ?><?php echo get_the_term_list( get_the_ID(), 'portfolio_cats', ' ', ' , ', ' ') ?>
		</div>
    	<!-- END .post-meta -->
		<?php the_content(''); ?>
        
        <div class="clear"></div>
        
        <?php if($portfolio_url !='') { ?>
        	<p id="single-portfolio-link"><a href="<?php echo $portfolio_url; ?>" title="<?php if($portfolio_url_text !='') { echo $portfolio_url_text; } else { echo 'View Project'; } ?>" target="_blank" rel="nofollow" class="read-more"><?php if($portfolio_url_text !='') { echo $portfolio_url_text; } else { echo 'View Project'; } ?> &rarr;</a></p>
        <?php } ?>
        
	</div>
	<!-- END portfolio-single-left -->
    
    <div id="portfolio-single-right">
    
    	<?php
		//show embedded video if option isn't blank
		if($portfolio_video_embed !='') { echo do_shortcode($portfolio_video_embed); }
		else {
		?>
    
    	<?php
		//get attachement count
		$get_attachments = get_children( array( 'post_parent' => $post->ID ) );
		$attachments_count = count( $get_attachments );
		
		//attachement loop
		$args = array(
			'orderby' => 'menu_order',
			'post_type' => 'attachment',
			'post_parent' => get_the_ID(),
			'post_mime_type' => 'image',
			'post_status' => null,
			'posts_per_page' => -1
		);
		$attachments = get_posts($args);
		if ($attachments) {  
		?>

			<div id="slides_single" class="slides-js clearfix">
				<div class="slides_container">
                <?php
                foreach ($attachments as $attachment) :
				//get images
        		$full_img = wp_get_attachment_image_src( $attachment->ID, 'full-size');
        		$portfolio_single = wp_get_attachment_image_src( $attachment->ID, 'single-portfolio');
				?>
                    <div>
						<a href="<?php echo $full_img[0]; ?>" title="<?php echo apply_filters('the_title', $attachment->post_title); ?>" <?php if($attachments_count =='1') { echo 'class="prettyphoto-link"'; } else { echo 'rel="prettyPhoto[gallery]"'; } ?>>
            	<img src="<?php echo $portfolio_single[0]; ?>" height="<?php echo $portfolio_single[2]; ?>" width="<?php echo $portfolio_single[1]; ?>" alt="<?php echo apply_filters('the_title', $attachment->post_title); ?>" /></a>
                    </div>
                    <?php endforeach; ?>
        		</div>
        		<!-- end slides_container -->
    		</div>
    		<!-- end slides -->      
            
            <?php } else { ?>
                
			<?php if(has_post_thumbnail()) { ?>
                <?php the_post_thumbnail( 'single-portfolio'); ?>
            <?php } ?>
            <?php } ?>
            <?php } ?>
            
            <?php if($portfolio_below_right !=='') {
				echo '<div id="portfolio-single-right-below"> '. do_shortcode($portfolio_below_right) .' </div>';
				} ?>
            
	</div>
	<!-- END portfolio-single-right -->
    
    <div class="clear"></div> <!-- clear floats -->
    
    <?php
	//include related portfolio items if not disabled
	if($options['disable_related_portfolio'] != 'disable') {
    	include( TEMPLATEPATH . '/includes/portfolio/related-portfolio.php'); 
	}
	?>
    
    <?php endwhile; ?>
    <?php endif; ?>	
    
</div>
<!-- END #post .full-width -->
<?php get_footer(''); ?>