/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2020-08-11 16:31:29 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `cerber_acl` (
  `ip` varchar(81) CHARACTER SET ascii NOT NULL,
  `ip_long_begin` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ip_long_end` bigint(20) unsigned NOT NULL DEFAULT '0',
  `tag` char(1) NOT NULL COMMENT 'Type: B or W',
  `comments` varchar(250) NOT NULL,
  `acl_slice` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ver6` smallint(5) unsigned NOT NULL DEFAULT '0',
  `v6range` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `req_uri` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  KEY `main_for_selects` (`acl_slice`,`ver6`,`ip_long_begin`,`ip_long_end`,`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber IP Access Lists';

CREATE TABLE `cerber_blocks` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL COMMENT 'Remote IP',
  `block_until` bigint(20) unsigned NOT NULL COMMENT 'Unix timestamp',
  `reason` varchar(250) NOT NULL COMMENT 'Why IP was blocked',
  `reason_id` int(11) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber list of currently blocked IPs';

CREATE TABLE `cerber_countries` (
  `country` char(3) NOT NULL DEFAULT '' COMMENT 'Country code',
  `locale` char(10) NOT NULL DEFAULT '' COMMENT 'Locale i18n',
  `country_name` varchar(250) NOT NULL DEFAULT '' COMMENT 'Country name',
  PRIMARY KEY (`country`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cerber_lab` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL COMMENT 'Remote IP',
  `reason_id` int(11) unsigned NOT NULL DEFAULT '0',
  `stamp` bigint(20) unsigned NOT NULL COMMENT 'Unix timestamp',
  `details` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber lab cache';

CREATE TABLE `cerber_lab_ip` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL COMMENT 'IP',
  `reputation` int(11) unsigned NOT NULL COMMENT 'Reputation of IP',
  `expires` int(11) unsigned NOT NULL COMMENT 'Unix timestamp',
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber lab IP cache';

CREATE TABLE `cerber_lab_net` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'IP address',
  `ip_long_begin` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ip_long_end` bigint(20) unsigned NOT NULL DEFAULT '0',
  `country` char(3) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Country code',
  `expires` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`),
  UNIQUE KEY `begin_end` (`ip_long_begin`,`ip_long_end`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber lab network cache';

CREATE TABLE `cerber_log` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL COMMENT 'Remote IP',
  `ip_long` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_login` varchar(60) NOT NULL COMMENT 'Username from HTTP request',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `stamp` decimal(14,4) NOT NULL,
  `activity` int(10) unsigned NOT NULL DEFAULT '0',
  `session_id` char(32) CHARACTER SET ascii NOT NULL DEFAULT '',
  `country` char(3) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Country code',
  `details` varchar(250) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Details about HTTP request',
  KEY `ip` (`ip`),
  KEY `ip_long` (`ip_long`),
  KEY `session_index` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Cerber activity log';

CREATE TABLE `cerber_qmem` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL,
  `http_code` int(10) unsigned NOT NULL,
  `stamp` int(10) unsigned NOT NULL,
  KEY `ip_stamp` (`ip`,`stamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `cerber_traffic` (
  `ip` varchar(39) CHARACTER SET ascii NOT NULL,
  `ip_long` bigint(20) unsigned NOT NULL DEFAULT '0',
  `hostname` varchar(250) NOT NULL DEFAULT '',
  `uri` text NOT NULL,
  `request_fields` mediumtext NOT NULL,
  `request_details` mediumtext NOT NULL,
  `session_id` char(32) CHARACTER SET ascii NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `stamp` decimal(14,4) NOT NULL,
  `processing` int(10) NOT NULL DEFAULT '0',
  `country` char(3) CHARACTER SET ascii NOT NULL DEFAULT '',
  `request_method` char(8) CHARACTER SET ascii NOT NULL,
  `http_code` int(10) unsigned NOT NULL,
  `wp_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `wp_type` int(10) unsigned NOT NULL DEFAULT '0',
  `is_bot` int(10) unsigned NOT NULL DEFAULT '0',
  `blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `php_errors` text NOT NULL,
  `req_status` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `stamp` (`stamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=269 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_booking` (
  `booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trash` bigint(10) NOT NULL DEFAULT '0',
  `sync_gid` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_new` bigint(10) NOT NULL DEFAULT '1',
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sort_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `form` text COLLATE utf8mb4_unicode_520_ci,
  `booking_type` bigint(10) NOT NULL DEFAULT '1',
  PRIMARY KEY (`booking_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_bookingdates` (
  `booking_id` bigint(20) unsigned NOT NULL,
  `booking_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `approved` bigint(20) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `booking_id_dates` (`booking_id`,`booking_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_cerber_files` (
  `scan_id` int(10) unsigned NOT NULL,
  `scan_type` int(10) unsigned NOT NULL DEFAULT '1',
  `scan_mode` int(10) unsigned NOT NULL DEFAULT '0',
  `scan_status` int(10) unsigned NOT NULL DEFAULT '0',
  `file_status` int(10) unsigned NOT NULL DEFAULT '0',
  `file_name_hash` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `file_name` text NOT NULL,
  `file_type` int(10) unsigned NOT NULL DEFAULT '0',
  `file_hash` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `file_md5` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `file_hash_repo` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `hash_match` int(10) unsigned NOT NULL DEFAULT '0',
  `file_size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `file_perms` int(11) NOT NULL DEFAULT '0',
  `file_writable` int(10) unsigned NOT NULL DEFAULT '0',
  `file_mtime` int(10) unsigned NOT NULL DEFAULT '0',
  `file_ext` varchar(255) NOT NULL DEFAULT '',
  `extra` text NOT NULL,
  PRIMARY KEY (`scan_id`,`file_name_hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_cerber_sets` (
  `the_key` varchar(255) CHARACTER SET ascii NOT NULL,
  `the_id` bigint(20) NOT NULL DEFAULT '0',
  `the_value` longtext NOT NULL,
  `expires` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`the_key`,`the_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_cerber_uss` (
  `user_id` bigint(20) unsigned NOT NULL,
  `ip` varchar(39) CHARACTER SET ascii NOT NULL,
  `country` char(3) CHARACTER SET ascii NOT NULL DEFAULT '',
  `started` int(10) unsigned NOT NULL,
  `expires` int(10) unsigned NOT NULL,
  `session_id` char(32) CHARACTER SET ascii NOT NULL DEFAULT '',
  `wp_session_token` varchar(250) CHARACTER SET ascii NOT NULL,
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_cuteslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`(250))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_hotel_booking_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hotel_booking_order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_id` (`meta_id`),
  KEY `hotel_booking_order_item_id` (`hotel_booking_order_item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_hotel_booking_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_parent` bigint(20) DEFAULT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  UNIQUE KEY `order_item_id` (`order_item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_hotel_booking_plans` (
  `plan_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `room_id` bigint(20) unsigned NOT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `pricing` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`plan_id`),
  UNIQUE KEY `plan_id` (`plan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_mailchimp_carts` (
  `id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `cart` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_mailchimp_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `obj_id` text COLLATE utf8mb4_unicode_520_ci,
  `job` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_mp_timetable_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_id` int(11) NOT NULL,
  `event_id` int(11) NOT NULL,
  `event_start` time NOT NULL,
  `event_end` time NOT NULL,
  `user_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_mphb_sync_logs` (
  `log_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_id` int(11) NOT NULL,
  `log_status` varchar(30) NOT NULL,
  `log_message` text NOT NULL,
  `log_context` text NOT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_mphb_sync_queue` (
  `queue_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_name` tinytext NOT NULL,
  `queue_status` varchar(30) NOT NULL,
  PRIMARY KEY (`queue_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_mphb_sync_stats` (
  `stat_id` int(11) NOT NULL AUTO_INCREMENT,
  `queue_id` int(11) NOT NULL,
  `import_total` int(11) NOT NULL DEFAULT '0',
  `import_succeed` int(11) NOT NULL DEFAULT '0',
  `import_skipped` int(11) NOT NULL DEFAULT '0',
  `import_failed` int(11) NOT NULL DEFAULT '0',
  `clean_total` int(11) NOT NULL DEFAULT '0',
  `clean_done` int(11) NOT NULL DEFAULT '0',
  `clean_skipped` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`stat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_mphb_sync_urls` (
  `url_id` int(11) NOT NULL AUTO_INCREMENT,
  `room_id` int(11) NOT NULL,
  `sync_id` varchar(32) NOT NULL,
  `calendar_url` varchar(250) NOT NULL,
  PRIMARY KEY (`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=1853 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `hover` longtext COLLATE utf8mb4_unicode_ci,
  `advanced` longtext COLLATE utf8mb4_unicode_ci,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  `hover` longtext COLLATE utf8mb4_unicode_ci,
  `advanced` longtext COLLATE utf8mb4_unicode_ci,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext COLLATE utf8mb4_unicode_ci,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext COLLATE utf8mb4_unicode_ci,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=213 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_sbi_instagram_feeds_posts` (
  `record_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(11) unsigned NOT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `feed_id` (`feed_id`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_sbi_instagram_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  `last_requested` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=520 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_tinvwl_analytics` (
  `ID` varchar(32) NOT NULL,
  `wishlist_id` bigint(20) NOT NULL DEFAULT '0',
  `product_id` bigint(20) NOT NULL DEFAULT '0',
  `variation_id` bigint(20) NOT NULL DEFAULT '0',
  `visite_author` bigint(20) NOT NULL DEFAULT '0',
  `visite` bigint(20) NOT NULL DEFAULT '0',
  `click_author` bigint(20) NOT NULL DEFAULT '0',
  `click` bigint(20) NOT NULL DEFAULT '0',
  `cart` bigint(20) NOT NULL DEFAULT '0',
  `sell_of_wishlist` bigint(20) NOT NULL DEFAULT '0',
  `sell_as_gift` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `unique_product` (`wishlist_id`,`product_id`,`variation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_tinvwl_items` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `wishlist_id` bigint(20) NOT NULL DEFAULT '0',
  `product_id` bigint(20) NOT NULL DEFAULT '0',
  `variation_id` bigint(20) NOT NULL DEFAULT '0',
  `formdata` text,
  `author` bigint(20) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quantity` bigint(20) NOT NULL DEFAULT '1',
  `price` varchar(255) NOT NULL DEFAULT '0',
  `in_stock` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_tinvwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `author` bigint(20) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` text,
  `status` varchar(20) NOT NULL DEFAULT 'public',
  `type` varchar(20) NOT NULL DEFAULT 'list',
  `share_key` varchar(45) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp8b_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_wdi_feeds` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `feed_name` tinytext NOT NULL,
  `feed_thumb` varchar(800) NOT NULL,
  `thumb_user` varchar(30) NOT NULL,
  `published` varchar(1) NOT NULL,
  `theme_id` varchar(10) NOT NULL,
  `feed_users` varchar(2000) NOT NULL,
  `feed_display_view` varchar(30) NOT NULL,
  `sort_images_by` varchar(30) NOT NULL,
  `display_order` varchar(30) NOT NULL,
  `follow_on_instagram_btn` varchar(1) NOT NULL,
  `display_header` varchar(1) NOT NULL,
  `number_of_photos` varchar(10) NOT NULL,
  `load_more_number` varchar(10) NOT NULL,
  `pagination_per_page_number` varchar(10) NOT NULL,
  `pagination_preload_number` varchar(10) NOT NULL,
  `image_browser_preload_number` varchar(10) NOT NULL,
  `image_browser_load_number` varchar(10) NOT NULL,
  `number_of_columns` varchar(30) NOT NULL,
  `resort_after_load_more` varchar(1) NOT NULL,
  `show_likes` varchar(1) NOT NULL,
  `show_description` varchar(1) NOT NULL,
  `show_comments` varchar(1) NOT NULL,
  `show_usernames` varchar(1) NOT NULL,
  `display_user_info` varchar(1) NOT NULL,
  `display_user_post_follow_number` varchar(1) NOT NULL,
  `show_full_description` varchar(1) NOT NULL,
  `disable_mobile_layout` varchar(1) NOT NULL,
  `feed_type` varchar(30) NOT NULL,
  `feed_item_onclick` varchar(30) NOT NULL,
  `popup_fullscreen` varchar(1) NOT NULL,
  `popup_width` varchar(64) NOT NULL,
  `popup_height` varchar(64) NOT NULL,
  `popup_type` varchar(64) NOT NULL,
  `popup_autoplay` varchar(1) NOT NULL,
  `popup_interval` varchar(64) NOT NULL,
  `popup_enable_filmstrip` varchar(1) NOT NULL,
  `popup_filmstrip_height` varchar(64) NOT NULL,
  `autohide_lightbox_navigation` varchar(1) NOT NULL,
  `popup_enable_ctrl_btn` varchar(1) NOT NULL,
  `popup_enable_fullscreen` varchar(1) NOT NULL,
  `popup_enable_info` varchar(1) NOT NULL,
  `popup_info_always_show` varchar(1) NOT NULL,
  `popup_info_full_width` varchar(1) NOT NULL,
  `popup_enable_comment` varchar(1) NOT NULL,
  `popup_enable_fullsize_image` varchar(1) NOT NULL,
  `popup_enable_download` varchar(1) NOT NULL,
  `popup_enable_share_buttons` varchar(1) NOT NULL,
  `popup_enable_facebook` varchar(1) NOT NULL,
  `popup_enable_twitter` varchar(1) NOT NULL,
  `popup_enable_google` varchar(1) NOT NULL,
  `popup_enable_pinterest` varchar(1) NOT NULL,
  `popup_enable_tumblr` varchar(1) NOT NULL,
  `show_image_counts` varchar(1) NOT NULL,
  `enable_loop` varchar(1) NOT NULL,
  `popup_image_right_click` varchar(1) NOT NULL,
  `conditional_filters` varchar(10000) NOT NULL,
  `conditional_filter_type` varchar(32) NOT NULL,
  `show_username_on_thumb` varchar(32) NOT NULL,
  `conditional_filter_enable` varchar(1) NOT NULL,
  `liked_feed` varchar(30) NOT NULL,
  `mobile_breakpoint` varchar(10) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `feed_resolution` varchar(255) NOT NULL,
  `hashtag_top_recent` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wdi_themes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `theme_name` tinytext COLLATE latin1_general_ci NOT NULL,
  `default_theme` varchar(1) COLLATE latin1_general_ci NOT NULL,
  `feed_container_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `feed_wrapper_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `feed_container_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `feed_wrapper_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `active_filter_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_position` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_img_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_text_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_font_weight` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_text_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `header_text_font_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_border_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_text_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `follow_btn_background_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_horizontal_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_img_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_background_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_background_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_font_weight` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_text_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `users_text_font_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `user_description_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_overlay_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_overlay_bg_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_margin_top` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_margin_left` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_pos` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_cont_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_cont_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_cont_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_align` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_ctrl_btn_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_toggle_btn_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_toggle_btn_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_box_shadow` varchar(128) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_top` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_right` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_full_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_btn_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_share_button_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_box_shadow` varchar(128) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_close_rl_btn_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_rl_btn_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_pos` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_margin` varchar(128) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_active_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_active_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_thumb_deactive_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_rl_btn_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_rl_btn_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_filmstrip_rl_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_pos` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_align` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_bg_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_title_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_title_font_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_title_font_weight` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_title_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_description_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_description_font_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_description_font_weight` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_description_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_info_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_pos` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_font_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_font_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_author_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_author_font_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_author_font_color_hover` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_date_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_body_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_input_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_border_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_border_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_button_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_separator_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_separator_style` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_separator_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_load_more_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `lightbox_comment_load_more_color_hover` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_wrap_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_wrap_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_wrap_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_img_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_wrap_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_meta_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_meta_one_line` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_like_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_comment_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_caption_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_caption_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_feed_item_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_caption_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_like_comm_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_overlay_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_overlay_hover_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_overlay_hover_icon_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_overlay_hover_icon_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_photo_img_hover_effect` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_wrap_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_wrap_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_wrap_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_img_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_wrap_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_meta_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_meta_one_line` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_like_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_comment_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_caption_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_caption_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_feed_item_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_caption_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_like_comm_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_overlay_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_overlay_hover_transparent` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_overlay_hover_icon_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_overlay_hover_icon_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_photo_img_hover_effect` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_wrap_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_wrap_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_wrap_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_img_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_wrap_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_meta_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_meta_one_line` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_like_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_comment_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_caption_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_caption_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_feed_item_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_photo_caption_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `blog_style_like_comm_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_wrap_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_wrap_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_wrap_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_img_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_wrap_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_meta_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_meta_one_line` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_like_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_comment_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_caption_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_caption_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_feed_item_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_photo_caption_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `image_browser_like_comm_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_position` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_padding` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_border_radius` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_height` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_width` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_border_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_border_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_text_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_text_font_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `load_more_wrap_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_ctrl_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_size` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_ctrl_margin` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_ctrl_hover_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_position` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `pagination_position_vert` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_thumb_user_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `th_thumb_user_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_thumb_user_bg_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  `mas_thumb_user_color` varchar(32) COLLATE latin1_general_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

CREATE TABLE `wp8b_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14078 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6344 DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp8b_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp8b_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: cerber_acl */
INSERT INTO `cerber_acl` VALUES('190.206.192.*', 3201220608, 3201220863, 'W', 'My subnet', 0, 0, '', '');

/* INSERT TABLE DATA: cerber_log */
INSERT INTO `cerber_log` VALUES('139.59.57.64', 2335914304, '', 0, '1594937146.3896', 70, 'V14qMzRb8EAjaXWPSyBNvtHI', '', '0|0|0|0|modelox.vico.digital///wp-json/wp/v2/users/'),
 ('89.36.224.7', 1495588871, '', 0, '1595080578.7905', 55, 'lBo1OR3cpmLSVKriM2t5ek9n', '', '19|0|0|0|modelox.vico.digital/adminer.php'),
 ('93.113.111.100', 1567715172, '', 0, '1594714433.7131', 55, 'JTGjQigbyDav4MnZBKCwH3Eh', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('104.248.40.177', 1761093809, 'admin', 0, '1594776507.5107', 51, 'UtwyF6cuqsIH9Arvok7MWZhE', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('139.59.174.107', 2335944299, 'admin', 0, '1594786452.1223', 51, 'K3Wmbzap6J2oORtd0j85vNEr', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('142.4.7.212', 2382628820, 'admin', 0, '1594792955.9366', 51, 'PQWbnqUiHg79dj3NTh0xSrwv', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('104.199.101.230', 1757898214, '', 0, '1594800226.4204', 55, 'WRYsXZFM86ALO12zjkcVCdov', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('62.210.89.3', 1053972739, '', 0, '1594802848.0725', 55, '1V8fKrG9bSDNnqp3h6xt2wUu', '', '19|0|0|0|modelox.vico.digital/wp-content/plugins/t_file_wp/t_file_wp.php'),
 ('148.72.210.140', 2487800460, '', 0, '1594808766.9696', 55, 'uMm4Un6IyRlBrpdgAOP0zh9S', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('62.210.89.3', 1053972739, '', 0, '1594969484.6126', 70, 'eRNf810vXjPrwhxnt6OBSu5U', '', '0|0|0|0|modelox.vico.digital//wp-json/wp/v2/users/'),
 ('89.36.224.7', 1495588871, '', 0, '1595080581.1966', 55, '1Yv9PUklQN3s8bMrAhFcGgSi', '', '19|0|0|0|modelox.vico.digital/sql.php'),
 ('89.36.224.7', 1495588871, '', 0, '1595080582.9230', 55, 'w6kMEd4bGroLP1YvX0n2iaKO', '', '19|0|0|0|modelox.vico.digital/phpminiadmin.php'),
 ('103.133.114.31', 1736798751, '', 0, '1595098278.6632', 55, 'o20WYKvCgikU8yXcxnm6QPN1', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('122.117.44.59', 2054499387, '', 0, '1595147653.6430', 55, 'M4NtvbBgWKzTI5x9R8FDXlaq', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('67.205.14.147', 1137512083, '', 0, '1595164937.3026', 55, 'ftp80hDCkRxbn49MXyeOVHzT', '', '19|0|0|0|modelox.vico.digital/xmlrpc.php'),
 ('88.99.123.96', 1482914656, '', 0, '1596418810.7951', 55, 'I5NZdrl4VOD3QFjM0znWfTLx', '', '19|0|0|0|modelox.vico.digital/wp/wp-admin/setup-config.php'),
 ('88.99.123.96', 1482914656, '', 0, '1596418811.6861', 55, 'Qmhu1Jn3U9gpZi5GRtMTkrHj', '', '19|0|0|0|modelox.vico.digital/wordpress/wp-admin/setup-config.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 1, '1596835696.6519', 5, 'wvOlV9YRBUtpAeIHhfiKksLy', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('186.167.242.223', 3131568863, 'manager', 0, '1596836675.5649', 51, 'UrbXoWYclqNn9eOGwp5fKVdI', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('186.167.242.223', 3131568863, 'manager', 0, '1596836691.9721', 51, '5EQkL3IUFMpjOwy9gYK4a8Cx', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('186.167.242.223', 3131568863, 'demoweb', 1, '1596836702.6536', 5, 'hgFEATVGsNItCRuBmSbQa4p5', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 1, '1596906760.0954', 5, '1QBeMjyFhWNOICm6EGHi9zdY', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 1, '1596907293.3398', 5, 'acS9frNk1VEhBGnsyWgD0HKp', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 0, '1596909266.6446', 7, '9Cqre5FlKJtz08WDa3Ax7i2v', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 1, '1596909279.0977', 5, 'wlVtMAgTf2vkxBWZPzFY1JLm', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('201.243.46.194', 3388157634, 'demoweb', 1, '1596909286.0982', 5, 'JltCmK62fopNG0DSMIdHbAFP', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('104.131.8.207', 1753417935, '', 0, '1596995010.1943', 55, '87blPcLg2Q9Ts1efYWCr3XNF', '', '19|0|0|0|www.modelox.vico.digital:80/sql.php'),
 ('186.167.250.237', 3131570925, 'manager', 0, '1597070405.8669', 51, 'KDNybmMrklGL40CgOeJcWPS3', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('186.167.250.237', 3131570925, 'demoweb', 1, '1597070421.0514', 5, 'igD8FZmos4pyErHb0VNRA6xf', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('186.167.250.237', 3131570925, 'demoweb', 1, '1597070585.9986', 5, 'w7ZpzASQUagKVdmCfjI6nbBu', '', '0|0|0|0|modelox.vico.digital/wp-login.php'),
 ('190.75.83.206', 3192607694, 'demoweb', 1, '1597160241.9959', 5, 'fagAwJ5cskuKC721mEdIMNUq', '', '0|0|0|0|modelox.vico.digital/wp-login.php');

/* INSERT TABLE DATA: cerber_traffic */
INSERT INTO `cerber_traffic` VALUES('139.59.57.64', 2335914304, '', 'http://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'flxOEI5DTRHdiBM0ePwQAvtC', 0, '1594937123.8830', 17787, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('89.36.224.7', 1495588871, '', 'http://modelox.vico.digital/adminer.php', '', 'a:1:{i:1;s:79:\"Opera/9.80 (Windows NT 6.1; MRA 8.0 (build 5981)) Presto/2.12.388 Version/12.15\";}', 'lBo1OR3cpmLSVKriM2t5ek9n', 0, '1595080578.2000', 591, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('89.36.224.7', 1495588871, '', 'http://modelox.vico.digital/sql.php', '', 'a:1:{i:1;s:136:\"Mozilla/5.0 (X11; Linux i686; Ubuntu 14.04 LTS) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.0 Maxthon/1.0.3.10 Safari/537.36\";}', '1Yv9PUklQN3s8bMrAhFcGgSi', 0, '1595080579.9925', 1204, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'BhKg6GwXdUL53jZAPlQkabtm', 0, '1596268265.5592', 2808, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '3FW9bQyvMw6laD7kKhJ0YBjs', 0, '1596268316.1622', 2029, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'e9vyBDqTHO0htgV8LfuxGAio', 0, '1596399150.8616', 2706, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=0c434018b60908fab5f6e5606d263fa7&signature=5115e05cc7d520f3e0023d0079af65ec309e1add77fbe33dbb9b7b005c691a8a', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'fjuadcQMOZrpC3wKVyR6oseU', 0, '1596399153.6076', 1151, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=8b4450e71e', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=8b4450e71e\";}', '89LbpnKeJ5tw2UvWfsHhrFBS', 0, '1596399155.0468', 1246, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('88.99.123.96', 1482914656, '', 'https://modelox.vico.digital/wp/wp-admin/setup-config.php?step=1', '', 'a:1:{i:1;s:68:\"Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0\";}', 'I5NZdrl4VOD3QFjM0znWfTLx', 0, '1596418810.1794', 616, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('88.99.123.96', 1482914656, '', 'https://modelox.vico.digital/wordpress/wp-admin/setup-config.php?step=1', '', 'a:1:{i:1;s:68:\"Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0\";}', 'Qmhu1Jn3U9gpZi5GRtMTkrHj', 0, '1596418810.9405', 746, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'xvArq0cwBglU6H8jTyfXRG5u', 0, '1596596833.7032', 2542, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=69dc5cf4e3a70b1b23aad15c2870c6ca&signature=932135d2f7ffc6c7f705f5c5a294bdd6c6ec488a73da44c218e412ef3fff7e7f', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'wlTKr6RSk8zJC2WHD7u0tqYe', 0, '1596596836.2782', 1113, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Sjo6kXCQ0ZTyV9Bfae4ztcvb', 0, '1596811770.1845', 2311, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=5c410e80028d4600e5b0043050d28dbd&signature=41d51d85659809b96f0588a0ccebc49a9833d82da3351e5ff70e7096917d0b04', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '8aE4iuq1JFhOAfGLCl3Q29yc', 0, '1596811772.5920', 2188, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";}', 'fNZQa415roUPKVSCAFBLhEdH', 0, '1596835672.0960', 1263, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', 'wvOlV9YRBUtpAeIHhfiKksLy', 1, '1596835694.6789', 7525, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'WZmI3ibXAQN70rTlh8OMcusL', 0, '1594776525.0977', 2152, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=2e4932c042c9605ec779a3cca6ad4df3&signature=7856d718f14947d3c4e7cd549773d7cb805c7557f5f98c333e91491e85253ff9', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'vpRNGmkZhQysDiFUwBEb1gnI', 0, '1594776527.3181', 1447, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'c9gxTp0KXvoHe14tAsFiqRaI', 0, '1594776518.5404', 3569, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('104.248.40.177', 1761093809, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'zcURoPs7Xvfb91EhCa0k3egt', 0, '1594776486.5796', 18327, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('104.248.40.177', 1761093809, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'UtwyF6cuqsIH9Arvok7MWZhE', 0, '1594776505.4444', 3351, '', 'POST', 503, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/?wordfence_syncAttackData=1594776519.8231', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:70:\"https://modelox.vico.digital/?wordfence_syncAttackData=1594776519.8231\";}', '7I3RNBtbDr0sFMip9uOWoCzg', 0, '1594776519.8517', 1041, '', 'POST', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=338ae893b8716dbc24cb220e19b3ef0c&signature=e6c38132fde95ce9f6e3eb707189fe2d22e3b6c70da2ec207bd230b50b7f65fd', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'qhBPepgUDiV8GCMSr1TW7zo2', 0, '1594937151.5813', 2007, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'HFXiLA4CWUNBomnT9KaexJIk', 0, '1594937148.3222', 3175, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('139.59.57.64', 2335914304, '', 'http://modelox.vico.digital///wp-json/wp/v2/users/', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'V14qMzRb8EAjaXWPSyBNvtHI', 0, '1594937145.5801', 810, '', 'GET', 403, 0, 520, 0, 1, '', 0),
 ('139.59.57.64', 2335914304, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:40:\"http://modelox.vico.digital/wp-login.php\";}', 'cLbr5FKR9XfwVn8o1DxOaEtC', 0, '1594937142.4765', 1359, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('139.59.57.64', 2335914304, '', 'http://modelox.vico.digital///?author=1', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'Z4S3aIhGfsACMU5rQlO8P60D', 0, '1594937144.1863', 1319, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('89.36.224.7', 1495588871, '', 'http://modelox.vico.digital/phpmyadmin/', '', 'a:1:{i:1;s:86:\"Opera/9.80 (Windows NT 6.2; WOW64; MRA 6.0 (build 6089)) Presto/2.12.388 Version/12.16\";}', 'xET7zq40um8WwcbldAj9VyLN', 0, '1595080559.7494', 18235, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('65.154.226.109', 1100669549, '', 'http://modelox.vico.digital/wp-content/uploads/zn_fonts/Flaticon/Flaticon.ttf', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.71 Safari/537.36\";i:2;s:80:\"http://goctaprueba.vico.digital/wp-content/uploads/zn_dynamic.css?ver=1583000282\";}', 'GiJs8ZwpazLSV0cbyQuUNmH5', 0, '1595054380.5489', 1261, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('65.154.226.109', 1100669549, '', 'http://modelox.vico.digital/wp-content/uploads/zn_fonts/Flaticon/Flaticon.ttf', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.71 Safari/537.36\";i:2;s:80:\"http://goctaprueba.vico.digital/wp-content/uploads/zn_dynamic.css?ver=1583000282\";}', 'Rkh0gonbOflj3Fv8J5KQwzLZ', 0, '1595054380.5377', 1218, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('65.154.226.109', 1100669549, '', 'http://modelox.vico.digital/wp-content/uploads/zn_fonts/Flaticon/Flaticon.woff', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.71 Safari/537.36\";i:2;s:80:\"http://goctaprueba.vico.digital/wp-content/uploads/zn_dynamic.css?ver=1583000282\";}', 'OKLYSwzbJ7kCH3eDcRrB26qQ', 0, '1595054367.9348', 12613, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('65.154.226.109', 1100669549, '', 'http://modelox.vico.digital/wp-content/uploads/zn_fonts/Flaticon/Flaticon.woff', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/76.0.3809.71 Safari/537.36\";i:2;s:80:\"http://goctaprueba.vico.digital/wp-content/uploads/zn_dynamic.css?ver=1583000282\";}', 'weM9LqBlOrYzpG3u1xDy75nI', 0, '1595054371.3916', 9156, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('75.119.215.210', 1266145234, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'i5h0mC8f7xjcrW3DHuMvdsKN', 0, '1595043236.4761', 18034, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'pcFDTdNraGC3ug4LI5xKPwzZ', 0, '1594993965.4884', 1239, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'hfvNwP5IlZ0uG2LcBUADqEaj', 0, '1594993963.6093', 1821, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'caPrI0Kju3ZRfoxYqO4TLtpw', 0, '1594993962.2808', 1272, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'lO4fqMkNi3bw8saYpAnGSy1d', 0, '1594993958.3917', 3846, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=6480d35151', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=6480d35151\";}', 'kiDxelg7jsBNIdo6UpWJSqEv', 0, '1594993069.1935', 21040, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Gb3px2QokS6F89mXOZ51uEBf', 0, '1594993054.2519', 35228, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('69.46.36.28', 1160651804, '', 'http://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=8af18fff186a5d8614e22c4b120d07b9&signature=712ce93189c59e7ba72e70a4df22958dfd8d1ff1ab5a9c92993adf0a4694d7d6&remote=1', '', 'a:1:{i:1;s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.152 Safari/537.36\";}', 'RSvmwuea2HIhiPcMtglJoNTd', 0, '1594993068.0753', 21460, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=0376287a6d400f29a5c1b927b410944f&signature=d97ddbb9a131bf37f9eee8c2f73ab5809af031fad079ec14789127d154d8314b', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'hDpnwiaJfrQXCmZLeglOtvdP', 0, '1595253935.4686', 34281, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'VhgrYqH8vGDZOmf9BEIu6J7K', 0, '1595253932.2153', 3004, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=67423ffa8068a6ca439e207f97b4959f&signature=9fd2d833590e2ed74d0fa44394cb4c6ecf50bb75c94650a0545317f320799cf5', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'rb9NwIdoVOm5DvWKSYL721pP', 0, '1595253885.5538', 50699, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '7Gy3r5BpVFKwZeWQbknDaAvY', 0, '1595253883.1666', 2334, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=4ff7e5ea2f02347e59551eb8704c97d1&signature=3f008e61d0690bd1e0252e8d24edbc8ec693fba5b0b85ec635fc56430e016cdb', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '3h4Pk7X0FJdzSEQbHgRrIfnc', 0, '1595253834.5952', 51945, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=a2ff4dcf2ca73f5f47e0e1adf3c7827d&signature=8252391a46ff48972e5f08422701f023b3fedf1bd999001f8c900ba3f199b679', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'kJfLBSHrnaFmycVspNGiq1Ew', 0, '1595253784.0192', 51536, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'JI0v1WBiClkwGQhXAoanb9Oy', 0, '1595253802.4173', 2127, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'nye04QflROh8batHsK9M7xoE', 0, '1595253831.2206', 3296, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'FClWovqIxw8k3h15nsb9AyfU', 0, '1595253781.2334', 2750, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=671e0cc5d2edf7f1c45f3fd4a2802944&signature=88d11867a9f0c21c23f47d6ee037f18247e67c4b23135ce0d510c8e605c5e28d', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'dwbm6pEUhjAgBxC3fSvKaiJo', 0, '1595253734.4537', 50549, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'xFI6p2vRksQabV95XUAKyLEo', 0, '1595253732.2652', 2147, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=f0178938d85a967b877a6070664a2b78&signature=0a62c8963f17b8b5ca994c13f0db7474a2930db750a2a32005ada7997674ac44', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'K7SmQ8ytpXf3bCUkxvONE2sT', 0, '1595253683.6322', 51798, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=6016b3ce67', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=6016b3ce67\";}', 'WxBQFocDu3SXPpbG56n1def7', 0, '1595253689.4193', 1813, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('69.46.36.20', 1160651796, '', 'https://modelox.vico.digital/?_wfsf=detectProxy', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.82 Safari/537.1\";}', '9upZFgcBb7QAUOqNzyMR1Yih', 0, '1595253693.6030', 836, '', 'POST', 200, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=b15db945eae886205f02cb63862bb62f&signature=eb1bcf51bef364762405aab978b11fd63856f49a3a8e58f8a5b368615979bbb3', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'IGAHwoZ9s5grDzJiBeavEbX1', 0, '1595253688.3606', 1963, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'SRJbfBo9TWvIXPM3q8lhitLU', 0, '1595253680.3578', 3211, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Y31IzEjQ06WtBSGXdmh4CRn8', 0, '1595253685.8133', 2454, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Q0Uv3Yw8sECyq5SVIpeb9Mna', 0, '1595353357.1175', 3317, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=3cd6c8b84a', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=3cd6c8b84a\";}', 'WFJfKrGI857iyHCs4BO9kAcv', 0, '1595751839.6021', 1175, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=10de66ac9f217856f09ce6b284c62a3d&signature=9c8d0bb5d42bf0aee23a962130ddf7ec9ab7d256355c3f0ff661d4cbad46964c', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'exQHRFfY93X5ioGvMmLKpUyO', 0, '1595751838.5808', 1031, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '1AdX64D9Og3mhJaRMxF8kpPI', 0, '1595751837.5032', 1043, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '0uBw9ZpDlXe2SyYRN3x8vAgc', 0, '1595751825.9636', 8725, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=25df297ffecdc5376899c13b8d5a3e8c&signature=3639ecc8926d921305c532caeebc9c1b14b1e94afa712cb892767e0b5d7179e9', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '7aNyIAsei61dvnUDuC2wLPtV', 0, '1595853384.8901', 1115, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'MJt7oE1vNwFPWkQqi4ruzg8j', 0, '1595853383.0186', 1838, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=f18838b1bb', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=f18838b1bb\";}', 'AkfE3aVrvdDoUe2FNPyYuRsx', 0, '1596149487.2527', 1063, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '4X7wtv9CYW65SqQlrcPhUTfi', 0, '1596149483.1109', 2659, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=4e3f0a1314a85f8085040109e02f9d78&signature=8a7f1d707937c9043c086cad3145176b8e98b6eb117bcc383ca3c537b454a637', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'TlPVkeLYbhA0iIKzwJ5osuE4', 0, '1596149485.8134', 1350, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=1f805441cd', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=1f805441cd\";}', 'fxGzcJXgd7epV2WihHoIErjO', 0, '1596218070.4987', 3343, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '5DCt09klaI42SHQz7wfghqmc', 0, '1596201099.2532', 2464, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=2a16c2d1fc63edbefddac8ebb9eb7d94&signature=913dc11e5a0e95391d603e0ee435834415865f4c34f05ca3a8df228fe111a923', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'REmzciwxJCnGfdWtOKM07BgU', 0, '1596201101.7604', 1126, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=6a49610dba21e82684cd1e846bd361ed&signature=1b4ab4941f9f5f3514d7cb3dc7dc069cfe2d74eb862f6d9434e5c3f7fa5ac54f', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'il0ZsmTx4VGnCX8quSBeL1jW', 0, '1596303571.4039', 1171, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=6c5c801cbb2b0c4d4c52a486b998744d&signature=56bfef412c86d2d8968b322288c2ecf0299a42f6d5f7d4fb204e1d4509484f63', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'Av6hPF78GZHgr2YKC9lbxRn4', 0, '1596906740.9464', 1763, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'aWVm7ZPMUDlJYBXhknrsRz8d', 0, '1596906739.0063', 1890, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";}', 'qlVNtPzbTSMHoQmRyA5IK9W6', 0, '1596906736.1117', 1397, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('104.131.8.207', 1753417935, '', 'http://www.modelox.vico.digital:80/sql.php', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1 Safari/605.1.15\";}', '87blPcLg2Q9Ts1efYWCr3XNF', 0, '1596995000.8832', 9312, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'jLeUSMN9mnzs68oqKwXud2xI', 0, '1594657418.9440', 2589, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=31a6155552a83a91136d8e2327c113dc&signature=f9e49473a86556cd4e2fb9153ee8357d38dbd83297bd21994b243ec7f37ae653', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'X8VM7LPUxvki5IZed0ozJNm6', 0, '1594657421.5688', 1347, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=e4f2ed8791', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=e4f2ed8791\";}', 'nzLoG7aT9Rs5iDO1JyA4ePQV', 0, '1594657422.6162', 1501, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('93.113.111.100', 1567715172, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'vNftqCkGRUbL4zjHM8QagrWT', 0, '1594714414.9849', 16164, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('93.113.111.100', 1567715172, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'c1DAOlZ9KwEuR2MyXtWbCNgs', 0, '1594714431.3156', 913, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('93.113.111.100', 1567715172, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'y5Du7ePsZhXzAYEiJfBjFcvI', 0, '1594714432.2727', 888, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('93.113.111.100', 1567715172, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'JTGjQigbyDav4MnZBKCwH3Eh', 0, '1594714433.2014', 512, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=2218d19eed', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=2218d19eed\";}', 'ksefUI6AO3r40Ex8jKdYyW7P', 0, '1594776528.3467', 1339, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'ezbmPG4BI3yhSfkN08KdW1lJ', 0, '1594776570.1761', 2560, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=6338995fa8e2d3cf7cf18758bfecaf78&signature=b542dc9989b9b6fd1c4b92fc97bfe9fdd8cb186c5dfd27bf5faa663e5bea9bb5', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '58zRYhtvuTxlWcCKQ2AapXnH', 0, '1594776522.1637', 51605, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'QArHk3DbU9wjGfZNupdOV1zJ', 0, '1594776620.2877', 1714, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=8226617511283fdcf7da063c1abef683&signature=6b99be8180c0707a2a7a214fbce66e4cda04bd525f77926a43046c93020c280e', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'KQIyRNc0TD9HlBfodgO7jbqC', 0, '1594776572.8133', 50213, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'RTdqPp8uz0HLmwCvQBGAVZ3r', 0, '1594776637.2151', 2207, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '3sxAqrt16TEoVenSL9QyRkMz', 0, '1594776669.1551', 1250, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=ba74980c4f416114bd22e3a20056fc73&signature=3707c280773e96f35ae6a9a24295cfe137df45288284d95b3e45cb09dad7ff51', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'pR9vFu70sLYKDjbrQH6EnioG', 0, '1594776622.0529', 49369, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'q36o0h5kT9xnSYZ7iIPec2Rt', 0, '1594776718.7685', 2422, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=b3d509eb66e05d016730d00eff06f27b&signature=3b8de12efa64ae8f3dd83f529954c87272fa3f163d064905f5efb4dd2ed57917', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '7zWHmawBAPd18xboirIKCOXU', 0, '1594776670.4447', 51776, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=9e06235521ab463167a45fd1e8f8dad0&signature=0c32bacc3bbcb55dfd73bd8b578685c3676e4dc10b2208239d3c3bdbf529bc70', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'lYXoctE2MihZHCmPunsAf5bG', 0, '1594776721.2528', 45380, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('139.59.174.107', 2335944299, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'JQc9ByxM0dKkILSq6Vz7vhHO', 0, '1594786433.0806', 17346, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('139.59.174.107', 2335944299, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'K3Wmbzap6J2oORtd0j85vNEr', 0, '1594786450.6772', 2139, '', 'POST', 503, 0, 600, 0, 1, '', 0),
 ('142.4.7.212', 2382628820, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'LPQHG8Bon4zZj16VX5cbiktr', 0, '1594792950.5426', 2722, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/?wordfence_syncAttackData=1594792951.7821', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:70:\"https://modelox.vico.digital/?wordfence_syncAttackData=1594792951.7821\";}', 'YXb2pFOdMU7EvAqQPCa5LfGm', 0, '1594792951.8224', 2110, '', 'POST', 200, 0, 600, 0, 1, '', 0),
 ('142.4.7.212', 2382628820, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'PQWbnqUiHg79dj3NTh0xSrwv', 0, '1594792954.8967', 1694, '', 'POST', 503, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/?wordfence_syncAttackData=1594800216.7541', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:70:\"https://modelox.vico.digital/?wordfence_syncAttackData=1594800216.7541\";}', 'uqjKwk98SImRPxZneLypvYoH', 0, '1594800217.0297', 4384, '', 'POST', 200, 0, 600, 0, 1, '', 0),
 ('104.199.101.230', 1757898214, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'ZAHUQSlsvExMu5KFabzT3Ghf', 0, '1594800195.6106', 28054, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('104.199.101.230', 1757898214, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'IU8kbJmYpXtqO36ySFLMN5RQ', 0, '1594800223.9786', 910, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('104.199.101.230', 1757898214, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'hQZSTEbUwDg3Xnm8WsorPJ57', 0, '1594800224.9499', 880, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('104.199.101.230', 1757898214, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'WRYsXZFM86ALO12zjkcVCdov', 0, '1594800225.8949', 526, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('62.210.89.3', 1053972739, '', 'http://modelox.vico.digital/wp-content/plugins/t_file_wp/t_file_wp.php?test=hello', '', 'a:1:{i:1;s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";}', '1V8fKrG9bSDNnqp3h6xt2wUu', 0, '1594802847.2697', 803, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('148.72.210.140', 2487800460, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'BJ6oRcpfI8bY1ZV75rLDiA9t', 0, '1594808744.0942', 16890, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('148.72.210.140', 2487800460, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'aevsnfdlCwQpRLWAVYEDMGK9', 0, '1594808762.3634', 992, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('148.72.210.140', 2487800460, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', '3PgLNjoa4OXWcMKC9G012STR', 0, '1594808764.3671', 982, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('148.72.210.140', 2487800460, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'uMm4Un6IyRlBrpdgAOP0zh9S', 0, '1594808766.3722', 598, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=4d0e3fc256', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=4d0e3fc256\";}', 'YQopt5fdUe9LV3OliCjhRgSK', 0, '1594820295.4939', 3097, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=91fa7d7fd7', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=91fa7d7fd7\";}', 'm3NQMOVpPxU1aY947WHjgeTr', 0, '1594937153.0707', 2309, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('62.210.89.3', 1053972739, '', 'https://modelox.vico.digital//wp-json/wp/v2/users/', '', 'a:1:{i:1;s:115:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36\";}', 'eRNf810vXjPrwhxnt6OBSu5U', 0, '1594969483.4701', 1143, '', 'GET', 403, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'ay7MNmzhLnPRA9WK6wjf1Y5t', 0, '1594969483.2283', 2579, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Z8ESNh7D5yMcY4vatfgOXpqF', 0, '1594969534.1609', 1942, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=54f2d24d62a40bd27856ea15ea5789dd&signature=cb6b4b34ed87eacc3e8a262f24237229eea03e2066822c5da2b5b59265b828bb', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'dfGtYv1aAJ278wqVPzo0egUF', 0, '1594969485.8483', 51272, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'eFOVblNALoTw5ZWPjyixdKfk', 0, '1594969583.4291', 1916, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=c19f454fedc2980ef3305c5e27dc6d19&signature=f119deb4397bc584fedc76e835001d3be786cef019ab2d2dd012c0297e0c0eb0', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '8Ahidl6tZkRDXQ9J4wvyFPWf', 0, '1594969536.1361', 50230, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'UGYrwP2MEC03lhJOBAWx9t1D', 0, '1594969592.4531', 1065, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'wPsqG3WIhROuYpDNZErycbnH', 0, '1594969633.1448', 1951, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=be23cec1173d484801f270fb2b55bec0&signature=be8ef63f509c183fab96437379f8693e952c5b3a112cae7ad6613f082a236f96', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'YJ64AITdqu0bnzBsQRp3PxVH', 0, '1594969585.3891', 50723, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'm8dcF2wLhSzKtRrHGljkIA0M', 0, '1594969682.1680', 1983, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=5c37ff345133f6f44587b16bfb45412d&signature=746f0fbb9c2293795056141182c4ad0f8ed43f78925cfbcf8666da7de8bc05d3', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'c9Xxkj6qs4SyZWn2Hh3wQYzT', 0, '1594969635.1286', 50042, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=37b6e35aabdf8944990e48bc5aa496cf&signature=8776a952405c6b4fc9304bc69603b3af3b711a013c770fb2a646464ec9422c1d', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '9dE5Ia0HxmDv3XZhzQyMqARn', 0, '1594969684.1865', 20632, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('89.36.224.7', 1495588871, '', 'http://modelox.vico.digital/phpminiadmin.php', '', 'a:1:{i:1;s:101:\"Mozilla/5.0 (Windows NT 6.3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2062.94 Safari/537.36\";}', 'w6kMEd4bGroLP1YvX0n2iaKO', 0, '1595080582.3944', 529, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'OGtSVahRQLMnHsTDvw2NW7Ko', 0, '1595080583.0633', 2584, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=cebd54454c', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=cebd54454c\";}', 'ePxK6j2EG4aAmTc3pINv0DCU', 0, '1595080587.2800', 1199, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=2d264c600033f05a7320109c376506e5&signature=7e3961824f588a72db8e6396698bea933c9eb24cae42452c9da0464e9deb6682', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'cUEB2aRKIuoyz4drk1nY5LCj', 0, '1595080585.7290', 5730, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('103.133.114.31', 1736798751, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'o20WYKvCgikU8yXcxnm6QPN1', 0, '1595098268.1035', 10560, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('66.249.65.145', 1123631505, '', 'https://modelox.vico.digital/?wc-ajax=get_refreshed_fragments', '', 'a:2:{i:1;s:145:\"Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; Googlebot/2.1; +http://www.google.com/bot.html) Chrome/83.0.4103.122 Safari/537.36\";i:2;s:63:\"https://modelox.vico.digital/producto/duvet-cover-set-in-white/\";}', 'p4W1If8N0tVnGhUzyxc2Sv6m', 0, '1595124259.2199', 2324, '', 'POST', 200, 2414, 500, 0, 1, '', 0),
 ('122.117.44.59', 2054499387, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'RApqPFLimX8BjUv5V4Zu2wf3', 0, '1595147631.2012', 17333, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('122.117.44.59', 2054499387, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'XIRS0B6tGxaV4if9oqwdr3jQ', 0, '1595147602.6017', 46129, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('122.117.44.59', 2054499387, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'hKjQDY29liURoM356B4w7ucC', 0, '1595147650.2943', 947, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('122.117.44.59', 2054499387, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'M4NtvbBgWKzTI5x9R8FDXlaq', 0, '1595147653.1076', 536, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('67.205.14.147', 1137512083, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'mtzR4lVjuPpHSQrT50hqNikJ', 0, '1595164916.5155', 16532, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('67.205.14.147', 1137512083, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'PRlQoHdZNAyxCJ17hLDekazT', 0, '1595164933.6191', 908, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('67.205.14.147', 1137512083, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'sgnzbWrMYw2If6QBtaOxm4EX', 0, '1595164934.8585', 1441, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('67.205.14.147', 1137512083, '', 'https://modelox.vico.digital/xmlrpc.php', '', 'a:1:{i:1;s:76:\"Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:62.0) Gecko/20100101 Firefox/62.0\";}', 'ftp80hDCkRxbn49MXyeOVHzT', 0, '1595164936.7936', 509, '', 'GET', 403, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'epzVuNFl3c0MJQ2LKaTB6qDS', 0, '1595164938.4090', 3111, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=12150a8fa9e7a1428f2c6bd3f0827fab&signature=2ee6cfdada8937932bd52b4ccfa9bf7958a48ecdab15704bc5775de6420d041d', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'hmHsM6jFtD4CViweUNcqYuOo', 0, '1595164941.5528', 1080, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=c14763f9e5', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=c14763f9e5\";}', 'k4vxfju7ARE0woiMesFCYIHz', 0, '1595164942.9692', 1060, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=15a09e848c', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=15a09e848c\";}', 'DnmSLvNBO6XWFcGIKUJo7sMP', 0, '1595353361.5487', 1273, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=ae34acd803d911ce530a12588c049660&signature=346f4463e92d1bb0d01db7bd4185e25a8cf7a934bd18c74b2d4e2a30e7c0c55e', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'rzFcHdheXEv9b47nQ56IOiWG', 0, '1595353360.5375', 6362, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'vYhwL5yBa16ZHoSxXeEMr3cb', 0, '1595442341.4461', 2907, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5962c3c6ba', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5962c3c6ba\";}', 'Y18DXOxHf6307AmMGFwUqrtk', 0, '1595442345.8293', 1144, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=9db4821d56a5a3a9079cc8a8c08c4eae&signature=717ca827e9d1256b10a26e093162f64f479a6b10cc1deea2cb7348bcf6a9bcb7', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'zE7sJkIV1d3jw0uT48rlqmW6', 0, '1595442344.4018', 6061, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'hcbQ5BfloFy3g2wYdjkRuSAx', 0, '1595751841.1459', 4018, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'C9IZMSspwcVnLl3WOxEHjD4A', 0, '1595751845.1963', 1092, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'PlwLdeQ2SrcjXTInAU9yDH37', 0, '1595751846.3229', 1053, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'NjS3IMVFyXP1fWBbO9rCGK7l', 0, '1595751847.4142', 1212, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'BX1lT8Ln5RYiQHchIeE7ow3j', 0, '1595751882.5438', 2274, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=b12849505d4e181a38b62fa96d7754a1&signature=90a5fb35e431b1ec14494ffd86c168df04e9aa056a6bd0ac025061eeba64ecc4', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'qAY16pskuQKOIw4NLRMrDCaf', 0, '1595751834.7228', 51113, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'u7VzorkmldK68CiUebBcOwMg', 0, '1595751932.1738', 1145, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=fb1a1414b742d32e7cadb2567a5284e6&signature=4ffdca687dec1e902792d410598503c4d301f2ffd6d673ef04e06d2578d9c4cd', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'yh4gH6NCRlv0tUEXkO1JdxQP', 0, '1595751884.8553', 49486, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '9bz6eSpgGxkRP8VF7tcL1d5A', 0, '1595751980.2055', 2261, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=9942aa5308c29d1dd86fb62836c5a3ff&signature=51521092e3b41769eb046eecfa7933ac1371e2c2205a20488096971c715f909b', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'JxfYeT250R3mDMz4kiab8ZhB', 0, '1595751933.3580', 50129, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'LSBnI7pjR6QzD0ZuGKy1P9i8', 0, '1595752029.1756', 1984, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=184ac0afc5926eb42665dfa3c98dc000&signature=b5d1849e3bf9f5b4dbdfd52b5fc4f31877a2870ec9b6e22884abc319fbd09aac', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'ysi2LZzKma56k9tIeUxNrjnX', 0, '1595751982.5038', 49675, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '8WbAODcUoZqEehJ7KtjPkgrl', 0, '1595752078.1636', 1998, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=d7b9e49719bedb4fec3d32c6e270af01&signature=c8a19f1378435a9c2964b96607859e56b075f95df5e07cf0623fcff1c574241e', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'RaMCQsxtWmdBZXAnzgw5jh7v', 0, '1595752031.1994', 49979, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'IDtdz7hWeEx5R26YjirsoBUO', 0, '1595752091.9217', 1155, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'kabfFzBRMr1pPl65SNL3whgV', 0, '1595752127.1714', 2324, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=4d96b5622907faf600a31a54676db7d7&signature=b8e18eb7b0dd499bae1f1156eb3da92df6cf86a5aabd46649c134adbd5ccb1eb', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'x5gzJZDhpcoHm7OX964rTK3A', 0, '1595752080.2015', 50317, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'wzh7NlEIvKGiTSRoLxOam4CF', 0, '1595752177.1476', 1954, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=ff946064877df69660fb1391bcec084f&signature=d763b3a04f53b1e227c2d9deb8f4b81c4b78fe115accbed6ed10471f77e0496e', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'Gf5KnAOygXjwE4N79SQMCdY0', 0, '1595752129.5521', 50567, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=cac395b751e8b42fa4a2a0e9c781ef1b&signature=e7983f4915fbeec96fe1988c27de29a3fd2deac9f01685f8516fa2ac5369603c', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'NF3nbkjVat7RMGJsPe1DITlx', 0, '1595752179.1393', 34823, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=f7edb11b3c', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=f7edb11b3c\";}', 'oireHqgDMlfK5ByVA67pbUs3', 0, '1595853386.3384', 1085, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=05f6e0d86f', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=05f6e0d86f\";}', 'ualLeor3AJDMB4pzk25dNSK1', 0, '1595967254.0008', 5031, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'drwzKYUFE9vWcJtAa0bZonSM', 0, '1595967267.3879', 1034, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=5bde37fb4e70651f79d888980e4e1e95&signature=eb942379f50fbd9c173d03f0a0995962381edaa01747ad7b0542d216b96c09ce', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '58Z1iV3pduUclzmnoJwSFDIy', 0, '1595967268.4640', 4871, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '4FUkBlscrdTMVezt7KRZ0haD', 0, '1595989041.6848', 3283, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('69.46.36.20', 1160651796, '', 'https://modelox.vico.digital/?_wfsf=detectProxy', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.82 Safari/537.1\";}', 'IjQDW9gAJKGyurH0XPLOcfYZ', 0, '1595989056.4706', 1096, '', 'POST', 200, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '5E2xW0KbgJYlDV8NFfTBLtR1', 0, '1595989094.2039', 2809, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=0ccfc65c5709a31f32f23d761c610aeb&signature=7111c65bf501390c8a586456b5503778b42d763c8017027e08f23fdcd2eef373', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'dbm7FcVWwox9lHr1qRDUMe2h', 0, '1595989045.0415', 52993, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'YcoRu8JyImles2M7BGVgUf4d', 0, '1595989144.7773', 2793, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=02e858f4dbac044725c6f0770b9d96f1&signature=b2dd23a0c7435a5a256928be62afae718692661874755e31faf6c17605829866', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'sxU0PHMbK9zDhiCgeVZ6Jl2X', 0, '1595989097.0628', 51538, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'p7WhmiyP846bTCsaMZGFjltk', 0, '1595989178.0936', 2347, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'AMjegTOmQr896XRWqaZptnso', 0, '1595989195.3260', 2251, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=7687259b8199a6b89aad0405639c65e4&signature=1b5b9910d693038745436718a96dbbb34d5bac09237a34f8dc85a8af85ce8379', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '62plyNr5gqjn70aEF93hGBfL', 0, '1595989147.6283', 50973, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'dycKBjn4X7J1iEoDvrS8I52Y', 0, '1595989246.1984', 2336, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=0c7d84890583b6d22edb6c1ca4dec247&signature=6ddc9617ee746acbbc2afdc370ea07bdd8123480127acecf03dd6484f7337cc5', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '4xb0kginU3ETPdap8lOMfcy2', 0, '1595989197.6431', 51916, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'dKRrCyZMYfBb2o5xOkpGiEFU', 0, '1595989295.2786', 2658, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=b00d123b559c8343daa9841f770b92e5&signature=8a8cfef46f113cb355af3fea7a3a3e7609e08c060e1029e32047532ef55dc8b4', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'nXqLsxGE3Z9bPfiwFkM52cmH', 0, '1595989248.5823', 50386, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=6d02138a10cb6acf1012275059fcb94b&signature=f0e2fa07c84735afa7d131c11ed7f5e5ba10a848ee7abf073ab9bfc52a0900ed', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'IWgipkjx07tumysH24JrcTPU', 0, '1595989297.9905', 36130, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'hx6OEKN10YVFZys4neaT3z9r', 0, '1596059975.0309', 2469, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=9fb1f8c5f11d13aefb53502cefc60bc8&signature=ec80fad8a3ef392f7be3f06c9c6035cccdd0696eeb69e503d6cf450c1a817599', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'iEjJSAT74YvKCurlPfygs5w8', 0, '1596059977.5530', 1300, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=d1c4f66fce', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=d1c4f66fce\";}', 'e8tvFJSKDkTP7RBgUm5paXQI', 0, '1596059978.9810', 1560, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'e9Ki6ZFm7dDyaEPQRvxIBU8b', 0, '1596218072.9873', 2891, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', '7x5t0bvTfZwsW34Nre9OdhCF', 0, '1596218076.0385', 1037, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'y5hIBCW34OUp6dLiN2JztADv', 0, '1596218077.1156', 1100, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'E9okHwZQgxXjsTIVhcYe1mfJ', 0, '1596218078.2496', 1094, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=b8df0640c36334375bd72b8f26d7dcbe&signature=901e1c377face9cda7a937e69a38dbfb5b50d985fb4c3cfdf7f43e56a68f8cc3', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'Lh6wZtzq4GYASiBOdbjUafQp', 0, '1596268268.4073', 50799, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'FXNK0H4WYi7vrSE6btjwaCLf', 0, '1596268365.4408', 2037, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=a2847b288dc0c76e2130b33f8f5712da&signature=76e7fc86891e8cbed161a9353fc87cf10fd987b8a4314ba04e7724de8bf76657', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'sLj60nW5AqRBypD9rKG8EYzk', 0, '1596268318.2243', 50274, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', '6vCgebhIVXYqpG13n4PtNMSj', 0, '1596268373.6647', 1127, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'hHLm9D0WX6oG5fje8UtSCKzB', 0, '1596268414.1496', 2018, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=a46a54869cde51ac7e97dec6735483d0&signature=2b6ee2299dc9d950621776bfd46739a9d43f5e49dd835d73ff8b5f235e73306f', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'oCjIe7imKTnMXbqEgOzVA4Y5', 0, '1596268367.5252', 49662, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'NRCy5JDxUwf2uMjL6H3pdlkW', 0, '1596268463.1455', 1048, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=e6e679015bab1252ff26c7b3fd6f67d8&signature=f8900204b5534cf21cd91048f549167bbdf2b90ee9002b39d514ea8e59a59011', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'rBzbwaWoR1YyD62V4FqeILQE', 0, '1596268416.2145', 49001, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=2610514e903e37c007a919ff4df3d6b1&signature=d83c6cf39678064c50349face067f211a5aacc245cf93af6f1c5c9e482ceecae', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'VJmXvMk2GH56EyWC1w3lUPDR', 0, '1596268464.2458', 17224, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'MwFdv3E0hXioIHSA4qjcrOtK', 0, '1596303568.9654', 2389, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=4c6c6a6eeb', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=4c6c6a6eeb\";}', 'AWei4gY5mpbjLh2ZSzwDqa6n', 0, '1596303572.9435', 1121, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('66.249.66.39', 1123631655, '', 'https://modelox.vico.digital/?wc-ajax=get_refreshed_fragments', '', 'a:2:{i:1;s:145:\"Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; Googlebot/2.1; +http://www.google.com/bot.html) Chrome/84.0.4147.108 Safari/537.36\";i:2;s:34:\"https://modelox.vico.digital/shop/\";}', 'O4QRsvYCDibaoGLU2XZK1cJT', 0, '1596331092.4116', 1457, '', 'POST', 200, 2414, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=c5dbedb42d', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=c5dbedb42d\";}', 'nuy1TfDCU8Pxh4OamiZlAs5q', 0, '1596596837.8593', 1296, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'jnwQ0S5kZyszigd89tIKRCYT', 0, '1596596849.0465', 1100, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('69.46.36.20', 1160651796, '', 'https://modelox.vico.digital/?_wfsf=detectProxy', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.82 Safari/537.1\";}', 'cEFUJ7XTd4uk6qO9wfCNeWIK', 0, '1596596859.3125', 558, '', 'POST', 200, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'nLlwWA0YOkeB6Qt3IyaZXdDc', 0, '1596596897.2335', 2025, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=5d30ab3edf8ef17125449fd481bc3588&signature=5357977dd7770b23bae48bad34b89fff62298f37dde9662f18e5902e09eeaa92', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '2Xd4oHkUZAcWMrKOTz0fCmGu', 0, '1596596850.1801', 50098, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Vkm0ngd9ADYEwi3fF5N4JyUW', 0, '1596596946.1912', 1041, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=f75dea12b701bd5adb8906f57a77e76c&signature=db9b17e22bd839552d1a2cadc99a7cffc4c1b48e67c295e180577d8bdb188681', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'SK2lPMfd40jqchLADmTiGEsy', 0, '1596596899.2916', 48957, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', 'P23qWX7Gnw4ELD5USryxfic9', 0, '1596596952.4240', 1195, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'BFWeHNd14uJthRDTgPLX3YUz', 0, '1596596994.1432', 1957, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=0d9478af1a683cbf90904d92ea501199&signature=8ba5294d1e9c7056b8443f3f8d560c968e80ed778400c392492d5142b92b602a', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'gUGAEZw0K1omLQ39iaqMynCv', 0, '1596596947.2720', 49848, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'PQbUYcVEZoeKSMCxTilI3Lgm', 0, '1596597043.1508', 2057, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=cbfa0025bfd4e50eedaf611b9a32a823&signature=c2134aef9e5b2378d8b6b00359b26ea1323501465813b244445065c8cf6f2b9d', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'dwDxrtgUeZb4Il9zsRaiYKE1', 0, '1596596996.1413', 50087, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=60f139f5f54d746bd87e8cb32853e093&signature=9113edbd5015d54083d98a45b796848e8ff69444b78b8add8fad5cb6e4ca61c0', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '7ghnReY5rpG4SHdQq0bik6Lf', 0, '1596597045.2576', 21996, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=63379de5cb', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=63379de5cb\";}', 'bSNPmzUo3LBswFDKVlrEaZCt', 0, '1596811774.2316', 2071, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'imR7vT3F1PVIGyw60l5fYZnC', 0, '1596811775.6800', 1977, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=35de2401f1f08050893e18345b35b2b8&signature=614891b4f0d4d9d970e35c35d41082dc5f45498ba15604ca0ecf4ffd9fcd6865', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'foRNCj0Jyptc914K2nauF7mL', 0, '1596811777.7200', 1752, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'sqUk7EjDotWXBGIHa5iSNlx1', 0, '1596811779.0261', 2330, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'XkHwSUKRr5vVJOpqgcbox081', 0, '1596811781.4231', 1634, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'Lqk4MZ6AebI2pvxocjigJfnz', 0, '1596811783.1073', 1387, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'VvdKZTfXnxAzjyEQpa6D72I8', 0, '1596811784.5555', 1735, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('186.167.242.223', 3131568863, '', 'https://modelox.vico.digital/?wc-ajax=get_refreshed_fragments', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'TIcYHbzoGefU4gAqOMxW1vhn', 0, '1596836081.3375', 2653, '', 'POST', 200, 2414, 500, 0, 1, '', 0),
 ('186.167.242.223', 3131568863, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";}', 'acz6UbN4fZqXSOky18pRKlms', 0, '1596836630.4170', 1006, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('186.167.242.223', 3131568863, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', 'UrbXoWYclqNn9eOGwp5fKVdI', 0, '1596836673.2757', 2941, '', 'POST', 403, 0, 600, 0, 1, '', 0),
 ('186.167.242.223', 3131568863, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', '5EQkL3IUFMpjOwy9gYK4a8Cx', 0, '1596836689.8738', 2112, '', 'POST', 403, 0, 600, 0, 1, '', 0),
 ('186.167.242.223', 3131568863, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'hgFEATVGsNItCRuBmSbQa4p5', 1, '1596836700.7866', 7786, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=0b2213187a', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=0b2213187a\";}', 'qTkX732ZMwn6DOdWJfgGhrUm', 0, '1596906742.0081', 1539, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', '1QBeMjyFhWNOICm6EGHi9zdY', 1, '1596906757.4865', 7818, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('69.46.36.20', 1160651796, '', 'https://modelox.vico.digital/?_wfsf=detectProxy', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.82 Safari/537.1\";}', 'Tha1cmLJeI2Hwq6KMtsE8jNF', 0, '1596907211.5204', 15073, '', 'POST', 200, 0, 700, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'kDOWJtLlEAzMqc2XUKfpv8Ci', 0, '1596907202.7114', 25241, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?interim-login=1&wp_lang=es_ES', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'wmE7FIL4otJghqQ0cG9kPDny', 0, '1596907230.9590', 9308, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'jxAnkuFy6v4rWpgoNfti8aLT', 0, '1596907262.3172', 1710, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'n1hyX8SNaiA70Yk2KVZDoju4', 0, '1596907271.4488', 890, '', 'GET', 302, 0, 501, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&reauth=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'aIvuQNH2EGsKhTp7qDyBC6iO', 0, '1596907272.5920', 724, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:192:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&reauth=1\";}', 'acS9frNk1VEhBGnsyWgD0HKp', 1, '1596907290.9903', 8320, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&action=confirm_admin_email&wp_lang=es_ES', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:192:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&reauth=1\";}', 'gmjREAya8qL4OPzp9fUlXo1d', 1, '1596907299.5916', 749, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'g07svpQP1nCyEKqz954NVhiX', 0, '1596907302.4083', 722, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'eQyXpMIG7D8q3ilmL5uT0WxE', 0, '1596907303.1799', 908, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', '5kIw3QyOPNebh02LqXns7fVr', 0, '1596907304.1330', 1167, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&action=confirm_admin_email&remind_me_later=173f5e4ab2', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:224:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2Foptions-general.php%3Fpage%3Dupdraftplus%26updraft_restore_success%3D1%26pval%3D0&action=confirm_admin_email&wp_lang=es_ES\";}', 'tmIaV4jK9LwzD1i7hSWFvdG0', 1, '1596907304.8809', 1292, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', '5bwhXHOvej1BxSQszIyJPgU6', 0, '1596907305.3618', 1587, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'cUTmYXEkpsK3tDoGngAa1ZRl', 1, '1596907325.0351', 1512, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Da3qzxQeEKLcJIGimr5UFtCs', 0, '1596907330.0238', 1335, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=e051a2cb03799e2549e85a90d91c955b&signature=c859c0886bb4fc23096d0efe82c8581eab363f7b98d852006af00ebfb0692c30', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'iXEaM6krQ0Dz7tKvxPjnUo8h', 0, '1596907331.4178', 6329, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'mW1yNkxhuSA49qn0CfbOPYtR', 1, '1596907349.1348', 904, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/login-customizer/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', '3QqXHSYnD8OjNh7vioKt9p1B', 1, '1596907350.7441', 804, '', 'GET', 302, 8, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'sPM8oNJ3x6hq7F0t2LE1muyb', 1, '1596907351.8233', 792, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/sample-page/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'CEuzBYKkajL0qUOpMgXxRrDT', 1, '1596907353.4515', 717, '', 'GET', 200, 2, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=0&pval=0\";}', '4WFsdhJQM6NRanx0YPzAtc82', 1, '1596907439.9178', 807, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/login-customizer/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=0&pval=0\";}', 'H6fXm4BPau3SC2FLWct8MAds', 1, '1596907483.7361', 1276, '', 'GET', 302, 8, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=0&pval=0\";}', '7kMim4o0962BdrVeOFyHcqC5', 1, '1596907486.8642', 1208, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/sample-page/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=0&pval=0\";}', 'v8sVRAMgdJeIf51Ymxwyj4Wb', 1, '1596907504.1792', 2035, '', 'GET', 200, 2, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'NfL19TXEVZRrxQIm3yusq6Yc', 1, '1596907548.2948', 893, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'VTxYsKWDClrNGyPegqOzHuSZ', 1, '1596907565.9368', 990, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', '6LUdP8NWSZj3YHJ0XxMf2GOA', 1, '1596907571.8800', 1125, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:61:\"https://modelox.vico.digital/wp-admin/admin.php?page=zn-about\";}', 'pGoJnV9HxkeMERuY1WtTrXQz', 1, '1596907688.8709', 741, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'Eokg34we10LDT2fbXYshxcWt', 1, '1596907696.5442', 1833, '', 'GET', 200, 115, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'Yxsv6yLIJHOm3uwr0TtagpNF', 1, '1596907707.2331', 762, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-minimal/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'pmujMJtQeob6x0WPHOK2CdR9', 1, '1596907710.5099', 895, '', 'GET', 301, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'o5ZKrdHm1cDBWjEq23QvsNxk', 1, '1596907711.7344', 943, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'VrOsMCmFf1WUcPoqzj3RJ8XA', 1, '1596907741.1613', 1110, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'o9a6CrAMilWq234fJn7XSc5D', 1, '1596907744.3055', 815, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'SzEkFhwIctZdeaGDfJq7WXN5', 1, '1596907749.2857', 911, '', 'GET', 200, 115, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/?preview=true&zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'CXu0hDNMAbBrT53xmSv7WULj', 1, '1596907756.2585', 797, '', 'GET', 301, 115, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/?zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'p6qA7rIvhTSbBUKgucwoNWMk', 1, '1596907757.2988', 1183, '', 'GET', 200, 115, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-minimal/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:42:\"https://modelox.vico.digital/?zn_pb_edit=1\";}', 'SRjGaikv5FIKly9Tbsut2Qzc', 1, '1596907865.0642', 3207, '', 'GET', 301, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:42:\"https://modelox.vico.digital/?zn_pb_edit=1\";}', '8hNqEWOKzygit7Jo3IxjUfva', 1, '1596907868.8952', 1073, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/?preview=true&zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'Xrs5nyAqL9bVzCBOIaoxhMY2', 1, '1596908156.5752', 27511, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:73:\"https://modelox.vico.digital/portfolio-details/?preview=true&zn_pb_edit=1\";}', 'Uxz83CXShyNAe5RPTrKJ0Dsg', 0, '1596909054.7016', 2513, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/?preview=true&zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'zQ7ATDxEO6vKtucf2bsMYqwe', 0, '1596909162.5726', 2320, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/?preview=true&zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'oUeAIDrxgTmzCh82u7YQ9MEc', 0, '1596909198.8433', 1204, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";}', 'J1XCIkKba4oYmZSOL5RWHAv7', 0, '1596909248.6182', 787, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', '9Cqre5FlKJtz08WDa3Ax7i2v', 0, '1596909265.8340', 1831, '', 'POST', 403, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'wlVtMAgTf2vkxBWZPzFY1JLm', 1, '1596909278.0912', 1015, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'JltCmK62fopNG0DSMIdHbAFP', 1, '1596909285.2830', 826, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:38:\"https://modelox.vico.digital/wp-admin/\";}', '0nwJYCeykpvbNqLXgi4Usxtf', 1, '1596909437.1710', 1012, '', 'GET', 200, 115, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-minimal/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'FeoMq5cpTRAdS93YIOhP8xk6', 1, '1596909451.2553', 778, '', 'GET', 301, 0, 600, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'EFoRB1yLAgiDGNJ3YSW4Ujrk', 1, '1596909452.5608', 837, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('201.243.46.194', 3388157634, '', 'https://modelox.vico.digital/portfolio-details/?preview=true&zn_pb_edit=1', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:47:\"https://modelox.vico.digital/portfolio-details/\";}', 'c1SzhNKOIUtxmW2ZgDTY4FEG', 1, '1596909480.0215', 78373, '', 'GET', 200, 112, 601, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'bayIHxFGVmwpTSqUzOQRhrN6', 0, '1597070337.0097', 2155, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=785c98df348ddbe8b44e237e8ee2190c&signature=4d067bcf8752a2e99349d99a6ec7950ddb2efb6f1d75af200f2bbc48cef006b0', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'LyOrMeWPa0zKTgmwpxDXY1kN', 0, '1597070339.3703', 1597, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '9wvKs3no2ulH5VF6WCYAXijk', 0, '1597070340.3940', 1566, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";}', 'XiULDM4y0kJ1hOGVzIeRZ29x', 0, '1597070386.3095', 1380, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'NuioKWyscA1fYBMCZG65ajwp', 0, '1597070390.1336', 818, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=standard&cronKey=f6cabf8b92a792ad665aa90324b58727&signature=8e041cadc14435a9e348099578756cb0ec88b88c636ef09cbec5a62c3fc2f36e', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'ojSyzWPNQXYp8VI3KfkrnvO4', 0, '1597070342.0163', 49955, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', 'KDNybmMrklGL40CgOeJcWPS3', 0, '1597070401.6199', 4788, '', 'POST', 403, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/.user.ini', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:38:\"https://modelox.vico.digital/.user.ini\";}', '7au6GcFrLD425EY3yUCtpSjK', 0, '1597070424.0773', 994, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'igD8FZmos4pyErHb0VNRA6xf', 1, '1597070416.5056', 10516, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'MXgwoAYjhuxkdasmE5tnUB47', 0, '1597070437.4126', 2772, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=ebad094eb2d042331d40269e0f94240e&signature=1099a492c30643ca914fe024a2af1e53d1eef35dffdc61cd4f41cf569ca202e3', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', '5aJgLCrXfDyUNhjBk1xIA3OE', 0, '1597070391.0088', 50200, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('69.46.36.20', 1160651796, '', 'https://modelox.vico.digital/?_wfsf=detectProxy', '', 'a:1:{i:1;s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/21.0.1180.82 Safari/537.1\";}', 'QvmkEq5hgUPBruX3Ysw9RTpK', 0, '1597070507.2455', 13765, '', 'POST', 200, 0, 700, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'Ku0I4r2y89P7cQYdljamShwN', 0, '1597070488.2272', 35740, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=c28b09a8e527d1514d6c20732f69f388&signature=1bcf4d4bdd380b06705f94a5ff22e4e59b6e2b955c585eeb26e97eb66a440827', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'fgA4BcuhR6xEvGyVwHCdl3j0', 0, '1597070440.2346', 84801, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=1&scanMode=standard&cronKey=23646ee31afe9b67ca576b5b285f400b&signature=6b66f24283f0496f49b38464979374957fe08eb26586ac790028a60d416c39c9', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'Q2awZ6BxOnLdTfUm9IEb7sMC', 0, '1597070525.0687', 14181, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'AxRG7jVeNDpHlSqM4PgkUzOn', 0, '1597070535.8508', 10633, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php?interim-login=1&wp_lang=es_ES', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'W6KqfEmc2sC9dJTLOZ3Mzpko', 0, '1597070550.5412', 20045, '', 'GET', 500, 0, 600, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:74:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus\";}', 'lIDxLENyUq9jzsYhKM5rFG1m', 0, '1597070562.3894', 8586, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:66:\"https://modelox.vico.digital/wp-json/wp/v2/types/post?context=edit\";}', 'VeSzsm9riTovG7wjlnKD2kW6', 0, '1597070588.6803', 1081, '', 'GET', 401, 0, 520, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'w7ZpzASQUagKVdmCfjI6nbBu', 1, '1597070584.6323', 6026, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'odYjwXIVlcNE6G5kM0rUCSAW', 0, '1597070589.8021', 1141, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&action=confirm_admin_email&wp_lang=es_ES', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:41:\"https://modelox.vico.digital/wp-login.php\";}', 'vwKhtzfVUJlSBkx6Io14TF0p', 1, '1597070590.9348', 1098, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'JRBGrDiKlcX4Yj5keAw90ZHf', 0, '1597070591.0040', 1356, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:52:\"https://modelox.vico.digital/wp-admin/admin-ajax.php\";}', 'dgLEJ0XHmWMcz4wYFRroiAGO', 0, '1597070592.4837', 1277, '', 'POST', 400, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', 'dXTEoCkJQYH1UWiz5ql0jaeA', 0, '1597070614.9901', 1492, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=052c66d07b867893533431c6e26cb047&signature=43c0a93b93de776a57056bc35777b9e014c83786846fee111b5ddfeb8a14dd56', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'PdmkCaLfnR04V31SJiBNMWqO', 0, '1597070616.5769', 5667, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:107:\"https://modelox.vico.digital/wp-admin/options-general.php?page=updraftplus&updraft_restore_success=1&pval=0\";}', 'WgNTutGZhlYPrS17yJUHfEs4', 1, '1597070632.5213', 683, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('186.167.250.237', 3131570925, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:114:\"Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36\";i:2;s:77:\"https://modelox.vico.digital/wp-admin/plugins.php?plugin_status=all&paged=1&s\";}', 'kM5U2xmT7bzVFRp3wcNoHfvd', 1, '1597070955.6702', 785, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:78:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_testAjax\";}', '4fmuCIEMNUtZ3FJBVxK0Sq81', 0, '1597160010.9604', 2691, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wordfence_doScan&isFork=0&scanMode=quick&cronKey=9a336383ad52d6d4ccb27df5d09dba55&signature=1b8c443c68f773ab25b0cdc9a21a1f3cb60d4218402b4b5e98328f52b9f7089d', '', 'a:1:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";}', 'k01gn3L9sxGjWPJZHE6FmyCr', 0, '1597160013.7144', 1766, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1', '', 'a:1:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";}', '8PaphcYbGMWLBtoHuOlXTmKd', 0, '1597160193.0712', 1560, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/wp-login.php', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', 'fagAwJ5cskuKC721mEdIMNUq', 1, '1597160239.0505', 10382, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&action=confirm_admin_email&wp_lang=es_ES', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:111:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&reauth=1\";}', '7qjwVhzInTsAbSN8vyPmctu4', 1, '1597160249.7299', 1515, '', 'GET', 200, 0, 600, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/wp-login.php?action=confirm_admin_email', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:143:\"https://modelox.vico.digital/wp-login.php?redirect_to=https%3A%2F%2Fmodelox.vico.digital%2Fwp-admin%2F&action=confirm_admin_email&wp_lang=es_ES\";}', '9eVmyIRspGPBc70wY5xOEKDz', 1, '1597160264.1378', 2033, '', 'POST', 302, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-content/uploads/woocommerce_uploads/', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:68:\"https://modelox.vico.digital/wp-content/uploads/woocommerce_uploads/\";}', 'S4tMfKXrqaG0jmRZQ17o5pci', 0, '1597160562.8475', 3773, '', 'GET', 404, 0, 600, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5253e50224', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5253e50224\";}', 'bDE9XlapQfOe0z5oKnmZFcGy', 0, '1597160573.2324', 4794, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5253e50224', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:100:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=wp_1_wc_privacy_cleanup&nonce=5253e50224\";}', 'SZdv8P2oN67J3ymYgTwIcAfG', 0, '1597160589.7231', 2045, '', 'POST', 200, 0, 500, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/favicon.ico', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:61:\"https://modelox.vico.digital/wp-admin/admin.php?page=zn-about\";}', 'jGoQqO8v5C3xkIY0esgFtznT', 1, '1597160662.3510', 2145, '', 'GET', 302, 0, 600, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:61:\"https://modelox.vico.digital/wp-admin/admin.php?page=zn-about\";}', 'szVYM4KIJ1thcdfGNx6yk5eF', 1, '1597160700.5776', 11661, '', 'GET', 200, 149, 601, 0, 1, '', 0),
 ('190.75.83.206', 3192607694, '', 'https://modelox.vico.digital/?wc-ajax=get_refreshed_fragments', '', 'a:2:{i:1;s:102:\"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/84.0.4147.105 Safari/537.36\";i:2;s:29:\"https://modelox.vico.digital/\";}', 'L02eBP58y7mdHz9RA4X3KxrE', 1, '1597160734.8846', 3085, '', 'POST', 200, 149, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161286', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161286\";}', 'gZj7VmzHGCLK2l0h5pusTkc9', 0, '1597161286.7223', 6687, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161288', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161288\";}', 'EaMyb3Nw75x4nmKTS1oOgIl9', 0, '1597161288.4360', 6573, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161289', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161289\";}', 'RXiwd6oOGQk9HUsp7YKbBfNC', 0, '1597161290.0381', 8174, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161293', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161293\";}', 'vCxyp5UanQ7VZ1ihK4lNd9Aq', 0, '1597161293.2930', 12315, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161300', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161300\";}', '6COu0AgQrc85wPyxvVBnJmhF', 0, '1597161300.6112', 10221, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161303', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161303\";}', 'FKw3aqGMbQ97LST8ONfRxAhr', 0, '1597161303.2362', 20895, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161316', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161316\";}', 'zMQK76lk8YmyfEwiUun9TWeh', 0, '1597161316.9164', 18902, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161328', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161328\";}', 'mAtbLVOTrjX0Skl98eCxoW23', 0, '1597161328.2053', 16183, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161339', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161339\";}', 'GjLdb1cnl8FIeui5EYR4XHmh', 0, '1597161339.4134', 21546, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161354', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161354\";}', 'x5WTGmNMoAb7vfSyDwzFR29Q', 0, '1597161354.1124', 17397, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161366', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161366\";}', 'WfxXvCdhk6uNe0zyiPb87tTK', 0, '1597161366.1893', 17094, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161378', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161378\";}', 'S0acpdTJ8bjRIKUBmXOqFGty', 0, '1597161378.3039', 17852, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161390', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161390\";}', 'DeGklZazg8E3qx906iQfTR1K', 0, '1597161390.7378', 19381, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161415', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161415\";}', '6s7h8I3NdVYzZ9ftP2vGXjFy', 0, '1597161415.0669', 3788, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161402', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161402\";}', 'cxZzbHgi07kMWIv1jq8FAoXr', 0, '1597161402.5325', 16352, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161415', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161415\";}', 'edfb3JVA2xhX1uSY4ZwqGF0K', 0, '1597161415.1688', 17870, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161428', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161428\";}', 'dRnhaMO6B8XclLevupYf0H2t', 0, '1597161428.0912', 18948, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161442', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161442\";}', 'yZru4hTEeaJYQ0wfztOimxMV', 0, '1597161442.0623', 17590, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161454', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161454\";}', 'LVQo45CEmpnKSY903RP86DId', 0, '1597161454.6692', 16726, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161466', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161466\";}', 'T9Nh1gdmnUt30WJ4LKbHwivF', 0, '1597161466.3963', 6380, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161467', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161467\";}', 'kEGN4jMmhfJo7glpAyZHQacY', 0, '1597161467.7964', 6882, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161469', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161469\";}', 'OjaRVEpTY2L1HN076QclSJZ5', 0, '1597161469.7107', 7740, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161472', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161472\";}', 'GuWSrDn1YMRd8eTm23kLN7B0', 0, '1597161472.4892', 6504, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161484', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161484\";}', 'alHKLDIGAunR0Xrmtw3QNqvV', 0, '1597161484.9587', 3153, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161473', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161473\";}', 'BGT0nJf4y1zto6vlwFqLupc3', 0, '1597161474.0175', 14117, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161484', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597161484\";}', '06XDLgTiGsV4OqSylwJzZm7B', 0, '1597161485.0463', 3223, '', 'GET', 200, 0, 500, 0, 1, '', 0),
 ('51.91.128.199', 861634759, '', 'https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597163482', '', 'a:2:{i:1;s:45:\"WordPress/5.4.2; https://modelox.vico.digital\";i:2;s:104:\"https://modelox.vico.digital/wp-admin/admin-ajax.php?action=duplicator_pro_process_worker&now=1597163482\";}', 'jgw0T9CdX5rsluxnEAN2V3DR', 0, '1597163482.4365', 8223, '', 'GET', 200, 0, 500, 0, 1, '', 0);

/* INSERT TABLE DATA: wp8b_actionscheduler_actions */
INSERT INTO `wp8b_actionscheduler_actions` VALUES(20, 'action_scheduler/migration_hook', 'complete', '2020-08-11 15:43:53', '2020-08-11 15:43:53', '[]', 'O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1597160633;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1597160633;}', 1, 1, '2020-08-11 15:43:58', '2020-08-11 15:43:58', 0, NULL);

/* INSERT TABLE DATA: wp8b_actionscheduler_groups */
INSERT INTO `wp8b_actionscheduler_groups` VALUES(1, 'action-scheduler-migration');

/* INSERT TABLE DATA: wp8b_actionscheduler_logs */
INSERT INTO `wp8b_actionscheduler_logs` VALUES(15, 20, 'acción completa vía WP Cron', '2020-08-11 15:43:58', '2020-08-11 15:43:58'),
 (14, 20, 'acción empezada vía WP Cron', '2020-08-11 15:43:57', '2020-08-11 15:43:57'),
 (13, 20, 'acción creada', '2020-08-11 15:42:53', '2020-08-11 15:42:53');

/* INSERT TABLE DATA: wp8b_booking */
INSERT INTO `wp8b_booking` VALUES(1, 0, '', 1, '', '2020-01-18 00:00:00', '2020-01-16 19:20:39', 'text^name1^Jony~text^secondname1^Smith~text^email1^example-free@wpbookingcalendar.com~text^phone1^458-77-77~textarea^details1^Reserve a room with sea view', 1);

/* INSERT TABLE DATA: wp8b_bookingdates */
INSERT INTO `wp8b_bookingdates` VALUES(1, '2020-01-18 00:00:00', 0),
 (1, '2020-01-19 00:00:00', 0),
 (1, '2020-01-20 00:00:00', 0);

/* INSERT TABLE DATA: wp8b_cerber_sets */
INSERT INTO `wp8b_cerber_sets` VALUES('_cerberkey_', 0, 'a:3:{i:0;s:32:\"13bc103045e0c5ca40ea88334148417a\";i:1;i:1597070713;i:4;s:40:\"SK//OIL8PZMCAH7XQJ23WE64KYVGDF0RST5N91UB\";}', 0),
 ('admin_notice', 0, 'a:0:{}', 0),
 ('admin_message', 0, 'a:0:{}', 0),
 ('_cerber_mnemosyne', 0, 'a:3:{i:3;s:20:\"IAG9E4FBW7JSN16TPR2K\";i:4;i:6;i:6;s:16:\"7H1GXI0KWQEYUR8L\";}', 0),
 ('hash_pl_c86251ee8490a52c4fa644073ba03eed598555a8', 0, 'a:4:{s:4:\"name\";s:17:\"Slider Revolution\";s:3:\"ver\";s:5:\"6.1.8\";s:4:\"hash\";a:1620:{s:9:\"index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:16:\"release_log.html\";s:64:\"b9a60e72cfe90694d53551554a54d767fa4134ee84c82d33c41a0d3e3ea39480\";s:13:\"revslider.php\";s:64:\"e0ca29a52ca6c230653652fc90263b88947332d9233384ad7fd76fec68986f40\";s:13:\"uninstall.php\";s:64:\"d9c8a5801c741f9b8e7a9d333438a1109b15fe8ab9e19a41106d3e8841f394cc\";s:12:\"welcome.html\";s:64:\"2b2524c7dfa5c9f8a7c89444e6eba47ff5a225f74c4458fd7fa99b1057c03733\";s:15:\"admin/index.php\";s:64:\"ae6fc10874855daddd44765416e0f28da65a2b89e9e32802dd66e7fa6690d2d9\";s:31:\"admin/revslider-admin.class.php\";s:64:\"5f939196ce06b5ab6a121975f0a3460ee409898d77107e8fd09484a8f960987d\";s:22:\"admin/assets/index.php\";s:64:\"ae6fc10874855daddd44765416e0f28da65a2b89e9e32802dd66e7fa6690d2d9\";s:27:\"admin/assets/css/basics.css\";s:64:\"e5423c2dc742b4bdbf66c62dc70308d7733dcc6528e79f1f843c634d04e9af8a\";s:32:\"admin/assets/css/builder-rtl.css\";s:64:\"f814492ceeba94b6490a520e742a803d7b531a614b3a1de1876a1d48b3ff639c\";s:28:\"admin/assets/css/builder.css\";s:64:\"ad52898c5bd4b9a23ef9b926cc8d9e961b518b3be04e81ba2efc89efc02f7128\";s:31:\"admin/assets/css/codemirror.css\";s:64:\"2e11f933dfa7cf4af1e6c6dd8007d84b02a56b256d086003e3673cc8ff10f1a6\";s:25:\"admin/assets/css/help.css\";s:64:\"0bb2181f2f91524e22af3f5fc6e62075be9d44897d463c94a369de8ca29f001e\";s:26:\"admin/assets/css/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:30:\"admin/assets/css/select2RS.css\";s:64:\"56393588b984bde1ad4b56446439f1d82fbd06b37c666d1ce64a1be12bf6d002\";s:28:\"admin/assets/css/tooltip.css\";s:64:\"e7a0b0c3ea280a3dbf7ed15ced9355bf4442d7b8a5b04bf8262e1b169d3d73b3\";s:36:\"admin/assets/css/tp-color-picker.css\";s:64:\"5f4984d1249ae63a8c8ac52edff9aa358e7db194dd30dc1bb2429be4461ca753\";s:44:\"admin/assets/icons/MaterialIcons-Regular.eot\";s:64:\"8c998b4a9c0acbb9fe5dd572c206a5a33fdd5ca2b58db87fc3b893beac85068d\";s:46:\"admin/assets/icons/MaterialIcons-Regular.ijmap\";s:64:\"88182029715624355dbc49c97b3af61e311538ddd33d31c6f4d13b2937411d1d\";s:44:\"admin/assets/icons/MaterialIcons-Regular.svg\";s:64:\"8b922129360ee12051269278e95ccff05ab4a60ccd39b9117f8216ede63a91c0\";s:44:\"admin/assets/icons/MaterialIcons-Regular.ttf\";s:64:\"b7f4a3ab562048f28dd1fa691601bc43363a61d0f876d16d8316c52e4f32d696\";s:45:\"admin/assets/icons/MaterialIcons-Regular.woff\";s:64:\"c4a1baec300d09e03a8380b85918267ee80faae8e00c6c56b48e2e74b1d9b38d\";s:46:\"admin/assets/icons/MaterialIcons-Regular.woff2\";s:64:\"a87d66c91b2e7dc5530aef76c03bd6a3d25ea5826110bf4803b561b811cc8726\";s:28:\"admin/assets/icons/README.md\";s:64:\"402d2770ce34261fff627b7ca12775ad286be2d1e49a934d4bb9383139761ad2\";s:29:\"admin/assets/icons/codepoints\";s:64:\"dc0a89e73a83c4a4eeb14b9ae5a7bccb76f01fee1b13b243bfe9b266a249fc2d\";s:37:\"admin/assets/icons/material-icons.css\";s:64:\"afb727c828f3957ada8e546f9bce9c9c733bc1d2f09a83eb47f2114302cd9f2b\";s:36:\"admin/assets/images/UI-ICONS-BIG.png\";s:64:\"8309cde41bcb3a757d014256fb00609001b9a13789361d41b94a6d8f9a677bc6\";s:39:\"admin/assets/images/UI-ICONS-BIG_bg.png\";s:64:\"a224fc7c20a805a335e52897abea5d49c974ab496005080f15a294b79e289815\";s:32:\"admin/assets/images/UI-ICONS.png\";s:64:\"b8a3ec9b7472285c6be8764e8c79f3a9595f92f9f175d87a9760c40c713ace65\";s:35:\"admin/assets/images/UI-ICONS_bg.png\";s:64:\"1fcc2359e0afb275ad9faf97a924f5d5f2325864b5675afc10ddd83752b74305\";s:39:\"admin/assets/images/active_bg_modal.jpg\";s:64:\"17ecf0fc21e69374c4419e73d4325100ccda5c215115e3325dab66eb24f422ce\";s:29:\"admin/assets/images/check.png\";s:64:\"b29d8a045d0c404209dc1eb5ba7ac4a7c86fdd697373fd7c3f1c0ae97a5d47c4\";s:39:\"admin/assets/images/dark_pattern_2x.png\";s:64:\"f824a0fcfc076e3506c47181c0d47e34a69e9db58fd96ff4774d3f3b5b6d7338\";s:29:\"admin/assets/images/dummy.png\";s:64:\"69539b5b3777cffda28a66d7f2aa9b17c91ee1ec8fd50c00c442af91753a60f7\";s:32:\"admin/assets/images/gridtile.png\";s:64:\"71b8a238b9bd03570c3d2b5a6907d6db6e4ba6e1d8be7b454c69c4abbf31edc2\";s:36:\"admin/assets/images/gridtile_3x3.png\";s:64:\"71f4cfe8713e2d57e4cdf8e160f60e8df3cb64ada67962302308d8d32a6cc3f3\";s:42:\"admin/assets/images/gridtile_3x3_white.png\";s:64:\"27c29032de418b1950dba1efe909414e56142d088e3093307ed161ac072bff85\";s:38:\"admin/assets/images/gridtile_white.png\";s:64:\"1dd723b101f64f8555d58fbe4a7bf4781ec732fc162783c3a065d8485117fdbd\";s:28:\"admin/assets/images/hand.png\";s:64:\"defc640a8b92201ac144a8bf82c2469f58c386473edba5c10103f5d89693fd53\";s:40:\"admin/assets/images/light_pattern_2x.png\";s:64:\"3bc3620ff365e1140e8699bc4b8de2107be52e87338a5bfdf6bc59a2c6987e6b\";s:37:\"admin/assets/images/modal_asset2x.jpg\";s:64:\"9d3ed1573a9ff7b864ddd46fcd0248af7ee7e14333b1390f164ccfaa9275e9f4\";s:32:\"admin/assets/images/modal_bg.jpg\";s:64:\"6488a70995e61f41dca7acdd5ea3149aa379b381ba4becf78d8a89884a644948\";s:28:\"admin/assets/images/move.png\";s:64:\"7f5ad57e6db0f4817e5d7b6b061f88c860ba746d74734715753a5e6260949b28\";s:36:\"admin/assets/images/point_bottom.png\";s:64:\"34398b312ba7fe9c51fb94456214a7f4e6c03860218450be05ebe6040e2a2c6b\";s:33:\"admin/assets/images/point_top.png\";s:64:\"ab3a334761e0f1d22fa69ea22ac564e83a908674e8324e7add58d6c5990fb118\";s:31:\"admin/assets/images/rb_logo.png\";s:64:\"ad8daaf4061d9e29b6924e3a5d5933299bec8b0411b681adabb29969ffc13ab7\";s:34:\"admin/assets/images/red_diag2x.png\";s:64:\"3a4bc5b13f6bf517560b65d7721a1e8cafd89cd6a3807a05ea02b6d80b628b27\";s:30:\"admin/assets/images/resize.png\";s:64:\"f09329e7a74df8ae9a35aa80f620fe87a27f6e588c184352ba08d3cbee488e93\";s:34:\"admin/assets/images/resize_old.png\";s:64:\"3fff7f0227aa525da07b9ce5ba515ff07aacc02cef17d24b3820e00d59dc9a25\";s:30:\"admin/assets/images/return.png\";s:64:\"1ffe67dfdf227e584118a858ed95e6c3a2610d55f686ada9d99468e3ccdf2e70\";s:31:\"admin/assets/images/revlogo.png\";s:64:\"9b9f04e77c92b456d57e874eef47dca2ab7b6401d234d12a101146c60d0a90c9\";s:35:\"admin/assets/images/rs6_logo_2x.png\";s:64:\"cd445ca3726da218e9e1e1f00ac1f53e7ec46fab85da51bc535b9ad49bee228e\";s:37:\"admin/assets/images/rs6_number_2x.png\";s:64:\"ed896bd6f181c8a7c6c0255f9a197ec3b305ab5cb1a6e1ec78524b06e9ae8ca3\";s:38:\"admin/assets/images/tp-brokenimage.png\";s:64:\"1306aded900d43461c2b5a83bf17e15e27594e60d7fe37b48d438e2f8ff79794\";s:34:\"admin/assets/images/trans_tile.png\";s:64:\"de88c2c9dd9fd2c79a1702f3d78502982f311a0f1ee95f7af9a49c786467e81d\";s:35:\"admin/assets/images/transparent.png\";s:64:\"f1bd92c463d12ce6843f60eafdfae463c377da9e4384faf0ea7fd303f0f0eb2e\";s:47:\"admin/assets/images/transparent_placeholder.png\";s:64:\"b65d53c2ed7af699179f0226f75d3b873710996cd2a589ba5460bc771c5141da\";s:26:\"admin/assets/images/wc.jpg\";s:64:\"e81aa9b11b00f8f187b13cb527f6a2ae020e673262ec39ee0bbf8e3fdfe36433\";s:31:\"admin/assets/images/wc_logo.png\";s:64:\"ec1ee9b12a2defa72c1a931eb7bf60d5119dc2c03b54ebb725e0d6fbcb5c98dc\";s:30:\"admin/assets/images/wplogo.png\";s:64:\"292fdf705e6afff430f6c6940818b214fde96d816e8e795350d9f65b1ec3c4bc\";s:35:\"admin/assets/images/guide/guide.jpg\";s:64:\"d04a3ecc9f645b5271ec974db385e7b6aadd917db3bde141fc9bad5c04c552ab\";s:40:\"admin/assets/images/guide/guide_auto.jpg\";s:64:\"6211002a12349f4a6ec4ba5040daf53bfc34886811aeb2a3502e73b458febc97\";s:50:\"admin/assets/images/guide/guide_autoresponsive.jpg\";s:64:\"e55b9ca4d3cd8d621276dd5494dc2aaa876c7d14b7f3b377d56aa51c3d67f8c9\";s:44:\"admin/assets/images/guide/guide_carousel.jpg\";s:64:\"c7d11098a081465f21809756c851ceb73d6d235e167c759354f14e2d2387b149\";s:46:\"admin/assets/images/guide/guide_fullscreen.jpg\";s:64:\"5d8cff981422c79ba7fa17c5ab7696346744771249ab92d3e53ee17fa17e0870\";s:45:\"admin/assets/images/guide/guide_fullwidth.jpg\";s:64:\"60dc73ce677cf23014dc7a5dd87bd5119f43ef29ec08287920e2cfbd95349979\";s:47:\"admin/assets/images/guide/guide_intelligent.jpg\";s:64:\"e4e785915db415f6edeeb3b38a7ae9b3e785aff78cc4ca60c929844a8e03441a\";s:42:\"admin/assets/images/guide/guide_manual.jpg\";s:64:\"0c82ded71280094fc268d5cc4b35aa1bb73e97a4575e5c652c06d4b4eb5e3896\";s:41:\"admin/assets/images/guide/guide_scene.jpg\";s:64:\"98b3f28ebbfd27d59636948497867c6c3874c2a5d6f440ca6142320a5ac37c9e\";s:42:\"admin/assets/images/guide/guide_slider.jpg\";s:64:\"e863e4b5366136f6ab35e157408a32f65dfdd4c9d8b1edaa8638275ffdbb479f\";s:49:\"admin/assets/images/guide/video_addnavigation.jpg\";s:64:\"61d9d9a4bce6d3568f4df80bef4c83bd685eb07276fbcffd013bcd37a7268d2d\";s:51:\"admin/assets/images/guide/video_backgroundmedia.jpg\";s:64:\"b6f65a850eda05efa722eb962ebe74d2b7dc9d03d54a26abea972d2318dbda00\";s:44:\"admin/assets/images/guide/video_kenburns.jpg\";s:64:\"40c170d8660f52638fd26d456a1ec6aa16ca720c7d6a9059a877f1d4c58b16f5\";s:44:\"admin/assets/images/guide/video_parallax.jpg\";s:64:\"c35a2a49cde585257f8ea530974a6a9ab106ea3eb64511685afa5751f8126646\";s:45:\"admin/assets/images/guide/video_preloader.jpg\";s:64:\"dc75eae4dbe030addf108997cec65d1347b0179530a5e272399cc2fdd241cf67\";s:50:\"admin/assets/images/guide/video_slideanimation.jpg\";s:64:\"d3fdc3a270aafd14032674e6c9bc0e33d26c184acc6a056feeb787a65807e274\";s:40:\"admin/assets/images/socials/dribbble.png\";s:64:\"eccf6cd7d9c837658cdc7557c1a5cb568b217f4c5be678df085e756b59fc01d1\";s:40:\"admin/assets/images/socials/facebook.png\";s:64:\"8c1664480d3173a9589ed7715389accf7276360f3e10bc5a78cdd78971e7b9cf\";s:42:\"admin/assets/images/socials/googleplus.png\";s:64:\"871c106f57c031695b4fa87bdc2da257d6a63407027a5c5edd25f7fa930192f7\";s:41:\"admin/assets/images/socials/instagram.png\";s:64:\"fb55da35fd109dda13f151c16c10765ca4d18def3061785b0c66c7743040fdfd\";s:39:\"admin/assets/images/socials/twitter.png\";s:64:\"fdd2d2b2092974ddb05e35cd6c44871b4c0bad80ca8aa5a560f742511d63e5cb\";s:39:\"admin/assets/images/socials/youtube.png\";s:64:\"f9799e89df6a96ffced54075d23eaf47ad290c2a38bcb809ccb323e063ed6c4a\";s:40:\"admin/assets/images/sources/facebook.png\";s:64:\"202540c1f898c94e83b49038ceb28ec48e078f9460706244f7ca294e5b09c3b6\";s:38:\"admin/assets/images/sources/flickr.png\";s:64:\"351a3549e7c6b3d80ace1b2996acb7a1c5b1f17d51c62b5ce639eebf5b9cc2cd\";s:39:\"admin/assets/images/sources/gallery.png\";s:64:\"868cb041e5cd1d8c3dd980d0f2b63bec1d0db9ed1d2e667f6d47c807a38718c8\";s:37:\"admin/assets/images/sources/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:41:\"admin/assets/images/sources/instagram.png\";s:64:\"a4370783505a6a90f4c445ba3b7478baf852351c71deec6d797fe579bb6a9ae1\";s:38:\"admin/assets/images/sources/notice.txt\";s:64:\"126128e2388e7d373aa092a9c55f484ffeb2ddb0df66c10411594d40a1884c92\";s:36:\"admin/assets/images/sources/post.png\";s:64:\"bc7b40d886192b3ead79aedb2cd1855dba921cbd6c224b582f756a62f320c28f\";s:38:\"admin/assets/images/sources/static.png\";s:64:\"868cb041e5cd1d8c3dd980d0f2b63bec1d0db9ed1d2e667f6d47c807a38718c8\";s:39:\"admin/assets/images/sources/twitter.png\";s:64:\"4563c3ac62ea1a05c5b3f25eab448caa131f1bdbf8bc5b15e54a623436c2e58b\";s:37:\"admin/assets/images/sources/vimeo.png\";s:64:\"76c3a285ea36fa9170b76610cb4b41d447898fd55443edf618aad6b28086d400\";s:35:\"admin/assets/images/sources/woo.png\";s:64:\"7eda50bf7a85bf75e3cf2f332413cc2daabc147feaa393ae080b082114811528\";s:39:\"admin/assets/images/sources/youtube.png\";s:64:\"67419aec01cea6047a67ba733cdaaead38c9112da951be1f74007fc10ba6b89f\";s:36:\"admin/assets/js/modules/admin.min.js\";s:64:\"1b673f216e9b3e467dd0893024545cd893ed3bac8e6b8f923ea2e88b43050d34\";s:37:\"admin/assets/js/modules/editor.min.js\";s:64:\"9ae51f2c7f9978512eebb2e8087f30e404efe997c897755e9f67fee341cc1e66\";s:31:\"admin/assets/js/modules/help.js\";s:64:\"0666c042b16ba14de69119955c7c244a5833c25b3c6043be9c77501f87d35425\";s:39:\"admin/assets/js/modules/overview.min.js\";s:64:\"6ff64cbd0dd44e71528e5690e72581e13ce1a51b52a336046dd40212d8dcc314\";s:34:\"admin/assets/js/modules/tooltip.js\";s:64:\"bc6495f4dbf9bbbb477389d6efdae4d7bd060e7b6976b3de6a73bd4d4a7b95ad\";s:37:\"admin/assets/js/plugins/codemirror.js\";s:64:\"ba05e0676ebcbbaf34c2414c942ba2fa41946d6aeb0e0ddf1fc9423478014b5b\";s:40:\"admin/assets/js/plugins/penner-easing.js\";s:64:\"1a7ff16e46eede4a8dcd951acbdbd1cebff68a965f20050865cdc43418608af8\";s:36:\"admin/assets/js/plugins/utils.min.js\";s:64:\"eee6cf3efe3c8d25df41a9731759e94d7d559966e181d3a0fa151ded637b3395\";s:37:\"admin/assets/js/plugins/wavesurfer.js\";s:64:\"5b31e8381937f666e18cfb64d4613b6d30d1f752f0c7f09b2c8015ccd370db08\";s:58:\"admin/assets/js/shortcode_generator/shortcode_generator.js\";s:64:\"cef020ad02cb0c7a0735133b1d93c4c333cb22853914e59c0103bae1d47b741f\";s:46:\"admin/assets/js/shortcode_generator/tinymce.js\";s:64:\"bf06203d1152a3499349ea6d0500c91cfa25ba5d9cf3be29f220d3ad58fa559b\";s:41:\"admin/assets/js/shortcode_generator/vc.js\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:38:\"admin/assets/videos/hover_tutorial.mp4\";s:64:\"026c4a507f9431baa95c701c633fad5392f1c93e6aea6b4a2c95a9f766e7b8f3\";s:31:\"admin/includes/addons.class.php\";s:64:\"837b196340c9f7c323f017422edf3b8bc01dbf1b92cb816673b47546f70e40e3\";s:24:\"admin/includes/debug.php\";s:64:\"27b1f7b1180cd728beef64bfd791eea05f6e2fbdfb2c82fa36d2727df6aad5a5\";s:36:\"admin/includes/export-html.class.php\";s:64:\"d1ce2873bcf1de469a29194eced3dbf5b22d93c17fa0550cba5fdb677e3901e7\";s:31:\"admin/includes/export.class.php\";s:64:\"3bf3a0f939eee2be3c648b1b93c17612a7ab698f645729a17640d4930f8b72c4\";s:31:\"admin/includes/folder.class.php\";s:64:\"668880574463b53d46069a478a23ed894564096dca53e367f82035018e593bf9\";s:40:\"admin/includes/functions-admin.class.php\";s:64:\"e8ee9a300d5fbb8948a0b15c1ab047a1e4c66b2c0e0f5d42c9c440d739ede036\";s:29:\"admin/includes/help.class.php\";s:64:\"b2b3e002c96d5298d21aece7f6b97724cf35854ae83034a8c4d3928aa7c931c9\";s:31:\"admin/includes/import.class.php\";s:64:\"abe0960180bd749c5724a9db256321ad617912e715655d30240948dc20ef817b\";s:37:\"admin/includes/loadbalancer.class.php\";s:64:\"0cfd0162d0db6a3286862bf51bac5e3b512a268574c6f38c2310b4b2a2e80190\";s:35:\"admin/includes/newsletter.class.php\";s:64:\"22c72250809fe6adecafb577d34803d0e009b12b8ce05889deda2b6aea6dd716\";s:38:\"admin/includes/plugin-update.class.php\";s:64:\"ccb03d9a1295c03f1d3f234a5d2931c99e2041320d90046a578dcba3c82eb4ba\";s:33:\"admin/includes/template.class.php\";s:64:\"5a14b4eff2929b7be5b4eb460c3cc7a3d3a28044a268ead13f0a5cea37268a34\";s:33:\"admin/includes/tooltips.class.php\";s:64:\"575a99463b3448fa00374ae894fcc05e450518844910fc34ecf65aec449c5b22\";s:31:\"admin/includes/widget.class.php\";s:64:\"8be15b36cf1e5bd50a14e9071010e109cbb6f5dd3e91c0e8a0c1bc0892ab386b\";s:64:\"admin/includes/shortcode_generator/shortcode_generator.class.php\";s:64:\"9a12d09bb64a541f8dae304472a7ad16f12665cb9732d69e791f4b5b0f558662\";s:71:\"admin/includes/shortcode_generator/elementor/elementor-widget.class.php\";s:64:\"04e287a3268a772c562ca3c2c687ab4b54e88499d4342a621c2b7eb5b40ebf35\";s:64:\"admin/includes/shortcode_generator/elementor/elementor.class.php\";s:64:\"4fe51b8a1c9b7ddbf1657c8ed315d7863a123707f76f77c1bedd5bc97b985441\";s:72:\"admin/includes/shortcode_generator/fusionbuilder/fusionbuilder.class.php\";s:64:\"f9362da640300d8995fb78424143ffddb6a725dcd452c7551a42244fcce9ffac\";s:54:\"admin/includes/shortcode_generator/gutenberg/README.md\";s:64:\"2464d9cba2ec8666bd3412c3240dbe66c6bfbef4a6596cbf85455eac0c2fd0cf\";s:64:\"admin/includes/shortcode_generator/gutenberg/gutenberg-block.php\";s:64:\"65150faa09f88b8a71a0926139431ec61a44fc1193bbacb74344e16a48af6513\";s:57:\"admin/includes/shortcode_generator/gutenberg/package.json\";s:64:\"3dc1b828068b59d2b291a4528e9673fc099aad4e943816ca1a18c3af7c8f8ea9\";s:55:\"admin/includes/shortcode_generator/gutenberg/plugin.php\";s:64:\"ca5b977bb88f55c0f899ccbf5340dbb2aa8fc21e0a548dca7850863802b3851a\";s:65:\"admin/includes/shortcode_generator/gutenberg/dist/blocks.build.js\";s:64:\"2070a9dd0833a7b6a2499d02ee6ffb32d1ad3d1f8e07c7ddc731c2ad3be25b3d\";s:73:\"admin/includes/shortcode_generator/gutenberg/dist/blocks.editor.build.css\";s:64:\"6dbfdb3f0689e2ddf7df17dc958bb52a301e6d2288956656f6ff56f9a4d5f3f9\";s:72:\"admin/includes/shortcode_generator/gutenberg/dist/blocks.style.build.css\";s:64:\"634cb987a331fb17d0c89658e59fa14d57dd8de253d00295a811d6114ff5caeb\";s:72:\"admin/includes/shortcode_generator/gutenberg/dist/images/rs6_logo_2x.png\";s:64:\"cd445ca3726da218e9e1e1f00ac1f53e7ec46fab85da51bc535b9ad49bee228e\";s:74:\"admin/includes/shortcode_generator/gutenberg/dist/images/rs6_number_2x.png\";s:64:\"ed896bd6f181c8a7c6c0255f9a197ec3b305ab5cb1a6e1ec78524b06e9ae8ca3\";s:58:\"admin/includes/shortcode_generator/gutenberg/src/blocks.js\";s:64:\"efd8c7b995c1835886c682bea7a6e9df312f7b8e9634cc0f82e159d958e81ef8\";s:60:\"admin/includes/shortcode_generator/gutenberg/src/common.scss\";s:64:\"be5178bf1db137be216ce89aef3c1c8c9bc6f14fdcc17142a6deb9aa7c99c2e6\";s:68:\"admin/includes/shortcode_generator/gutenberg/src/gutenberg-block.php\";s:64:\"20a1ac155a9f56cd59f3fcfe9fdeb3b7d3e2143ee0a155a1ecced49b3b3073c2\";s:74:\"admin/includes/shortcode_generator/gutenberg/src/assets/images/esglogo.png\";s:64:\"fac10591d1459fa6b2f717f0f3c1d86434df1c648e0ac87c6b52c888ee923176\";s:75:\"admin/includes/shortcode_generator/gutenberg/src/assets/images/js-wapuu.svg\";s:64:\"61c447e08efea7e9c2a16852d5cee3353ea68c36ac6d1e279f1c3c1de702b657\";s:74:\"admin/includes/shortcode_generator/gutenberg/src/assets/images/revlogo.png\";s:64:\"9b9f04e77c92b456d57e874eef47dca2ab7b6401d234d12a101146c60d0a90c9\";s:78:\"admin/includes/shortcode_generator/gutenberg/src/assets/images/rs6_logo_2x.png\";s:64:\"cd445ca3726da218e9e1e1f00ac1f53e7ec46fab85da51bc535b9ad49bee228e\";s:80:\"admin/includes/shortcode_generator/gutenberg/src/assets/images/rs6_number_2x.png\";s:64:\"ed896bd6f181c8a7c6c0255f9a197ec3b305ab5cb1a6e1ec78524b06e9ae8ca3\";s:72:\"admin/includes/shortcode_generator/gutenberg/src/revslider/deprecated.js\";s:64:\"99457402ad4338fad79d5eabadab6af50b8591007d65229b97a226cdb7b1dbe2\";s:70:\"admin/includes/shortcode_generator/gutenberg/src/revslider/editor.scss\";s:64:\"7ef54f16537496b99a2d7cb1ae320feb363005812357537600afce2a68d768a5\";s:67:\"admin/includes/shortcode_generator/gutenberg/src/revslider/index.js\";s:64:\"892f4359a45b7d1010343fae3cc346bbfbd54412d7956084f0c086120011dda4\";s:76:\"admin/includes/shortcode_generator/gutenberg/src/revslider/revSliderImage.js\";s:64:\"e73cdb93818b7c8c3bada1ffe89b98713d4c7eccb1689ca93b0207555e3b397a\";s:71:\"admin/includes/shortcode_generator/gutenberg/src/revslider/revslider.js\";s:64:\"c4ce472f248058074e8bb65004599bc591fb499526aef631a2937689e37d31b5\";s:69:\"admin/includes/shortcode_generator/gutenberg/src/revslider/style.scss\";s:64:\"6360332bed614ce6a5887b91a76b790d04171b0f1b7ad91d11ad7ea013c8fb15\";s:62:\"admin/includes/shortcode_generator/wpbakery/wpbakery.class.php\";s:64:\"69dddadf7be06dd70691004db07d904b56f6ac47812320db3b5d34045623985b\";s:35:\"admin/views/builder-layer-forms.php\";s:64:\"a6878f891188dc3627a75de9859def02e490c92a255611c694f7a0e4bd7dca12\";s:33:\"admin/views/builder-nav-forms.php\";s:64:\"1120324f2c94b25bfcfc5617dd872ef259c3277d89334dd04bcc6612bd13d52a\";s:35:\"admin/views/builder-slide-forms.php\";s:64:\"feb3f12d764214a8dd73a19ff14eae3b51ad2921add6ae2696117bc32cbe9cb0\";s:36:\"admin/views/builder-slider-forms.php\";s:64:\"278a50aad3e8820b345e44af3ef19f7d955141cf0d428c673eba086a53fb36f7\";s:32:\"admin/views/builder-timeline.php\";s:64:\"e747ff11b902f347e814770017d581dbc1094f07de8cac2d9dea8edd4d2e4382\";s:23:\"admin/views/builder.php\";s:64:\"2140e3bc1b6eccfcc62ecce96f8427dfe4332df13a131ab8207dd1a0446563b3\";s:22:\"admin/views/footer.php\";s:64:\"01ba76fda5cc40f589b0531ec2c29815b7d357564d548261bb51f866b04d0652\";s:22:\"admin/views/header.php\";s:64:\"0cdaed45a07a4c124bb63948674527c825782466b08b8daa999606076805aea0\";s:21:\"admin/views/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:30:\"admin/views/modals-builder.php\";s:64:\"35469148acd36fa7078219d460c5ff858d367c2fc69ad625a8ef403db154625a\";s:32:\"admin/views/modals-copyright.php\";s:64:\"e1e3d4622c2237b115eb7e5a5b077e6c799f1461a08a2f520d27949e35aee975\";s:30:\"admin/views/modals-general.php\";s:64:\"a161ab24cd5c56cb8647ead4a899c72ff21ddeccf0ab374e9680dd9feee71c1e\";s:31:\"admin/views/modals-overview.php\";s:64:\"7ad1f963a81a332cf91205f8d0f4251ab780c9d9a257e402da7fc899cca50e21\";s:24:\"admin/views/overview.php\";s:64:\"9d9fd54829a2d71ce832e2d5c0fdb093ab9b396eecef3ab4802c5a5d34241447\";s:32:\"admin/views/features/add_ons.php\";s:64:\"2d6f9a15af937cfdcf605b022ad7a78ded85bcd89af7f9fdbb1023f9a1b41049\";s:30:\"admin/views/features/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:41:\"admin/views/features/layer_animations.php\";s:64:\"b0a3ffe1067725baae55595f35b2e729d005d1884ad7ad42e6c7926493cbd5f8\";s:39:\"admin/views/features/object_library.php\";s:64:\"7518e597c70510fec32933fa1debe3a674d70767f6f6f8932d693201d35508ac\";s:41:\"admin/views/features/premade_template.php\";s:64:\"4a2117abeee10db6f11f6dd39a7d37c842b5556a2b9332c6f7360cf23ddbbf3f\";s:32:\"admin/views/features/support.php\";s:64:\"5025ae9ed4e70b33e947920d34729685ab3d8dd688356d87ceafc72618e41b8c\";s:39:\"admin/views/features/assets/add_ons.png\";s:64:\"96fb6b841d2bc049fcba0fa80ef79de4ff77388dbf91d6ab6fc598e95f503a02\";s:38:\"admin/views/features/assets/addon1.jpg\";s:64:\"3c96a68fd78f03fc3e5410170fad75c91f738e0be582d9d8c54c167bd6faac71\";s:39:\"admin/views/features/assets/addon10.jpg\";s:64:\"5cff72c81bbf24757489f259f23300cc2ce1e24b9d95824d4f3a9b2d8f20a3cc\";s:39:\"admin/views/features/assets/addon11.jpg\";s:64:\"b19e4fa5383868c975e46e2691cde73c18d25a6fa166911c50ffef4aaf4fac14\";s:39:\"admin/views/features/assets/addon12.jpg\";s:64:\"97d66387851a59cbd865b1a6fee7484a4e4fa2a0f438a0e516a8a1543f48e497\";s:38:\"admin/views/features/assets/addon2.jpg\";s:64:\"b95f83b889b4d22f101494f10db3578caded883e7f09bed2a25f9dc3a166c6cd\";s:38:\"admin/views/features/assets/addon3.jpg\";s:64:\"bcf5f7bc1cf3fc2e2401bf626596f46fb7c966b40c110d570de4bf9e64905637\";s:38:\"admin/views/features/assets/addon4.jpg\";s:64:\"d2175d4787a5bc31d9ec691247004c4fe43b1e27ad247c5a73e92c985a2978c7\";s:38:\"admin/views/features/assets/addon5.jpg\";s:64:\"7c3d70a0629604ad7bed73446e938b079f1df559d117905ad4d0b8ba538e1560\";s:38:\"admin/views/features/assets/addon6.jpg\";s:64:\"d08bfca4bc79226fe9f9494c5e3ccd0a1f5ee720ca86b85a2cdb8d460194c6bf\";s:38:\"admin/views/features/assets/addon7.jpg\";s:64:\"3e0fbadec6e55daa136bb03f8b2cb442465984f80ef86501e9efc7de3a2ccd4a\";s:38:\"admin/views/features/assets/addon8.jpg\";s:64:\"f76ce3e794787a1550473e062c6c1683e426f702e3d5386ea676c7b50c85386d\";s:38:\"admin/views/features/assets/addon9.jpg\";s:64:\"7878375cc336a8341c30d96d978cc3051f78cb59d74759fd59285fcc66fd06e4\";s:43:\"admin/views/features/assets/addons_bg-2.jpg\";s:64:\"c53e7c20f2c1966ae5146d16dabb74b79530e5c3a5c4dd54bf05fb282252d2d9\";s:37:\"admin/views/features/assets/dummy.png\";s:64:\"17af9e65317bbbfbbd0bcdc729f14faadf37cd08cf30cc0fe0b72443e78cbffb\";s:48:\"admin/views/features/assets/layer_animations.png\";s:64:\"8b97dad548ecf3ad58e242e97d8a6f3c2a40862f5a8443da482d4c59090e4e17\";s:51:\"admin/views/features/assets/layer_animations_bg.jpg\";s:64:\"f1e60e1e34f8cfd1edac9ab4f6668d8f3f3293ccaca37123ca5900254bb322df\";s:41:\"admin/views/features/assets/layers_bg.jpg\";s:64:\"a2094004d1c3d41a5be38c934e377740e80738b39a5c64aa326200aa815915f6\";s:46:\"admin/views/features/assets/object_library.png\";s:64:\"75c5c9f4a02ae447dc1389073b0a368961d0329efe7ee745b5d66b3c9301ab4d\";s:51:\"admin/views/features/assets/object_library_bg-1.jpg\";s:64:\"233b17c0d88b2c69e1c8482c8ab468dc3a3bfeaf4da4184102bc71d315f97fcb\";s:57:\"admin/views/features/assets/object_library_headphones.png\";s:64:\"4a7cb601c92ea14a79c41c52fa61073941742256a9b39fcca5117ac377478edf\";s:52:\"admin/views/features/assets/object_library_phone.png\";s:64:\"e441a781269ad9a9f21f675007da81b6b49e3d6675523250d03202efadac6851\";s:44:\"admin/views/features/assets/premade_left.png\";s:64:\"d6262fc3ba8fffb98ff03130f887efc7041663ba6a6efdea76019e723a9357fb\";s:45:\"admin/views/features/assets/premade_right.png\";s:64:\"f1c1c7b56b43f9f7e3f714cfa453315620de6223857a7257312c6015d934118e\";s:49:\"admin/views/features/assets/premade_smallgird.jpg\";s:64:\"2feb8a6201d288b64e38fd8a070ec9511a5b6b6177ed3a8995e4fd32a5aad7ef\";s:39:\"admin/views/features/assets/support.png\";s:64:\"310257766bb9c53e37170d5f7fe1e49bed0a58a87ef0e807cb9bcbd4b59c4f02\";s:44:\"admin/views/features/assets/support_bg-1.jpg\";s:64:\"93b6687e1e441c7570e9f504751b663c6d6c3011f377d3eae0987e87309efa78\";s:43:\"admin/views/features/assets/support_bg2.jpg\";s:64:\"527bbcbd1c80b7138365ad99ea3a643f4d9dffec5ff4a6c8b2a650b0268900bb\";s:43:\"admin/views/features/assets/transparent.png\";s:64:\"8ea078292393a14a8e44be139a7fa6ed09d9c650e210eccca587045239b71cab\";s:16:\"backup/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:29:\"includes/InstagramScraper.php\";s:64:\"b6c1995afd7981b29cb5096ff99247251c60910f793fd22c23ff3c8d71b8c19c\";s:20:\"includes/Unirest.php\";s:64:\"87b480d091661be15d74c5e9c4b7b8852bf66d59e22fce81b291de085b72af9c\";s:29:\"includes/aq-resizer.class.php\";s:64:\"c76eb2a9d72dcb3390a68e696e1d2de0dff19615cc734eac5f80a3a7b46244c7\";s:22:\"includes/backwards.php\";s:64:\"8644bf563db4b7988aa4967fa2fcd08cf564d08a0c36bac4a78dcabb4630c6ab\";s:22:\"includes/basic-css.php\";s:64:\"f9a052ce264163ad9141a12d0503e144c0b98d9d2b626912f664a650ce2cd90a\";s:30:\"includes/coloreasing.class.php\";s:64:\"b9fae53a3df0b6e84467adee087091fb0e88690c4844ca38785337b2cb61c85d\";s:30:\"includes/colorpicker.class.php\";s:64:\"2b1b0a719f48fd92830dfddfc9097f92b7d638a18f9bb0807508ea1e8892c8a0\";s:28:\"includes/cssparser.class.php\";s:64:\"e0cb0f34262ec9580a8e11074f224533f18258c139f2f6adaf9278eb5c61af00\";s:23:\"includes/data.class.php\";s:64:\"2bc946e79c5369d5984418143e684cd825adb31907bc71705a49075670d1bda4\";s:33:\"includes/em-integration.class.php\";s:64:\"3ea8e4ef346b4599ee955abd00636cd8ebe0bf8c5dda6bebc3a6745e31496151\";s:28:\"includes/extension.class.php\";s:64:\"2c1186cabb51bbcafbf9ae8e409464821261bad96cb0ec1c1a4e7ad3ea408eb3\";s:35:\"includes/external-sources.class.php\";s:64:\"31c8fe12b8dd901629b07acb72c53afc005a71b97521e93f93387d5178824f18\";s:27:\"includes/favorite.class.php\";s:64:\"6abbd236e879d8f829fd8292436a89c8fb7e03fb3ac9f1fa3bade4b363f9eda9\";s:28:\"includes/functions.class.php\";s:64:\"54226614bda93517ee8e871ccd1b0eb4425412e36cfc173853d8c5620d2ad91d\";s:24:\"includes/googlefonts.php\";s:64:\"fe0349d84d40be776caf50008f49c019c2bc7707b25e918a4d1b4572ffb75edb\";s:29:\"includes/navigation.class.php\";s:64:\"6ea4d93939ce8d939b7e3e863aaa2d0c1dabedc14dcab13e002d3da3e6d0bda6\";s:24:\"includes/navigations.php\";s:64:\"1800f6eea89f7f88da09996e1a9c0eef8b920ed0c913deb266f2c66d69d0fcbe\";s:33:\"includes/object-library.class.php\";s:64:\"8d99362f536f44f54fb7ecad8249036190896360d7aa8ed7ecb547423481467f\";s:25:\"includes/output.class.php\";s:64:\"9b4ba502d033de7912eb4c3ceb3fa1432d544f1fdbf577920eb34ee185ad41b5\";s:32:\"includes/page-template.class.php\";s:64:\"0970d7f374a664c6f3f061b5820da24358b8aa50c228ff21a039cd0fbc5bf035\";s:24:\"includes/slide.class.php\";s:64:\"851164d4c70f3646bbeb02afb7d44def95eb222ff78a2ea759c471a75b998ef3\";s:25:\"includes/slider.class.php\";s:64:\"83ba0ac5da950c5c18a8ed60b0eeb1354144553fb69096e1fbb057cdb351054a\";s:25:\"includes/update.class.php\";s:64:\"6f7b1261f5f1fdf54fa3c0b48c1666df6ae3f73cc7041b94b7a048cb82f8b9b9\";s:30:\"includes/woocommerce.class.php\";s:64:\"1f1bc10faf857c06ffafe6740049f5da7e168213dea941bcbe8f6ff7166f8958\";s:23:\"includes/wpml.class.php\";s:64:\"a5f227b274467ceb0b478e55decfa246703341f61b809fdb3db8615b7a1e0227\";s:39:\"includes/InstagramScraper/Endpoints.php\";s:64:\"8f3591b3ffb5a1daca12467e8d7afc29435d1136b0b693e3eaa4ce0a02b1dcc0\";s:39:\"includes/InstagramScraper/Instagram.php\";s:64:\"5f546dac80cd784cb45fea3c54e52bb75f1f8e0f470e45117c44af4dc459e867\";s:46:\"includes/InstagramScraper/InstagramQueryId.php\";s:64:\"02d5c38d0b845e53141d357735e166069aa6cbf106318ca17b25346dccc720cf\";s:43:\"includes/InstagramScraper/Instagram_old.php\";s:64:\"580217260b9494cd773ddd3070173a18d3ebcea8964e4da709e7957936639b86\";s:62:\"includes/InstagramScraper/Exception/InstagramAuthException.php\";s:64:\"ad8a6ebe0eb4aff6b61f723516af75fe580e45f47ed9b67acb7a1dd4fac4eca7\";s:58:\"includes/InstagramScraper/Exception/InstagramException.php\";s:64:\"72570b2ba1943c9fbcb7ec601b2606b1b6245a44d61d1417ea293c357fda626c\";s:66:\"includes/InstagramScraper/Exception/InstagramNotFoundException.php\";s:64:\"6494e53fe7efe6d6336e114237365e84b1eea820d2c7ef1e8047246f517aa57d\";s:49:\"includes/InstagramScraper/Model/AbstractModel.php\";s:64:\"0669f393a8c3c7138239c11bd495a1e01cb5e38d524797bda0ae1182bed3f282\";s:43:\"includes/InstagramScraper/Model/Account.php\";s:64:\"f74753bdb4d6fa465dbb620cd88363cf59cb08988cf0ab90a2afd1ec3b71c5fb\";s:49:\"includes/InstagramScraper/Model/CarouselMedia.php\";s:64:\"9aeef630302bc13e4b0eb581d4fe5a028bfe482679c6c1de12c7f6bee36709d7\";s:43:\"includes/InstagramScraper/Model/Comment.php\";s:64:\"b229e099790d3091de53dc9dcd3224b43f6a3dbf3ccd3b1408844c4f180f7d6f\";s:40:\"includes/InstagramScraper/Model/Like.php\";s:64:\"2b817e2ac6b9e80382bd4107d6c00168b365eda3b5077126bccb1e77509ee0ce\";s:44:\"includes/InstagramScraper/Model/Location.php\";s:64:\"2bfab5fbab00843fde8874fac8649f43140fe350311fd3815a333615099cf75e\";s:41:\"includes/InstagramScraper/Model/Media.php\";s:64:\"4c4e061cc2fbf6ab48f8019317871f8bf1d95f7332356d214f1729acefd6964d\";s:41:\"includes/InstagramScraper/Model/Story.php\";s:64:\"bdc484342c42aa6998024920de5e2970b7b862c17fb0cb39490cd21165018c21\";s:39:\"includes/InstagramScraper/Model/Tag.php\";s:64:\"0544a543c1d346aa51fa72703f3b46d96546e20a50d01707d527c00e2018cbf0\";s:47:\"includes/InstagramScraper/Model/UserStories.php\";s:64:\"811c198285410b8e3804e5f6bb584f14aa06da42c8aa7fab00dcd3280d44c892\";s:51:\"includes/InstagramScraper/Traits/ArrayLikeTrait.php\";s:64:\"a5b63d339635e43f42af92613a7684c80cb3b158ad3510983aa88d5c68d57833\";s:53:\"includes/InstagramScraper/Traits/InitializerTrait.php\";s:64:\"d214374db156593dda9caaf70d36e0482fdda22ffe432358e935042a550dd9ec\";s:30:\"includes/Unirest/Exception.php\";s:64:\"d0806a98b6ebe83deedcbca2cd3262c1a572e0d41919fe53a4bcb393199fdba0\";s:27:\"includes/Unirest/Method.php\";s:64:\"264a8e8043fdd77153615feaecace61e8ad6a6006476eedde4c8edda9cfca826\";s:28:\"includes/Unirest/Request.php\";s:64:\"e5a75f5d02d44869616fab4c48b852fee79c39583f9ffe53198ba373f762ddf1\";s:29:\"includes/Unirest/Response.php\";s:64:\"5dee538c65123ac9d96c06696020685f1ddd66397f3d2c5a0847626c632cc08b\";s:33:\"includes/Unirest/Request/Body.php\";s:64:\"542d56094bcaff1b041d6d969334f7606091a5aa5166a97d052f57e1f31085f8\";s:19:\"languages/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:52:\"languages/revslider-de_DE-backup-201911120818060.po~\";s:64:\"0a4d4a438743ec2328dcc3211dbb7d432330fe585b0e2d4d02a8374cd4951da3\";s:28:\"languages/revslider-de_DE.mo\";s:64:\"8298c17a391fad96c417c894d3f23dec8d19345b0b30d387ba243938786c9f21\";s:28:\"languages/revslider-de_DE.po\";s:64:\"681cf3c73fb020f8b8f27ab1c46277a24869e0e38d02bd9f4cdcc71d0c2eb530\";s:28:\"languages/revslider-en_US.mo\";s:64:\"b25f5e9fcbbdd63dac695132b3d1c8328e3e4cb52957a53e9aaa6bbece7c3769\";s:28:\"languages/revslider-en_US.po\";s:64:\"bb2559430235c1165b075411e662318ed2e627a13a29abf9c62165ca0568f180\";s:28:\"languages/revslider-fr_FR.mo\";s:64:\"31527867138b40f6d4707890035dbe494419fe0f9984fcd10a87496f70e1797d\";s:28:\"languages/revslider-fr_FR.po\";s:64:\"0f461f184c6b478a841a98fb451e60d3c6698f978477060dff31426ac9ca098e\";s:28:\"languages/revslider-zh_CN.mo\";s:64:\"e67ebfae2cfc720c3469d745a57f0cc7b2cc8ffcb0c2fdf7d968f3dcdcec5896\";s:28:\"languages/revslider-zh_CN.po\";s:64:\"fcbc1a592e4390be364564f6bc05b672b9a228eb7083ee0d6c62ef9ffa0b2baa\";s:23:\"languages/revslider.pot\";s:64:\"cac3f197b6b33470b912c0ab0099f4a6d4d05d832513b17c65d6e57344037bd8\";s:32:\"languages/revsliderhelp-en_US.mo\";s:64:\"84c006116d561382ab453eb7756885fe458f50dd5359338973d1c0aaa1c7da51\";s:32:\"languages/revsliderhelp-en_US.po\";s:64:\"bd5cf09a6f5d98fec9f1465db30fd85eb4b0dc1ad9d6ded1da94918b7d9a0a1c\";s:27:\"languages/revsliderhelp.pot\";s:64:\"83b2a945105b0cabf0fd9699b5f6a3f144b9201e5990548b5aba740bb63e8fbe\";s:16:\"public/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:32:\"public/revslider-front.class.php\";s:64:\"23f60fb1c14e6c29edca1ee7d7b089348f406ae60e22cffd48be6787d4a92b15\";s:23:\"public/assets/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:22:\"public/assets/info.cfg\";s:64:\"2acc6ae56117f5c640a0b5538c2553b6ee62e959c648cb904f0761519f1bbccb\";s:38:\"public/assets/assets/coloredbg-old.png\";s:64:\"dbdeeafb5a38524899108cc99f5dc390e050c0efb3f9aec9d995c9642a179fae\";s:34:\"public/assets/assets/coloredbg.png\";s:64:\"a35f8bcd547ba482014e170e64c9ceb86269cbc46e1222ea46c750aa41cec584\";s:30:\"public/assets/assets/dummy.png\";s:64:\"69539b5b3777cffda28a66d7f2aa9b17c91ee1ec8fd50c00c442af91753a60f7\";s:33:\"public/assets/assets/gridtile.png\";s:64:\"663ccd5f5b33695f6f6384996bbb9601b1a7060570b8dcb5882329fbc40d6a01\";s:37:\"public/assets/assets/gridtile_3x3.png\";s:64:\"dbf0e6a761cf159977157dc42860a904a2d96e84780f2a370b4a693628a85334\";s:43:\"public/assets/assets/gridtile_3x3_white.png\";s:64:\"71912c3ae2c32be8756c13063cd63b54152bb8cbf9ac58e2e006791e7a2edc23\";s:39:\"public/assets/assets/gridtile_white.png\";s:64:\"ab8b528f64344e9e45af4eb7a89c9799e96e65feef2599e51ccda62f94655aed\";s:30:\"public/assets/assets/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:31:\"public/assets/assets/loader.gif\";s:64:\"9034d5d34015e4b05d2c1d1a8dc9f6ec9d59bd96d305eb9e24e24e65c591a645\";s:36:\"public/assets/assets/transparent.png\";s:64:\"9603ffeb6772f1cf745e0097d5d6c046eaf16151e5bc521f20764bba5ddb7713\";s:41:\"public/assets/assets/sources/facebook.png\";s:64:\"202540c1f898c94e83b49038ceb28ec48e078f9460706244f7ca294e5b09c3b6\";s:39:\"public/assets/assets/sources/flickr.png\";s:64:\"5f4dc5d6036da9259490b58f542e927d6285768455b7b4d3525849bbf386b1fe\";s:38:\"public/assets/assets/sources/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:42:\"public/assets/assets/sources/instagram.png\";s:64:\"0c55e02fc17a7501f3033cf44bf8d6532f9c6089aac2b075bc925ae1e00a9c4e\";s:37:\"public/assets/assets/sources/post.png\";s:64:\"dfee347a623d04a7765c852cc2bf5e1a5a1897b30ae06054c52982901bcf1382\";s:50:\"public/assets/assets/sources/revolution_slide1.png\";s:64:\"fe9ba6099a9529b202df00038a5e61471b41fe490233b3eeced40e0631abbcd4\";s:50:\"public/assets/assets/sources/revolution_slide2.png\";s:64:\"cb89209e783ff616e4374febbcd28a2bc295aea64ae129e40a8d4c5ed7e7d2c3\";s:40:\"public/assets/assets/sources/twitter.png\";s:64:\"7c6d27160cd71bbed952fc79a1293cd1e3e52e7a36fe9ba0fa63481b6bb3a95c\";s:38:\"public/assets/assets/sources/vimeo.png\";s:64:\"7f135deb73d2e7d541990ab631b50bf9e82c638d0eb80d0acd89bfe0a8c4d5db\";s:36:\"public/assets/assets/sources/woo.png\";s:64:\"ef678e063b89dcdfb42875ef59e71de8cce4b0f6851cd68c2020e36c34c32190\";s:40:\"public/assets/assets/sources/youtube.png\";s:64:\"67419aec01cea6047a67ba733cdaaead38c9112da951be1f74007fc10ba6b89f\";s:34:\"public/assets/assets/svg/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:55:\"public/assets/assets/svg/action/ic_3d_rotation_24px.svg\";s:64:\"2cd6f97c898a9d375f34c864b398dce61797ccbad9b029afa1389ed93d46eaaf\";s:57:\"public/assets/assets/svg/action/ic_accessibility_24px.svg\";s:64:\"8022b6ebeb57dbc9a8313fe6775ebaa492fac8d1ea231cb9f508a3d9d9a74386\";s:54:\"public/assets/assets/svg/action/ic_accessible_24px.svg\";s:64:\"19cd6de8ad01b6a137f55d1dd029d566d9b35d5f163682991980efd496ede79b\";s:59:\"public/assets/assets/svg/action/ic_account_balance_24px.svg\";s:64:\"b06a4de954f153bfe722612a7fc856e025959598ee90e6cbd5a5f2f9c225b609\";s:66:\"public/assets/assets/svg/action/ic_account_balance_wallet_24px.svg\";s:64:\"8040d187943fb04e23328da8717b770ac4199a9eb7eae3685760ea33847c45fa\";s:55:\"public/assets/assets/svg/action/ic_account_box_24px.svg\";s:64:\"8385158e8a78dc93defbfc368652061e8fcef6bf4dbb663aa953058e076a248e\";s:58:\"public/assets/assets/svg/action/ic_account_circle_24px.svg\";s:64:\"5307e5835c29e08a10ca5b9828f6b48b3c6c136e853e08b140c38035ab341aee\";s:61:\"public/assets/assets/svg/action/ic_add_shopping_cart_24px.svg\";s:64:\"ec4dafd78c83fa8adf012a9b2d3f1c5e30b60b781f4c5cf3f42caa89a6bd07ee\";s:49:\"public/assets/assets/svg/action/ic_alarm_24px.svg\";s:64:\"f5bb2755fe1c016cea33c93d636299a87e6f944591a13ee9528916a119ad6251\";s:53:\"public/assets/assets/svg/action/ic_alarm_add_24px.svg\";s:64:\"2506b8f9a82a215ed55397fc4bc604e7b801c3b2ba6eccaeee4645e258e8855b\";s:53:\"public/assets/assets/svg/action/ic_alarm_off_24px.svg\";s:64:\"ebc71479525918cae1910d65e4f325364dc17d8487c6a67ff01a9096c8ca36e8\";s:52:\"public/assets/assets/svg/action/ic_alarm_on_24px.svg\";s:64:\"001f268aaf3cc662a746d4b53acb3bc1ba410ff24647ab8a6567d81f615beb67\";s:51:\"public/assets/assets/svg/action/ic_all_out_24px.svg\";s:64:\"65294437f76fc07e83f0138807a4c52642dbdbf36694692e769cbe27fcbebd72\";s:51:\"public/assets/assets/svg/action/ic_android_24px.svg\";s:64:\"9393ba16bacc597817cad0aced2bb749231603a5a4a5358ec3f42ec731f7bc9e\";s:56:\"public/assets/assets/svg/action/ic_announcement_24px.svg\";s:64:\"cb4e608b2ec678d82a94536b54d15f5dc0b0dee41edf7fa77f15e6cda369b3c1\";s:56:\"public/assets/assets/svg/action/ic_aspect_ratio_24px.svg\";s:64:\"39654b5c3d466de4a1bd7bc73cdd23c4c4e469650978982d8b982f9c1e6db217\";s:54:\"public/assets/assets/svg/action/ic_assessment_24px.svg\";s:64:\"251b8d550df4665af92dd66a774ae43f0f002826a4b091b86c1310a28e9e8c87\";s:54:\"public/assets/assets/svg/action/ic_assignment_24px.svg\";s:64:\"8b17928ea973dc3769296238377ffab29faaeefc6e17eb0caaa81f1d49047232\";s:58:\"public/assets/assets/svg/action/ic_assignment_ind_24px.svg\";s:64:\"8f602235bf471c42c0fe83f545510b7ca9bef3a8e1cfa018276050117a87cf6a\";s:59:\"public/assets/assets/svg/action/ic_assignment_late_24px.svg\";s:64:\"b566a6525d683f2980095c36c7d96c57033420c2432a5d88d50e8945636355c6\";s:61:\"public/assets/assets/svg/action/ic_assignment_return_24px.svg\";s:64:\"39b57d9aec212b05a310f294d5f3e4f618e95cc590bc63eae78f28bbd7d494e6\";s:63:\"public/assets/assets/svg/action/ic_assignment_returned_24px.svg\";s:64:\"53fcee7ee684bc86e4ea9204359a3e898d1d9aa48eaa137a51c039754faa62f7\";s:64:\"public/assets/assets/svg/action/ic_assignment_turned_in_24px.svg\";s:64:\"85a808b5a8b2771f46e7fa89c097753f75ba394cfb666a6293acb021441f6c32\";s:53:\"public/assets/assets/svg/action/ic_autorenew_24px.svg\";s:64:\"aad13610f87f1111f68486d00deea78831d71a356ea8c938f1ecfd607e5a16f2\";s:50:\"public/assets/assets/svg/action/ic_backup_24px.svg\";s:64:\"dd4ebaae0dbf20252947784ca93dccd3a08b346d2b408c1469adad0c5b2749c0\";s:48:\"public/assets/assets/svg/action/ic_book_24px.svg\";s:64:\"8eedb182a120658c26b0f01aef92ce0ed278bb67edb6e0ad937578aa6ef958ce\";s:52:\"public/assets/assets/svg/action/ic_bookmark_24px.svg\";s:64:\"d0292992d4c29e0a16b288bbf994c2561caadcfd6d492d53d4b1571b84d4b6c5\";s:59:\"public/assets/assets/svg/action/ic_bookmark_border_24px.svg\";s:64:\"a9db5e689655829bec9e4e05e97f350183d8e6758ca63830707ec4a8ecd4f8e8\";s:54:\"public/assets/assets/svg/action/ic_bug_report_24px.svg\";s:64:\"166fdfbc7007b8a4f17b94e5ddaac10f16f563561e7fd1e93d4eafde5da6a73c\";s:49:\"public/assets/assets/svg/action/ic_build_24px.svg\";s:64:\"472cdcdc978ade62fdeb92002d62e4ade55808c9dbdf94b5c07f5a67102c28a8\";s:50:\"public/assets/assets/svg/action/ic_cached_24px.svg\";s:64:\"82644bc640d245152e2fb87a94d75b562fd2796c86511e2d9ba939274d8a2cb1\";s:58:\"public/assets/assets/svg/action/ic_camera_enhance_24px.svg\";s:64:\"3aea2383cfa246beaa2d0d62f8d0f78fbb7bbd555686a5e6d0d8e361fb5e8742\";s:57:\"public/assets/assets/svg/action/ic_card_giftcard_24px.svg\";s:64:\"3e2067fe21fa34db03b793148e4f3b2491c335003dc3719a114d9b9fe3281362\";s:59:\"public/assets/assets/svg/action/ic_card_membership_24px.svg\";s:64:\"e49e0e700795da64a8c8bfb20109a834bf497592bce5db6327cee827bf5f4403\";s:55:\"public/assets/assets/svg/action/ic_card_travel_24px.svg\";s:64:\"b4793ec7215a38ce4125291c07ad12c5b22d8f75c0b154a82ab9289dcdd767c5\";s:58:\"public/assets/assets/svg/action/ic_change_history_24px.svg\";s:64:\"93a10e36c7550ecd220d36c33ad822f2d31e520ee9fba0c9cb6c1eb44042e9f0\";s:56:\"public/assets/assets/svg/action/ic_check_circle_24px.svg\";s:64:\"01cdde3a2fcc3d3f0791e101ebef1cd4b1d6dfdc460130981b4542e8cc580e1e\";s:62:\"public/assets/assets/svg/action/ic_chrome_reader_mode_24px.svg\";s:64:\"5df175b40ca3de612ba119474c017e9135f2b32a9eb347345a54a1134e6512ae\";s:49:\"public/assets/assets/svg/action/ic_class_24px.svg\";s:64:\"8eedb182a120658c26b0f01aef92ce0ed278bb67edb6e0ad937578aa6ef958ce\";s:48:\"public/assets/assets/svg/action/ic_code_24px.svg\";s:64:\"110d861995707b4f598543260c3d2dfd3272c3cc8f195ca85f228c005c482fb7\";s:58:\"public/assets/assets/svg/action/ic_compare_arrows_24px.svg\";s:64:\"17be262944bf2d4e47016a25ecacb6971051dbbde49dd7b24f147150ab45c258\";s:53:\"public/assets/assets/svg/action/ic_copyright_24px.svg\";s:64:\"c38a054f660d70db2611e025a9c99f4d608c709ee42ae22a2e164f2ff0626ef5\";s:55:\"public/assets/assets/svg/action/ic_credit_card_24px.svg\";s:64:\"474f2dee5391671e3804e0f4852e069208bf9bee234ed66d058c3e287a452477\";s:53:\"public/assets/assets/svg/action/ic_dashboard_24px.svg\";s:64:\"ca2ad044eb803c6c5bf2a4725976880c492f5777174b7fed1794594b8a70698e\";s:54:\"public/assets/assets/svg/action/ic_date_range_24px.svg\";s:64:\"d01b507b8c688f789eee03e58e8a107460d7cabaf55623430f0b57e1930882ac\";s:50:\"public/assets/assets/svg/action/ic_delete_24px.svg\";s:64:\"40cfa49b563a8051443cd6dd3a0abc7ebb72d9b3edd17a32b4428f9b579146cd\";s:55:\"public/assets/assets/svg/action/ic_description_24px.svg\";s:64:\"0cb5a4634edb3203e6bff62ccb7de1c2bb017e79d5acfbfb5d72959d40a8bff4\";s:47:\"public/assets/assets/svg/action/ic_dns_24px.svg\";s:64:\"86419fc739623a45dc75963cddaa1ae0363de8a187cae06f48991a0b0de7e598\";s:48:\"public/assets/assets/svg/action/ic_done_24px.svg\";s:64:\"f1f1a9f32a0488db0541fc9a8b9475ea9739335aa022d69799f9f42859042761\";s:52:\"public/assets/assets/svg/action/ic_done_all_24px.svg\";s:64:\"3f16565700b11c685d8d7d9b624c9815bd65febcaaf22cdce12ea87b41b15259\";s:55:\"public/assets/assets/svg/action/ic_donut_large_24px.svg\";s:64:\"33be9532f60d90a76e87aad1608893b33e7cdcc95c1bd1486e54c6b7345a51d8\";s:55:\"public/assets/assets/svg/action/ic_donut_small_24px.svg\";s:64:\"6035acd879d4558cee4dd68a957621833ebae4a002479230fb5775081223d7fc\";s:49:\"public/assets/assets/svg/action/ic_eject_24px.svg\";s:64:\"80e3d48004058a83ebb77097a2d76a31d5140adde9d644c6739ccd3ddbaef603\";s:49:\"public/assets/assets/svg/action/ic_event_24px.svg\";s:64:\"b5d8a4f1247c3fc9e280c69763e3635b4331790f3b31d55ce02e4d2000c5f352\";s:54:\"public/assets/assets/svg/action/ic_event_seat_24px.svg\";s:64:\"c511a9da50df5f3471f7bd198b96c7dd4663c67c0ac4d69d124a5fb3b285e7e1\";s:55:\"public/assets/assets/svg/action/ic_exit_to_app_24px.svg\";s:64:\"6f44f4bd06a3b73c5b110c161b94f4498fb064859372acf010cc523e757474a2\";s:51:\"public/assets/assets/svg/action/ic_explore_24px.svg\";s:64:\"32136b5377d32476b0ef17039f3ec2e3205b9ad421e768f70ca1adcc3f2581cc\";s:53:\"public/assets/assets/svg/action/ic_extension_24px.svg\";s:64:\"3161d000350c7e92bbf84664a7e733f063d993f838bb88ae61de78acffcc2a36\";s:48:\"public/assets/assets/svg/action/ic_face_24px.svg\";s:64:\"1abe822e65e6fbd36ade6814465352770ae46d0abae49163ed7593163b09c9f0\";s:52:\"public/assets/assets/svg/action/ic_favorite_24px.svg\";s:64:\"9b33632e04c6f9daff1c924d88693e3747d6342d887ab504a500d18f539dc3ea\";s:59:\"public/assets/assets/svg/action/ic_favorite_border_24px.svg\";s:64:\"9662ae91a720bfb5e9e4a923fb703d38fc483c1bd8874a3037b48ab9faed90a5\";s:52:\"public/assets/assets/svg/action/ic_feedback_24px.svg\";s:64:\"595ba91ca31e088440162257d23e9088e10d5e275d14723a54c0bebcf7675af1\";s:56:\"public/assets/assets/svg/action/ic_find_in_page_24px.svg\";s:64:\"cb98fb75c16fd260fa14548788ebd52b05e81893e89314f7c55acd7a46b9a86d\";s:56:\"public/assets/assets/svg/action/ic_find_replace_24px.svg\";s:64:\"22a50a908f8341b6f2339f08336d292f29b60fa3c38513f3ea4f9f27dd0d4062\";s:55:\"public/assets/assets/svg/action/ic_fingerprint_24px.svg\";s:64:\"b628602ba26661a51043b8f2e89e332d612da2220d22c73e021eb19f8e020963\";s:55:\"public/assets/assets/svg/action/ic_flight_land_24px.svg\";s:64:\"f73c009fb011f4808fedccd90728dccdb47a781ce89e9b6506532d84bee61463\";s:58:\"public/assets/assets/svg/action/ic_flight_takeoff_24px.svg\";s:64:\"134c42726afb9a339563059edc24e7a356cd1538db6d89d281c4204bb9656724\";s:56:\"public/assets/assets/svg/action/ic_flip_to_back_24px.svg\";s:64:\"89fc12034a80435a9ab3c21e5576144917c8b2a4f8cc9cc96a90d3753134ac09\";s:57:\"public/assets/assets/svg/action/ic_flip_to_front_24px.svg\";s:64:\"d60331725abe254a22d65a7f87ee5789e051cecf117efe3ac19ed5a0b682af8b\";s:49:\"public/assets/assets/svg/action/ic_gavel_24px.svg\";s:64:\"0bf0ec8b469ac32679102aaa9300ddd682badd3e6282f228909f302fa6ca4a17\";s:51:\"public/assets/assets/svg/action/ic_get_app_24px.svg\";s:64:\"b887b20de9d7850bac7629bbc72519f5f76c1ae988c692f1970e70cec7498456\";s:47:\"public/assets/assets/svg/action/ic_gif_24px.svg\";s:64:\"20a65fbd5f8db4510c78a667e0607aeac979bebe029cb62229948043d5dde2c9\";s:49:\"public/assets/assets/svg/action/ic_grade_24px.svg\";s:64:\"831a2d3bc08e707d81bcc14c883e3142e7fc0c29237aa18efd0942f5477de5f3\";s:54:\"public/assets/assets/svg/action/ic_group_work_24px.svg\";s:64:\"e86bae3711b455b57ae55b588fab87e8975f04e8ac3c1451632236eb37da8f3b\";s:48:\"public/assets/assets/svg/action/ic_help_24px.svg\";s:64:\"1a580d7787bbf78c63954485d3315c666790c8eedb5a9566ebf0b7ba3ec312a8\";s:56:\"public/assets/assets/svg/action/ic_help_outline_24px.svg\";s:64:\"962aee2433f026ed7843790f6757dc3c25c34f349feb9b4fe816629b1b22442d\";s:57:\"public/assets/assets/svg/action/ic_highlight_off_24px.svg\";s:64:\"e67ffdde1b954ed3a1671d3c7ab14be81e44a124429a966d45236a6173f9746e\";s:51:\"public/assets/assets/svg/action/ic_history_24px.svg\";s:64:\"2894645dc9a542d65f105e3a7c263c5b8288972fdefd8d5eaac4bd8d5abc0a41\";s:48:\"public/assets/assets/svg/action/ic_home_24px.svg\";s:64:\"58f47974b72f8431037cffc73aa575dd8def0fadd76942eb131a7fd2e973d0a8\";s:59:\"public/assets/assets/svg/action/ic_hourglass_empty_24px.svg\";s:64:\"2bfd61b69bfa0009ebc4cd154d1ee7c65ec9812ab3b707db4f55b9d9bb154f01\";s:58:\"public/assets/assets/svg/action/ic_hourglass_full_24px.svg\";s:64:\"f7cb509b6a0a40c67dff93960707d5bb2ed3f86d96f8b5ead29848bff1f09467\";s:48:\"public/assets/assets/svg/action/ic_http_24px.svg\";s:64:\"d15dd7e1307af7a4eee3efeecd8dee817ef413a165d8f4134ac13ac73dd8f41a\";s:49:\"public/assets/assets/svg/action/ic_https_24px.svg\";s:64:\"020a1d8bb2f5067f85f46a1586e83f31d542ea1dceb752c511dda3710c3781ce\";s:61:\"public/assets/assets/svg/action/ic_important_devices_24px.svg\";s:64:\"7d09a7ca29b1528dd998a36b2558ea507c8c609cdee7d9384c9b297a574adbdb\";s:48:\"public/assets/assets/svg/action/ic_info_24px.svg\";s:64:\"2e1a5c0fc47b41204eccc4b45a4cb73e147d8e6f1c4dbbdebbe675b09a4eb82d\";s:56:\"public/assets/assets/svg/action/ic_info_outline_24px.svg\";s:64:\"f3d6e717a2d6fa6caec61221fb4b838663abbd1a58933dd7d2824b408932d3fe\";s:49:\"public/assets/assets/svg/action/ic_input_24px.svg\";s:64:\"5be6de945a729227c5b4bb62a07555c56982afb0f3704c2a6ad86aebf93432b7\";s:57:\"public/assets/assets/svg/action/ic_invert_colors_24px.svg\";s:64:\"66f787f1c3eeaf5ed97d1ff8493bb1841f802d3125ad153cd1601f8c9dac01ec\";s:49:\"public/assets/assets/svg/action/ic_label_24px.svg\";s:64:\"449267400a53003848a30f7beef9744baacb2ca6c201b5014ca9952898dc8c1d\";s:57:\"public/assets/assets/svg/action/ic_label_outline_24px.svg\";s:64:\"78c496e79bd3533896bb5ea56a5405dc2f5387fab74bce82f798c5d8417d80a9\";s:52:\"public/assets/assets/svg/action/ic_language_24px.svg\";s:64:\"0db467748c0aa4ef1bc7cb4b1f00e494d94d9b5a0594cc3deaef0b7202dc3f24\";s:50:\"public/assets/assets/svg/action/ic_launch_24px.svg\";s:64:\"6fff1248147a3d9126ce993e7e8f601f0d7dc20a5bfdb53f7c078509468ee43f\";s:61:\"public/assets/assets/svg/action/ic_lightbulb_outline_24px.svg\";s:64:\"3ce06b1e3f0410f3a0422c863da7c932efc76e398474850326d75cb16fde94a7\";s:54:\"public/assets/assets/svg/action/ic_line_style_24px.svg\";s:64:\"751b4e0fc4b016000b8c9c98f5c2b84268072615fd9498879cea696202e59c1b\";s:55:\"public/assets/assets/svg/action/ic_line_weight_24px.svg\";s:64:\"32d7865ef79ef4d116da510754c1579ff2fdccf70471db552350bb02d1fd39d8\";s:48:\"public/assets/assets/svg/action/ic_list_24px.svg\";s:64:\"c42e1da30a0f68437deb05c82d28bd2e85b7f90a2e9791a9a7cac6040dcafe33\";s:48:\"public/assets/assets/svg/action/ic_lock_24px.svg\";s:64:\"020a1d8bb2f5067f85f46a1586e83f31d542ea1dceb752c511dda3710c3781ce\";s:53:\"public/assets/assets/svg/action/ic_lock_open_24px.svg\";s:64:\"2dd4fba1808dbc69284a4413054386e63c7e097937252d5f3de424d62d637cac\";s:56:\"public/assets/assets/svg/action/ic_lock_outline_24px.svg\";s:64:\"37a12efbafa952d3cce85429621104544aed0834e2dab378068bb73dcda9ca2e\";s:51:\"public/assets/assets/svg/action/ic_loyalty_24px.svg\";s:64:\"544a694e424e88f12de457da0bd0bff938d4f56372e8b7806ed0ae3217e5750b\";s:62:\"public/assets/assets/svg/action/ic_markunread_mailbox_24px.svg\";s:64:\"a4911773cd3d4025631f6d72dcf2e8ce1f8a263b9414bea04a241de611fb7f68\";s:54:\"public/assets/assets/svg/action/ic_motorcycle_24px.svg\";s:64:\"1bab92d01aeabbb6ee02ad52f2f615bfb6efe0253ed806126395f293e852c7ab\";s:52:\"public/assets/assets/svg/action/ic_note_add_24px.svg\";s:64:\"50fc2f2a9ee8110b31b777a497cd795dbe02d5a8b92139fa5053fb824856206b\";s:55:\"public/assets/assets/svg/action/ic_offline_pin_24px.svg\";s:64:\"4026a4b4742574e50942b0a2c4faf2ff47c9c5915923aeff35cc2d37e8819b23\";s:51:\"public/assets/assets/svg/action/ic_opacity_24px.svg\";s:64:\"73f34a9d670810aa24e128b770124e5861edec135cc87cb3eec5bd1362583d00\";s:59:\"public/assets/assets/svg/action/ic_open_in_browser_24px.svg\";s:64:\"5000360064c22752607f6b19e3e8e432f9b56136d7e0c9679f5228ce0aaacb2f\";s:55:\"public/assets/assets/svg/action/ic_open_in_new_24px.svg\";s:64:\"6fff1248147a3d9126ce993e7e8f601f0d7dc20a5bfdb53f7c078509468ee43f\";s:53:\"public/assets/assets/svg/action/ic_open_with_24px.svg\";s:64:\"1a5b7f01f94b0ac4d93e157595020abc9b87eb3322a1684728209bc79615438c\";s:52:\"public/assets/assets/svg/action/ic_pageview_24px.svg\";s:64:\"47dddb8fe4f37a5790d5c7dc26806866bfb94b14d0a8ede0c71267291220a8d5\";s:52:\"public/assets/assets/svg/action/ic_pan_tool_24px.svg\";s:64:\"560bdfe0c2dee0cd1b5ac91a487f3437cb648317ac6c7acc23297a92a6dcd012\";s:51:\"public/assets/assets/svg/action/ic_payment_24px.svg\";s:64:\"474f2dee5391671e3804e0f4852e069208bf9bee234ed66d058c3e287a452477\";s:59:\"public/assets/assets/svg/action/ic_perm_camera_mic_24px.svg\";s:64:\"b79c03ef277c9605d41dfad9cfd014a3c2744f8889a8579f2be7d4e2fe02424c\";s:65:\"public/assets/assets/svg/action/ic_perm_contact_calendar_24px.svg\";s:64:\"1bb91282eb6563c9d1e027b52228ae41999676f27b98323311cd4f88e6bbeb7a\";s:61:\"public/assets/assets/svg/action/ic_perm_data_setting_24px.svg\";s:64:\"3547fea5a2b8bf3bda3c25b113739163e1894cd2689e876b36dac56ded7ff7b5\";s:67:\"public/assets/assets/svg/action/ic_perm_device_information_24px.svg\";s:64:\"1618bd3397443603722da3586f1a377f6db73ad2acf9e9bddc698cadb17bf560\";s:57:\"public/assets/assets/svg/action/ic_perm_identity_24px.svg\";s:64:\"4898e25f97f9ec192a657033130950a2501d4d9e3035591b0aee07cdff009d6f\";s:54:\"public/assets/assets/svg/action/ic_perm_media_24px.svg\";s:64:\"3a9ea15767047d9a233e387abe557036b0c2bda9072d71b2add7a7b8c1993cf8\";s:58:\"public/assets/assets/svg/action/ic_perm_phone_msg_24px.svg\";s:64:\"71b29338948d534d02e1f3447135537597c427e3eda1fe8e5b698cbf898340cf\";s:58:\"public/assets/assets/svg/action/ic_perm_scan_wifi_24px.svg\";s:64:\"870e44c9b73142c68dfdee8bde6bfa4eb2accf2bdf583be855dc61c0f5d07d2f\";s:48:\"public/assets/assets/svg/action/ic_pets_24px.svg\";s:64:\"20d0172a4d899f1f82f11205b7591d8d8c71e653aeb17948c2a0ac33ce89ab74\";s:62:\"public/assets/assets/svg/action/ic_picture_in_picture_24px.svg\";s:64:\"c1f8615d8f6359bd1bcdae0d5e735a20427e78292ee13f44ade63cd262e25219\";s:66:\"public/assets/assets/svg/action/ic_picture_in_picture_alt_24px.svg\";s:64:\"09f15e1791f0f6b08ad6e84acfd0d46a8331a50c4b5c2158cfa7f9565ea9858c\";s:57:\"public/assets/assets/svg/action/ic_play_for_work_24px.svg\";s:64:\"f0e45c3b5fa77396525b7dafd66d36cc55825734793304d86cf4d3607d823c30\";s:51:\"public/assets/assets/svg/action/ic_polymer_24px.svg\";s:64:\"4197307bbe73818ffcafb54b9c75ebb558c9907e7d2b7614c3b9b5bbcf6a6f5d\";s:62:\"public/assets/assets/svg/action/ic_power_settings_new_24px.svg\";s:64:\"2426eae67a7f97e8f4e4ab0729b5eaeb243f28cf188a5c380df2e281ae61411c\";s:58:\"public/assets/assets/svg/action/ic_pregnant_woman_24px.svg\";s:64:\"58d28196f780a3dc09e550ad84ff27cc0171a07e69c0a2d4cea3ee5afaac98f5\";s:49:\"public/assets/assets/svg/action/ic_print_24px.svg\";s:64:\"7ea1c5ab4938c31fff7349644e8181445d15a9576418e3ec0a5ff20ec4f3efd7\";s:57:\"public/assets/assets/svg/action/ic_query_builder_24px.svg\";s:64:\"c62263947febeef13f89926ef5a05b0eda6aeec920681de2af86ef07a1180bb3\";s:59:\"public/assets/assets/svg/action/ic_question_answer_24px.svg\";s:64:\"398cec3f2e81b31f36c273fe3610d985f103301925941df0260d09ec85092fd4\";s:51:\"public/assets/assets/svg/action/ic_receipt_24px.svg\";s:64:\"7a1f49481c6edd54f5f0adff914260f376860b27724523a2599775003300f4bb\";s:61:\"public/assets/assets/svg/action/ic_record_voice_over_24px.svg\";s:64:\"72dba1683877a7fd771c48b092b6200c3b8345421fd4a2a117e4bc84f79c2c7d\";s:50:\"public/assets/assets/svg/action/ic_redeem_24px.svg\";s:64:\"3e2067fe21fa34db03b793148e4f3b2491c335003dc3719a114d9b9fe3281362\";s:51:\"public/assets/assets/svg/action/ic_reorder_24px.svg\";s:64:\"5d2591bdb00660e261d0d15d2b813ecdbf3d4e97622a86a4c51d7eafbf271be6\";s:58:\"public/assets/assets/svg/action/ic_report_problem_24px.svg\";s:64:\"e800748c34aac0e0560a3bc3f98672243a35262ea64818e48832ce7094539eaf\";s:51:\"public/assets/assets/svg/action/ic_restore_24px.svg\";s:64:\"2894645dc9a542d65f105e3a7c263c5b8288972fdefd8d5eaac4bd8d5abc0a41\";s:48:\"public/assets/assets/svg/action/ic_room_24px.svg\";s:64:\"b989d3c8cfe19edd295378071c23de9c787cbc6ee66cc6a83023968837d0a88f\";s:58:\"public/assets/assets/svg/action/ic_rounded_corner_24px.svg\";s:64:\"3cfaf5d5834cd9c8d92fa077225626c63c6e25d24a90e5301b3830b580e539a2\";s:50:\"public/assets/assets/svg/action/ic_rowing_24px.svg\";s:64:\"6a9bbd1827eb34d8e0ee3762e570ce9ae7d42ffe0e19645c861a3172c2748c08\";s:52:\"public/assets/assets/svg/action/ic_schedule_24px.svg\";s:64:\"c62263947febeef13f89926ef5a05b0eda6aeec920681de2af86ef07a1180bb3\";s:50:\"public/assets/assets/svg/action/ic_search_24px.svg\";s:64:\"6105c83ef3637bbb1f1f8ceceacb51df818e867238ee6c49e0a8d1ca7f858b72\";s:52:\"public/assets/assets/svg/action/ic_settings_24px.svg\";s:64:\"d0872fb94037822164c8cea43a2ebeafdd1b664ff0fdc9387f0e1e1a7ee74628\";s:65:\"public/assets/assets/svg/action/ic_settings_applications_24px.svg\";s:64:\"3fd52f0ae491c017155008ffb5d2d008e15da6768b7ef9d73ed42943bd8597ae\";s:67:\"public/assets/assets/svg/action/ic_settings_backup_restore_24px.svg\";s:64:\"a4028f05e564ed5dad036779cd61db591577c2c558dc0f77acafb53712a95bd4\";s:62:\"public/assets/assets/svg/action/ic_settings_bluetooth_24px.svg\";s:64:\"c7c750f6e8155c45771fc6606b113bcbc0ea906de7e637f6c3448358f77b42ae\";s:63:\"public/assets/assets/svg/action/ic_settings_brightness_24px.svg\";s:64:\"83a5103a39cea5245f3cf0c2134eb1cc1a55092439251d11acdabe229134f2bc\";s:57:\"public/assets/assets/svg/action/ic_settings_cell_24px.svg\";s:64:\"4240ab860b6c3918b667705f3e7fd467c37d95c147acaa5ef1dc7cfdec5cb4ee\";s:61:\"public/assets/assets/svg/action/ic_settings_ethernet_24px.svg\";s:64:\"d055e53659a5b6a4fc64c054f5081da44616a333adc2a0249d03e01edbac5de1\";s:66:\"public/assets/assets/svg/action/ic_settings_input_antenna_24px.svg\";s:64:\"eb3fd523dcca534cc79a2789266846b67536fe17cc8f5886bf4a79123755b8d9\";s:68:\"public/assets/assets/svg/action/ic_settings_input_component_24px.svg\";s:64:\"2fa532bab05d6053811c4720f8c656b16dfc9c79ef6281d5f8e87c6718dfd542\";s:68:\"public/assets/assets/svg/action/ic_settings_input_composite_24px.svg\";s:64:\"2fa532bab05d6053811c4720f8c656b16dfc9c79ef6281d5f8e87c6718dfd542\";s:63:\"public/assets/assets/svg/action/ic_settings_input_hdmi_24px.svg\";s:64:\"4e67e33dba4111951d3e2fdf777d864993000936084e73d95118329f303d44d8\";s:65:\"public/assets/assets/svg/action/ic_settings_input_svideo_24px.svg\";s:64:\"a9d78b79f959631fcc745ed145a9cda9a9637177be5322eaecd6edeb887cf70e\";s:61:\"public/assets/assets/svg/action/ic_settings_overscan_24px.svg\";s:64:\"8b9f14c69b767957c13d47db813ff767731bc09e2c28b40cda73db09f1e3af70\";s:58:\"public/assets/assets/svg/action/ic_settings_phone_24px.svg\";s:64:\"23b112f8e7cd2e068019c927abbe3c20e720803444baf06bae5fbee1f3ba2e4a\";s:58:\"public/assets/assets/svg/action/ic_settings_power_24px.svg\";s:64:\"bef9bf5960b48c9be6e57c5b04fbcf5edd515782b8b759fda65ee2952eed20ec\";s:59:\"public/assets/assets/svg/action/ic_settings_remote_24px.svg\";s:64:\"e3bc91ecf41e10c0a8177e3ff7c81648b6eb786c64eec2d18b7d64e06d53fba5\";s:58:\"public/assets/assets/svg/action/ic_settings_voice_24px.svg\";s:64:\"957f0b30687763f12399cfbc927635d104c437ff194db8361a7a5b0da00df58c\";s:48:\"public/assets/assets/svg/action/ic_shop_24px.svg\";s:64:\"a923ac48e5f55e13e7d961b445974e0d09115de349360027ab8205b3a98426e5\";s:52:\"public/assets/assets/svg/action/ic_shop_two_24px.svg\";s:64:\"bfa899caac93fad623f9053cac0c2f2bced5540bb9735f9b04c288b8e79b90fe\";s:59:\"public/assets/assets/svg/action/ic_shopping_basket_24px.svg\";s:64:\"44d9968b0ea3bf9864a4668fe7119e1fd32abdafefeaedf9c5dcbeff371e4607\";s:57:\"public/assets/assets/svg/action/ic_shopping_cart_24px.svg\";s:64:\"0d5d165f3e9eea299e31d16c845eb305ba008dfe45f839619eb98ab0b229f34f\";s:57:\"public/assets/assets/svg/action/ic_speaker_notes_24px.svg\";s:64:\"d8a89ba474c600dbc9c2a5bf41cd92e85f32a948e0180604df5be69c433d992e\";s:54:\"public/assets/assets/svg/action/ic_spellcheck_24px.svg\";s:64:\"7f926aab657b75b779b84eb8cb20e1d0a803cd72623f911bb1b799b3e1b373cd\";s:49:\"public/assets/assets/svg/action/ic_stars_24px.svg\";s:64:\"43981f2a1fefa6ab98cb06185c46fffc910f9c74143b953d8b7ea17eef83a0f9\";s:49:\"public/assets/assets/svg/action/ic_store_24px.svg\";s:64:\"61aae36d8f51d94ffa1f6b35ef20d433d714158375d94ced41d74a92b46e09d8\";s:51:\"public/assets/assets/svg/action/ic_subject_24px.svg\";s:64:\"02064baf66c5048653894e41d692e09b516271ea9ee165079f851d2585d1ccec\";s:62:\"public/assets/assets/svg/action/ic_supervisor_account_24px.svg\";s:64:\"4fdfd3292b54dcbe52e59b84450bbf5c54c2df357cc7b8aad7b45ef048396e15\";s:54:\"public/assets/assets/svg/action/ic_swap_horiz_24px.svg\";s:64:\"c4c7779e94b9dc3b22c363de7c6f5d7e7bb3283e1d4de4a3800df37616eeac0e\";s:53:\"public/assets/assets/svg/action/ic_swap_vert_24px.svg\";s:64:\"8bf9f4dc84a011c1c4df0a7a5056bcd81727496495fbca0912b10cf9c891dc15\";s:64:\"public/assets/assets/svg/action/ic_swap_vertical_circle_24px.svg\";s:64:\"a8b74890a237d433fafeb97fc58a19828ef137b69701141990f79438a48d324e\";s:61:\"public/assets/assets/svg/action/ic_system_update_alt_24px.svg\";s:64:\"005c56e8e70b578c1df3d18d4f30ba0d26ae5def01783b1f5ded36c31787e42c\";s:47:\"public/assets/assets/svg/action/ic_tab_24px.svg\";s:64:\"f9c4af27982996283a56303996e24afb4e2b2dfc9b6b2611af0b0e160b7033e4\";s:58:\"public/assets/assets/svg/action/ic_tab_unselected_24px.svg\";s:64:\"c45500d4f4820f29f98e1443dda1c20ee3e80f4cee1e208479e50e377518fc2b\";s:52:\"public/assets/assets/svg/action/ic_theaters_24px.svg\";s:64:\"aacde086862a86f1d85daca021e414ae732e235e9ad09963d71520903bb8be4f\";s:54:\"public/assets/assets/svg/action/ic_thumb_down_24px.svg\";s:64:\"df1ed1d9f26cb121e9be865aec900a8c8be9e90314856ccbe478e52bf6803807\";s:52:\"public/assets/assets/svg/action/ic_thumb_up_24px.svg\";s:64:\"7d8bc098c000ed722c4e95d0cf743ca4d2db82d2970fb7aa5c44e55158c38cad\";s:58:\"public/assets/assets/svg/action/ic_thumbs_up_down_24px.svg\";s:64:\"0bce2d2a51d70fb90262e2dedd2d3ed8be8b4eff246174a6687bb9ee5373c21c\";s:52:\"public/assets/assets/svg/action/ic_timeline_24px.svg\";s:64:\"ad8e78763f70925d35df4b0cf4b6ca68caa9cc47dc479825acb025727b45d220\";s:47:\"public/assets/assets/svg/action/ic_toc_24px.svg\";s:64:\"0b5ae5bed340f38002d7ec1af09932f4263b6cf273a750997595400cc96c0ad7\";s:49:\"public/assets/assets/svg/action/ic_today_24px.svg\";s:64:\"41016b2e3a9ae4830eb32f90764802c967c8e6ee9dc153a2ebc0f1b9e2b9ff26\";s:48:\"public/assets/assets/svg/action/ic_toll_24px.svg\";s:64:\"54d68919f835f7400fe1f036c8ba8deabecb897ce5becc407552ef325c3ecd5c\";s:53:\"public/assets/assets/svg/action/ic_touch_app_24px.svg\";s:64:\"813b6dc3c359b3a67fc867bbbb64ddc30388eceff1649aef2c0626b31dbb1614\";s:57:\"public/assets/assets/svg/action/ic_track_changes_24px.svg\";s:64:\"56e65bf95be2fccb69f30c0e4019717baf18a49845014d053481fb6b9f27738d\";s:53:\"public/assets/assets/svg/action/ic_translate_24px.svg\";s:64:\"41fc130b717be1a3135c13f9e25ec1bbe238b085bfc133ac5c141898f31e3cb9\";s:57:\"public/assets/assets/svg/action/ic_trending_down_24px.svg\";s:64:\"6f71e01ed302c8683f13440d4cd1bf8463dbafc0a7eabec864917bcd2aff884d\";s:57:\"public/assets/assets/svg/action/ic_trending_flat_24px.svg\";s:64:\"915ede525d33cdcf4459563ea51c4f04d781de7dd99611f33c326b3febaf36b9\";s:55:\"public/assets/assets/svg/action/ic_trending_up_24px.svg\";s:64:\"317c33204739a14472a766f7e16861ad414a94f3718f0e46ef62ac454a64e0a8\";s:53:\"public/assets/assets/svg/action/ic_turned_in_24px.svg\";s:64:\"d0292992d4c29e0a16b288bbf994c2561caadcfd6d492d53d4b1571b84d4b6c5\";s:57:\"public/assets/assets/svg/action/ic_turned_in_not_24px.svg\";s:64:\"a9db5e689655829bec9e4e05e97f350183d8e6758ca63830707ec4a8ecd4f8e8\";s:50:\"public/assets/assets/svg/action/ic_update_24px.svg\";s:64:\"406de3533ca04bcf0aeb56954c5a4e3fcbf0921e1127b3b526913f5a3c0e7e6c\";s:57:\"public/assets/assets/svg/action/ic_verified_user_24px.svg\";s:64:\"97fa5a3e9dc2a0f97558fde82a523d2ac463911118ece99fed65585f1cbb7a50\";s:55:\"public/assets/assets/svg/action/ic_view_agenda_24px.svg\";s:64:\"f81cf055d77a00e08700c0818a64620c3e7fb9367d443fa43e3f8bfb03c9abd5\";s:54:\"public/assets/assets/svg/action/ic_view_array_24px.svg\";s:64:\"3ed4ae83d1ab5f95c8dbefe18e276634ed0b8e89c80ef2b0dd328204cee824c4\";s:57:\"public/assets/assets/svg/action/ic_view_carousel_24px.svg\";s:64:\"3d90db7f2cbbf01bdaf1e22ff55dc63b98d7dac3a5ff261eeaef88336f536c5c\";s:55:\"public/assets/assets/svg/action/ic_view_column_24px.svg\";s:64:\"58830764e6ac79ebeaa0072145c3ebcd9ee3561d0918c931c39788f006b34cec\";s:52:\"public/assets/assets/svg/action/ic_view_day_24px.svg\";s:64:\"51815603f490cd9c0465615593652daebf8bc6d4bca85190aa82be9e0bb601c1\";s:57:\"public/assets/assets/svg/action/ic_view_headline_24px.svg\";s:64:\"65ff18d7a57edbc1c19a86a0f4dfd4a00a2bc32d9044db0b52890e57ac7d7ff0\";s:53:\"public/assets/assets/svg/action/ic_view_list_24px.svg\";s:64:\"6c1cc758d53140efbf126fd615eda7d6c35a4acb4fa5fa5975d1bafeff7fac77\";s:55:\"public/assets/assets/svg/action/ic_view_module_24px.svg\";s:64:\"785d77f7d70ad29575e39a8f162675f1f72503755dc7db688a442a2d645b9c1f\";s:54:\"public/assets/assets/svg/action/ic_view_quilt_24px.svg\";s:64:\"cb55ba8c853aa72775d6e0e3948dccdb428236e57443916725113a31182551a5\";s:55:\"public/assets/assets/svg/action/ic_view_stream_24px.svg\";s:64:\"2aa1548a7e5f1f8101b10b7c30972e379d462523af66d9e0ad0e56275000259d\";s:53:\"public/assets/assets/svg/action/ic_view_week_24px.svg\";s:64:\"eaf19c02e55e7f76bb2bd45e15aeada3a0b4633eeee8b53584fe6dbd98edf184\";s:54:\"public/assets/assets/svg/action/ic_visibility_24px.svg\";s:64:\"5e2fc28ae621a18342caf71644f0b5725d9cbe377932db896a0009fa21250201\";s:58:\"public/assets/assets/svg/action/ic_visibility_off_24px.svg\";s:64:\"b1e7ec6fcc3a0aeefe585abd0860e60dabd39b884be8b52cd886acb3e0635ec3\";s:55:\"public/assets/assets/svg/action/ic_watch_later_24px.svg\";s:64:\"df75e4561457f52ea6fdc778acd2abaa7dbb730863a539d78792d4932fc55595\";s:48:\"public/assets/assets/svg/action/ic_work_24px.svg\";s:64:\"a5c19aa33beecc38eb8a25c87f009684e1161bb51c4072514147d0babcc523eb\";s:64:\"public/assets/assets/svg/action/ic_youtube_searched_for_24px.svg\";s:64:\"cdcd5dd8ea46efd70beca392d9fbe4966e0410ea38d9dd6cff8e716210e0cf80\";s:51:\"public/assets/assets/svg/action/ic_zoom_in_24px.svg\";s:64:\"409b79194243e3deefcbaded57a4539b19233de0db1c71b13f7ff2e025ceddc2\";s:52:\"public/assets/assets/svg/action/ic_zoom_out_24px.svg\";s:64:\"0162300846c6d6908e7c537ed701fbda0685290452907b65c42367d6fc904ed1\";s:52:\"public/assets/assets/svg/alert/ic_add_alert_24px.svg\";s:64:\"9c617ce39567153b0d9a28a88f767e0e5fd1208cfbad9d215021034dd4f3228d\";s:48:\"public/assets/assets/svg/alert/ic_error_24px.svg\";s:64:\"4ab47484995ab72bd8b7175bd36273d3e8787cf3e1e28a4f695fee07e8d0884d\";s:56:\"public/assets/assets/svg/alert/ic_error_outline_24px.svg\";s:64:\"bc2d656a0626a5859f6bce73e972e8f841b5c0f3cf43502e2bf4a1137704581a\";s:50:\"public/assets/assets/svg/alert/ic_warning_24px.svg\";s:64:\"e800748c34aac0e0560a3bc3f98672243a35262ea64818e48832ce7094539eaf\";s:52:\"public/assets/assets/svg/av/ic_add_to_queue_24px.svg\";s:64:\"6ecdda24cb184812d3f02772991d81287bd31c29e22fcc217bd21d6e3f5d68b5\";s:47:\"public/assets/assets/svg/av/ic_airplay_24px.svg\";s:64:\"81393da86075121cf7af7b5d9fd9218b6cd6da4c9a1fe6c62612fbb6a25f1875\";s:45:\"public/assets/assets/svg/av/ic_album_24px.svg\";s:64:\"972c1832668ead7eddd09dfeec59b1fb0602ee47baae4785127da3dbbbb3b34f\";s:49:\"public/assets/assets/svg/av/ic_art_track_24px.svg\";s:64:\"51cb99e4a078c0b103f6e16ad7c4de005586f89edad0b76a7598fc7379b6a729\";s:48:\"public/assets/assets/svg/av/ic_av_timer_24px.svg\";s:64:\"a9fcde09a80353c03ba3127d9a32441a7d33a27190d1d48cea5dd4b3043b895d\";s:54:\"public/assets/assets/svg/av/ic_closed_caption_24px.svg\";s:64:\"0b1e10ba4c813d636dfd1f0112c781299f1aaf944ba0fd9408e2a1d9efc74da3\";s:49:\"public/assets/assets/svg/av/ic_equalizer_24px.svg\";s:64:\"e028813a5f0fa89569beb1bc69c04268337d714ba77f136293b368e96b6dd2f0\";s:48:\"public/assets/assets/svg/av/ic_explicit_24px.svg\";s:64:\"292cdd9b632ed2e85a484eaa6221b864c2bf03539b20930dd60f76b574c58664\";s:52:\"public/assets/assets/svg/av/ic_fast_forward_24px.svg\";s:64:\"b39a2a4e4d36201ee17cd506fb369276849e6c952f644f5a9720b63d4b44d8d9\";s:51:\"public/assets/assets/svg/av/ic_fast_rewind_24px.svg\";s:64:\"b21d952289780119520a46f9a96511b8119b292d9990c45adfb24803a70ffe40\";s:49:\"public/assets/assets/svg/av/ic_fiber_dvr_24px.svg\";s:64:\"0ba6fd6e37c343439e887d7b1e57db2198d2d4574952343ce37a9b397fc3f94b\";s:59:\"public/assets/assets/svg/av/ic_fiber_manual_record_24px.svg\";s:64:\"a016ab5615ab36f49187c1726ad9c3032b6521f342d105144afe8e7c8c71769d\";s:49:\"public/assets/assets/svg/av/ic_fiber_new_24px.svg\";s:64:\"019f91835033bfedd9f52dcda9750060255bf19cf0d32b0b43d783a08b3e36a3\";s:49:\"public/assets/assets/svg/av/ic_fiber_pin_24px.svg\";s:64:\"11f74c1ce4bfba5c8d25686f12dac9eb29ff6d6faae38f8755a5aa3c87ae182b\";s:58:\"public/assets/assets/svg/av/ic_fiber_smart_record_24px.svg\";s:64:\"3c5a54c5d5e2260528cf8e8a6f5097ece0c3d7be3f9ed45d3d561e09c44a0971\";s:50:\"public/assets/assets/svg/av/ic_forward_10_24px.svg\";s:64:\"c832506e0e526cba812933d0e70ddf4edf364e6cca456e5ba9df6122236c20ec\";s:50:\"public/assets/assets/svg/av/ic_forward_30_24px.svg\";s:64:\"534b7e074aac4be8551997b75354ed5d6edfb4eb11d84ab225ce886039d0599d\";s:49:\"public/assets/assets/svg/av/ic_forward_5_24px.svg\";s:64:\"1d0cbc16a2ec77f495421eca8d2f9136f5a439710b75afe941b0dc323fe95340\";s:45:\"public/assets/assets/svg/av/ic_games_24px.svg\";s:64:\"3e850f0a5ebf1e0bfa149967352eff6c9f9ff7c7d262c570fb0bec99c9cda33a\";s:42:\"public/assets/assets/svg/av/ic_hd_24px.svg\";s:64:\"2cff875236651008df0e1003cbda45a642424887ae07938e98c18cb9fb35a798\";s:47:\"public/assets/assets/svg/av/ic_hearing_24px.svg\";s:64:\"3fd43722aaadad35379ba08d4c128eb3ef2313b8b628a55e2febcb11d900ec90\";s:52:\"public/assets/assets/svg/av/ic_high_quality_24px.svg\";s:64:\"1b8b37fa67be12e021865281b0608b019ec28e4d8e5b1a87ff87c188a5b03886\";s:51:\"public/assets/assets/svg/av/ic_library_add_24px.svg\";s:64:\"2057c6177d9cdc9f6154e9ee439ddd7a49dd9b9eafff5977aac46da6c154452b\";s:53:\"public/assets/assets/svg/av/ic_library_books_24px.svg\";s:64:\"e73fcd98a762a217049b28c2d023a5d240eb7294a10102db914025725260f0d8\";s:53:\"public/assets/assets/svg/av/ic_library_music_24px.svg\";s:64:\"46cba011cb13dbfa2fc46672c9fe69f2aea4fff36be86337470e836adad3dbc0\";s:44:\"public/assets/assets/svg/av/ic_loop_24px.svg\";s:64:\"d9efa9690a6a43ddb127ce41d3b5b05305c174e24776937718fe55eafe85d498\";s:43:\"public/assets/assets/svg/av/ic_mic_24px.svg\";s:64:\"3f1c2357dd8bc86ef9fa3adece98f15a51e81d553495df4473a174e4296b5211\";s:48:\"public/assets/assets/svg/av/ic_mic_none_24px.svg\";s:64:\"b14ce9c93e916d4bf6362db9066e04f718373b34ecc2f986294251b26ae339f9\";s:47:\"public/assets/assets/svg/av/ic_mic_off_24px.svg\";s:64:\"df347ed26ace976d932847ff337e86bb7c25b87fe10139380f57959c35717ba3\";s:45:\"public/assets/assets/svg/av/ic_movie_24px.svg\";s:64:\"f0d2c7e0515d6dace01851022d3cebce6dfbc95e0541a8bd26312b63306b2452\";s:51:\"public/assets/assets/svg/av/ic_music_video_24px.svg\";s:64:\"449f58f3bfff35ffbe54b15e8f5fe58c3925761c0e1df8fce2ce8de5b5604755\";s:52:\"public/assets/assets/svg/av/ic_new_releases_24px.svg\";s:64:\"6f5d9a3d3909e8766c752e9a97715795f6c0eae7a6c9cb86f190e09b53be6a2e\";s:54:\"public/assets/assets/svg/av/ic_not_interested_24px.svg\";s:64:\"1e87a9fc6d4fc9f66fa9eef5726764ab9a7afd32cc7eda04106bf8308007ed24\";s:45:\"public/assets/assets/svg/av/ic_pause_24px.svg\";s:64:\"dbd40f5581dcbad635d694bd1885b95aab53d6989827984d7646f5da2d59d367\";s:59:\"public/assets/assets/svg/av/ic_pause_circle_filled_24px.svg\";s:64:\"322ac92862767f7cbff27062745c99413fa1071657f26b541b7207b9c93d58ab\";s:60:\"public/assets/assets/svg/av/ic_pause_circle_outline_24px.svg\";s:64:\"a3b2c518d796564caa9a8277c9b9089ab41e894f719f376118691df7a01ca6e9\";s:50:\"public/assets/assets/svg/av/ic_play_arrow_24px.svg\";s:64:\"54077d93aca5c4b0dbc80d177dfe003e689ef3e6dfffdf306ee8027b53282c38\";s:58:\"public/assets/assets/svg/av/ic_play_circle_filled_24px.svg\";s:64:\"0a80ec6c1cb0ab52b42223000e681e15192d94d3a9a1f051c1a40011e5e6b982\";s:59:\"public/assets/assets/svg/av/ic_play_circle_outline_24px.svg\";s:64:\"00dd67c77ca21e6ca6ac11b8456d0eee65607444caf9c932b73044dc0ff7af57\";s:52:\"public/assets/assets/svg/av/ic_playlist_add_24px.svg\";s:64:\"bf7742a1b999ff0a084f6e57857910b4f0e4e7ee4bcc0b199627d0a34d8e3843\";s:58:\"public/assets/assets/svg/av/ic_playlist_add_check_24px.svg\";s:64:\"a9e09dd807901bc5f8e90dc77fbd77d212b6cc700d8934bf086e009f8f7d2976\";s:53:\"public/assets/assets/svg/av/ic_playlist_play_24px.svg\";s:64:\"cdc22ff6b84b77d41155f6eb36f27fa67738b009cc0151852b7b43f531ec6484\";s:45:\"public/assets/assets/svg/av/ic_queue_24px.svg\";s:64:\"2057c6177d9cdc9f6154e9ee439ddd7a49dd9b9eafff5977aac46da6c154452b\";s:51:\"public/assets/assets/svg/av/ic_queue_music_24px.svg\";s:64:\"fc269bb7535bccc2d9a1cc3c14648340d6dcb986425c910d8fd65c6c3da6ba9e\";s:55:\"public/assets/assets/svg/av/ic_queue_play_next_24px.svg\";s:64:\"75ab9e5cc5c8998e493732f875cec21dc07fa7d6717cb9375b39ac610302811e\";s:45:\"public/assets/assets/svg/av/ic_radio_24px.svg\";s:64:\"e30a53a4882be9d57a1f2a901660e5418d4020a46c34da2bd44ced17632b61be\";s:53:\"public/assets/assets/svg/av/ic_recent_actors_24px.svg\";s:64:\"8cf55f1bc9d26afa61ef44da184fc125592271ceb5c238f9afdaba54154a07ab\";s:57:\"public/assets/assets/svg/av/ic_remove_from_queue_24px.svg\";s:64:\"0c2f0152e63279c86eac50a6b7d977ced9369654c03302dab553054359f771ab\";s:46:\"public/assets/assets/svg/av/ic_repeat_24px.svg\";s:64:\"d3b967ec4b08f57d06bd84cc21475272c3457ad6284ff994842e8dddcc601ac1\";s:50:\"public/assets/assets/svg/av/ic_repeat_one_24px.svg\";s:64:\"e689b58af6944aa87146ab223ecfd4dd45ddce2d785ba2a3258b194e3aa1af9e\";s:49:\"public/assets/assets/svg/av/ic_replay_10_24px.svg\";s:64:\"477ba562ec28cb50780d7c196d47025b9c92880ab412a6c1becde4bcb987f66e\";s:46:\"public/assets/assets/svg/av/ic_replay_24px.svg\";s:64:\"9d2ddd56af8e4ae35ce3132f0f67bf92527451001284bfa9c18301c6a02dc8a7\";s:49:\"public/assets/assets/svg/av/ic_replay_30_24px.svg\";s:64:\"65b8b58fb625096978094cc23c078431531f36854ca26bd2097b93a6891a1750\";s:48:\"public/assets/assets/svg/av/ic_replay_5_24px.svg\";s:64:\"32dabbbbe4cf13321f111c2faa00d5fe680308df3e6106baadc20df5194730f4\";s:47:\"public/assets/assets/svg/av/ic_shuffle_24px.svg\";s:64:\"ef83a99f447d1979001dde7075939c33354972b8afd1b91f001fe5f50525740a\";s:49:\"public/assets/assets/svg/av/ic_skip_next_24px.svg\";s:64:\"f38f8615459381790ed142e8729a1a9e29710b85169c8d49cadeb6f0592e1e64\";s:53:\"public/assets/assets/svg/av/ic_skip_previous_24px.svg\";s:64:\"09244a94224a6b76c8b4bcf04fb6503378baff7bc4b13f84c9350326bcc3176a\";s:57:\"public/assets/assets/svg/av/ic_slow_motion_video_24px.svg\";s:64:\"d57c9707ade7e36709e4b7469a61af8928492e96496fa38510578aeb42709b4e\";s:46:\"public/assets/assets/svg/av/ic_snooze_24px.svg\";s:64:\"a183cee31844f977b16f0f8486d8972323e2ad687fbfffb5da88b1eec3dde0d0\";s:53:\"public/assets/assets/svg/av/ic_sort_by_alpha_24px.svg\";s:64:\"c87c1edd1e8ecc3195605c81d09ca81303201213647f5f63a52616b9c5a9c6af\";s:44:\"public/assets/assets/svg/av/ic_stop_24px.svg\";s:64:\"e827b7b17eaea2f4181dfb8d68d6a5813871ab051374c484ba9ed09589a24ce4\";s:53:\"public/assets/assets/svg/av/ic_subscriptions_24px.svg\";s:64:\"aaaf69582782c8af8e6d19f701c0ac8b446228d243794874561adf7ef670caa4\";s:49:\"public/assets/assets/svg/av/ic_subtitles_24px.svg\";s:64:\"b52f32b2c62a202ab6515d88d3d7b34be78c8019657344fd460e3d98da456c36\";s:54:\"public/assets/assets/svg/av/ic_surround_sound_24px.svg\";s:64:\"4aab19a5ea185e2be451f25f11116be5f47b7033bdb60d9ef5fbce5ee001ab45\";s:53:\"public/assets/assets/svg/av/ic_video_library_24px.svg\";s:64:\"b871451f431f71cd4b59398cf624eda5833892f221db237da8e5631fad19301f\";s:48:\"public/assets/assets/svg/av/ic_videocam_24px.svg\";s:64:\"2c24035292a25b8a48085e4a46c7aab8ef049a5b0999c3c4d9874743f172be93\";s:52:\"public/assets/assets/svg/av/ic_videocam_off_24px.svg\";s:64:\"aef175c4bb8e87826e5dd2a78474d75f8cd6ab07e759f6ed9faf0732fe919b10\";s:51:\"public/assets/assets/svg/av/ic_volume_down_24px.svg\";s:64:\"a1e651489af5feb4f9061d7795fca06b8ec77965a5d351f4bb5c694052fd4806\";s:51:\"public/assets/assets/svg/av/ic_volume_mute_24px.svg\";s:64:\"775e30c2eef3f744a824153c2b01a921b708d157f36623f9697bb7a13445b851\";s:50:\"public/assets/assets/svg/av/ic_volume_off_24px.svg\";s:64:\"72ad487d8ee7250ccc6f958b35b5005a3c75a868b2c6b9107276b2d9320e27d0\";s:49:\"public/assets/assets/svg/av/ic_volume_up_24px.svg\";s:64:\"bde5fafcc187a43dee9cc2b4457eab5e56cea79a25802a099bbefb88d0260ea7\";s:43:\"public/assets/assets/svg/av/ic_web_24px.svg\";s:64:\"982fd3f829fc2aa3ab0c72162de4dd120951fc2cac29e3634213022d48fb15cc\";s:49:\"public/assets/assets/svg/av/ic_web_asset_24px.svg\";s:64:\"99be0fc9b1ea8ad3f0b983c40536e43dd20e253a0727cf5ef6a4784f01ce3d2a\";s:50:\"public/assets/assets/svg/busy-icons-svg/NewTux.svg\";s:64:\"533bef67f47576927f4be3a1252749763c10e1644a8142f9ec86488cd71652db\";s:50:\"public/assets/assets/svg/busy-icons-svg/abacus.svg\";s:64:\"2c8fcdb9f11e1f547c0b27a36fdbc0544ffd9c3fb4940923382d2de8429edc74\";s:56:\"public/assets/assets/svg/busy-icons-svg/address-book.svg\";s:64:\"b63a29e7ba91d88139c3b8b0716c1979cb11d87fe800d03889ce0cf2aa06356c\";s:57:\"public/assets/assets/svg/busy-icons-svg/address-book2.svg\";s:64:\"f9690b79e77f2d3659c6a01a5b01f26d1659fd2c76d3d007a75f109a6f94a116\";s:47:\"public/assets/assets/svg/busy-icons-svg/aim.svg\";s:64:\"51dd3aadc20c41edd0987cdc53d382101825a5ce8ad938f48118090564c44a5d\";s:49:\"public/assets/assets/svg/busy-icons-svg/alarm.svg\";s:64:\"73f962236bf2c21b6f3df53bf3f6cef70ca2df82855e0c51b1d688c8bdc79260\";s:49:\"public/assets/assets/svg/busy-icons-svg/apple.svg\";s:64:\"948239ed19b3bc22e43b1c091ed620d6981bd1bc7780632b6e3e2bb26779c2f4\";s:54:\"public/assets/assets/svg/busy-icons-svg/arrow-left.svg\";s:64:\"b2b3a81db02ff6b703bad574de5deab2dc22c7225ac084fa0aa2d27acf1d729a\";s:55:\"public/assets/assets/svg/busy-icons-svg/arrow-right.svg\";s:64:\"fc86505b252b85474334bb474e3b58034cff744c5fbbae542896d7808d8875c1\";s:57:\"public/assets/assets/svg/busy-icons-svg/arrows-updown.svg\";s:64:\"7789e9d7ce373e5f223db9e067c8e235d7205fe346ae93fe2334a8b7ef9cc127\";s:52:\"public/assets/assets/svg/busy-icons-svg/atm-cash.svg\";s:64:\"7643ae344164cfe9de6ea6aeedb852d6904b5cc2989e073fc9c2f47ed85f87fe\";s:50:\"public/assets/assets/svg/busy-icons-svg/award1.svg\";s:64:\"2a41b0ae73e849e53e2cea117b89abd30ec7f76215c5315c4fe44b96dc16376e\";s:50:\"public/assets/assets/svg/busy-icons-svg/award2.svg\";s:64:\"076e6db108a783605f2e060f24790c65fc285ae3f6d99fec1a50a385fd8c27c2\";s:50:\"public/assets/assets/svg/busy-icons-svg/award3.svg\";s:64:\"419329beec3f766097355c2f2821c1397acfc1dcc2759e496a8eea7080f7acc3\";s:50:\"public/assets/assets/svg/busy-icons-svg/award4.svg\";s:64:\"12596fd63bd22de0c2ba0e597281c1c82e6fd12030a9ede5a1a665a42a103fc8\";s:50:\"public/assets/assets/svg/busy-icons-svg/award5.svg\";s:64:\"fc5830783f97ef7c67f7500526a79f2aab08e2ed18ceb7dcae386ca60ff37b08\";s:51:\"public/assets/assets/svg/busy-icons-svg/badge01.svg\";s:64:\"4767e3f81c5ab2df315b90f3f676066c4ec3738fdf416486e4c3bfd89793465f\";s:51:\"public/assets/assets/svg/busy-icons-svg/badge02.svg\";s:64:\"15efb4a50e18fc9e6d2fcf3528171d49faaee2be108063e0b95b36f2a41da5eb\";s:48:\"public/assets/assets/svg/busy-icons-svg/bank.svg\";s:64:\"a99c5b856e62497b7e778c4361f3b4eed6756e14b6feb58ca08fdbfbb4fc7e65\";s:49:\"public/assets/assets/svg/busy-icons-svg/bank2.svg\";s:64:\"e93449a52a20438000290edda3f0edb03380a1da37c25a728ff16df05ed67065\";s:48:\"public/assets/assets/svg/busy-icons-svg/bell.svg\";s:64:\"fb38d3e12f2615012bc1db73a8efba596f8a8f4393a1e3daabe8d7e9c4d01766\";s:54:\"public/assets/assets/svg/busy-icons-svg/binoculars.svg\";s:64:\"8b7fecc3d01871f343c5509c221ca19f12c7e59b00611826e6669abcdabffae2\";s:48:\"public/assets/assets/svg/busy-icons-svg/bomb.svg\";s:64:\"ee2064db9bc9a287abff736d0968ebe00c1923468abd60b5016c6cef2045b713\";s:50:\"public/assets/assets/svg/busy-icons-svg/bonsai.svg\";s:64:\"4810d95cf9f2e6f4d0fc98e802948ac0d0711a7aecab5e3556d9ebb99c2f7354\";s:54:\"public/assets/assets/svg/busy-icons-svg/book-apple.svg\";s:64:\"c9719b5697e8d9889539fa82c787b22d7b06d84c3d14c2a4d6a053a94f766ec4\";s:48:\"public/assets/assets/svg/busy-icons-svg/book.svg\";s:64:\"ae5b4bbc85d8da9ef0f82cc6fb6450a6b07481a7955a99bdab4374b208682879\";s:52:\"public/assets/assets/svg/busy-icons-svg/bookmark.svg\";s:64:\"6d7f87bcbf40ab5abc484048510fb3d25599dd01dc3932fb10df389f3fb5c989\";s:47:\"public/assets/assets/svg/busy-icons-svg/box.svg\";s:64:\"88ef3d60b8e3859ae78fc458add425de0ed9f49c7c252672f40414b51b9a3a47\";s:49:\"public/assets/assets/svg/busy-icons-svg/brain.svg\";s:64:\"6feffae9211bd25e71dfaa90039fc07bb9832e4a23878559d628599bc4f87ae8\";s:53:\"public/assets/assets/svg/busy-icons-svg/briefcase.svg\";s:64:\"d2b92e04722d95ab9449b5ab915da05148642d8d0a9bb57089be1d7c82fe4e20\";s:53:\"public/assets/assets/svg/busy-icons-svg/browser01.svg\";s:64:\"f3594b9488f4d551c79814fc98308863fcecee32d869c48325d92bf2a8cefbfb\";s:53:\"public/assets/assets/svg/busy-icons-svg/browser02.svg\";s:64:\"7db509080724d0b37d763046599d1132f93ab314b5ea4cc411a57df14ab29034\";s:53:\"public/assets/assets/svg/busy-icons-svg/buildings.svg\";s:64:\"1911b08ba44eafb23837cf6bbb3ff85ed84292335e2e81790fa900f0d1948c00\";s:52:\"public/assets/assets/svg/busy-icons-svg/buy-sign.svg\";s:64:\"34a9a436ce2d206ca7869685cd393340067c5ebed406d9e2cc553dfa08de0f18\";s:55:\"public/assets/assets/svg/busy-icons-svg/calculator1.svg\";s:64:\"70ba749d75b833df7c4f2c592164d8853fac7c56f97cd267117b06403ecb1eb4\";s:55:\"public/assets/assets/svg/busy-icons-svg/calculator2.svg\";s:64:\"b18f27690444ed3072a40729ba724393e21077736566eb35ab0379b8f34d7314\";s:55:\"public/assets/assets/svg/busy-icons-svg/calculator3.svg\";s:64:\"a2bd45518507a9fb34331bf63a331dd6e80dd1dbd169330707060c74193d16e2\";s:53:\"public/assets/assets/svg/busy-icons-svg/calendar1.svg\";s:64:\"e3560b15852dc2519a064111993d4719d4d355ab8745f11503a937bca489cbcb\";s:53:\"public/assets/assets/svg/busy-icons-svg/calendar2.svg\";s:64:\"e24c33ec574568b10ae7387a4a810602a26452a064be99d643c90a3e65910cfb\";s:53:\"public/assets/assets/svg/busy-icons-svg/calendar3.svg\";s:64:\"645db8395146ec55da1eec6ca300459f4765c60c4fd42c9963ae96a5ef22e21c\";s:53:\"public/assets/assets/svg/busy-icons-svg/calendar4.svg\";s:64:\"b06f066e64a10bfe0b2b1f6388dba0aaadbadcb63a8591165bab83a6edf84520\";s:53:\"public/assets/assets/svg/busy-icons-svg/calendar5.svg\";s:64:\"a8655ebcf239294597a5d134fb775d6cc8869357f320828e02d05e8307c09e3d\";s:55:\"public/assets/assets/svg/busy-icons-svg/certificate.svg\";s:64:\"43e5968c82f631d690829e69b089d69e40692e5fc1078accecf9c9192ace4c57\";s:53:\"public/assets/assets/svg/busy-icons-svg/champagne.svg\";s:64:\"7f9f00cc2095847ff065948749fc081352e070b95a1bf07be87e6c65bb96e8d3\";s:55:\"public/assets/assets/svg/busy-icons-svg/character01.svg\";s:64:\"e24c8f055f6d9de504d8a18f1a33e8635ed1bce95e6b57ded85327e4f4c233ba\";s:55:\"public/assets/assets/svg/busy-icons-svg/character02.svg\";s:64:\"b2dd0b68603f116dc7e5a81be26da0f2214310d982c99c92c8c774b3c3f78390\";s:55:\"public/assets/assets/svg/busy-icons-svg/character03.svg\";s:64:\"8be5eb81fcc67164fa59a51a55374f0da859061b9d0a267ac81cc801fc8c8a26\";s:55:\"public/assets/assets/svg/busy-icons-svg/character04.svg\";s:64:\"62de246e9b7073e36b4057a3409469f6c9107b8debfc46909d39aa426dd17c70\";s:55:\"public/assets/assets/svg/busy-icons-svg/character05.svg\";s:64:\"48a1575db0c86a853b78064cd17644f3ed0b6b6e355744b423a5d8208890f804\";s:55:\"public/assets/assets/svg/busy-icons-svg/character06.svg\";s:64:\"338451da63fc22eba588c76add1b45ecb069996258b7328bb1e74343e5fed26f\";s:55:\"public/assets/assets/svg/busy-icons-svg/character07.svg\";s:64:\"d60c68a0bd56fef8fdfa0e4130816c40c4a40095065d672b1bf7bd90a6924dc8\";s:55:\"public/assets/assets/svg/busy-icons-svg/character08.svg\";s:64:\"9e19091db350fecc5b6f71173ad5542b540251fbb42ec75e5e65eb64b4849db9\";s:58:\"public/assets/assets/svg/busy-icons-svg/chart-analysis.svg\";s:64:\"66038ac7f995fee7e19bc778e75dc04ade2d3f4271ac29eb2e8e6c2f51bf8fe5\";s:55:\"public/assets/assets/svg/busy-icons-svg/chart-board.svg\";s:64:\"88add3c757b74071cd9274a033f3c1706abe3de2382dae3635cb2b1e82fac9eb\";s:57:\"public/assets/assets/svg/busy-icons-svg/chart-pyramid.svg\";s:64:\"48bb5d31b6c02ec81e8aa37a7cd90c618e54fb564854bb856c11991fde4a65cf\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart01.svg\";s:64:\"2d3de4c84eb950d2fb7c42874a70b8530ed5ef319923d6af588157a4dadb6b80\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart02.svg\";s:64:\"370b5c8c08af1ec02d28303618608bc796d84a456e663b4ed29d1ff0b05ce68c\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart03.svg\";s:64:\"331274fb0126e095e5dffba5090e246e5420453ff27f1d6085be16cd92ecbc10\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart04.svg\";s:64:\"5f179a1e7902d66936a7df747a48de12704f76b6f51f83d9de77307aab9ee78b\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart05.svg\";s:64:\"40cdc6cf63e736e91196d906064a32c0861c12f8698b125a1e114881c549dfc7\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart06.svg\";s:64:\"7ffe973e81d8054a815d674678fe00c7f12ac71b78df7d49515b1dde7889608c\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart07.svg\";s:64:\"faeef6343ddab11b798a14e03ea4e6a7398ba54f141da0bc8764469e29ba7a37\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart08.svg\";s:64:\"a5e745d9c455a271b004f845b68244425fcbe35d29664dbf73704561a3bf9af4\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart09.svg\";s:64:\"703a3dea1474ced468642f1eb91557fbd71f67bfe7566d135b3c71c0e39d7c47\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart10.svg\";s:64:\"e5e7af29b42655374a6a055322efb3d2051a05875588e364834a2e45e10e3ccc\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart11.svg\";s:64:\"9b4c4435f665c1adef240ee74aa125946adfacceb8e8a7e79c0ec6c01fe48041\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart12.svg\";s:64:\"0597d605c6878dde16d6039f16c93885e5b2253d8c83be6bd8559da19d89f242\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart13.svg\";s:64:\"150037d5603f2f4624a0c22de79720bac086d5baedaf0361784dc686554a5e24\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart14.svg\";s:64:\"668560668a799622fbbcbf936c1ff1de189c5ede9b23e4d62e81ea0b2ee3a481\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart15.svg\";s:64:\"7758c3c426f2323d13268f462fc284660f84f764b1ebb645138e96ad84c8c513\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart16.svg\";s:64:\"a8c5290ddd5848a7f5cf8f10064aec106b02d4f7cdae38066bf2a61d69c55c6d\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart17.svg\";s:64:\"aa1f1c28306ee4bb6068efc32b65dc897dc1cee2f63975cfc339a4893c9f39b6\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart18.svg\";s:64:\"30f6b804b088029addb513b0caf513c00859a970adaa09a2162a3bddb786c3f6\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart19.svg\";s:64:\"92ee4aab883e355666c6ce54a60e2fcba19691ed98eac3fdd67feb7c6d13164b\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart20.svg\";s:64:\"59619b7b8174171ef01114e0424ddbc3a9b0bf0f362728c88d67937b36f8d2b0\";s:51:\"public/assets/assets/svg/busy-icons-svg/chart21.svg\";s:64:\"ab8b0e263cad17a944eb9f3276dbea526de072cc6b019f3eb01e2e240cad6182\";s:48:\"public/assets/assets/svg/busy-icons-svg/chat.svg\";s:64:\"c20700933be70ca86bfa395dac68ff711fafd8f3bb322759f7d849adb27262c8\";s:53:\"public/assets/assets/svg/busy-icons-svg/checklist.svg\";s:64:\"e9b74ba2d4909b995a39be37436fc030cb6c5d5eb7a9c8c14c9491e26dc8cc17\";s:54:\"public/assets/assets/svg/busy-icons-svg/checklist2.svg\";s:64:\"f8fc1e9232f223d1360d28ea9c0d27c4b58ec53fea8ba98730f0ee2ae0f537ad\";s:54:\"public/assets/assets/svg/busy-icons-svg/checklist3.svg\";s:64:\"df9cd20cfa10b02ca0eeaa50a8b44b20028fd4aa1665d2eab53e69e215bfdcf9\";s:53:\"public/assets/assets/svg/busy-icons-svg/chemistry.svg\";s:64:\"36423d098b41d049438ab24a5e514abccd5029829f1b1737279e9152ded0b2f7\";s:56:\"public/assets/assets/svg/busy-icons-svg/chess-knight.svg\";s:64:\"ae2a1b60189877f2613c59c86b8143bbae29e07a42276e11012fd940fd929edf\";s:54:\"public/assets/assets/svg/busy-icons-svg/chess-rook.svg\";s:64:\"38a3b176a78d1536b4310ddcfd5455b64434e720804ef38cf70cc2ee06726253\";s:49:\"public/assets/assets/svg/busy-icons-svg/chess.svg\";s:64:\"37efdb870c19a3c272410bfeb99ad5bb1cb5ebe6374f798046ffcd831425eb1a\";s:49:\"public/assets/assets/svg/busy-icons-svg/clock.svg\";s:64:\"bfb4574fcfa6a281499f1662d81f58fda619cb69693a5952db62452e8f120dbf\";s:55:\"public/assets/assets/svg/busy-icons-svg/closed-sign.svg\";s:64:\"09e7ca737f6dc9fcfa851506029e8217869186af26b518bc85f18a6aa04f1cf9\";s:55:\"public/assets/assets/svg/busy-icons-svg/cloud-coins.svg\";s:64:\"ab8c9a10ea77161bc58a2f02d1e19f886f39f0db37342f5e6935d859cb967aad\";s:54:\"public/assets/assets/svg/busy-icons-svg/cloud-down.svg\";s:64:\"29cd80c9b4bd5d45254306c94a5a3acb6cf501becc53180667ad413a07daf3e9\";s:52:\"public/assets/assets/svg/busy-icons-svg/cloud-up.svg\";s:64:\"bb3afa67a29e291e61fe25b20e08c586a96929ebe6b2c43adb1ee5f8f2649da4\";s:50:\"public/assets/assets/svg/busy-icons-svg/coffee.svg\";s:64:\"71eeef559a657b1b13a6428437372165de72d5c13de4765554008ad92b4bacc7\";s:54:\"public/assets/assets/svg/busy-icons-svg/conference.svg\";s:64:\"4ff2f27d4cb95c4874f3b52527e43e4be72cd7a373ee28fcde9fccf89bc722f2\";s:56:\"public/assets/assets/svg/busy-icons-svg/contact-book.svg\";s:64:\"37bc2c0b9c4a982debef2227b64d2f0aaf4cc661881e152980f8a2ddcfd6c6c7\";s:50:\"public/assets/assets/svg/busy-icons-svg/coupon.svg\";s:64:\"be6f9e5e17f8bc1bbd341b0be9b467245785a49d6505bff9e61d5b7c4f76db95\";s:55:\"public/assets/assets/svg/busy-icons-svg/credit-card.svg\";s:64:\"7226ff5a71d862dc5e8a51e086b1db81d1b713a9fd3b0f312c53c4e06dd37306\";s:49:\"public/assets/assets/svg/busy-icons-svg/crown.svg\";s:64:\"3d8f9fa5d394c64ef255d34aa62376fbeac31cb9bcf0befa129cf23df0095729\";s:54:\"public/assets/assets/svg/busy-icons-svg/currencies.svg\";s:64:\"3d04930635a23e3aa1f6a26610e2609220e993092e67c74deefce0c76b87c2a0\";s:52:\"public/assets/assets/svg/busy-icons-svg/database.svg\";s:64:\"5ee03018ab363c45ca9278a0b1012c6316e514a00416dfc620dbefefa6c77b81\";s:52:\"public/assets/assets/svg/busy-icons-svg/delivery.svg\";s:64:\"ca4e3596944038b76b1de9b65fed69bc8f21275b656f40c42075b043dd1c31ed\";s:61:\"public/assets/assets/svg/busy-icons-svg/diagram-hierarchy.svg\";s:64:\"2fcfeee9ac1f38303df063088a278fe1358e9522c05861022fc0b32245af2ac8\";s:51:\"public/assets/assets/svg/busy-icons-svg/diamond.svg\";s:64:\"5e226e8884e6ab1e24181f143425f9dbc2dbfe1e454b587fd0d354e8c49432e4\";s:50:\"public/assets/assets/svg/busy-icons-svg/dollar.svg\";s:64:\"834c9f9a38a5f86ff5492928a095f76199fd8b139f578d64fd6f169a6584c7bb\";s:50:\"public/assets/assets/svg/busy-icons-svg/drawer.svg\";s:64:\"f6b9baff5396a149ca20e5250b5ef26594c5274cf2569aa7bc8b1ce665421fff\";s:47:\"public/assets/assets/svg/busy-icons-svg/egg.svg\";s:64:\"4e63c6275af7f0ad77dd580c25ee8ac51b24091e2ef43c265610870f001daa81\";s:50:\"public/assets/assets/svg/busy-icons-svg/emblem.svg\";s:64:\"522cd1e75a856f03920b18113dc42e7bc2821519a817e16e4bd4a065109e7cc7\";s:58:\"public/assets/assets/svg/busy-icons-svg/envelope-money.svg\";s:64:\"75adcddf23a06001b72d10bc122383cda115a64755a13198ecbab452b10ca1e5\";s:53:\"public/assets/assets/svg/busy-icons-svg/envelopes.svg\";s:64:\"1e3968e350d4dd221851f61e0881fd1bcc07d69789300ab8f1bfac8eaef3cdaf\";s:48:\"public/assets/assets/svg/busy-icons-svg/euro.svg\";s:64:\"54db30d600e368d8c060b952ea2c6526a929b48ca02cff44840fc53790e15c02\";s:52:\"public/assets/assets/svg/busy-icons-svg/exchange.svg\";s:64:\"a2eb15b60e1565fd484a0b5bda48bba737198be2d49b85ccd7cb58e1cc9dec07\";s:48:\"public/assets/assets/svg/busy-icons-svg/exit.svg\";s:64:\"af189a07dc233f9afae899011285777dbcd59dc6426f1764bade17f04ac12563\";s:51:\"public/assets/assets/svg/busy-icons-svg/factory.svg\";s:64:\"c1002f8659b1be6de42e54a6d270cde922fbb94589a64f12cf4505923ddcf26e\";s:47:\"public/assets/assets/svg/busy-icons-svg/fax.svg\";s:64:\"036e082826dbb2bb9a0a88c38b3690f4d0f65642655fdc535331981bf2152166\";s:50:\"public/assets/assets/svg/busy-icons-svg/file01.svg\";s:64:\"01bbd954f334cf71339390f41a8c48444f5110c8870a0efcc5672666750d1159\";s:50:\"public/assets/assets/svg/busy-icons-svg/file02.svg\";s:64:\"373f2a96ad1309f4c8ffa4dac35d57666d1cd73fc94fd8ca240704ee77a5d8e4\";s:50:\"public/assets/assets/svg/busy-icons-svg/file03.svg\";s:64:\"2d4a9ef37a7a62a4bc93f81460e25511bc98fa285919f54e666a83a07a3d39e0\";s:50:\"public/assets/assets/svg/busy-icons-svg/file04.svg\";s:64:\"5c748275b6a21476b1c45f25c27cd18318fea3581312018f6458dbeae2332bb7\";s:50:\"public/assets/assets/svg/busy-icons-svg/file05.svg\";s:64:\"62391ed3eb1a074d7f4a0d1cfb690ec19aaed6f49ac4aa1e0257583314dc872c\";s:50:\"public/assets/assets/svg/busy-icons-svg/file06.svg\";s:64:\"ef8fe7424f515e2e501c44832de844ab612674d0ad4b87abe943b626c5b7a01e\";s:50:\"public/assets/assets/svg/busy-icons-svg/file07.svg\";s:64:\"4d8a0eb669d87bb47c80da17a13a4d6067bb1a400526ade1728f5059663e171c\";s:50:\"public/assets/assets/svg/busy-icons-svg/file08.svg\";s:64:\"e76b16efbb01f7c84c6881a54c0976827a9af260032c1001433db396419e2f47\";s:50:\"public/assets/assets/svg/busy-icons-svg/file09.svg\";s:64:\"d91d7d0959acf1616ca6ac820667c9c5f6d8d5f18b1b27cd96acb29924e09a24\";s:50:\"public/assets/assets/svg/busy-icons-svg/file10.svg\";s:64:\"c70b77d7c8badb11156a478d2eded3490aea32493834f5d3713c6f3c061d7e09\";s:49:\"public/assets/assets/svg/busy-icons-svg/files.svg\";s:64:\"2faa9776f2edfd6a304ad54b86f083f20cb369481815ded958cf03dfc9668227\";s:48:\"public/assets/assets/svg/busy-icons-svg/fire.svg\";s:64:\"9be1a8d3e3601ed99e98dc0496eb1afe340c7b6ebeffc16f99c26a359e24ed44\";s:48:\"public/assets/assets/svg/busy-icons-svg/fish.svg\";s:64:\"20da6f0d5bc0f350f5516a2ddb7e707bab08f5f1ae9681ccb9eb6cd1a088d693\";s:48:\"public/assets/assets/svg/busy-icons-svg/flag.svg\";s:64:\"442fe7ed76d7427e692dbab8db20b3e34fa5813ceb5fb6cd589c45c6a81a36e3\";s:54:\"public/assets/assets/svg/busy-icons-svg/folder-add.svg\";s:64:\"fb4f21cdba5d5290e0fe46b3b02e48846df8e49683caea6e93016f565a8c3faa\";s:57:\"public/assets/assets/svg/busy-icons-svg/folder-delete.svg\";s:64:\"30f3241541894f48a67e666b884a9cd91bad3694b23b650288773166794dd55f\";s:57:\"public/assets/assets/svg/busy-icons-svg/folder-online.svg\";s:64:\"65eb436c43605a9e42da8bc1eb20352160e3a431a330d301c073f5a52ad59779\";s:58:\"public/assets/assets/svg/busy-icons-svg/folder-private.svg\";s:64:\"61b9a6a67cb7c1d3f0361f0aaab8f0187b79d357f6defc2d389970c562a95f53\";s:57:\"public/assets/assets/svg/busy-icons-svg/folder-remove.svg\";s:64:\"1a5878cbce0bffab8c9d09e8359a2282462ed164f1e81633fa006f6e47a48ffc\";s:50:\"public/assets/assets/svg/busy-icons-svg/folder.svg\";s:64:\"70ff4a52bf2bdd27f8b82b428df7047b62ee77e7285d3403c8faf8ae8d19fd8e\";s:51:\"public/assets/assets/svg/busy-icons-svg/folders.svg\";s:64:\"f1e782e7523b22002d9a9cdbc192dd05a0b898e67c30c7ce17db78a3686dc149\";s:56:\"public/assets/assets/svg/busy-icons-svg/funnel-money.svg\";s:64:\"6e21a968a862aa5b53144d6ca0b9f6b52c25cd04b91609d8d30d566f28336583\";s:50:\"public/assets/assets/svg/busy-icons-svg/funnel.svg\";s:64:\"2593bdb8f6d671c5f3c298d9f9802449025155ea3476da814a4b5edc8d4eea92\";s:49:\"public/assets/assets/svg/busy-icons-svg/gauge.svg\";s:64:\"4483e634855b35127fbacc8fb6601319f7a757ae8efbc541dafb4bcc06b433c2\";s:50:\"public/assets/assets/svg/busy-icons-svg/gauge2.svg\";s:64:\"689c10140da140f3af2bbfa13f38de3928eb15d2696584c65421d012df5149bf\";s:50:\"public/assets/assets/svg/busy-icons-svg/gears1.svg\";s:64:\"4261c14aaf6d5d8cae144af73f76403b0d64b4dac4e7c91da81efa5ac5a09b76\";s:50:\"public/assets/assets/svg/busy-icons-svg/gears2.svg\";s:64:\"a67daa4a554d0e45e7fd54dc3244ffa703649aaca4355d6e1a9f30adf29941a0\";s:61:\"public/assets/assets/svg/busy-icons-svg/glasses-moustache.svg\";s:64:\"b5e282f5dfb4bad7b2c8c8a5a6bbcee0982403898c46ad23977230ce79e8ebfd\";s:55:\"public/assets/assets/svg/busy-icons-svg/globe-money.svg\";s:64:\"67af5d958b27d88cbf6d9c2a22fca699031826a66083393c61fbb03d039dbd3f\";s:49:\"public/assets/assets/svg/busy-icons-svg/globe.svg\";s:64:\"c8c9b739ea6e54340edc712800240516e1803e6948fe916c71dd64478e641d60\";s:50:\"public/assets/assets/svg/busy-icons-svg/globe2.svg\";s:64:\"294e7069020569f4d03bdce820f15cb8e56259135847f40f4bf8c40fe940d2a4\";s:58:\"public/assets/assets/svg/busy-icons-svg/graduation-hat.svg\";s:64:\"859699e88337270eaa398694ab374d42ca0b6cd2ddd67512b95df71394742b12\";s:54:\"public/assets/assets/svg/busy-icons-svg/hand-globe.svg\";s:64:\"77fb9367a4c2bbee03be26bd62adc50bf70e618939f1ceef6e169b49b0f802f2\";s:52:\"public/assets/assets/svg/busy-icons-svg/hand-key.svg\";s:64:\"c100b7b4e846d2972dc0d2d527b931de25edf6a58cf383ec50a8e9dd7e2fc976\";s:54:\"public/assets/assets/svg/busy-icons-svg/hand-money.svg\";s:64:\"ada05657bbfe7a6a68d7edf2e1f09d1d027192a4ee77defbd491091c06edd0dc\";s:55:\"public/assets/assets/svg/busy-icons-svg/hand-money2.svg\";s:64:\"4e6d718eec2e07d87171acc2ffcd53ec7d694a4d823d41cd840a92473010331e\";s:53:\"public/assets/assets/svg/busy-icons-svg/handshake.svg\";s:64:\"f435d0c8cc9f9665f70ffb8ac6238503d6cdb13599d9487ebf6621f58ae2ef99\";s:57:\"public/assets/assets/svg/busy-icons-svg/hat-moustache.svg\";s:64:\"f1b4136ca4054fbc9ef1e36bb87bb2aa1f71c9f5a5caa5c51df4291207434c5b\";s:47:\"public/assets/assets/svg/busy-icons-svg/hat.svg\";s:64:\"d7591c34734286221aec742cc832192fdeacf7da32c5a4e59b8af59cb0f44b52\";s:55:\"public/assets/assets/svg/busy-icons-svg/head-arrows.svg\";s:64:\"943d312c775edc358c0fd276bdbad1417bfae8947d5f5208bff66ee5a4c91aa2\";s:56:\"public/assets/assets/svg/busy-icons-svg/head-battery.svg\";s:64:\"84cc9f4f9870fd4cc42f23b64f1a20271f7091cab4b26d9abcc47069a7cd2a19\";s:54:\"public/assets/assets/svg/busy-icons-svg/head-check.svg\";s:64:\"4a1361104a0c053bfd4b01f2b003a5463e1fff8ba15d2f7dec791bcdad486c89\";s:56:\"public/assets/assets/svg/busy-icons-svg/head-compass.svg\";s:64:\"1274bef2383f640d2ab7471b33ecf35da373fcf2cc46bbe880ee03926bb66ec6\";s:55:\"public/assets/assets/svg/busy-icons-svg/head-dollar.svg\";s:64:\"12ee216f219d054f4584bb9c2ad14e10847791a91ca0073bb88a283890573ad4\";s:60:\"public/assets/assets/svg/busy-icons-svg/head-exclamation.svg\";s:64:\"9b0f49ddb0ca907ad75c590b947a4eb979706a65fabcf2e80cfbf614e0022093\";s:54:\"public/assets/assets/svg/busy-icons-svg/head-flash.svg\";s:64:\"4dff469f335d625f5566bf4e0ef6e9ad15bdc37e8b8138b18d3759e7784db830\";s:54:\"public/assets/assets/svg/busy-icons-svg/head-gauge.svg\";s:64:\"d90ab3f6c8cb773bb3dbeba89b661e960a24a1ad6e1e342fe83a70f6bc2a2159\";s:54:\"public/assets/assets/svg/busy-icons-svg/head-gears.svg\";s:64:\"cc3df32139638541b452508bc8098b795f93b6583181eef19ff74a4e0f61f7a7\";s:58:\"public/assets/assets/svg/busy-icons-svg/head-hourglass.svg\";s:64:\"a2114e23e5b256303f1a7ab1fc3e07687516d0805a4b688f62c4387970d83fa7\";s:53:\"public/assets/assets/svg/busy-icons-svg/head-idea.svg\";s:64:\"b7703545a4606d4d4411213bc3f3ace6a74da9c75b707e3046c6735c0c06b477\";s:57:\"public/assets/assets/svg/busy-icons-svg/head-question.svg\";s:64:\"3de3923c884bc00859e21029c82ec477eec282f4dd81a42da7c2bdbb40ad9a59\";s:58:\"public/assets/assets/svg/busy-icons-svg/head-structure.svg\";s:64:\"7c0913b4cd255b7a138bc5f7dc723a8fc826c03e466e7024a1fd870eeef4569a\";s:48:\"public/assets/assets/svg/busy-icons-svg/head.svg\";s:64:\"a298d0fc05e47d4628e7951f354d9bbdab308ce762c3253910f4528b835ca9d1\";s:56:\"public/assets/assets/svg/busy-icons-svg/headquarters.svg\";s:64:\"28871cf85ccea68ba78b5b0a5584ab9878a8cdbc4828d8284f83b0aae6523c69\";s:53:\"public/assets/assets/svg/busy-icons-svg/hourglass.svg\";s:64:\"c553021891322dfb7ba4282153f144b7aae8b301626703a3fe7bb1ee19bd1266\";s:49:\"public/assets/assets/svg/busy-icons-svg/hours.svg\";s:64:\"48b87c52949d5b8d4aa5e9ce81662037eee1e89c0632db0fd8758b499b88ea0f\";s:52:\"public/assets/assets/svg/busy-icons-svg/incoming.svg\";s:64:\"fded8b465fb284682b339e68a3d022db1350c9bc2fdafef012a703eb2ad9aab6\";s:50:\"public/assets/assets/svg/busy-icons-svg/ingots.svg\";s:64:\"8fcaa5efdae6a686b4e7420ed56d217be18de2a8e6a82892195ed5d32de7c785\";s:47:\"public/assets/assets/svg/busy-icons-svg/key.svg\";s:64:\"61418becc2fb046e3063a5cb4e6b727fb564bf2759dab73898664685613ab4f6\";s:48:\"public/assets/assets/svg/busy-icons-svg/key2.svg\";s:64:\"da8b590ba5ca9e16ca6139bb532597677319550b9fae6f3432953c25955f84c9\";s:52:\"public/assets/assets/svg/busy-icons-svg/keyboard.svg\";s:64:\"8105805d0693cc45015aec8ce128d97c818df29b009e8301ee717fb8a1755170\";s:49:\"public/assets/assets/svg/busy-icons-svg/label.svg\";s:64:\"913551fcb5ba79f3aea8d3f2c65940b379712ac220cb184754df196da5a75039\";s:48:\"public/assets/assets/svg/busy-icons-svg/lamp.svg\";s:64:\"f7e2614d3264e5f68f03536fd7f39cfaec5135f5042ec80df094fe1cc13e54f7\";s:58:\"public/assets/assets/svg/busy-icons-svg/laptop-article.svg\";s:64:\"93e38e8d1f6ce7e71ab823909450ff21b2ce3748e0539bd506ce17e7d1b092a8\";s:55:\"public/assets/assets/svg/busy-icons-svg/laptop-cart.svg\";s:64:\"9a1d3ff7d16c277f6438df97b440e097fc8d55e01fc715e3ee5af9616c104912\";s:56:\"public/assets/assets/svg/busy-icons-svg/laptop-chart.svg\";s:64:\"5e148653fe341bf8253671aaa74f7c7636a0d5ea771113be411b05583362a884\";s:57:\"public/assets/assets/svg/busy-icons-svg/laptop-chart2.svg\";s:64:\"c7bb3e8688c5a13d8ec1ad0aaf48d632b683d9be64120a85d1de60db94713a1d\";s:58:\"public/assets/assets/svg/busy-icons-svg/laptop-diagram.svg\";s:64:\"55fc8285b821b3d5fa0b571a9a88bd77087ebfa2720f58498a8936fef411f1e4\";s:59:\"public/assets/assets/svg/busy-icons-svg/laptop-envelope.svg\";s:64:\"55d7bffc2a888f8fd8bd2775343071751184c6d87af49970f5fff0bbb1a6bd49\";s:58:\"public/assets/assets/svg/busy-icons-svg/laptop-finance.svg\";s:64:\"3ce5d591447ff623a527c830b49f985f3e03f5eeac5af66a29f7515a1ec0beec\";s:58:\"public/assets/assets/svg/busy-icons-svg/laptop-privacy.svg\";s:64:\"9a2ea0681827cddf04cae9e323f13569f7ad623154d4a78c275d3ca65e955a74\";s:59:\"public/assets/assets/svg/busy-icons-svg/laptop-settings.svg\";s:64:\"f05331d144c97b42742ae47a22570efb0effd428698148ffdf4decd828eea604\";s:55:\"public/assets/assets/svg/busy-icons-svg/laptop-user.svg\";s:64:\"fbf18dfb15ab156969f8f819b1452b889005fde35ddc626d4cc3f423753e7b05\";s:50:\"public/assets/assets/svg/busy-icons-svg/laptop.svg\";s:64:\"c8d6a583c98776bedde473b68ff9fa1ced317cf631d4963419765b41abdcc025\";s:59:\"public/assets/assets/svg/busy-icons-svg/lightbulb-green.svg\";s:64:\"700eefae907d22fe99b626e612452c02e1de598985337c8d205159dde37813c0\";s:53:\"public/assets/assets/svg/busy-icons-svg/lightbulb.svg\";s:64:\"3a797af481234fe873caf056ad6422a4defc888fba43886d2165102fa31a6724\";s:53:\"public/assets/assets/svg/busy-icons-svg/lightning.svg\";s:64:\"e72db0bed9dc10c07796c20e67458634e132b0b5b027c88f2c81937e9274d9c5\";s:48:\"public/assets/assets/svg/busy-icons-svg/like.svg\";s:64:\"5ae9c84079d7100b9c12039c14bad1a9969c4e1f1ca0553a6aee9cfcc14c52f2\";s:48:\"public/assets/assets/svg/busy-icons-svg/lock.svg\";s:64:\"f403c42b716d6a73890c740806c4b50e35c34f63fee31ee09cee2b093012b7fe\";s:56:\"public/assets/assets/svg/busy-icons-svg/magnet-money.svg\";s:64:\"33a54170088674d6e5da70b8c704915405d036ae126818b77d7fc9b28e8f66ee\";s:60:\"public/assets/assets/svg/busy-icons-svg/magnifying-glass.svg\";s:64:\"df4c8cd180fa3b8f6ae2d7af66739d0ec47b280cd906c45ac7ddb78a4b5f2ed6\";s:57:\"public/assets/assets/svg/busy-icons-svg/manager-globe.svg\";s:64:\"bb3c3234d892199c37a4d4c04d2a628532c5ac016de931611096d1ec82da6844\";s:56:\"public/assets/assets/svg/busy-icons-svg/manager-idea.svg\";s:64:\"2a3c7e0dbc04889605ce8c553248528b10d90a6e1c761828f9120dda8c639e0c\";s:53:\"public/assets/assets/svg/busy-icons-svg/manager01.svg\";s:64:\"b2ba093291d267fed9d3bfc1bd82f5fac1fdcdf0d6a39a919e9afe49e4d8ba7d\";s:53:\"public/assets/assets/svg/busy-icons-svg/manager02.svg\";s:64:\"da20cdf4fc727b60f4aaaf23471ac933d78db281b7607fb339f78f2f9e1ed990\";s:54:\"public/assets/assets/svg/busy-icons-svg/meditation.svg\";s:64:\"267d38b8108beca8d9a94c598d5f0a06fddb4a7454a4c86c71b9d09d14f5931b\";s:53:\"public/assets/assets/svg/busy-icons-svg/megaphone.svg\";s:64:\"8b216c924cdff1e11efe4aa19a8de62fba918452daba00ba1ddb5162d531404f\";s:56:\"public/assets/assets/svg/busy-icons-svg/money-growth.svg\";s:64:\"be12fa628893cd534716b3a74776fa837a3273af46bd5df7625af0bcbe6cfe49\";s:56:\"public/assets/assets/svg/busy-icons-svg/money-scales.svg\";s:64:\"b948a4d0f828a98105472636a14cf81bb6a23f60ba074a287878c278b7af038a\";s:49:\"public/assets/assets/svg/busy-icons-svg/money.svg\";s:64:\"96b01a12dd3d1fed63ea67e89e3f9c9126a008a668ba9a21a9589cbb0bffd9a8\";s:50:\"public/assets/assets/svg/busy-icons-svg/money2.svg\";s:64:\"304e6d4f2b3cb6cf95a378cd8d6bf7458d0cc4d638f2b0b514c678035b61e1fe\";s:50:\"public/assets/assets/svg/busy-icons-svg/money3.svg\";s:64:\"72e8bf2f8d583934299fc60aeb22cc504ab4615f933ff41747476c15a7bcab3f\";s:50:\"public/assets/assets/svg/busy-icons-svg/money4.svg\";s:64:\"17cb90f05213d65aed600953f49674ea3eb2db3cae1afcd1b2e68f66eb84952d\";s:50:\"public/assets/assets/svg/busy-icons-svg/money5.svg\";s:64:\"2001200cfa05e277fab364329b323376db7d52e227e3bf45fbcd5eb01fa3aa03\";s:50:\"public/assets/assets/svg/busy-icons-svg/money6.svg\";s:64:\"9ccf0ec64c3ae22501b27ed496bfff9a380082e8ff89f02971bc3e427845cab6\";s:51:\"public/assets/assets/svg/busy-icons-svg/monitor.svg\";s:64:\"dcd7187ce0be4d50a9166bde3246f4f01ff4b04d2725469bd271aee6600b78ce\";s:49:\"public/assets/assets/svg/busy-icons-svg/mouse.svg\";s:64:\"ae406f24deeb22299f81cd939b2e0b40c3fe301965d65e1feb9ead0ead752cc3\";s:54:\"public/assets/assets/svg/busy-icons-svg/nest-money.svg\";s:64:\"87bd64a802a75896c8f019c85051abcd419627e23d9da4822f73248e0b91eb2a\";s:58:\"public/assets/assets/svg/busy-icons-svg/newspaper-jobs.svg\";s:64:\"56029e8a0ccb493c31b1808fe6b2753f5e6700ce6d29fc9dc4a83d84558baa16\";s:57:\"public/assets/assets/svg/busy-icons-svg/newspaper-pen.svg\";s:64:\"673eb89b5d37886fa731004bc3c858e536b816c1a25ba1abd1cba395fb130bcc\";s:53:\"public/assets/assets/svg/busy-icons-svg/newspaper.svg\";s:64:\"fcd46ce5100d6d3b03426f059916bce5d915ed5c6395ab9758c57432bd801c5a\";s:54:\"public/assets/assets/svg/busy-icons-svg/note-paper.svg\";s:64:\"608f3a0569c365af3a55ed60bf572190ecd83b165a09c81f502028fc1c538a41\";s:56:\"public/assets/assets/svg/busy-icons-svg/office-chair.svg\";s:64:\"1150cf91e260c1a35068e76dbfe4089e419866850f6adf589fcd222ed72d3271\";s:53:\"public/assets/assets/svg/busy-icons-svg/open-sign.svg\";s:64:\"1ce9d9cd8541439439116bbcdf5e69ceb2e7c87d966319dd073541e4ecb3201e\";s:52:\"public/assets/assets/svg/busy-icons-svg/outgoing.svg\";s:64:\"d867643711e9577e88582b26223a3f5858d009ddcd50b1a6bca964595e53cad9\";s:54:\"public/assets/assets/svg/busy-icons-svg/paper-clip.svg\";s:64:\"6152f2337ed932c75d7e24b70dd249126b78aa450721afafec14632323a470df\";s:55:\"public/assets/assets/svg/busy-icons-svg/paper-plane.svg\";s:64:\"6152f2337ed932c75d7e24b70dd249126b78aa450721afafec14632323a470df\";s:47:\"public/assets/assets/svg/busy-icons-svg/pen.svg\";s:64:\"8cda8d0bed689de759950a2993a937e8890bb9c0836fad3cee99499fef349802\";s:48:\"public/assets/assets/svg/busy-icons-svg/pen2.svg\";s:64:\"a23b1afc925fc98820049a59a50dff4594bf8bad5b899b48fc8e5e801eee0bb0\";s:50:\"public/assets/assets/svg/busy-icons-svg/pencil.svg\";s:64:\"527edcd79093bbe66252426a12fe3a90323f2f1d22bf9f132d5b8e3b2b768caf\";s:56:\"public/assets/assets/svg/busy-icons-svg/pens-pencils.svg\";s:64:\"02fdf6842584a17b72994fb959f8b9a2f17601a7ff3bc9fd9013796f2ebf225d\";s:59:\"public/assets/assets/svg/busy-icons-svg/people-arrows06.svg\";s:64:\"644ba52bc146cca3095e4438aaef4d8ba6a483051ccf4d4a8678c1efaf536c93\";s:56:\"public/assets/assets/svg/busy-icons-svg/people-gears.svg\";s:64:\"f73956a35f2b850fab9519179fffd1c30d8fbc6964329369fa928949228588a0\";s:60:\"public/assets/assets/svg/busy-icons-svg/people-handshake.svg\";s:64:\"6dcbb3054a3c81f18cedbc162d2b9adcebb7f382b922c3575bb8b08199196b96\";s:55:\"public/assets/assets/svg/busy-icons-svg/people-idea.svg\";s:64:\"a2aa5f73a1e7709ed758d20a4d02b8d4dc547c599ad92d92ccca9637e8c02946\";s:58:\"public/assets/assets/svg/busy-icons-svg/people-meeting.svg\";s:64:\"0acf6a6f9d4e20e492f1bd3f4d90a3fbc4f6ceeb648cfa8fc95515f6494014be\";s:60:\"public/assets/assets/svg/busy-icons-svg/people-meeting02.svg\";s:64:\"041ac93d2885efa150ccd8024fb68e77e68372f6eb99052ae51dc534cf766771\";s:59:\"public/assets/assets/svg/busy-icons-svg/people-search01.svg\";s:64:\"51dba30d97e73854f262da75394ada50ba85eb95b11414b063c9ada1fdf3e098\";s:59:\"public/assets/assets/svg/busy-icons-svg/people-search02.svg\";s:64:\"65a1d380f28c9dbe19357dc316693edccec96261ace5a1754a9d9fb3677a7ede\";s:60:\"public/assets/assets/svg/busy-icons-svg/people-structure.svg\";s:64:\"a3ad402df1c03a2b6e41f27971f3851e7342822296f5446cc9a983a3f1202d5a\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure01.svg\";s:64:\"9940fcd5fe908e3d1c8b3e9b2bddce61d51e7ad28d69fe8a37f2a106d404f685\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure02.svg\";s:64:\"3abc1e327b57be948ded61d537b811eb346b8101d3302f321fa38f848d4dd36d\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure03.svg\";s:64:\"7ff22c89112e2bba485883d878db13db882d3ba5e75788364c894fea7e4675bc\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure04.svg\";s:64:\"127010127c35785e38a03bc4757488a67efba252ada044ed776de18520c6d84a\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure05.svg\";s:64:\"8dfb345e00e7f3dc47b02730ef13fab505ce14fb4dde76a41657812fcdb3f3fd\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure06.svg\";s:64:\"c77fa508b9ca401238335f12d6c7bfbf4fba2de9d797e9191aa65bbceca6e982\";s:62:\"public/assets/assets/svg/busy-icons-svg/people-structure07.svg\";s:64:\"a952e4e7d05961daa17e9586ae2e97223430e7165f22f47d4c522a55dec272ac\";s:51:\"public/assets/assets/svg/busy-icons-svg/percent.svg\";s:64:\"9d8d95846c6546622aaf014b0430cb47e5fe770c3cd43b39b030173dde942a26\";s:58:\"public/assets/assets/svg/busy-icons-svg/periscopemoney.svg\";s:64:\"055b50e73c7a4b3413d98f71661aa2f427779ed865799f1085dfb4d66f55cbba\";s:59:\"public/assets/assets/svg/busy-icons-svg/person-arrows01.svg\";s:64:\"65c32d333c2415a643d1ddaf23dfa6aa6cda5675a25f0878c14ad5b3b93eb733\";s:60:\"public/assets/assets/svg/busy-icons-svg/person-arrows012.svg\";s:64:\"9d70a9728c1eaedcac8041d1b94886217dbbf323fa58d9e6d5ffa4159a6f5c39\";s:59:\"public/assets/assets/svg/busy-icons-svg/person-arrows02.svg\";s:64:\"ae74700fbb2b677e36900e6f6c383359546944ca8d90a10e9c2949ff07b6e9c2\";s:60:\"public/assets/assets/svg/busy-icons-svg/person-arrows022.svg\";s:64:\"998fda705762edeaec5893bd2ea4345d06671d7e1a114b97de989d78e621a2fb\";s:59:\"public/assets/assets/svg/busy-icons-svg/person-arrows03.svg\";s:64:\"7bb29b5671a483965506ad124f8bf08bc90eaa5373b7fdf751d519aa9abf21d4\";s:60:\"public/assets/assets/svg/busy-icons-svg/person-checkmark.svg\";s:64:\"74881b2f9915c7592292d9c65356f9e8cc33a2e5db48d8c7d740fb6fc7436688\";s:56:\"public/assets/assets/svg/busy-icons-svg/person-cross.svg\";s:64:\"8bfd782db79536dec93c3c20f0d65fe5ded4a20eb843e81af1e5eaad4d87ff3d\";s:55:\"public/assets/assets/svg/busy-icons-svg/person-data.svg\";s:64:\"08cda43f716660270ebf07b4fc57f5f206ff27a8c24616d5a639e8b0907b7626\";s:57:\"public/assets/assets/svg/busy-icons-svg/person-dollar.svg\";s:64:\"d1f50bd6745b51447e46e3d53d1d6d9a4483f8726cda7b64ecabbeaf4903f7fc\";s:58:\"public/assets/assets/svg/busy-icons-svg/person-finance.svg\";s:64:\"7edd195b55d5fbd0fd2a12d9be2a53019c26644cb8fa5e708fd95b264db4be39\";s:55:\"public/assets/assets/svg/busy-icons-svg/person-flag.svg\";s:64:\"ba12e061d4ba097199a2166aa5bee7eea2fe427dfc664a978f35c929b772712c\";s:56:\"public/assets/assets/svg/busy-icons-svg/person-globe.svg\";s:64:\"78ca8535f3879f86970b9d31c6efb596a4d6aa9fe7d79fc1d34b1801c56077d9\";s:57:\"public/assets/assets/svg/busy-icons-svg/person-idea02.svg\";s:64:\"892fd7af5c5158b964ca71328935523ec8cd31eaf71cfe62f531d033d055f4e6\";s:55:\"public/assets/assets/svg/busy-icons-svg/person-info.svg\";s:64:\"5a6a6d17ff125b23753aa0515f89b1532b92558e7911b0e0260f8914a793bf56\";s:57:\"public/assets/assets/svg/busy-icons-svg/person-puzzle.svg\";s:64:\"2b5083419230b5c913dc121bca6221e957493735aa9614997066881200ab95fa\";s:57:\"public/assets/assets/svg/busy-icons-svg/person-scales.svg\";s:64:\"738d6af39f4df64f11a06d147bb1a3f6187c0f86c722d7fb2bd1a78cdc5eb715\";s:55:\"public/assets/assets/svg/busy-icons-svg/person-time.svg\";s:64:\"623ea24d6849d3f846d0f8b6c9e67cb7d397c2142c873cbeb9f8440c9d9b9af6\";s:59:\"public/assets/assets/svg/busy-icons-svg/person-umbrella.svg\";s:64:\"d5f0616a6a68672d0153708e791247496d1db178dd40306a3b2afaf092eb5eca\";s:49:\"public/assets/assets/svg/busy-icons-svg/phone.svg\";s:64:\"f20ccb6a06329c76a19b3d9312e4760969a0f18685ee64657bc3e2c2801406a7\";s:55:\"public/assets/assets/svg/busy-icons-svg/pie-chart01.svg\";s:64:\"c4b0f404cab573ab80492d73415a70443a78c07dffa656213f2a314595fc7078\";s:55:\"public/assets/assets/svg/busy-icons-svg/pie-chart02.svg\";s:64:\"fb72a34884d5fb97197b332e7ac4449183e6374becc37af06900b7656998b482\";s:54:\"public/assets/assets/svg/busy-icons-svg/piggy-bank.svg\";s:64:\"ad472bc1be1e73c3e51d7001081b614f451c4cdb1c7839bd2328a55c4bb76a33\";s:47:\"public/assets/assets/svg/busy-icons-svg/pin.svg\";s:64:\"b11034e56963461396cbdaec8152ffe1f2f5b035c4d420b6a0bcc9c13b9cf6bf\";s:55:\"public/assets/assets/svg/busy-icons-svg/plant-money.svg\";s:64:\"7c5c17c54a899ea3a2f887ecd80be6e6a44566eb9539d4d64a27284d456070d3\";s:49:\"public/assets/assets/svg/busy-icons-svg/plant.svg\";s:64:\"f0f9b6bf7f76ed5fd2ac413e47f26230d6e37d681b0205cebdc9afec360d4101\";s:49:\"public/assets/assets/svg/busy-icons-svg/pound.svg\";s:64:\"fb47da2f307bbeeae4300ceaa716f898d91f35c2e620724c7288051bade5b522\";s:56:\"public/assets/assets/svg/busy-icons-svg/presentation.svg\";s:64:\"7b47536c137240fdbc7d54e6502cb5888fae67275505252419651920f47815d4\";s:58:\"public/assets/assets/svg/busy-icons-svg/presentation02.svg\";s:64:\"a443c5193d4be8f24e626c2e563562b9678d7429ca6846d1ffd1548ffb273b79\";s:58:\"public/assets/assets/svg/busy-icons-svg/preson-chart02.svg\";s:64:\"cfcfe6a89d816f5ef240eda38d68df44adcd49b01f17872b565362a32e22effa\";s:58:\"public/assets/assets/svg/busy-icons-svg/preson-chart03.svg\";s:64:\"006d747fc26bfcdd7eb922df9757e57548887295d9d618cb8fa8bc41682cf13b\";s:58:\"public/assets/assets/svg/busy-icons-svg/preson-chart04.svg\";s:64:\"aabceab237319b19ff332703d4643a9afcc172e36a7d2f0e421440746cd23fca\";s:58:\"public/assets/assets/svg/busy-icons-svg/preson-laurels.svg\";s:64:\"466bcd71a38d353ece0c98e646c8781716fd6090706ecb3b087f23f5670d5696\";s:60:\"public/assets/assets/svg/busy-icons-svg/preson-megaphone.svg\";s:64:\"e08414cf0806c013ebe9e629a9c0395bc49baf73a751273dbdd27bfddde8ab95\";s:57:\"public/assets/assets/svg/busy-icons-svg/preson-stairs.svg\";s:64:\"a5dd0399d7164ee38f6710814fbdb865b194db823125cc1c8e743b197ca0c2be\";s:51:\"public/assets/assets/svg/busy-icons-svg/printer.svg\";s:64:\"a6466afb429238ebc3d76c2ca4a80ab1003d72500f8c9f9e0ac64697d472428e\";s:51:\"public/assets/assets/svg/busy-icons-svg/profile.svg\";s:64:\"bbf828f1db18d6864c8f0912bf1435e5445b9197a52ebb84bb9c8781c57897f2\";s:49:\"public/assets/assets/svg/busy-icons-svg/pulse.svg\";s:64:\"b75281bd8ce9b87b83cc011cbd0be2824a329b223460e22342b7f8ee33e26599\";s:50:\"public/assets/assets/svg/busy-icons-svg/puzzle.svg\";s:64:\"da73a3f5c1c47891192248be7e0c5956b09182e9169ed5faedf433dbe47349a5\";s:49:\"public/assets/assets/svg/busy-icons-svg/quill.svg\";s:64:\"7aaca04298535c2d7a1bdd45cb4c419d3591aae9795f7dd30799a148865f44d2\";s:51:\"public/assets/assets/svg/busy-icons-svg/recycle.svg\";s:64:\"f1b8568e2346e8bf54ca754ceaf9a2aacf603e4b7dbb83584599c968dde890b1\";s:50:\"public/assets/assets/svg/busy-icons-svg/rocket.svg\";s:64:\"3c7ab5bba299bc8c4028e9094bb006322073b1e3842d1e5cb0481dbb6504b7c6\";s:51:\"public/assets/assets/svg/busy-icons-svg/rocket2.svg\";s:64:\"895ac6b2f0f1fee5d0a1fcdd5a72cfa6eca699dbc751ca63f629a045fbafd530\";s:49:\"public/assets/assets/svg/busy-icons-svg/ruble.svg\";s:64:\"a499338e8c305ad7744ab7b8a5f7b1e8ba49093d3ac1dfce7554a5aa3c22fb40\";s:59:\"public/assets/assets/svg/busy-icons-svg/ruler-compasses.svg\";s:64:\"7aeda665f61f4f5e4c6945eb9ce4cf5dbcf507a1d5de1a45b9dcc532c215d98b\";s:48:\"public/assets/assets/svg/busy-icons-svg/safe.svg\";s:64:\"34bc63f91fb49f814f0fd09537b5d73e9a9cd81d52a7e1edf255513bac27fa0f\";s:53:\"public/assets/assets/svg/busy-icons-svg/sale-sign.svg\";s:64:\"1c2cda9413f0c16c741dd4dd9030a1f6368431fca2f79e1cae34b6a5b2153a20\";s:58:\"public/assets/assets/svg/busy-icons-svg/satellite-dish.svg\";s:64:\"1a60cfcb728880bcbad110822b2ef47022bb277c4f60ac1af62b851ba3bab623\";s:50:\"public/assets/assets/svg/busy-icons-svg/scales.svg\";s:64:\"e98f27601c7bf2b26c65b91d32685190067fd5d6526f338a4012c3f74a0c2443\";s:52:\"public/assets/assets/svg/busy-icons-svg/scissors.svg\";s:64:\"a7f5670a9ef41c3d9f79af9db757883d3d3f7a0ac96ecd371a2837293e3cf450\";s:52:\"public/assets/assets/svg/busy-icons-svg/security.svg\";s:64:\"06deced612a11efae6f28bf4540ce2ef26061531693d2d711f3ec56d0a8c163f\";s:48:\"public/assets/assets/svg/busy-icons-svg/send.svg\";s:64:\"51c0609ab249da6bffd6172411d4f54e2ade61ebe8e1dd47b14682fbb3502049\";s:50:\"public/assets/assets/svg/busy-icons-svg/shield.svg\";s:64:\"2eb30baf95710c0dce408c58853d85a336c33aae414ac5033e9828d4905645da\";s:57:\"public/assets/assets/svg/busy-icons-svg/shopping-cart.svg\";s:64:\"d21f541a18ae17c2633244386b44ceffd4f1f7892bd534bee162e030b9f95b8a\";s:48:\"public/assets/assets/svg/busy-icons-svg/sign.svg\";s:64:\"510a9f1b6ea6d6ee934c7a742ab71a88839e639772f517538f4b333c591ee253\";s:60:\"public/assets/assets/svg/busy-icons-svg/smartphone-chart.svg\";s:64:\"bbb60cd54eb599eba1da9da38345976d96ae45aa889d3a543df458efb14fa349\";s:66:\"public/assets/assets/svg/busy-icons-svg/smartphone-exclamation.svg\";s:64:\"623c758b2b2e133a829c9f71b1cdec1e416feba138aef2f18ce884afe041c405\";s:60:\"public/assets/assets/svg/busy-icons-svg/smartphone-gears.svg\";s:64:\"71357355e6adc99f4ca784fc7a90efc42e59cb3cf1c4650ed4c95bd4fb3ea2e4\";s:61:\"public/assets/assets/svg/busy-icons-svg/smartphone-growth.svg\";s:64:\"e8304805928fb6554933542e2e79c7ed99d14ad9682ccbb17ae5ab0cb95d4e8e\";s:60:\"public/assets/assets/svg/busy-icons-svg/smartphone-money.svg\";s:64:\"436a1812c338cb7ab5f874c82501f8430135da3e201f5fe7d9da1c7ac6750577\";s:59:\"public/assets/assets/svg/busy-icons-svg/smartphone-user.svg\";s:64:\"9d946ff5f81edb4fdad3f06362af882e6219c80342e511933b67a0d3c160a7a1\";s:54:\"public/assets/assets/svg/busy-icons-svg/smartphone.svg\";s:64:\"ddf8fb992b4e5a96be559dd89b957f5a4814f33f06185bc74085bd78dd6e684c\";s:51:\"public/assets/assets/svg/busy-icons-svg/speaker.svg\";s:64:\"ae7458c4084ee69296e1254b5a9e0535ce8b2724e4499a9fcf073085c9b2a14c\";s:53:\"public/assets/assets/svg/busy-icons-svg/speaker02.svg\";s:64:\"dc0b16be1203daca54ac680380edfca63e51c17ea7ee1e21e956665a73f694c5\";s:57:\"public/assets/assets/svg/busy-icons-svg/speech-bubble.svg\";s:64:\"ae1f13b974973f1ffcbe649c1ffd45d7580c6e2dbf660bb1bdde2007eda0fd91\";s:49:\"public/assets/assets/svg/busy-icons-svg/stamp.svg\";s:64:\"f4ae3938ce0727bccc0eb8d74ab07f0a11ed9c8ae55347d9460865bf93ffc4b4\";s:48:\"public/assets/assets/svg/busy-icons-svg/star.svg\";s:64:\"6b1d65864e10c126b58783fc389bd58ddb0e52658650d34d721c9aaead94e295\";s:58:\"public/assets/assets/svg/busy-icons-svg/steering-wheel.svg\";s:64:\"363524229afedca47072895f78f2fb4e34283d6e05d323e98bec4699a93dee84\";s:54:\"public/assets/assets/svg/busy-icons-svg/strategy03.svg\";s:64:\"82ccf78ae3c84978440944cbbd0a6b9911b18b5ebb659745a9e092e6a61cef24\";s:53:\"public/assets/assets/svg/busy-icons-svg/strategy1.svg\";s:64:\"7326329ae56d2640845e7ffc7f01023a1b315483ea09177fe7525d43c189247e\";s:53:\"public/assets/assets/svg/busy-icons-svg/strategy2.svg\";s:64:\"1fa7692c2c42d437e0379cef665c79cc95f2edfab9b1d96d256bf48e1be0cd56\";s:58:\"public/assets/assets/svg/busy-icons-svg/support-person.svg\";s:64:\"99ca5a7deced71030dfa4d6b1cdea6f063c0b91f51b0fa8e8c7facce64dc1734\";s:58:\"public/assets/assets/svg/busy-icons-svg/tablet-article.svg\";s:64:\"7f8877e8ba47b464729a87fb2f1fc0b51da04eeb0010154fc92f616497e33da5\";s:56:\"public/assets/assets/svg/busy-icons-svg/tablet-chart.svg\";s:64:\"4bc390886fd8aea0da9dfcf026e9869fd40f27b11784ae743f566b8e1f6a1b7d\";s:57:\"public/assets/assets/svg/busy-icons-svg/tablet-chart2.svg\";s:64:\"8e836b6e5c59b2191c5d7c712e5218e5f6aa180585ec75cedd6baac536d8de44\";s:57:\"public/assets/assets/svg/busy-icons-svg/tablet-chart3.svg\";s:64:\"9b0975383962fd2d67f6a744d39a91a7a15aa7872c79965b0c840d7dc0dc7458\";s:60:\"public/assets/assets/svg/busy-icons-svg/tablet-pie-chart.svg\";s:64:\"772810bed7f4b1ca99cbb41689d2433a390a978327b0fcd6367dfe6a9cdf65d6\";s:61:\"public/assets/assets/svg/busy-icons-svg/tablet-pie-chart2.svg\";s:64:\"f94a8849e9078b9d000414d1a245d8cbf4c5d414c98ca5dfee3418d8eced6bd2\";s:50:\"public/assets/assets/svg/busy-icons-svg/tablet.svg\";s:64:\"1c861ca4f53575d5ca1498bed7d790517bc1ba88208bad641e820734dc8410f5\";s:50:\"public/assets/assets/svg/busy-icons-svg/target.svg\";s:64:\"f1dfd07fad7b1cffeb96ca740284f1a9688ce9a38ac1e580a7c11047cdcb598a\";s:48:\"public/assets/assets/svg/busy-icons-svg/team.svg\";s:64:\"6be39c6dd55d1a6765d6bf4a79e9f99acafadbed4c197817a7753b2feeacaafd\";s:53:\"public/assets/assets/svg/busy-icons-svg/telescope.svg\";s:64:\"76bbd60ebfe84d76a2c5c8f42d141103600684fedab9ef254d49581f48a3bd8b\";s:47:\"public/assets/assets/svg/busy-icons-svg/tie.svg\";s:64:\"6617dd1d3ff8f6170c975e88e3437198c93842a6404d38d3c77558da30e05dd5\";s:49:\"public/assets/assets/svg/busy-icons-svg/tools.svg\";s:64:\"5c79172cec45b7cf3e7575a17baf34d179cf8eee30ac8b868551e2b11d975901\";s:50:\"public/assets/assets/svg/busy-icons-svg/tools2.svg\";s:64:\"2804887b62e19a764ff2f874788e674b6c1d839bb239986e19cf75e0daf10d24\";s:53:\"public/assets/assets/svg/busy-icons-svg/trash-bin.svg\";s:64:\"a2b5ea1ed18e28f885d4a8c53e86ebdb40d5424bd090ef775b4c090e6adb7e50\";s:52:\"public/assets/assets/svg/busy-icons-svg/umbrella.svg\";s:64:\"090f0ce96965afe869455144c43a9a9113a3e024030b815688e8db1fa145ff48\";s:50:\"public/assets/assets/svg/busy-icons-svg/user01.svg\";s:64:\"62c21dba871eb013cbb8ba6291a5fb7eb4639a99bdefebd5ef55c849c2b96fea\";s:50:\"public/assets/assets/svg/busy-icons-svg/user02.svg\";s:64:\"d7fa7961eed76cdc402259d4da6cd46d3fc20a7382698e3c5987f74aa1d1af2a\";s:50:\"public/assets/assets/svg/busy-icons-svg/user03.svg\";s:64:\"13a315390826723c9f269458dfcd44e25e42f46e8aec90e7f820335a97995947\";s:50:\"public/assets/assets/svg/busy-icons-svg/user04.svg\";s:64:\"c7c3025901bf18dc4f1c51da55c6235f907eff4e1adb0a1d31a4bfc8604645ff\";s:50:\"public/assets/assets/svg/busy-icons-svg/user05.svg\";s:64:\"bf6067f0709a7efe8c61f6a489b49f5e69e487fa94fbfde329f716e172913fff\";s:50:\"public/assets/assets/svg/busy-icons-svg/user06.svg\";s:64:\"b8d37fee29053a2ddf9cd4ccd300c4f20ca65b5b3775e892fa2e648fefabdce3\";s:50:\"public/assets/assets/svg/busy-icons-svg/user07.svg\";s:64:\"19f99034bea0833d087bde20f7f0e63bb0efdd00050d969df7abc79022928316\";s:50:\"public/assets/assets/svg/busy-icons-svg/user08.svg\";s:64:\"d114513c3923fe8bb4cf12f29d5a665968754fc2125814b138fc1804485f22be\";s:50:\"public/assets/assets/svg/busy-icons-svg/user09.svg\";s:64:\"b8ce9bc6c29a53f12e15804683b721042aa7d4e73202c3e26a87121503624e86\";s:49:\"public/assets/assets/svg/busy-icons-svg/users.svg\";s:64:\"f56e0f7612bd86af4765b64d4310ecae8845cd0864c01d6f71e80440b8d3f8af\";s:56:\"public/assets/assets/svg/busy-icons-svg/venn-diagram.svg\";s:64:\"564dac74a353d82b3e8c51ca402f61aaf553ff4fcc086fb1ce70caef3ec09b95\";s:50:\"public/assets/assets/svg/busy-icons-svg/wallet.svg\";s:64:\"6bb34ae5c42a4233c1f817bd342e95ba2e6f025c571a1d7a676db31e1b7dcf21\";s:50:\"public/assets/assets/svg/busy-icons-svg/wrench.svg\";s:64:\"221cd9fa62623a232f7ab1d39af1cc51f21ba11050124a5738c827bbb5282f57\";s:47:\"public/assets/assets/svg/busy-icons-svg/yen.svg\";s:64:\"05717ee216465b10eec28ab4554cfc877940fcf9c8b9ce3ceb99cde7d7feac30\";s:51:\"public/assets/assets/svg/busy-icons-svg/yinyang.svg\";s:64:\"b41f7517201cf50ca526f32c3ece161ab0222f5101ae5f4d87d1896c375d40b3\";s:59:\"public/assets/assets/svg/communication/ic_business_24px.svg\";s:64:\"8e9c8f7a170c7c8e31e3f3e2012a8e9d8ba63e99617b9e2f5a6064ab52ec89c2\";s:55:\"public/assets/assets/svg/communication/ic_call_24px.svg\";s:64:\"90e91c5a06d5dd3138b6367236463d917fd7f7114d2e4b50ced8ac4d6bfc7672\";s:59:\"public/assets/assets/svg/communication/ic_call_end_24px.svg\";s:64:\"11ace18d0e7ff57fe1bbfb07094194b905bf6331ece7b8af8895ef96e95569db\";s:60:\"public/assets/assets/svg/communication/ic_call_made_24px.svg\";s:64:\"1cbab97025c30d76fad76ddca2c6ea101edb3b8257e3ffe1d234a89c6078a2a9\";s:61:\"public/assets/assets/svg/communication/ic_call_merge_24px.svg\";s:64:\"d2627e120e5048a0a0e194515378fefa6a4fb8503062df36227142eda186ebec\";s:62:\"public/assets/assets/svg/communication/ic_call_missed_24px.svg\";s:64:\"3958af915677dbf9929160d159508fba9ca77f8354ac597ea857de26d3f1cfdd\";s:71:\"public/assets/assets/svg/communication/ic_call_missed_outgoing_24px.svg\";s:64:\"d60bf801263fecb1353831c5eee084093f0ee0eb564126caf860d699fbb240bf\";s:64:\"public/assets/assets/svg/communication/ic_call_received_24px.svg\";s:64:\"0555e32aeca742372bfc4635051ca7947dad43989f16f63b525667e002c97e93\";s:61:\"public/assets/assets/svg/communication/ic_call_split_24px.svg\";s:64:\"72fddee2be7fd8a07d5b5f431f42c49b603437051caa3d7b72ac69858609a320\";s:55:\"public/assets/assets/svg/communication/ic_chat_24px.svg\";s:64:\"497d821d55b355fa77cf31cccd4333c517800cb7336d9257bdf46b4d47001b70\";s:62:\"public/assets/assets/svg/communication/ic_chat_bubble_24px.svg\";s:64:\"c5e5108c4a54079792345d2b2cd7d85bb6108af15b69ee056aab178278594d16\";s:70:\"public/assets/assets/svg/communication/ic_chat_bubble_outline_24px.svg\";s:64:\"08c08a7ce136523e76b40f1177a76b473f5a110c025e7668afbaa9314ca0a038\";s:60:\"public/assets/assets/svg/communication/ic_clear_all_24px.svg\";s:64:\"35ebb1e4cde6db93402b55d394e4090a21a1258873b8ee2ec64abb7b9e4d7698\";s:58:\"public/assets/assets/svg/communication/ic_comment_24px.svg\";s:64:\"71281f53a2ff6f7c5b7c14e7c4ec73f5be960e86d5266f189e12484c56ddc09d\";s:63:\"public/assets/assets/svg/communication/ic_contact_mail_24px.svg\";s:64:\"5630d82c6ec803237ecce82de4df1e84a1922834981b205e7f27e141231ecf9f\";s:64:\"public/assets/assets/svg/communication/ic_contact_phone_24px.svg\";s:64:\"3444048ce47a065a49c2cf78203f7535357cbd157283521c883eea0b4eb08ccd\";s:59:\"public/assets/assets/svg/communication/ic_contacts_24px.svg\";s:64:\"b8b319399019a871d9939af1414351f8fe192317c17b4ba190eb1f4f8c55ee57\";s:61:\"public/assets/assets/svg/communication/ic_dialer_sip_24px.svg\";s:64:\"5a30b114757aa99c3eb0bb20c1d22780a07840d713102f5b6c0390cbb6f9de58\";s:58:\"public/assets/assets/svg/communication/ic_dialpad_24px.svg\";s:64:\"6ce565cdbda7fb6455fc65f1865d8384084fb92abf502b0bb734022c0072c6f0\";s:56:\"public/assets/assets/svg/communication/ic_email_24px.svg\";s:64:\"36855acaeb73e1543f77500e12a3db813a0cf698a310e337306a9042dcf607ed\";s:56:\"public/assets/assets/svg/communication/ic_forum_24px.svg\";s:64:\"398cec3f2e81b31f36c273fe3610d985f103301925941df0260d09ec85092fd4\";s:66:\"public/assets/assets/svg/communication/ic_import_contacts_24px.svg\";s:64:\"305d9e3fcffd2604d59d4451579522ffac96e056401c0d394364ec364fc9175a\";s:64:\"public/assets/assets/svg/communication/ic_import_export_24px.svg\";s:64:\"fc0aabe8f8324ce4fee59499955cebbf101c54efd8e04995e0421016b0456c05\";s:68:\"public/assets/assets/svg/communication/ic_invert_colors_off_24px.svg\";s:64:\"33fc642acc55e516f22281809379b2d5eeec77547c9b5c6e2032761b32e398e0\";s:60:\"public/assets/assets/svg/communication/ic_live_help_24px.svg\";s:64:\"8caa502e5d1d86c43b8703d5d728b63ac57c3e1e5bb6827254372315e5c03ad4\";s:63:\"public/assets/assets/svg/communication/ic_location_off_24px.svg\";s:64:\"568e4e7e3fd70f39f261abfe0b0823fab530a32d63f0e0ce494ffaaf3d9a405b\";s:62:\"public/assets/assets/svg/communication/ic_location_on_24px.svg\";s:64:\"b989d3c8cfe19edd295378071c23de9c787cbc6ee66cc6a83023968837d0a88f\";s:63:\"public/assets/assets/svg/communication/ic_mail_outline_24px.svg\";s:64:\"e6bb13a283ab6f8060f55c00c4549687059070c6eeb9ade05e567fbedb96267a\";s:58:\"public/assets/assets/svg/communication/ic_message_24px.svg\";s:64:\"f1065e5ead5aeab0c17fd928b10015670071593da73659f6d9e2b142fab9c379\";s:57:\"public/assets/assets/svg/communication/ic_no_sim_24px.svg\";s:64:\"25b950b67877899a82b30ea0067a2cb40c3d55c37d006546a9c4dd41c2903b91\";s:56:\"public/assets/assets/svg/communication/ic_phone_24px.svg\";s:64:\"90e91c5a06d5dd3138b6367236463d917fd7f7114d2e4b50ced8ac4d6bfc7672\";s:66:\"public/assets/assets/svg/communication/ic_phonelink_erase_24px.svg\";s:64:\"a9ef1b4cfe564cb289efca71dfa3b9b18007c869eceeed790d130d043b3d55c7\";s:65:\"public/assets/assets/svg/communication/ic_phonelink_lock_24px.svg\";s:64:\"7bbdfa9da1819039090777f7d0296563c2ddceb007ae4abd57895e102409cad4\";s:65:\"public/assets/assets/svg/communication/ic_phonelink_ring_24px.svg\";s:64:\"2fe361a924220c2e138d8a6a89f220adaf0ce7b4fedc8c41d2c6fa11c38a7375\";s:66:\"public/assets/assets/svg/communication/ic_phonelink_setup_24px.svg\";s:64:\"088c98912def478fd332141e5c106debeffac34bd871362536cbae100256ff34\";s:68:\"public/assets/assets/svg/communication/ic_portable_wifi_off_24px.svg\";s:64:\"dbbc53a77e41355df1a39432ba581564426d62432c954f42cddcefd0689e39a2\";s:65:\"public/assets/assets/svg/communication/ic_present_to_all_24px.svg\";s:64:\"c72c408c2ae774cdb8c28049d6402bc7bb3aea74d44512f69c840811dfaf9c1c\";s:62:\"public/assets/assets/svg/communication/ic_ring_volume_24px.svg\";s:64:\"72a4ccd0cdc1be9501c77a27a436d7d45992296e02d195c8453322a02d0aa0a0\";s:63:\"public/assets/assets/svg/communication/ic_screen_share_24px.svg\";s:64:\"6258e87733e230d4e63068e249d49ae9080b812480a8f00d900925c4c19ece00\";s:64:\"public/assets/assets/svg/communication/ic_speaker_phone_24px.svg\";s:64:\"c0339d2ea91e6d2acd1d26ce0e35792b8217d82b7653fb1b3a4d80b38c47aad8\";s:73:\"public/assets/assets/svg/communication/ic_stay_current_landscape_24px.svg\";s:64:\"56ab6c7c1e8243657ca6bab8c22606c9c2914fa4b92622e9602f057fa885dc7d\";s:72:\"public/assets/assets/svg/communication/ic_stay_current_portrait_24px.svg\";s:64:\"88d265a414a3a15831054138c85d825fa6dcaa1a480af4f7b6cb7b9c2a7e3a35\";s:73:\"public/assets/assets/svg/communication/ic_stay_primary_landscape_24px.svg\";s:64:\"56ab6c7c1e8243657ca6bab8c22606c9c2914fa4b92622e9602f057fa885dc7d\";s:72:\"public/assets/assets/svg/communication/ic_stay_primary_portrait_24px.svg\";s:64:\"88d265a414a3a15831054138c85d825fa6dcaa1a480af4f7b6cb7b9c2a7e3a35\";s:68:\"public/assets/assets/svg/communication/ic_stop_screen_share_24px.svg\";s:64:\"311e33ba314d0febbe4ecea61a5a60731c8256aa902c2f91cd8c5fdf8b7f5eed\";s:61:\"public/assets/assets/svg/communication/ic_swap_calls_24px.svg\";s:64:\"4aaa62e95a6f53fd42cebe746f04c88224307f0148c6a9d4baf2bcd0b5676b7a\";s:58:\"public/assets/assets/svg/communication/ic_textsms_24px.svg\";s:64:\"df528d71ba49e60b247601e7d24dd171f3d803e978b4615e0e01a16a6ec1bcf7\";s:60:\"public/assets/assets/svg/communication/ic_voicemail_24px.svg\";s:64:\"4e95370e260b0f85bb36ae4aad1b3ee14deed1860af41532e0268550f2ad4a9a\";s:58:\"public/assets/assets/svg/communication/ic_vpn_key_24px.svg\";s:64:\"fbc7f1e13ede896120574dfe8e41fde4a42e493fccbe695a7cc4a5e892399fc8\";s:48:\"public/assets/assets/svg/content/ic_add_24px.svg\";s:64:\"4dc5547840d699651cf7d3059a91d575cddaf80451ab85a7c41ed1d7c7998b24\";s:52:\"public/assets/assets/svg/content/ic_add_box_24px.svg\";s:64:\"f62e8deb85a226dafc4e73ae8c6506451186bbf09c55acebeca15f5bbe417baf\";s:55:\"public/assets/assets/svg/content/ic_add_circle_24px.svg\";s:64:\"cfacf4398f71468c3a3b08eb0babd0ab121fbac981d017a3a5ea135472557d77\";s:63:\"public/assets/assets/svg/content/ic_add_circle_outline_24px.svg\";s:64:\"af03d496ca3677e7b741fbe9c3803c685b542dd82eba1eeccff0f7d5c8e126a9\";s:52:\"public/assets/assets/svg/content/ic_archive_24px.svg\";s:64:\"950ba84b916dd0d34d6eb040fe6a4360797d58e64a6f1885a1da840c0f90c330\";s:54:\"public/assets/assets/svg/content/ic_backspace_24px.svg\";s:64:\"1ec236e72ee705bf70eb29a2613499a1da4aa413d987673115e55874d8869a0c\";s:50:\"public/assets/assets/svg/content/ic_block_24px.svg\";s:64:\"47abe59201834a5ff2d5ac562c891a346ab3ff2952555844940f343587fcd57b\";s:50:\"public/assets/assets/svg/content/ic_clear_24px.svg\";s:64:\"6d4ccf520d400755057a1739a66c0feda3c98bbc34e8e7f79afa630b2e43f87e\";s:57:\"public/assets/assets/svg/content/ic_content_copy_24px.svg\";s:64:\"fa4ad2661739c9ecefa121c41f5c95de878d4990ee86413124585a3af7d7dffb\";s:56:\"public/assets/assets/svg/content/ic_content_cut_24px.svg\";s:64:\"df484339f6dc6092c32d1434b407673818fbffcc6a9400936af897be07989cfa\";s:58:\"public/assets/assets/svg/content/ic_content_paste_24px.svg\";s:64:\"6ee126c4f729d61c571d0514a52628c74046f6fcc405fb929e0eadc3673b0a5f\";s:51:\"public/assets/assets/svg/content/ic_create_24px.svg\";s:64:\"e421babfbbe69cd7e72fca2b85774b26ec4c9557384b9a3bbfb3d3cef031b4a0\";s:51:\"public/assets/assets/svg/content/ic_drafts_24px.svg\";s:64:\"53b24844172c2992f84c453929a90cde6595a103e4a0c32d8ea05b6fbeca86e9\";s:56:\"public/assets/assets/svg/content/ic_filter_list_24px.svg\";s:64:\"62517f12ccdaef9d5ffe156d7acff9b9a845c8f48e00eacfe6a9b3d8f8299265\";s:49:\"public/assets/assets/svg/content/ic_flag_24px.svg\";s:64:\"cbb30ec622923b6e0442d67277e30eaa1ba429223b132fde3289d125f2c62c88\";s:58:\"public/assets/assets/svg/content/ic_font_download_24px.svg\";s:64:\"94e8a2cd9b85df173be7f3a8212f5d144592e119a8257f724454b02ded4586a6\";s:52:\"public/assets/assets/svg/content/ic_forward_24px.svg\";s:64:\"463ebcb207246b8f41745085176d0bf277bd253351b3bd8f50e176f1334f928a\";s:52:\"public/assets/assets/svg/content/ic_gesture_24px.svg\";s:64:\"7b5dce0c1c0ad0562037b69bd70dea6942e82ca0bd9e9e4b5ed644d6b2766946\";s:50:\"public/assets/assets/svg/content/ic_inbox_24px.svg\";s:64:\"5b6064c5f8b2a04da2414b5d56e9a07f0f327b12b90918363bab94483c654bc6\";s:49:\"public/assets/assets/svg/content/ic_link_24px.svg\";s:64:\"76f4817ff3dc15862585d0f79b491f64c87d836b4c9216cb1be783e2ba714f06\";s:49:\"public/assets/assets/svg/content/ic_mail_24px.svg\";s:64:\"36855acaeb73e1543f77500e12a3db813a0cf698a310e337306a9042dcf607ed\";s:55:\"public/assets/assets/svg/content/ic_markunread_24px.svg\";s:64:\"36855acaeb73e1543f77500e12a3db813a0cf698a310e337306a9042dcf607ed\";s:58:\"public/assets/assets/svg/content/ic_move_to_inbox_24px.svg\";s:64:\"73868a7847e8126a3048015e32069324eb7097ae25b4eeeda6051366990e6846\";s:54:\"public/assets/assets/svg/content/ic_next_week_24px.svg\";s:64:\"80e242a0806debd1939746808921205e5208be7c67278f98fa3ea7a479a11540\";s:49:\"public/assets/assets/svg/content/ic_redo_24px.svg\";s:64:\"07548d839167082f7cf924130cbd4785816679872b4ad7fcbe216dd2107f10eb\";s:51:\"public/assets/assets/svg/content/ic_remove_24px.svg\";s:64:\"d7b1b4b4e65bc4d62714b3bc9d5183978389e64995ebca75ea6d4773ff6e17ce\";s:58:\"public/assets/assets/svg/content/ic_remove_circle_24px.svg\";s:64:\"8cdf4cce2be9bd306a573d48305391e2824d4fec2d8ab84795ba86e2f7be70e8\";s:66:\"public/assets/assets/svg/content/ic_remove_circle_outline_24px.svg\";s:64:\"6f7c0be01433d939fc6364cf1903ba390f11b5e7cdebb9a03f84b585ae4ec5a1\";s:50:\"public/assets/assets/svg/content/ic_reply_24px.svg\";s:64:\"bdae829ba44f83def0e28955b3290e9bcb99ad14886de70c21113f865a0566fd\";s:54:\"public/assets/assets/svg/content/ic_reply_all_24px.svg\";s:64:\"76795b312b3e927150b209bbdc67a93627ea906c5b6faf7a87d87d6aef24eff2\";s:51:\"public/assets/assets/svg/content/ic_report_24px.svg\";s:64:\"53a051dd6b0b1ac7eda3d88a95484d5b3122f2faa62a978c3c8313a054e0bf10\";s:49:\"public/assets/assets/svg/content/ic_save_24px.svg\";s:64:\"47bb956e475240ebad8d42df4e355340ef8c16aafddcebfa57f1d2890deac775\";s:55:\"public/assets/assets/svg/content/ic_select_all_24px.svg\";s:64:\"027c27edc3f9aeeea50e523dbe66a003ba716053d473c6eea2552c9773acaa2c\";s:49:\"public/assets/assets/svg/content/ic_send_24px.svg\";s:64:\"04566e9523723adf734dbc9dc3547b4adb71cbca596d5595535c951d4fae2b79\";s:49:\"public/assets/assets/svg/content/ic_sort_24px.svg\";s:64:\"c4434ace1d68a1c914f5f20cbcadb26e90066f6ae2b810677478399a6fa0ab1a\";s:56:\"public/assets/assets/svg/content/ic_text_format_24px.svg\";s:64:\"eca0608ef6db59934ecbd41ecbb5fbf6b3f5307d42ea625a7f027edd50ba49ae\";s:54:\"public/assets/assets/svg/content/ic_unarchive_24px.svg\";s:64:\"3294e48df5efcd880819794eaefdeb5ef567a4f5b6069b7d755faf7d9bb719d1\";s:49:\"public/assets/assets/svg/content/ic_undo_24px.svg\";s:64:\"b7356672bcd0d369d104c11020eee2d798bd416bf903e37ab10144079583df57\";s:52:\"public/assets/assets/svg/content/ic_weekend_24px.svg\";s:64:\"4067f2b7e603d744cb3829c4484f4d6f526cb2ccaf3d5c7873fa8b7372b83389\";s:56:\"public/assets/assets/svg/device/ic_access_alarm_24px.svg\";s:64:\"f5bb2755fe1c016cea33c93d636299a87e6f944591a13ee9528916a119ad6251\";s:57:\"public/assets/assets/svg/device/ic_access_alarms_24px.svg\";s:64:\"fd9ff1e1b11f0f537a664ab0e6d14c911ca48e184ae9b3073a99f33fa019aa23\";s:55:\"public/assets/assets/svg/device/ic_access_time_24px.svg\";s:64:\"c62263947febeef13f89926ef5a05b0eda6aeec920681de2af86ef07a1180bb3\";s:53:\"public/assets/assets/svg/device/ic_add_alarm_24px.svg\";s:64:\"2506b8f9a82a215ed55397fc4bc604e7b801c3b2ba6eccaeee4645e258e8855b\";s:63:\"public/assets/assets/svg/device/ic_airplanemode_active_24px.svg\";s:64:\"e36f1d063cc9ae3c0acd5b63cd747185b1ccbb0a4c9b571a235fe654b1a213b1\";s:65:\"public/assets/assets/svg/device/ic_airplanemode_inactive_24px.svg\";s:64:\"2991bf185c43de233a9649f1433bd53e52ef5ff8a737ad91e4548bbd03daffae\";s:54:\"public/assets/assets/svg/device/ic_battery_20_24px.svg\";s:64:\"daf99ac73179b17a96c65a7bcfc981419f21ca94c80cf23945afc7c66aa21ffd\";s:54:\"public/assets/assets/svg/device/ic_battery_30_24px.svg\";s:64:\"234c3c1d1442abdeecf225610d1a7e6ed53c69f017d1cd80571b273f0a56ffff\";s:54:\"public/assets/assets/svg/device/ic_battery_50_24px.svg\";s:64:\"915ebc9b80b4ba44814d95d061c825a7e6a9480771f074c0dfec019b0eb87de6\";s:54:\"public/assets/assets/svg/device/ic_battery_60_24px.svg\";s:64:\"f4cdca80372775f54244efb3d808a1df2d1b750aa84625b873e55843cb19ffe9\";s:54:\"public/assets/assets/svg/device/ic_battery_80_24px.svg\";s:64:\"d037ca180916cdefd0e20b2009cc48ae7c6a80f8cb768ab70e83f5e3ffd213cd\";s:54:\"public/assets/assets/svg/device/ic_battery_90_24px.svg\";s:64:\"d05dcc86a728bea59be9b88260ce634faa97af7cd118954a84cc0c7f3e857b20\";s:57:\"public/assets/assets/svg/device/ic_battery_alert_24px.svg\";s:64:\"aafdb7c23ddfe5048dcc3aadb9dffac00cffce51d2e51b90d716c2bbdcf8cde7\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_20_24px.svg\";s:64:\"b9e4cfd1e3e628b66347ecd23de88175e5996eabc6c3969a3dc74fe5d1b20a23\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_30_24px.svg\";s:64:\"1416623d138ecbd5702f1a288273220bbd53898754423d35777bf6cba4e47c70\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_50_24px.svg\";s:64:\"d3734d1839ba5a8aeed21d1671c314f4438daa31ff982f7d2867ee058029379e\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_60_24px.svg\";s:64:\"6d7222e70cc42c1fc482ea485f8971aa38d374e68d1797ac6339dd7b3fe1cdde\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_80_24px.svg\";s:64:\"1cf1abbfe3e0fdf77b83cf0b5e672ad67ddd22257583e39259e3059c06f97634\";s:63:\"public/assets/assets/svg/device/ic_battery_charging_90_24px.svg\";s:64:\"f2669b04c3bfcc69ab9423ef652edefd8d168d446612c88703b406e6c22976de\";s:65:\"public/assets/assets/svg/device/ic_battery_charging_full_24px.svg\";s:64:\"99a7c5c052878add509e48f9b79c6a13b3c83d401a421af770b505a3a78deb32\";s:56:\"public/assets/assets/svg/device/ic_battery_full_24px.svg\";s:64:\"de631b4f54ba7b2e10092bf54be5f85c1542e1ba4ed8ea16a6f64d3f24a2a467\";s:55:\"public/assets/assets/svg/device/ic_battery_std_24px.svg\";s:64:\"de631b4f54ba7b2e10092bf54be5f85c1542e1ba4ed8ea16a6f64d3f24a2a467\";s:59:\"public/assets/assets/svg/device/ic_battery_unknown_24px.svg\";s:64:\"5d76d11e0a35c4ad0e92ab7d8c30c8d45ee9eff4f52560f755507f8657bd6d70\";s:53:\"public/assets/assets/svg/device/ic_bluetooth_24px.svg\";s:64:\"d2fb69008a07f1aab59b32e2c46ff833af9c3590364040137c35318e1fa6b640\";s:63:\"public/assets/assets/svg/device/ic_bluetooth_connected_24px.svg\";s:64:\"af8eb9315f3fb87ca86624c391a1eed597d0f7b4aebab1cf629b80bdd30d6cd5\";s:62:\"public/assets/assets/svg/device/ic_bluetooth_disabled_24px.svg\";s:64:\"37c16976af009d9a52f64d9c017875a7e7d82eff9f5cba7bb07d0c4c4155e600\";s:63:\"public/assets/assets/svg/device/ic_bluetooth_searching_24px.svg\";s:64:\"e6cc41bdf18f24f7f9dd00899ebc5e91e10268b2ec4c5426e84fc6b99539c27a\";s:59:\"public/assets/assets/svg/device/ic_brightness_auto_24px.svg\";s:64:\"4a74c4d2e8df52092b29017480ad9fc0f289228d473abc5e32c1e3e3bf410f7f\";s:59:\"public/assets/assets/svg/device/ic_brightness_high_24px.svg\";s:64:\"e9d4d6f8f068e875bb94666332c9e2d273a806028c5df9f64065d062917a6aad\";s:58:\"public/assets/assets/svg/device/ic_brightness_low_24px.svg\";s:64:\"d0655c2f58d3fd47c4f5bda9efcd64845e695c357221dbe97a82343585f01bc9\";s:61:\"public/assets/assets/svg/device/ic_brightness_medium_24px.svg\";s:64:\"7b248a3f7cd27cd31575fa060235a702e2daaf51490a173413e5a4ea90f9df68\";s:54:\"public/assets/assets/svg/device/ic_data_usage_24px.svg\";s:64:\"d90d02cae59b4f30ff2880a4b616ab36e2d1c6791862955ec1fac51865a32d86\";s:58:\"public/assets/assets/svg/device/ic_developer_mode_24px.svg\";s:64:\"15f55ab75c38b7bc6e52885534b4fe6d0be2b5a2aa649bcc46cc97e93416403a\";s:51:\"public/assets/assets/svg/device/ic_devices_24px.svg\";s:64:\"ff603e07968311f66ff514e30cf6f17f5d17d0e80e2b82a1beac4ed28336b30c\";s:47:\"public/assets/assets/svg/device/ic_dvr_24px.svg\";s:64:\"a938e785839b0eecf6c9c519562e2812eccb1bc7f325d62330322c58ef7d01b4\";s:53:\"public/assets/assets/svg/device/ic_gps_fixed_24px.svg\";s:64:\"5067b58e47e1b295b815c4218624d821702892d97e8ad8d6bb75837979a4237e\";s:57:\"public/assets/assets/svg/device/ic_gps_not_fixed_24px.svg\";s:64:\"03b363aa228d4235b9aae00bb270a620ad1f43e2019224ca9270f97f74c97492\";s:51:\"public/assets/assets/svg/device/ic_gps_off_24px.svg\";s:64:\"52ab21c191b6cd60dfd6698f5248b72a5b120cfac80baac792b01f8d686967bb\";s:54:\"public/assets/assets/svg/device/ic_graphic_eq_24px.svg\";s:64:\"10d4f5757f39772fb1dc38507d833fd8db237fee3f1b295832c9d526292009b1\";s:61:\"public/assets/assets/svg/device/ic_location_disabled_24px.svg\";s:64:\"52ab21c191b6cd60dfd6698f5248b72a5b120cfac80baac792b01f8d686967bb\";s:62:\"public/assets/assets/svg/device/ic_location_searching_24px.svg\";s:64:\"03b363aa228d4235b9aae00bb270a620ad1f43e2019224ca9270f97f74c97492\";s:56:\"public/assets/assets/svg/device/ic_network_cell_24px.svg\";s:64:\"077cb5b7683002d0e56dce6537b12977bc3cc8a2862ea21d63bfe55365222f8b\";s:56:\"public/assets/assets/svg/device/ic_network_wifi_24px.svg\";s:64:\"5a3cc3c902b719d6c073c915636c014ae523af9a14fab5e808242593b91fc8b4\";s:47:\"public/assets/assets/svg/device/ic_nfc_24px.svg\";s:64:\"b7eec9a0dcf1822b52ef3640947f416a5780bd463f935089819c4d207c8a1e97\";s:65:\"public/assets/assets/svg/device/ic_screen_lock_landscape_24px.svg\";s:64:\"4a14ebebd9394770f8fd5874da85b18918ac21e229a85d6f55241a9ec7ee2b65\";s:64:\"public/assets/assets/svg/device/ic_screen_lock_portrait_24px.svg\";s:64:\"d46c6719e5d28d3c4a1cb0ba31b0e34ae1214f000bc55ced4f09c156e133e5e1\";s:64:\"public/assets/assets/svg/device/ic_screen_lock_rotation_24px.svg\";s:64:\"572bd34740f075fba2f6a737989ac3727da2038fcb640d3fde397e31e8c2e502\";s:59:\"public/assets/assets/svg/device/ic_screen_rotation_24px.svg\";s:64:\"512ae6aacd7d207730b831cb89892261fcec4816c38c0b6666f86b481b1607ea\";s:54:\"public/assets/assets/svg/device/ic_sd_storage_24px.svg\";s:64:\"9f4cd0b97e1106e9016f54bcc3d02159cd0bf275110575f4d4497fdbbd2936e4\";s:68:\"public/assets/assets/svg/device/ic_settings_system_daydream_24px.svg\";s:64:\"ce4f575730373392aee5f3c82d666607bb49cebcb36f1874b30271366fc06682\";s:65:\"public/assets/assets/svg/device/ic_signal_cellular_0_bar_24px.svg\";s:64:\"e67fb56b0a397005cd49ed351daca53f41d8a4bf8ec26a7bbde963ef4dd50bab\";s:65:\"public/assets/assets/svg/device/ic_signal_cellular_1_bar_24px.svg\";s:64:\"99447279b189a3faca75569c8ecdeb9885f10fcab5c52d103481e8b01759523c\";s:65:\"public/assets/assets/svg/device/ic_signal_cellular_2_bar_24px.svg\";s:64:\"b156564909cedc28daf23bfe74c7b3cd1e077884ede04b6bbb25f273acb8be06\";s:65:\"public/assets/assets/svg/device/ic_signal_cellular_3_bar_24px.svg\";s:64:\"077cb5b7683002d0e56dce6537b12977bc3cc8a2862ea21d63bfe55365222f8b\";s:65:\"public/assets/assets/svg/device/ic_signal_cellular_4_bar_24px.svg\";s:64:\"0291f45ac5714b42bf7976b0dbaaf5bfd1d84491796aee98569589aa99487c6d\";s:87:\"public/assets/assets/svg/device/ic_signal_cellular_connected_no_internet_0_bar_24px.svg\";s:64:\"33dc55fc2009777c96594fa074932c1c405d1f353bd3a94b0fead27b477cbabd\";s:87:\"public/assets/assets/svg/device/ic_signal_cellular_connected_no_internet_1_bar_24px.svg\";s:64:\"8387d776d369fbda0a0c4d7bacd8635cea6e083e734b84c88ac5223639ad4d4e\";s:87:\"public/assets/assets/svg/device/ic_signal_cellular_connected_no_internet_2_bar_24px.svg\";s:64:\"71267f270aa60d93bbcc5cd4197e0e47cfc81a15786506659351cc6f1e5933d0\";s:87:\"public/assets/assets/svg/device/ic_signal_cellular_connected_no_internet_3_bar_24px.svg\";s:64:\"c00351c9a798a2bf26ead9c437ff7b978ff37c0baeecb03c9703fdb1ccf2f03b\";s:87:\"public/assets/assets/svg/device/ic_signal_cellular_connected_no_internet_4_bar_24px.svg\";s:64:\"a454753182fe9562eb204d551e8616282d31eafe533c90b8f96a48b9d52378ef\";s:66:\"public/assets/assets/svg/device/ic_signal_cellular_no_sim_24px.svg\";s:64:\"25b950b67877899a82b30ea0067a2cb40c3d55c37d006546a9c4dd41c2903b91\";s:64:\"public/assets/assets/svg/device/ic_signal_cellular_null_24px.svg\";s:64:\"b41897c015a953d131095043888be31db9771f25bd46c17e128532a3a10ee738\";s:63:\"public/assets/assets/svg/device/ic_signal_cellular_off_24px.svg\";s:64:\"ad46750af925c186285e3be095c758859f75924fd002aa1ea5cd0647f94f0663\";s:61:\"public/assets/assets/svg/device/ic_signal_wifi_0_bar_24px.svg\";s:64:\"cd4f2b992d85a64554c8b65c968aedb7c52f527ce59d7160f35685ff6f2322eb\";s:61:\"public/assets/assets/svg/device/ic_signal_wifi_1_bar_24px.svg\";s:64:\"a78aa5c5ad303d576b823915c0f3f86eda0cc65bf3c5207e218c240be343d53a\";s:66:\"public/assets/assets/svg/device/ic_signal_wifi_1_bar_lock_24px.svg\";s:64:\"41d06cee38ad6b535805aaec49695a29bd2be975a42dc8f5c892df068ed16064\";s:61:\"public/assets/assets/svg/device/ic_signal_wifi_2_bar_24px.svg\";s:64:\"623415f6ae50c833ac252612964d6705ded76185afaae14d66c6b4f1a261ad25\";s:66:\"public/assets/assets/svg/device/ic_signal_wifi_2_bar_lock_24px.svg\";s:64:\"a06f2095185d6323c17aee514552c14e8b8c7f988d60cc60393b84af06f50a21\";s:61:\"public/assets/assets/svg/device/ic_signal_wifi_3_bar_24px.svg\";s:64:\"5a3cc3c902b719d6c073c915636c014ae523af9a14fab5e808242593b91fc8b4\";s:66:\"public/assets/assets/svg/device/ic_signal_wifi_3_bar_lock_24px.svg\";s:64:\"692d87266675fc2bd7416de2200dd1d00c137301bfc90d8d5cf4b41694e95e9f\";s:61:\"public/assets/assets/svg/device/ic_signal_wifi_4_bar_24px.svg\";s:64:\"ddd369fafe50145f909624a9bbf7ac0c26206f12aca1c7a772a1708a69de99d0\";s:66:\"public/assets/assets/svg/device/ic_signal_wifi_4_bar_lock_24px.svg\";s:64:\"f1440c41e67cf7065b551d26d934227e4a4875e7c9f8f23416e5e876f034e5f5\";s:59:\"public/assets/assets/svg/device/ic_signal_wifi_off_24px.svg\";s:64:\"be0debc91dddaeb8dc14538a91835a906e3a05ce21bced5a309c9e850cee90c7\";s:74:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_1_bar_26x24px.svg\";s:64:\"58040d0c6fb01eba1cd76da0e5919fe27dced262d57a5067647e2c51af4f698e\";s:74:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_2_bar_26x24px.svg\";s:64:\"0e6dc02f60457c6f3696d94ceeec85a7d6f701a98149586a1247fed90a995b45\";s:74:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_3_bar_26x24px.svg\";s:64:\"5214ed6e490b62b4c501d5982aeb78b1afe10c3b6e1381e68253a97215ddb6e5\";s:74:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_4_bar_26x24px.svg\";s:64:\"c447fa69eb8ed961f085d3ed79cb912d7e2a13e933f5fc1e91f3f7367fbd98b3\";s:92:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_connected_no_internet_1_26x24px.svg\";s:64:\"18f945222bf23b7652c46a37595039c2863e8870497856e0dc08b5f819f8baaa\";s:90:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_connected_no_internet_26x24px.svg\";s:64:\"05fbaf001fdf008110fc4a19e45213af839f49dac4589b7968a847599750ea3e\";s:92:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_connected_no_internet_2_26x24px.svg\";s:64:\"88cef206c20102d30d016a30eaa7ad9bd1a2b8bab5db85cf25a008ef5c67e503\";s:92:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_connected_no_internet_3_26x24px.svg\";s:64:\"4829132f98bf4e5eb2c0d2b06da2aee42c3139b75050a4a1c550f05510e11783\";s:92:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_connected_no_internet_4_26x24px.svg\";s:64:\"0897b454494ca8e31457cf0f4318f0f5964877fb5ec09b5d233849d179b4b896\";s:82:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_not_connected_26x24px.svg\";s:64:\"882282c4d2ed48752474f640057602c5341fc32c36af52f2b370365ff9572e01\";s:73:\"public/assets/assets/svg/device/ic_signal_wifi_statusbar_null_26x24px.svg\";s:64:\"6745d4ec5917307dc2c5fd830d0728de8edc984bd1a83c8722ba0bb6533c67dd\";s:51:\"public/assets/assets/svg/device/ic_storage_24px.svg\";s:64:\"be32e6b9b8336d50c8115b9307280632b12006a92c7ee01e94ea9da60d6eb557\";s:47:\"public/assets/assets/svg/device/ic_usb_24px.svg\";s:64:\"8ffa7d6ac212b14fc3f4c3472ecd9261a298d14556366e97ecf9038b0413bba3\";s:53:\"public/assets/assets/svg/device/ic_wallpaper_24px.svg\";s:64:\"fe1b2934ba8e893fd8c616735b656039df8f17f9d94ff881d2fbe46169ba44d8\";s:51:\"public/assets/assets/svg/device/ic_widgets_24px.svg\";s:64:\"d097d13f77328fd8bede89c1badd498d9c7d46a1d025b251513ebd08164aa115\";s:53:\"public/assets/assets/svg/device/ic_wifi_lock_24px.svg\";s:64:\"257a347b1789eaa2878c50c39fd482b7c68c88f9120b83a8b838c8299a2c6a24\";s:58:\"public/assets/assets/svg/device/ic_wifi_tethering_24px.svg\";s:64:\"db7441d890d7fa2ed7ad3c01f1a5cbc55de01396bb6ce583ddf778903c8d1859\";s:55:\"public/assets/assets/svg/editor/ic_attach_file_24px.svg\";s:64:\"5dd22e10298cd409ffe4eba9dbf4560baf11887efc8fc69eb321cdf7bda0b3a6\";s:56:\"public/assets/assets/svg/editor/ic_attach_money_24px.svg\";s:64:\"de89a4828ec1f5681b5b3848819622cd65f685ae715d44555f34ab78f867657e\";s:54:\"public/assets/assets/svg/editor/ic_border_all_24px.svg\";s:64:\"ef682b811a6e8b455a1b2384d802c771318963abe093f6cf0483e352695bfa3f\";s:57:\"public/assets/assets/svg/editor/ic_border_bottom_24px.svg\";s:64:\"843afbed342821ba6ebfea33f574ce766d24ba1456997705cf3af91764c969f4\";s:56:\"public/assets/assets/svg/editor/ic_border_clear_24px.svg\";s:64:\"eab33d8cd525a4ea1f3a4e795d71a5a9e20628dd3a541f0cdafb7a990321fec9\";s:56:\"public/assets/assets/svg/editor/ic_border_color_24px.svg\";s:64:\"2e0722c7f2f7726f17f0ac5f54e9c757a0ddd27144ad7a87737df2de6ca2605e\";s:61:\"public/assets/assets/svg/editor/ic_border_horizontal_24px.svg\";s:64:\"60d07b8b69c2685f56a494bef06b7975a6261ce9c0fe2854741d786f60a47fcc\";s:56:\"public/assets/assets/svg/editor/ic_border_inner_24px.svg\";s:64:\"5b1d10c1a3abf2ec5b658f0d39116afbf50236b2c5a653cc0d67df75ad419e52\";s:55:\"public/assets/assets/svg/editor/ic_border_left_24px.svg\";s:64:\"54a452b24c824f9de4d3254448d2537b9256665a527abd69ee679bb3d61eba39\";s:56:\"public/assets/assets/svg/editor/ic_border_outer_24px.svg\";s:64:\"0adcc8c05753808a294828498f7899592bff7d117ee3d4dcaad434ac4e988cb9\";s:56:\"public/assets/assets/svg/editor/ic_border_right_24px.svg\";s:64:\"42ed10ad64ee6ad2f8ed224da6a2920f4053e8cbc9f1b974d04490a2a2ab7205\";s:56:\"public/assets/assets/svg/editor/ic_border_style_24px.svg\";s:64:\"e805faf4325564917774b1e8533c97a3812ef83490ce1fd25c9c0292ee340b82\";s:54:\"public/assets/assets/svg/editor/ic_border_top_24px.svg\";s:64:\"f172d58e3bc661d19ecd580613c13f723c763a0403be1f560bbdf610d73bdbff\";s:59:\"public/assets/assets/svg/editor/ic_border_vertical_24px.svg\";s:64:\"22c5c49a62ce7d9572aef3b0c92dfe8f437133d47242d70edbef7030ec9cafe0\";s:55:\"public/assets/assets/svg/editor/ic_drag_handle_24px.svg\";s:64:\"69d0d02cd6383dc13497c54ca3f78ca567c9d1950d073a212baba0a854a95d38\";s:63:\"public/assets/assets/svg/editor/ic_format_align_center_24px.svg\";s:64:\"d59c5220251fb7d5aa03bdfc7a8254d69dcd979ffbdce01a385ae47db225f1ed\";s:64:\"public/assets/assets/svg/editor/ic_format_align_justify_24px.svg\";s:64:\"ec14e8b0a63668976fb3422ef94220b8e95fdbdf963a9825964e65b5863b548e\";s:61:\"public/assets/assets/svg/editor/ic_format_align_left_24px.svg\";s:64:\"77878ab7bfed61963f388534c9f6906fc8fb7f03bdf9b033b0746d31e9987bf3\";s:62:\"public/assets/assets/svg/editor/ic_format_align_right_24px.svg\";s:64:\"13da283fdfae632966dbfbcaf23c2b649985205f65218dff53a0e17421d00368\";s:55:\"public/assets/assets/svg/editor/ic_format_bold_24px.svg\";s:64:\"ecb8716f2d78ca80edf5e48db912eef1287e0c8dd347c048c6274adcfc01c82c\";s:56:\"public/assets/assets/svg/editor/ic_format_clear_24px.svg\";s:64:\"e74f2a2d9a9ef941ae2c4a3b96438d5a4918daa987381023e07c3b000389ce6f\";s:61:\"public/assets/assets/svg/editor/ic_format_color_fill_24px.svg\";s:64:\"265a49a477901f4f73260226502df82326ffe3639c7fad51006683e673e406c2\";s:62:\"public/assets/assets/svg/editor/ic_format_color_reset_24px.svg\";s:64:\"f28dcc134a2b58e750f732f296460adc3c9be4cbc28f54b5ab47929231deecf7\";s:61:\"public/assets/assets/svg/editor/ic_format_color_text_24px.svg\";s:64:\"ed08115552a3a3d9fe5c44a5c72b5a129540bbaed0370c09b26f2e9a9ba7ac8c\";s:66:\"public/assets/assets/svg/editor/ic_format_indent_decrease_24px.svg\";s:64:\"dbc3919f71ff58b94a12155a424c8f295d3588791adaa06c0df956be5f9fa387\";s:66:\"public/assets/assets/svg/editor/ic_format_indent_increase_24px.svg\";s:64:\"e9c798a37a623e63951df9439b549a5a2d8439978f23e6e8da845797f1260e71\";s:57:\"public/assets/assets/svg/editor/ic_format_italic_24px.svg\";s:64:\"7bbce87338ed5ce0e35d1fefa0d41f62d5dfc6a31c8bc052e91f6ae7535abdb7\";s:63:\"public/assets/assets/svg/editor/ic_format_line_spacing_24px.svg\";s:64:\"d8f5b3011ea69eb863b7a32baa15127f456dea5856d6dd99899231c0e4710f52\";s:64:\"public/assets/assets/svg/editor/ic_format_list_bulleted_24px.svg\";s:64:\"e5120c96d4453f1521ffdb5c1b91832e297772dd1d9a40df2179853385888838\";s:64:\"public/assets/assets/svg/editor/ic_format_list_numbered_24px.svg\";s:64:\"3d2be5e9c4bf3fef59127d1c25e2e9f0d6441b608a610dd758791b74e6c38827\";s:56:\"public/assets/assets/svg/editor/ic_format_paint_24px.svg\";s:64:\"1e590f35a93b6fffc1e37884348075fedbdbb405ed0808d960d93d80eb25b854\";s:56:\"public/assets/assets/svg/editor/ic_format_quote_24px.svg\";s:64:\"b7ecd58048a6378a0ad3cb10bd37b84ac045e14336fb673c8a6e6f3655202437\";s:57:\"public/assets/assets/svg/editor/ic_format_shapes_24px.svg\";s:64:\"3345dbe2a4c9b12a1862e524ceb73e46d8fc06bec391db0676744217dc06e27a\";s:55:\"public/assets/assets/svg/editor/ic_format_size_24px.svg\";s:64:\"5fc2e44dc59b9a964fa3201b122c531f78d3a2875c19b72ef45086100cfeb071\";s:64:\"public/assets/assets/svg/editor/ic_format_strikethrough_24px.svg\";s:64:\"8d3943232b8ce2573106815af7abcc6934889974f9234a4e80a544afdf720ad0\";s:71:\"public/assets/assets/svg/editor/ic_format_textdirection_l_to_r_24px.svg\";s:64:\"e0925dbbe330a45628b66ba8005551de9f8831c8f628603e33de7dd5183120a5\";s:71:\"public/assets/assets/svg/editor/ic_format_textdirection_r_to_l_24px.svg\";s:64:\"0f97ab819d5504686e568eb9f6ce8b585ac9414a1d77246d76594200306ab00c\";s:61:\"public/assets/assets/svg/editor/ic_format_underlined_24px.svg\";s:64:\"2315327d177add381674d6c1312c755dbf0ba0232dc4c6d937591a9ebd57c8db\";s:53:\"public/assets/assets/svg/editor/ic_functions_24px.svg\";s:64:\"b43968e1ea308c32450ae47a20d61cc55d67335522a20be3d94270d0fe99209c\";s:53:\"public/assets/assets/svg/editor/ic_highlight_24px.svg\";s:64:\"ef312829b06795b06ec13526493508e2d589947495c762dbc512722f729b499b\";s:56:\"public/assets/assets/svg/editor/ic_insert_chart_24px.svg\";s:64:\"251b8d550df4665af92dd66a774ae43f0f002826a4b091b86c1310a28e9e8c87\";s:58:\"public/assets/assets/svg/editor/ic_insert_comment_24px.svg\";s:64:\"a2c7ceefc2216d2d9bd85d95944c655b5ac5400098234e85db4ba69cfb15c4f5\";s:61:\"public/assets/assets/svg/editor/ic_insert_drive_file_24px.svg\";s:64:\"b7a56b2ace1051167ee454a2f49e0db294c822fd370e79c3c7c00e3754058096\";s:59:\"public/assets/assets/svg/editor/ic_insert_emoticon_24px.svg\";s:64:\"975c5664d2b367f8a033b4eba9f34c6aafbad9b0b4cd25d5e5a1b122758a848a\";s:61:\"public/assets/assets/svg/editor/ic_insert_invitation_24px.svg\";s:64:\"b5d8a4f1247c3fc9e280c69763e3635b4331790f3b31d55ce02e4d2000c5f352\";s:55:\"public/assets/assets/svg/editor/ic_insert_link_24px.svg\";s:64:\"76f4817ff3dc15862585d0f79b491f64c87d836b4c9216cb1be783e2ba714f06\";s:56:\"public/assets/assets/svg/editor/ic_insert_photo_24px.svg\";s:64:\"671a02cb3a7a9c0553a56710d9abfa5bfaff8db9d22937a3b23c8be30f8ea7aa\";s:56:\"public/assets/assets/svg/editor/ic_linear_scale_24px.svg\";s:64:\"44f5f1c0e236df15d1557827871adca586398dd7456076652a0f913ddf4d3271\";s:54:\"public/assets/assets/svg/editor/ic_merge_type_24px.svg\";s:64:\"d2627e120e5048a0a0e194515378fefa6a4fb8503062df36227142eda186ebec\";s:56:\"public/assets/assets/svg/editor/ic_mode_comment_24px.svg\";s:64:\"c99a70527278d8cb07dcf6ebdb708bd36b7179184843d3cd6b2fbe2fa7d692c1\";s:53:\"public/assets/assets/svg/editor/ic_mode_edit_24px.svg\";s:64:\"e421babfbbe69cd7e72fca2b85774b26ec4c9557384b9a3bbfb3d3cef031b4a0\";s:53:\"public/assets/assets/svg/editor/ic_money_off_24px.svg\";s:64:\"80b1b9b2b9b12d23a61766d39bb0fdec7a547881e59f95643f819a136405cc73\";s:51:\"public/assets/assets/svg/editor/ic_publish_24px.svg\";s:64:\"7166d815729e58e5876f54da2fb7952ffbcd0416dbccaf65f708888220b81a08\";s:54:\"public/assets/assets/svg/editor/ic_short_text_24px.svg\";s:64:\"d411e4a4bd47c7b96041145ddc98abd6dbf6ce629cc451c733b3edb1cc785bd5\";s:53:\"public/assets/assets/svg/editor/ic_space_bar_24px.svg\";s:64:\"f7badb30f43620115598a703a8118e551639c82413abb6768594808ccd917283\";s:59:\"public/assets/assets/svg/editor/ic_strikethrough_s_24px.svg\";s:64:\"4e0faf0dbe503ef35e0a1d3c8aaa939ac52ab33f91a308464b811e2a96e85b82\";s:55:\"public/assets/assets/svg/editor/ic_text_fields_24px.svg\";s:64:\"79edc59515c2e37a818dd4a9147c696652b94df58ebafaf3bcc40908f75859da\";s:65:\"public/assets/assets/svg/editor/ic_vertical_align_bottom_24px.svg\";s:64:\"b1ae4b8b386753b5db3c6eb2c35eeb3bc09d2d0b159bb638fe0aae7652e0015e\";s:65:\"public/assets/assets/svg/editor/ic_vertical_align_center_24px.svg\";s:64:\"e139389be201e4d7198ee3a1a00e1b416942e3e3f39d89ed5886d315bde6cc75\";s:62:\"public/assets/assets/svg/editor/ic_vertical_align_top_24px.svg\";s:64:\"02460fd350ddf63e8d5db957f2c2d48cca0b9e4441b96644ec38b6682fbe95a5\";s:53:\"public/assets/assets/svg/editor/ic_wrap_text_24px.svg\";s:64:\"07218ac0f6ddce5948f9015c0020aa1a814a906def6de4b6e3ba049605b1dd2f\";s:52:\"public/assets/assets/svg/file/ic_attachment_24px.svg\";s:64:\"0c75d7eedc471d63354f6745fe2e6099e8d8d4e6956564859073e19c3793d9b4\";s:47:\"public/assets/assets/svg/file/ic_cloud_24px.svg\";s:64:\"efeea6e90b278c8d9199de26197ae8b198814abae672d22522cc1b925535cc96\";s:54:\"public/assets/assets/svg/file/ic_cloud_circle_24px.svg\";s:64:\"43ec9a5250be8ac9f9e501abd693a3d6b8bc95c4d0ee42f7c07c908de1fe9016\";s:52:\"public/assets/assets/svg/file/ic_cloud_done_24px.svg\";s:64:\"ac232d85225c34eff428c9ad5636bcced7bbfdbc62b919ad58b8ca338e6c1f04\";s:56:\"public/assets/assets/svg/file/ic_cloud_download_24px.svg\";s:64:\"381dc99d432cf55ee3d80fb717d0fdff2c1fe992649b55c9cc1594dd8f1b808e\";s:51:\"public/assets/assets/svg/file/ic_cloud_off_24px.svg\";s:64:\"715502c44c512ed88d28699768f0e7925fc60dfc65ccc5dcccd162f1072051a0\";s:53:\"public/assets/assets/svg/file/ic_cloud_queue_24px.svg\";s:64:\"e7d7494e63c21afe8ab8833b2fce9bd181a20cb4625a97ab3d22ee1b191e45ed\";s:54:\"public/assets/assets/svg/file/ic_cloud_upload_24px.svg\";s:64:\"dd4ebaae0dbf20252947784ca93dccd3a08b346d2b408c1469adad0c5b2749c0\";s:59:\"public/assets/assets/svg/file/ic_create_new_folder_24px.svg\";s:64:\"82b1e60efd9cac71491fde0af781fafad8caa9c913bc432ceedcce4153efa92e\";s:55:\"public/assets/assets/svg/file/ic_file_download_24px.svg\";s:64:\"b887b20de9d7850bac7629bbc72519f5f76c1ae988c692f1970e70cec7498456\";s:53:\"public/assets/assets/svg/file/ic_file_upload_24px.svg\";s:64:\"5dd98da44a81b5a2c430af52158959cc8f7ac9649b7c5a55a79e830b8accd555\";s:48:\"public/assets/assets/svg/file/ic_folder_24px.svg\";s:64:\"6fd163596302f902f0b52c168a367e02dafe72800bc169bc5a293b3e116256c9\";s:53:\"public/assets/assets/svg/file/ic_folder_open_24px.svg\";s:64:\"e8f2a20b5b3644d5b6b4ec4a0cb32bf51e5fdb5ba8ed3e0b515dc423fee6f573\";s:55:\"public/assets/assets/svg/file/ic_folder_shared_24px.svg\";s:64:\"5d5e33f385c481eb791ec73dc7f8de05bbd46152ee9b11fcd3e38ab6597223ed\";s:50:\"public/assets/assets/svg/hardware/ic_cast_24px.svg\";s:64:\"1d753fa5588099daa59b4fedde5781c61ff6e5e71ccdfa8dc333002a89faff19\";s:60:\"public/assets/assets/svg/hardware/ic_cast_connected_24px.svg\";s:64:\"2503e46da3ebd7e04648cd2a59ab0e9fe492db73e11039f90107aa6e2324a60c\";s:54:\"public/assets/assets/svg/hardware/ic_computer_24px.svg\";s:64:\"32fe80f9f3d86310dacf0df28c8720e55aa9b8dc07db2593bfcf63bea6d8bcff\";s:57:\"public/assets/assets/svg/hardware/ic_desktop_mac_24px.svg\";s:64:\"e57c29855f25917a830e1d68e4bbff0fc9d5d37167aa91dfe37a9601329e8459\";s:61:\"public/assets/assets/svg/hardware/ic_desktop_windows_24px.svg\";s:64:\"7bd00d8f25c80ef2b40816855428dd4a415e4fba41d14ea06500e41a2672de98\";s:61:\"public/assets/assets/svg/hardware/ic_developer_board_24px.svg\";s:64:\"941626c393631a4dbf0c2cf58eeb7b94dcc847ef5e2b498ded82edfb3189c6c8\";s:56:\"public/assets/assets/svg/hardware/ic_device_hub_24px.svg\";s:64:\"193f98a1fe680a48ec0a4345bf34860d49bbf70ff1d0d26cf9193089c1a9e4b1\";s:59:\"public/assets/assets/svg/hardware/ic_devices_other_24px.svg\";s:64:\"8078a45d2ddbac99becdb3a27445e78c026e741a70ccfb994600372c306b8454\";s:50:\"public/assets/assets/svg/hardware/ic_dock_24px.svg\";s:64:\"965910858b303d38b09aa46c215369e096618fcd0f776bb8d25476ab1290bd7a\";s:53:\"public/assets/assets/svg/hardware/ic_gamepad_24px.svg\";s:64:\"3e850f0a5ebf1e0bfa149967352eff6c9f9ff7c7d262c570fb0bec99c9cda33a\";s:53:\"public/assets/assets/svg/hardware/ic_headset_24px.svg\";s:64:\"1268bd5ad1c7c339be202cc4baca67f13d8d51c0b405d0bdd48cdd0aced11b98\";s:57:\"public/assets/assets/svg/hardware/ic_headset_mic_24px.svg\";s:64:\"892f8d67079f15a1d256eab665dc68b2055fa894911f17cb44668d98d14e165d\";s:54:\"public/assets/assets/svg/hardware/ic_keyboard_24px.svg\";s:64:\"211e47aef0b954dba38ab1549c11901255b5b0d8131056db1b39eae674971408\";s:65:\"public/assets/assets/svg/hardware/ic_keyboard_arrow_down_24px.svg\";s:64:\"5bb56392396df54f2fef737af5c4a1db53c8c2f2094cab6609fbe40871db3fb7\";s:65:\"public/assets/assets/svg/hardware/ic_keyboard_arrow_left_24px.svg\";s:64:\"1aeccc3fc200d2a9376cb1cdb7a98c4e337c9b19704d53168411d0150e13760e\";s:66:\"public/assets/assets/svg/hardware/ic_keyboard_arrow_right_24px.svg\";s:64:\"5e2d47bcb1b29ad75cd38794379b07a65398a983183f41d50e39dbf63ccd28ca\";s:63:\"public/assets/assets/svg/hardware/ic_keyboard_arrow_up_24px.svg\";s:64:\"00d8f7123bb5ef3f7fad786905f5407cc5fb8b4c55e1b0511803f6c8c01e3903\";s:64:\"public/assets/assets/svg/hardware/ic_keyboard_backspace_24px.svg\";s:64:\"2bbd845f280ad00b8a96804bab8db2ff00740eb4ab9f870e4a64a043c262f10f\";s:63:\"public/assets/assets/svg/hardware/ic_keyboard_capslock_24px.svg\";s:64:\"b4b76ebafbad449887b0e350f4b83e45036449e3e6284227a23ada345a0d32a0\";s:59:\"public/assets/assets/svg/hardware/ic_keyboard_hide_24px.svg\";s:64:\"69809155ec7d48e700a2c55152cf76fad788920b0e002ef62a81425f54efcd71\";s:61:\"public/assets/assets/svg/hardware/ic_keyboard_return_24px.svg\";s:64:\"628073a0ebc9e97b55f91d189f4d784596066e672fe7829bb507f135194da302\";s:58:\"public/assets/assets/svg/hardware/ic_keyboard_tab_24px.svg\";s:64:\"a03b1a14b4bfeb604f938dbc20c721a353be96b92fc0c883c0fb0f7b635a2446\";s:60:\"public/assets/assets/svg/hardware/ic_keyboard_voice_24px.svg\";s:64:\"608013b35d8e35fc1d651836cb057926d5604aec48d7ba32df581d53b12a893a\";s:52:\"public/assets/assets/svg/hardware/ic_laptop_24px.svg\";s:64:\"7ff4562d246007038bc8ea2a212e4f9ad7d3ad88f8fe46de3b7974f778d5576f\";s:63:\"public/assets/assets/svg/hardware/ic_laptop_chromebook_24px.svg\";s:64:\"c46ca0a1ed5975edcc49cb32cdb077e7c46c0c964fab1986f00435da087060dd\";s:56:\"public/assets/assets/svg/hardware/ic_laptop_mac_24px.svg\";s:64:\"fe0a0288cd3e94f31b078de241d6eb5e620a8fdbd74a924d744006cd1a69a422\";s:60:\"public/assets/assets/svg/hardware/ic_laptop_windows_24px.svg\";s:64:\"5b46b4975939fac6a7e9c3b774f05c58d96655f6c21276e386e8a3c56297947d\";s:52:\"public/assets/assets/svg/hardware/ic_memory_24px.svg\";s:64:\"d5f806ad64030d8c19188ac8add799e26f37f71bd2b10c7a32bc25769fd2a0a4\";s:51:\"public/assets/assets/svg/hardware/ic_mouse_24px.svg\";s:64:\"396a2266e2b3eedaaea2a6cc35da3b7a7bd934b1cdb21e4c9518eb1fbb21d49d\";s:59:\"public/assets/assets/svg/hardware/ic_phone_android_24px.svg\";s:64:\"4a15284d01c010d6ddb3a219045f25ec7f9924260aa5e40048b5cac83d5186b1\";s:58:\"public/assets/assets/svg/hardware/ic_phone_iphone_24px.svg\";s:64:\"ead5012394b90ef0bf39f499a3f45abab2124b929ffb6ea217693791881d2664\";s:55:\"public/assets/assets/svg/hardware/ic_phonelink_24px.svg\";s:64:\"ff603e07968311f66ff514e30cf6f17f5d17d0e80e2b82a1beac4ed28336b30c\";s:59:\"public/assets/assets/svg/hardware/ic_phonelink_off_24px.svg\";s:64:\"21b9024f4b52bbeb9a162238ad304ca8b98740780c71026159cdfe0d16be039d\";s:57:\"public/assets/assets/svg/hardware/ic_power_input_24px.svg\";s:64:\"c886c94e6ff36a8a21c3c944ab10b5032567ff57021d7a75a99e754b432b0f49\";s:52:\"public/assets/assets/svg/hardware/ic_router_24px.svg\";s:64:\"a3224c291ceffc7d953d1a94435456a75371f96e292181d0b7ca8a5443da8570\";s:53:\"public/assets/assets/svg/hardware/ic_scanner_24px.svg\";s:64:\"909e0857695026a4b7ea9db16e7ba2c12cf4ac6236b2e07553173664403080c1\";s:54:\"public/assets/assets/svg/hardware/ic_security_24px.svg\";s:64:\"f778dd116c1912f83e3a04675890d70e151f82189ddbc481b4026421aeb879ee\";s:54:\"public/assets/assets/svg/hardware/ic_sim_card_24px.svg\";s:64:\"0a1c80b771c01a3d2847f093a494173c2ae69034803fb63cc7824fa4a22d1d73\";s:56:\"public/assets/assets/svg/hardware/ic_smartphone_24px.svg\";s:64:\"2cda8927572e92b38e7ed94fbd4d8d4ffaaeb4bc1187125db4ca88da6bca2742\";s:53:\"public/assets/assets/svg/hardware/ic_speaker_24px.svg\";s:64:\"b32b12baf48ef24f05ebba385ffd8c4193d7917197e9e2f4ba6f394020831923\";s:59:\"public/assets/assets/svg/hardware/ic_speaker_group_24px.svg\";s:64:\"41833a1322d978a28a1968a63fb96ace4a502a63f976dc20cc54f74762138c82\";s:52:\"public/assets/assets/svg/hardware/ic_tablet_24px.svg\";s:64:\"60d8f7fff4bdf7a56e5e867458a598d5d5358517c3f163d17944384c71ebb72a\";s:60:\"public/assets/assets/svg/hardware/ic_tablet_android_24px.svg\";s:64:\"1c07ae860916f4c005b89468f2b7a8336cab7ef816a3866a1b59933c4bf8c9e3\";s:56:\"public/assets/assets/svg/hardware/ic_tablet_mac_24px.svg\";s:64:\"99aba9e7575bcdb7bf4286af1ce8b5a9160cb2c9f51bed8264de45ef31f0345f\";s:50:\"public/assets/assets/svg/hardware/ic_toys_24px.svg\";s:64:\"92220f21ebe3b399a6ea2c561959d261a1af0786a3fe376fd3c9b1e59d9bb434\";s:48:\"public/assets/assets/svg/hardware/ic_tv_24px.svg\";s:64:\"0278fb08c59bc5774294a851894332960068c13b36ff96ee207d6104a4e18951\";s:61:\"public/assets/assets/svg/hardware/ic_videogame_asset_24px.svg\";s:64:\"1e72ddb68f37e38c741f80ba1ed8599c2fe91e78dcb27b278c96ee6bf5b4b468\";s:51:\"public/assets/assets/svg/hardware/ic_watch_24px.svg\";s:64:\"1b22fa67a5a30e18d27418e91df20a52727bd03091ea380d07c577c6e1efeb39\";s:54:\"public/assets/assets/svg/image/ic_add_a_photo_24px.svg\";s:64:\"05f5db2f5d06b7c1ea6e5650262b29b166ffa71f69435e600965389340721585\";s:56:\"public/assets/assets/svg/image/ic_add_to_photos_24px.svg\";s:64:\"2057c6177d9cdc9f6154e9ee439ddd7a49dd9b9eafff5977aac46da6c154452b\";s:49:\"public/assets/assets/svg/image/ic_adjust_24px.svg\";s:64:\"50cedc221f18818328efcc710bd6fb7f6c6a2c33b888ed311f24780069044f39\";s:52:\"public/assets/assets/svg/image/ic_assistant_24px.svg\";s:64:\"d6c81bfbed6964aec30b3b9b86ff2b0e29787dc4b3658ff1d2bdaf7080ae7842\";s:58:\"public/assets/assets/svg/image/ic_assistant_photo_24px.svg\";s:64:\"cbb30ec622923b6e0442d67277e30eaa1ba429223b132fde3289d125f2c62c88\";s:53:\"public/assets/assets/svg/image/ic_audiotrack_24px.svg\";s:64:\"2d19fe8a34f497931c6606856f6cf002da95b3563b15280bc7c8f524018829b0\";s:56:\"public/assets/assets/svg/image/ic_blur_circular_24px.svg\";s:64:\"4da0e483dcdc6e31a76999acf4d8278f63776d1c44554d9debaaa0a2d5bf79c0\";s:54:\"public/assets/assets/svg/image/ic_blur_linear_24px.svg\";s:64:\"7136da487685ab87b30af98bf4aec7eb4d3ef4a6e3cc618f7a1f44b7fcfc8f53\";s:51:\"public/assets/assets/svg/image/ic_blur_off_24px.svg\";s:64:\"fdde52fa7432b4ccf30aabad9307b2146f55c2a2c2a341d23d0c44cf3fafbacc\";s:50:\"public/assets/assets/svg/image/ic_blur_on_24px.svg\";s:64:\"ae47cab9e4adeac358fe0d846c2c16909eb73805ad49791836a02c4b28cb92f0\";s:55:\"public/assets/assets/svg/image/ic_brightness_1_24px.svg\";s:64:\"5a119b27722ff80a801f50e83b4d78c78fe6002c513a037eb86ebccdb31f595a\";s:55:\"public/assets/assets/svg/image/ic_brightness_2_24px.svg\";s:64:\"923abe5df2ea16e95273f43c241ed1f86715c1e66184ea4e705cc61ce5be8c7d\";s:55:\"public/assets/assets/svg/image/ic_brightness_3_24px.svg\";s:64:\"5e0aa9434d2498076eeda61bb2ef7019ba97ae98b5ae91f77c204a57b0e9cde5\";s:55:\"public/assets/assets/svg/image/ic_brightness_4_24px.svg\";s:64:\"f313171cb4d6ab3ab7d4a635b22be00f8675f9a28f69d9e4a6f4f511b0107b3d\";s:55:\"public/assets/assets/svg/image/ic_brightness_5_24px.svg\";s:64:\"d0655c2f58d3fd47c4f5bda9efcd64845e695c357221dbe97a82343585f01bc9\";s:55:\"public/assets/assets/svg/image/ic_brightness_6_24px.svg\";s:64:\"7b248a3f7cd27cd31575fa060235a702e2daaf51490a173413e5a4ea90f9df68\";s:55:\"public/assets/assets/svg/image/ic_brightness_7_24px.svg\";s:64:\"e9d4d6f8f068e875bb94666332c9e2d273a806028c5df9f64065d062917a6aad\";s:55:\"public/assets/assets/svg/image/ic_broken_image_24px.svg\";s:64:\"7ffa61f2e3203e3097ccc706ad38fea5cb429b84ebb3313bee256f45d5fe7101\";s:48:\"public/assets/assets/svg/image/ic_brush_24px.svg\";s:64:\"7f269a46d7a942a72bb31e9c5427b2d5d22e473bf18f48aa98b87b02160362dc\";s:49:\"public/assets/assets/svg/image/ic_camera_24px.svg\";s:64:\"f8c3d560b0fe3d8d732a18cb3b7900eac9dae2777a8d056665577e4bdaebd1fa\";s:53:\"public/assets/assets/svg/image/ic_camera_alt_24px.svg\";s:64:\"752837fd86ca522bc055c564a6eac167fd011ea807a3a9ef86509b6eadeb015d\";s:55:\"public/assets/assets/svg/image/ic_camera_front_24px.svg\";s:64:\"059a95a1c77cf61574878a6f20b88ba0261b83f797557b81da48b43183a636bc\";s:54:\"public/assets/assets/svg/image/ic_camera_rear_24px.svg\";s:64:\"22c14e7e261250b874b237f3afa4f2429d3ceddee2928d9df16b4d91f5885811\";s:54:\"public/assets/assets/svg/image/ic_camera_roll_24px.svg\";s:64:\"258c18fe7ea0cc6cfe5cca9f1b83a383aedd4ef35ffdc06a8639eeeed2a98a47\";s:62:\"public/assets/assets/svg/image/ic_center_focus_strong_24px.svg\";s:64:\"897b692a5565b6ca2df37ad16714a6ca5e00a884fe77a870e3fb68456cacb250\";s:60:\"public/assets/assets/svg/image/ic_center_focus_weak_24px.svg\";s:64:\"c157a5df8bba18437b6c66144b25d87ed22542f6a333b53a4b909fbce1eceb58\";s:54:\"public/assets/assets/svg/image/ic_collections_24px.svg\";s:64:\"eb618dc1aab3fe560a3cee9c4626701e6451d8fd5c760d2fa7415efb75158fb9\";s:63:\"public/assets/assets/svg/image/ic_collections_bookmark_24px.svg\";s:64:\"2528414af7bdc861e1a418ff5a85e501675e644acb78ceb3d6368399533fca75\";s:53:\"public/assets/assets/svg/image/ic_color_lens_24px.svg\";s:64:\"db745aaa866a71056c8010d1bd9619612167f21a5ca24e691e36180283bc264b\";s:51:\"public/assets/assets/svg/image/ic_colorize_24px.svg\";s:64:\"0b2ba7c369e03e61bc6582090add0d452d2ea02350cff8ba70efc120d0279541\";s:50:\"public/assets/assets/svg/image/ic_compare_24px.svg\";s:64:\"f973668e0b367eba3da516ec97355beff11592842f772720810b62d20e6cd9f7\";s:56:\"public/assets/assets/svg/image/ic_control_point_24px.svg\";s:64:\"835a3568212151583dcf92e8aea0f01c378e527acdb384b812365c51d1f4a990\";s:66:\"public/assets/assets/svg/image/ic_control_point_duplicate_24px.svg\";s:64:\"49714bc3b17807071a6e0594c0972964afb106df43413c5a4426f16bba2b3162\";s:52:\"public/assets/assets/svg/image/ic_crop_16_9_24px.svg\";s:64:\"2fd6af1f67a4ad7ecafe96809fb3cbb1738106477133067b7c49b5b9640973ed\";s:47:\"public/assets/assets/svg/image/ic_crop_24px.svg\";s:64:\"19f0a7218634a715c5f8a415653d16b78a9e030a5a9e5ae9bff265e93c0ec431\";s:51:\"public/assets/assets/svg/image/ic_crop_3_2_24px.svg\";s:64:\"dda30ba0c5a371b9a4ee8a8893f08dd0961587527b56302435e078b5c697de0b\";s:51:\"public/assets/assets/svg/image/ic_crop_5_4_24px.svg\";s:64:\"7d13454d35b59cc1b6fc79a7ff7b94805522234424a6dee6c177936e38a39488\";s:51:\"public/assets/assets/svg/image/ic_crop_7_5_24px.svg\";s:64:\"32c95931ba1c0c508a3e2db3f44fe6e64f8af0bbb3c78083adf32d1dfe93d41e\";s:51:\"public/assets/assets/svg/image/ic_crop_din_24px.svg\";s:64:\"6bf3ebf6f495d1fa87f47aa4e97985f00f2d61cc2dbb18e8301228c07141679d\";s:52:\"public/assets/assets/svg/image/ic_crop_free_24px.svg\";s:64:\"1bc8298b0ceaf5654150eeb6da7d46db410923bb6bdecc83f5405378e326c336\";s:57:\"public/assets/assets/svg/image/ic_crop_landscape_24px.svg\";s:64:\"7d13454d35b59cc1b6fc79a7ff7b94805522234424a6dee6c177936e38a39488\";s:56:\"public/assets/assets/svg/image/ic_crop_original_24px.svg\";s:64:\"a12107990f15c01fcc2894713e72f28b11df97bffadbc02249a07ad3bd16d657\";s:56:\"public/assets/assets/svg/image/ic_crop_portrait_24px.svg\";s:64:\"aaeca5941d7cd902b55098f6f7af64d373c258f2d9a08838797d99c211f3cdea\";s:54:\"public/assets/assets/svg/image/ic_crop_rotate_24px.svg\";s:64:\"9bb39189c509c58f72e4edd3cc8cb9c312f58b48eb4a7c303fa1d21a2d78ca46\";s:54:\"public/assets/assets/svg/image/ic_crop_square_24px.svg\";s:64:\"b4f9019235eb0f80f4b00d7d5074d1d0391e701778d9eddfe061b102a66caab6\";s:49:\"public/assets/assets/svg/image/ic_dehaze_24px.svg\";s:64:\"beafab06427a5e62b4985e57c9083e1b3cfad635e7533002af84e7a963503f4a\";s:50:\"public/assets/assets/svg/image/ic_details_24px.svg\";s:64:\"8db56d6f321fdd301da92bc7b3a03631115efc183ac8eec3b41559c37c12e969\";s:47:\"public/assets/assets/svg/image/ic_edit_24px.svg\";s:64:\"e421babfbbe69cd7e72fca2b85774b26ec4c9557384b9a3bbfb3d3cef031b4a0\";s:51:\"public/assets/assets/svg/image/ic_exposure_24px.svg\";s:64:\"2159ad3156bd508ad39502c642f2efeda8e965b6e774c85dd8b4ccc3695ded98\";s:57:\"public/assets/assets/svg/image/ic_exposure_neg_1_24px.svg\";s:64:\"d6b59c28bd8fff8bfd201ae148c86981c6258c8640f8b75774ac44f8a415030a\";s:57:\"public/assets/assets/svg/image/ic_exposure_neg_2_24px.svg\";s:64:\"bc7aa945b286051333284c2ee5e99702432d7777c2849e5dd937cb4bf049262b\";s:58:\"public/assets/assets/svg/image/ic_exposure_plus_1_24px.svg\";s:64:\"36d67d5fef36cf77696057e506a58603f2b623f37c42acd86be415ecf2412a96\";s:58:\"public/assets/assets/svg/image/ic_exposure_plus_2_24px.svg\";s:64:\"b5a6209a7eef17e350377bc582965b77668062bffd9e1cedf8994d587ef541a4\";s:56:\"public/assets/assets/svg/image/ic_exposure_zero_24px.svg\";s:64:\"0957e6451e767ff4b81f13e3d69863fbeac1fa6926dbcb8828c778b97bc7ee96\";s:51:\"public/assets/assets/svg/image/ic_filter_1_24px.svg\";s:64:\"5af248a8a3c1c13b702ce0676bded165e181420a983f905e72b286fff5f18b6c\";s:49:\"public/assets/assets/svg/image/ic_filter_24px.svg\";s:64:\"9fd3cf3eea77f46c8dbcb63dee7b0aca5d29e9b7a079a4c89d7f585b33844e79\";s:51:\"public/assets/assets/svg/image/ic_filter_2_24px.svg\";s:64:\"8608e165b4fd5b834d1352bdcbb877b839b9ca99ee9d2ef36e2ed5a2ad2e01c4\";s:51:\"public/assets/assets/svg/image/ic_filter_3_24px.svg\";s:64:\"d5d13e11d001d9355f755cd317d95b0f26428482fc2bca0ad1e5afd451276fe6\";s:51:\"public/assets/assets/svg/image/ic_filter_4_24px.svg\";s:64:\"48c689190233b3c4440d2cc5d1f810065069db1a3924fe0d62b7d59ff9c55ca9\";s:51:\"public/assets/assets/svg/image/ic_filter_5_24px.svg\";s:64:\"6ddcc6f6d519c1f541ef87ca0cad9c0b43a0a856567c2a13f21e735979469937\";s:51:\"public/assets/assets/svg/image/ic_filter_6_24px.svg\";s:64:\"44258786dbb86b040fb4fba7da0de8f819e4c29c76e7d4c0454b2d491a241474\";s:51:\"public/assets/assets/svg/image/ic_filter_7_24px.svg\";s:64:\"56ad0a26ba4a7d4cb453d82fd4b0b6b5ce1c8f379d79bf2931581a4a49ed88a7\";s:51:\"public/assets/assets/svg/image/ic_filter_8_24px.svg\";s:64:\"01ea2aa8fc0008633cc2f56ed48f5086d32e1f26fc4e752050abfe8e92635066\";s:51:\"public/assets/assets/svg/image/ic_filter_9_24px.svg\";s:64:\"fa69cdb5dea15032f234d8bc8f89ff57014c90e1166538b33f1cac329f6a25e6\";s:56:\"public/assets/assets/svg/image/ic_filter_9_plus_24px.svg\";s:64:\"2d4fc474cdc3d2ede22208d66ac6ac97311f5e563bc4ee8b6f03c619dd6de3eb\";s:57:\"public/assets/assets/svg/image/ic_filter_b_and_w_24px.svg\";s:64:\"ff4668c169d8567de0846477ae0e6b451a06ae43859831d5f67a94f33006fbea\";s:62:\"public/assets/assets/svg/image/ic_filter_center_focus_24px.svg\";s:64:\"b561499a77947d87ea3b7a75b0b0007bd969b5ef5210c30c96d07016a0aaa704\";s:55:\"public/assets/assets/svg/image/ic_filter_drama_24px.svg\";s:64:\"68ac458d09d03737417cf66e3ed93baffd38c17ea0f00a07f331eea8ece34568\";s:56:\"public/assets/assets/svg/image/ic_filter_frames_24px.svg\";s:64:\"f3f7e9d502136a066ad8ad0303b17a3d6c398d772747c1c2f8442d26355d7ef8\";s:53:\"public/assets/assets/svg/image/ic_filter_hdr_24px.svg\";s:64:\"0a5c59a48aa9ee4e4be607609fce70e5ea694d775792f54a70e9ad144d054851\";s:54:\"public/assets/assets/svg/image/ic_filter_none_24px.svg\";s:64:\"e8e48ca7c38eb9aed542dcfd76b5acb23231803590e163bbb6a602229c8d0703\";s:60:\"public/assets/assets/svg/image/ic_filter_tilt_shift_24px.svg\";s:64:\"7edb7935beb6f97871ddc89a6eb1f55e7827890111b26deed636535161551c23\";s:57:\"public/assets/assets/svg/image/ic_filter_vintage_24px.svg\";s:64:\"215b5fb9ee6f493cabae75a912338412d718ad169670c871159ff633014fb0b1\";s:48:\"public/assets/assets/svg/image/ic_flare_24px.svg\";s:64:\"ef72e0f40a3e9a325428fde1680e253dea67a3874ad32dff7081da946dbbaf98\";s:53:\"public/assets/assets/svg/image/ic_flash_auto_24px.svg\";s:64:\"9c847b97e8ebe9c3942b3ec8eeff2f5e9331ccba10be8cc70bbadd5ac02f37f8\";s:52:\"public/assets/assets/svg/image/ic_flash_off_24px.svg\";s:64:\"a7a574e808dfc419ac451371049ded49718f425d833482a7907e9148e68c52dc\";s:51:\"public/assets/assets/svg/image/ic_flash_on_24px.svg\";s:64:\"006474f205048a7dc563a6b1729a2a3cdd896546b19e1c583c8be962e7b6964f\";s:47:\"public/assets/assets/svg/image/ic_flip_24px.svg\";s:64:\"ce0d4b20d4ddc719d3ee7777b281db9dc33f8e113335f93fadcef046c5269587\";s:51:\"public/assets/assets/svg/image/ic_gradient_24px.svg\";s:64:\"a081b8606c601df4cbfdbb69f1613a0c44ca6bbaf051c3a847081e884a856d63\";s:48:\"public/assets/assets/svg/image/ic_grain_24px.svg\";s:64:\"4530be4741ac9902bcbce258cf8548b86ec15bdef6b0a195038c7ebcd6384a4c\";s:51:\"public/assets/assets/svg/image/ic_grid_off_24px.svg\";s:64:\"6b4986199a820202f870965c91df85b525d5df294ec1deaa1393fc0d03ece81c\";s:50:\"public/assets/assets/svg/image/ic_grid_on_24px.svg\";s:64:\"7a7c2108c477f9eca82930302c1b0b1a1a9f4c5d6877d9b338929bbc108ee946\";s:50:\"public/assets/assets/svg/image/ic_hdr_off_24px.svg\";s:64:\"2ca63afa1c516b65c4807bd0814f648f8dff9b32125b21b5cf514ab40b1e564c\";s:49:\"public/assets/assets/svg/image/ic_hdr_on_24px.svg\";s:64:\"3fd1bf9e16aa092e9b32534fe66c4fc2db7435e38e43522499e757667a45fcf2\";s:53:\"public/assets/assets/svg/image/ic_hdr_strong_24px.svg\";s:64:\"0a26fba52d6c76ff8d850537be328772447fee1f525f608dff2f11199e016241\";s:51:\"public/assets/assets/svg/image/ic_hdr_weak_24px.svg\";s:64:\"a041e5f4fd5af4c7cc0e66898888039582cf9af7fd533de44f0a21515ccb8e8e\";s:50:\"public/assets/assets/svg/image/ic_healing_24px.svg\";s:64:\"c082ead5cfb5ce682aa5a3db82d247dc5265ca80993878b3fd041eff3102b60c\";s:48:\"public/assets/assets/svg/image/ic_image_24px.svg\";s:64:\"671a02cb3a7a9c0553a56710d9abfa5bfaff8db9d22937a3b23c8be30f8ea7aa\";s:61:\"public/assets/assets/svg/image/ic_image_aspect_ratio_24px.svg\";s:64:\"939821a7e396416e5ef8581b79d34db89e8b14ccdb41c8041640d527e2f426a6\";s:46:\"public/assets/assets/svg/image/ic_iso_24px.svg\";s:64:\"92e00417a55e8ae48837fd8f70405b5b226c2861de6ca4b221314bdee11e1e8d\";s:52:\"public/assets/assets/svg/image/ic_landscape_24px.svg\";s:64:\"0a5c59a48aa9ee4e4be607609fce70e5ea694d775792f54a70e9ad144d054851\";s:51:\"public/assets/assets/svg/image/ic_leak_add_24px.svg\";s:64:\"4444cba94792a7a7740baa6b86cdf87594c39e0f83159928a69246c827c80fbf\";s:54:\"public/assets/assets/svg/image/ic_leak_remove_24px.svg\";s:64:\"7ff1d06bb3841dd25f54333ed7f67c48b154789e0cb4e8dd0266cc0bcdee26cd\";s:47:\"public/assets/assets/svg/image/ic_lens_24px.svg\";s:64:\"ba021969f639f7ae307e708d92c058fdf1cd68304b214d5d11d9282b4670bfb1\";s:56:\"public/assets/assets/svg/image/ic_linked_camera_24px.svg\";s:64:\"18bc5da1690273f1485bfb21ae43d09bcf088bbb5715786e0892f2a69fbca421\";s:48:\"public/assets/assets/svg/image/ic_looks_24px.svg\";s:64:\"80d2fcca804f01b6904a81ce6b3c37a1eb25cd627422766ddf5d8045fd4bbf6c\";s:50:\"public/assets/assets/svg/image/ic_looks_3_24px.svg\";s:64:\"b6a0b82f369c2ccc01fd48793c6374c33beeed2b3b8612ed4e84b29eefa53a55\";s:50:\"public/assets/assets/svg/image/ic_looks_4_24px.svg\";s:64:\"6d75176283344fdf70b9c70b03bec118e3fb23b0382e7ed2ea105b9e390ca39d\";s:50:\"public/assets/assets/svg/image/ic_looks_5_24px.svg\";s:64:\"91760016a0f6959d6493d8b4b0a80e8f82a2886b8bcd042fed97ca49c6e64d01\";s:50:\"public/assets/assets/svg/image/ic_looks_6_24px.svg\";s:64:\"b8080689ac035abc6096bec09bfff0cf9b672511688c409f087423f9f02b5017\";s:52:\"public/assets/assets/svg/image/ic_looks_one_24px.svg\";s:64:\"64d4e9cafefae84e2ee4a8cdf4a43af90fdb53060c04a730e14b9ebc135b46a2\";s:52:\"public/assets/assets/svg/image/ic_looks_two_24px.svg\";s:64:\"dcf84b287e4e59e955c7a2e445cf3658671747d596475b09b200cd222897f6f8\";s:48:\"public/assets/assets/svg/image/ic_loupe_24px.svg\";s:64:\"506c39c16f65c64ccda81821f064bd79f8d58a97524d17760309d0ba41029900\";s:60:\"public/assets/assets/svg/image/ic_monochrome_photos_24px.svg\";s:64:\"cd15184b207620961df2513255bf0205a8d1e5bf8e16b8432c062c2485a901c8\";s:57:\"public/assets/assets/svg/image/ic_movie_creation_24px.svg\";s:64:\"f0d2c7e0515d6dace01851022d3cebce6dfbc95e0541a8bd26312b63306b2452\";s:55:\"public/assets/assets/svg/image/ic_movie_filter_24px.svg\";s:64:\"6f281ace9cdaadf91de572c175f2097728f51562c0814905ea95c01e6e3d1fba\";s:53:\"public/assets/assets/svg/image/ic_music_note_24px.svg\";s:64:\"2b5c610d246fc796dcd2385a5b058ae76ddaf65ccb93c18d5b13117417a6a1a8\";s:49:\"public/assets/assets/svg/image/ic_nature_24px.svg\";s:64:\"3a8d09d5664dfcfb9515dd9c1bdbba42393c000249b67b753d812d7c35e6a5e1\";s:56:\"public/assets/assets/svg/image/ic_nature_people_24px.svg\";s:64:\"845ccec72649d0e3c6aa1626e1289029c070e8ae4e452517f1b080f6bb4efed5\";s:58:\"public/assets/assets/svg/image/ic_navigate_before_24px.svg\";s:64:\"ad918f7ec0ff89298e84586b5b98cdf628c8457cd067dc592031fae783f71a1d\";s:56:\"public/assets/assets/svg/image/ic_navigate_next_24px.svg\";s:64:\"83f0da9735a4e475b0eca23b708ba09b2b7411e7d711b2d6be24bc2371d67ec8\";s:50:\"public/assets/assets/svg/image/ic_palette_24px.svg\";s:64:\"db745aaa866a71056c8010d1bd9619612167f21a5ca24e691e36180283bc264b\";s:51:\"public/assets/assets/svg/image/ic_panorama_24px.svg\";s:64:\"6132945672edd13d51b056ba8d3127dd15d4a0ff4dd5ff0e7867112a28e14f3b\";s:60:\"public/assets/assets/svg/image/ic_panorama_fish_eye_24px.svg\";s:64:\"90712781f09928f05ae42cdb09b273248719c717acc32d3311fa7f71fe69da40\";s:62:\"public/assets/assets/svg/image/ic_panorama_horizontal_24px.svg\";s:64:\"9dce30b26ec63f1c0fd1eea70c2fc7b989372a0100177be16a16ad33b999b5ee\";s:60:\"public/assets/assets/svg/image/ic_panorama_vertical_24px.svg\";s:64:\"7b0df6f1e3951f89849d3f014f6045f377d2ea46c8c7ba1733db19cdc6575194\";s:62:\"public/assets/assets/svg/image/ic_panorama_wide_angle_24px.svg\";s:64:\"1b83c5c99a29d66162fe1bb53cc86b1cb124e614001e52082cecaa9767e2287f\";s:48:\"public/assets/assets/svg/image/ic_photo_24px.svg\";s:64:\"671a02cb3a7a9c0553a56710d9abfa5bfaff8db9d22937a3b23c8be30f8ea7aa\";s:54:\"public/assets/assets/svg/image/ic_photo_album_24px.svg\";s:64:\"8c2675c5cf77d38d27381eca769f3182edb629af6212c65cd7e1cd79d02b3dbd\";s:55:\"public/assets/assets/svg/image/ic_photo_camera_24px.svg\";s:64:\"752837fd86ca522bc055c564a6eac167fd011ea807a3a9ef86509b6eadeb015d\";s:55:\"public/assets/assets/svg/image/ic_photo_filter_24px.svg\";s:64:\"62968b8d4458089756b1aff2c962fce039bcae7a95337a2814577ddac5bd9b84\";s:56:\"public/assets/assets/svg/image/ic_photo_library_24px.svg\";s:64:\"eb618dc1aab3fe560a3cee9c4626701e6451d8fd5c760d2fa7415efb75158fb9\";s:67:\"public/assets/assets/svg/image/ic_photo_size_select_actual_24px.svg\";s:64:\"6f8e3c4868ae5ef0e0be6c055c1240064cfb6116c5b5caf65e42ae520d5d8ff3\";s:66:\"public/assets/assets/svg/image/ic_photo_size_select_large_24px.svg\";s:64:\"ba354295f255827dcf3040cac6020ad813efe79603d23e200ec0997211094556\";s:66:\"public/assets/assets/svg/image/ic_photo_size_select_small_24px.svg\";s:64:\"7eeba2008c7c969000c14ce1288252f5467b6e63cd02471db25d157b67eb4123\";s:57:\"public/assets/assets/svg/image/ic_picture_as_pdf_24px.svg\";s:64:\"c5d404ff344246af8be939c7efcf4c7f5ab20f367cc616e5ed455bb709ea3719\";s:51:\"public/assets/assets/svg/image/ic_portrait_24px.svg\";s:64:\"9655d1ec45104d7f834b087930fc950ae580f268a4bc09bbdde9d2f33a50f007\";s:57:\"public/assets/assets/svg/image/ic_remove_red_eye_24px.svg\";s:64:\"5e2fc28ae621a18342caf71644f0b5725d9cbe377932db896a0009fa21250201\";s:64:\"public/assets/assets/svg/image/ic_rotate_90_degrees_ccw_24px.svg\";s:64:\"448c0b98c1795054c526b4905cd49903cc23c0d94ea673c8282b9443ff987330\";s:54:\"public/assets/assets/svg/image/ic_rotate_left_24px.svg\";s:64:\"254cc04b8cd845f4e17359e649bfa84a3c55d2ba9fe534a0aadbdc6a0214af8f\";s:55:\"public/assets/assets/svg/image/ic_rotate_right_24px.svg\";s:64:\"e1acb7373657e0d0b6b76611b042636181863feb70d447eed331fa1ef75af347\";s:52:\"public/assets/assets/svg/image/ic_slideshow_24px.svg\";s:64:\"a910a1f071e7d288803f9516fd5a312eb9fe1037bc9c4a8575ceda66f26e5136\";s:53:\"public/assets/assets/svg/image/ic_straighten_24px.svg\";s:64:\"faa637a71183f73c4307ba62e1b8e2a173f9dea1847c35070871b3f9c9357d55\";s:48:\"public/assets/assets/svg/image/ic_style_24px.svg\";s:64:\"232f1702bd366c5f470b7464385a23e2aa4ba088b95fd99abf16a1d333be6ac4\";s:56:\"public/assets/assets/svg/image/ic_switch_camera_24px.svg\";s:64:\"70551fbaa9ad60c496956e3d66db048adb19011592e976ed2c25aed62dda8ad4\";s:55:\"public/assets/assets/svg/image/ic_switch_video_24px.svg\";s:64:\"729dd60f9e92d170f7b24286b5f28c87e72682a684cd5303e7391cea5e353b14\";s:52:\"public/assets/assets/svg/image/ic_tag_faces_24px.svg\";s:64:\"975c5664d2b367f8a033b4eba9f34c6aafbad9b0b4cd25d5e5a1b122758a848a\";s:50:\"public/assets/assets/svg/image/ic_texture_24px.svg\";s:64:\"13d062c2113ba69a63568bf3e1ace05164a53e8738dd2050cc7f16dab5a2b392\";s:52:\"public/assets/assets/svg/image/ic_timelapse_24px.svg\";s:64:\"a888043c58bc4e6026e9519e07533a9c3768919f651350414dfc3d16a8dc7510\";s:51:\"public/assets/assets/svg/image/ic_timer_10_24px.svg\";s:64:\"d7720cba73531949693d88ee7f82ef5540d74c5fd7fb9823dd8b8aa9aebd9c76\";s:48:\"public/assets/assets/svg/image/ic_timer_24px.svg\";s:64:\"fa864ac5e99c2cddb3a7f8d6bd10f5ad3f15c71154ad77c593b8d6bb7152f516\";s:50:\"public/assets/assets/svg/image/ic_timer_3_24px.svg\";s:64:\"7dbe94b8c33865dcdc1c9b8a33467aa4682f539c18c0b20d5071bed7144fea48\";s:52:\"public/assets/assets/svg/image/ic_timer_off_24px.svg\";s:64:\"9ca9a3d736b970446e45ff6f7938a63c6f2f3cc3fe8eaa3abb46c1811b40ef5d\";s:51:\"public/assets/assets/svg/image/ic_tonality_24px.svg\";s:64:\"fe37322b694bfbfdd837f151f317751a864bfa0b679dddb3194a30538f227938\";s:52:\"public/assets/assets/svg/image/ic_transform_24px.svg\";s:64:\"ca307eadb86ba71f9102d87aea960d54144172bbded404e26419733e7ee46383\";s:47:\"public/assets/assets/svg/image/ic_tune_24px.svg\";s:64:\"da9e575b059e05491c555911fa0dfd0b340ad694fd83313769e41d329d826620\";s:53:\"public/assets/assets/svg/image/ic_view_comfy_24px.svg\";s:64:\"9125c262e9efb1df23d5f764ba0ab73964763f520e185c91c6d29a5141cbe173\";s:55:\"public/assets/assets/svg/image/ic_view_compact_24px.svg\";s:64:\"49048c901b81e15b0734e76075989311eab77e112cd81b7455dfbecfdfb72114\";s:51:\"public/assets/assets/svg/image/ic_vignette_24px.svg\";s:64:\"eaf464c2d6bd9f912de7bd7572770d29c8c309e1c75e33024bed0a8a74688c02\";s:50:\"public/assets/assets/svg/image/ic_wb_auto_24px.svg\";s:64:\"361ed4296eb64ddbfed92a4e5309e72d9126ad8133dce06a7e4adee136a78d11\";s:52:\"public/assets/assets/svg/image/ic_wb_cloudy_24px.svg\";s:64:\"b9f3295b533c64d3cb7ee7b0c35b7e9d35682d1a37274318d658ed41146f189e\";s:58:\"public/assets/assets/svg/image/ic_wb_incandescent_24px.svg\";s:64:\"1bc0aebc3e755e0ff863f3a2880f1903c5380bcc980f9dbe67c317205ebfe243\";s:56:\"public/assets/assets/svg/image/ic_wb_iridescent_24px.svg\";s:64:\"b4a11899836426d7f60e82b27c12933a35c9ad33857d675fa89be1cbd93bcc1b\";s:51:\"public/assets/assets/svg/image/ic_wb_sunny_24px.svg\";s:64:\"5f9bc00dec3b1ce3342d40a0a3b8cb14dc0efb8df4a45c67d32490acd3f7d699\";s:54:\"public/assets/assets/svg/maps/ic_add_location_24px.svg\";s:64:\"37c8875448cd80ab3eac5b719b736a3c24fffa4f7f10c6bd27b01c482ca909e2\";s:50:\"public/assets/assets/svg/maps/ic_beenhere_24px.svg\";s:64:\"15292394257011e63bbf7554c3d53334674b2c9381ee184f0de8b3a131e0250c\";s:52:\"public/assets/assets/svg/maps/ic_directions_24px.svg\";s:64:\"b2d77dfb880b70141c3bd19d0238efd649a75acdb963b98ef4119e142090d3a9\";s:57:\"public/assets/assets/svg/maps/ic_directions_bike_24px.svg\";s:64:\"7df1269c0c255f54892c083bd9c67db2fb8c5fa2f211587ac2645034e640da53\";s:57:\"public/assets/assets/svg/maps/ic_directions_boat_24px.svg\";s:64:\"90c77b241095dbc0949115f06a460bfaf587240a43dc7e579b614c3f3abd979d\";s:56:\"public/assets/assets/svg/maps/ic_directions_bus_24px.svg\";s:64:\"3d6da2f8585ce4332ccbd1f323288c7650625a8942860c9b098056686d03adc7\";s:56:\"public/assets/assets/svg/maps/ic_directions_car_24px.svg\";s:64:\"5e07d89850734743c0f201a6a17c53175701065245e558f96607091be477d242\";s:60:\"public/assets/assets/svg/maps/ic_directions_railway_24px.svg\";s:64:\"3c88917729445a1b570ff89a1ddce35c77cfff74a7d7296b2fae33f53960bb98\";s:56:\"public/assets/assets/svg/maps/ic_directions_run_24px.svg\";s:64:\"24b400f38b359203e86d9b9e0a44088822bb9f951dbf2d32109eaf4041551c0f\";s:59:\"public/assets/assets/svg/maps/ic_directions_subway_24px.svg\";s:64:\"c21348ccd68158842aebd40001e60df863ec05afedcef208e12bea1ca6d5851a\";s:60:\"public/assets/assets/svg/maps/ic_directions_transit_24px.svg\";s:64:\"c21348ccd68158842aebd40001e60df863ec05afedcef208e12bea1ca6d5851a\";s:57:\"public/assets/assets/svg/maps/ic_directions_walk_24px.svg\";s:64:\"099493269a0b49970d542dd7570fbedc59107c56c99d529ec85054e9dd16012e\";s:55:\"public/assets/assets/svg/maps/ic_edit_location_24px.svg\";s:64:\"eedc8aa35749d4f0ec443f9481a2e051db676249086b17f057a5c84f39358424\";s:48:\"public/assets/assets/svg/maps/ic_flight_24px.svg\";s:64:\"e36f1d063cc9ae3c0acd5b63cd747185b1ccbb0a4c9b571a235fe654b1a213b1\";s:47:\"public/assets/assets/svg/maps/ic_hotel_24px.svg\";s:64:\"212367d6b539a5948d0719396d9ae11692981f38182252a91b0209f4963eb350\";s:48:\"public/assets/assets/svg/maps/ic_layers_24px.svg\";s:64:\"bfa95b79775e5e549611a85cc586c60a28a23e83524f187c7c49c6e2ed448dd2\";s:54:\"public/assets/assets/svg/maps/ic_layers_clear_24px.svg\";s:64:\"351bbd17cce81422d572f76a18f4b593f5df96d114a6cb14741046a11635971e\";s:56:\"public/assets/assets/svg/maps/ic_local_activity_24px.svg\";s:64:\"0f4e3619863d3f0cd8314f5816104650b42c083a89bf6110f2c1607ff329008b\";s:55:\"public/assets/assets/svg/maps/ic_local_airport_24px.svg\";s:64:\"3ac3a72be56f0ecad93c896e296d982a5e56228865f45a8b2b7af731214ae429\";s:51:\"public/assets/assets/svg/maps/ic_local_atm_24px.svg\";s:64:\"9c67136fc66edc3cd76538bcb93353d0c1a9ce8d6c262a7fefccafbff44d347b\";s:51:\"public/assets/assets/svg/maps/ic_local_bar_24px.svg\";s:64:\"4b93ac6f31711ec4d1206ef5db33cb2148c3e53a765cab97f82c62b36ce878c9\";s:52:\"public/assets/assets/svg/maps/ic_local_cafe_24px.svg\";s:64:\"4d423d59fbd0d1f4eda69bf836a7959e66909e955863845ae0e89df34f0a9dc8\";s:56:\"public/assets/assets/svg/maps/ic_local_car_wash_24px.svg\";s:64:\"f832a1ff099e297b33eee0e8309e54b2eec369f1590b73fb0da3be6278aa3ff4\";s:65:\"public/assets/assets/svg/maps/ic_local_convenience_store_24px.svg\";s:64:\"9d22ce56c2ffd57cb0a09ccbbb2a40ba7c1d78a390605837ba1874156889bbfd\";s:54:\"public/assets/assets/svg/maps/ic_local_dining_24px.svg\";s:64:\"8c619a3dbfa9957d3237208556a03367fa099d5bf80b03e369328125e5ca1681\";s:53:\"public/assets/assets/svg/maps/ic_local_drink_24px.svg\";s:64:\"5639b8406fcbbb2caa680eb8d7344ecec8133506d2c0ef68c4be949e57b1bca9\";s:55:\"public/assets/assets/svg/maps/ic_local_florist_24px.svg\";s:64:\"6af2e59f1aaef801a7a6d47a214a714cf72021e033667e556402d5bb62ee1b65\";s:59:\"public/assets/assets/svg/maps/ic_local_gas_station_24px.svg\";s:64:\"9099cc34d4ecc0913f232b319febe7e13b7d96dc4eecd9694011815773d1e956\";s:61:\"public/assets/assets/svg/maps/ic_local_grocery_store_24px.svg\";s:64:\"0d5d165f3e9eea299e31d16c845eb305ba008dfe45f839619eb98ab0b229f34f\";s:56:\"public/assets/assets/svg/maps/ic_local_hospital_24px.svg\";s:64:\"e26882f6e0a1d4d584502be80a8d0b534faf41db37f7789f91bc67acc71c20d8\";s:53:\"public/assets/assets/svg/maps/ic_local_hotel_24px.svg\";s:64:\"212367d6b539a5948d0719396d9ae11692981f38182252a91b0209f4963eb350\";s:63:\"public/assets/assets/svg/maps/ic_local_laundry_service_24px.svg\";s:64:\"47b814c661fae38ab608d4203bf365d03efa398976cd43408c5c3726eb02ff71\";s:55:\"public/assets/assets/svg/maps/ic_local_library_24px.svg\";s:64:\"185a1c9b6b3d4c04f77d9eecf062f22ca088683d0c16040488b72ad18a865af1\";s:52:\"public/assets/assets/svg/maps/ic_local_mall_24px.svg\";s:64:\"7e3a51acabf987aedf3e44c96ea3178a9ce169c377bf341cb5f7184b7f97a8e4\";s:54:\"public/assets/assets/svg/maps/ic_local_movies_24px.svg\";s:64:\"aacde086862a86f1d85daca021e414ae732e235e9ad09963d71520903bb8be4f\";s:53:\"public/assets/assets/svg/maps/ic_local_offer_24px.svg\";s:64:\"2ed45b1d394e9e1bf7596f16462af322438f00b5deaf59a34afe39b19f95a18f\";s:55:\"public/assets/assets/svg/maps/ic_local_parking_24px.svg\";s:64:\"97806f50a2746ced6ba24943f6a452d87231968b10fa95e7eecf75de6be52d9c\";s:56:\"public/assets/assets/svg/maps/ic_local_pharmacy_24px.svg\";s:64:\"e1958f85ff5fd0228ed73a49486a965cb09ca525a7159b76fedaa8c13f11da5f\";s:53:\"public/assets/assets/svg/maps/ic_local_phone_24px.svg\";s:64:\"90e91c5a06d5dd3138b6367236463d917fd7f7114d2e4b50ced8ac4d6bfc7672\";s:53:\"public/assets/assets/svg/maps/ic_local_pizza_24px.svg\";s:64:\"6a48abd4760f5556baf986b4d16b80dfcbf898f6a1cf55bca8e7cb79ad7e25ee\";s:52:\"public/assets/assets/svg/maps/ic_local_play_24px.svg\";s:64:\"0f4e3619863d3f0cd8314f5816104650b42c083a89bf6110f2c1607ff329008b\";s:59:\"public/assets/assets/svg/maps/ic_local_post_office_24px.svg\";s:64:\"36855acaeb73e1543f77500e12a3db813a0cf698a310e337306a9042dcf607ed\";s:57:\"public/assets/assets/svg/maps/ic_local_printshop_24px.svg\";s:64:\"7ea1c5ab4938c31fff7349644e8181445d15a9576418e3ec0a5ff20ec4f3efd7\";s:51:\"public/assets/assets/svg/maps/ic_local_see_24px.svg\";s:64:\"752837fd86ca522bc055c564a6eac167fd011ea807a3a9ef86509b6eadeb015d\";s:56:\"public/assets/assets/svg/maps/ic_local_shipping_24px.svg\";s:64:\"99c1d7acde91364df2b3f239fc812639286cb27ce089290eea2ac6d5706ee553\";s:52:\"public/assets/assets/svg/maps/ic_local_taxi_24px.svg\";s:64:\"b919ea27f949fcb15a2522a45f2e641d962daa0e2dc60257121c4434ea8a7dfa\";s:45:\"public/assets/assets/svg/maps/ic_map_24px.svg\";s:64:\"db0a088d41c6c6fa198b1c78282640d473c21b6a38aefdc81d6d537ad29b3f21\";s:53:\"public/assets/assets/svg/maps/ic_my_location_24px.svg\";s:64:\"5067b58e47e1b295b815c4218624d821702892d97e8ad8d6bb75837979a4237e\";s:52:\"public/assets/assets/svg/maps/ic_navigation_24px.svg\";s:64:\"8c607d8e6e86a43ab6453439e82a206eba832b70e785f6bcd43ba5a0d5131922\";s:49:\"public/assets/assets/svg/maps/ic_near_me_24px.svg\";s:64:\"b5fe5fc7478a697901c31ee9188b1cb1f0bf80e4f3c82d93fb6b907a4f6a4fe3\";s:52:\"public/assets/assets/svg/maps/ic_person_pin_24px.svg\";s:64:\"0ceaa7e197c559a615af4fd5df1f8a7b591d50c703e1b914a3749ca3242d92a7\";s:59:\"public/assets/assets/svg/maps/ic_person_pin_circle_24px.svg\";s:64:\"4fba671b77369b1edecc5cbda1d57d9b1ad902f1614ac3b2820e6f43135d8934\";s:50:\"public/assets/assets/svg/maps/ic_pin_drop_24px.svg\";s:64:\"aaa411c0b6b2bf50c4bb5ed52e04c3d70957d8d27fcbd1d6b5029ff7c4588edb\";s:47:\"public/assets/assets/svg/maps/ic_place_24px.svg\";s:64:\"b989d3c8cfe19edd295378071c23de9c787cbc6ee66cc6a83023968837d0a88f\";s:53:\"public/assets/assets/svg/maps/ic_rate_review_24px.svg\";s:64:\"5fb92d258ba49e23ae9a58ba2c059d6374cff427a63e6a4b563f8f116437c0b9\";s:57:\"public/assets/assets/svg/maps/ic_restaurant_menu_24px.svg\";s:64:\"8c619a3dbfa9957d3237208556a03367fa099d5bf80b03e369328125e5ca1681\";s:51:\"public/assets/assets/svg/maps/ic_satellite_24px.svg\";s:64:\"8551b3ae4abd3e1b9e76efe114393dd1381a97d7b610e0cae92134427b67c43a\";s:62:\"public/assets/assets/svg/maps/ic_store_mall_directory_24px.svg\";s:64:\"61aae36d8f51d94ffa1f6b35ef20d433d714158375d94ced41d74a92b46e09d8\";s:49:\"public/assets/assets/svg/maps/ic_terrain_24px.svg\";s:64:\"0a5c59a48aa9ee4e4be607609fce70e5ea694d775792f54a70e9ad144d054851\";s:49:\"public/assets/assets/svg/maps/ic_traffic_24px.svg\";s:64:\"95c9b4610eea7ac052966bff64a7dceef6a8004bbf5e8226ae26b4494bf1d5d2\";s:54:\"public/assets/assets/svg/maps/ic_zoom_out_map_24px.svg\";s:64:\"d4847a4313cdb7492c29fde9608aba6b9ee591cf5a9f2d147fa81ee348604cbd\";s:52:\"public/assets/assets/svg/navigation/ic_apps_24px.svg\";s:64:\"3c1277e9cfc9c72963acd319a9452a7b93f805761159c1f614f8d2df913e55db\";s:52:\"public/assets/assets/svg/navigation/ic_apps_36px.svg\";s:64:\"8ca56bde95147ac71153f275894a9e54598af918961fab1672ad540f1e43c246\";s:58:\"public/assets/assets/svg/navigation/ic_arrow_back_24px.svg\";s:64:\"ad23ffb6d1c3708a262427c1e2241806d32d41246c248c79197ced6a5f091388\";s:58:\"public/assets/assets/svg/navigation/ic_arrow_back_36px.svg\";s:64:\"18ea6f93092f0e3e7d190826526cd5adefa2e97aef88e67ea16be021f3cc4c9f\";s:62:\"public/assets/assets/svg/navigation/ic_arrow_downward_24px.svg\";s:64:\"dd8deb85c82313c5aeb4936857fd99cb38a617507fb65afddf289941b99ae9f2\";s:63:\"public/assets/assets/svg/navigation/ic_arrow_drop_down_24px.svg\";s:64:\"628efa55ab34dc4b5d484da2d4ff2aebf9bf51f570d1adf827330185acbfe8d8\";s:63:\"public/assets/assets/svg/navigation/ic_arrow_drop_down_36px.svg\";s:64:\"0b237a12d712152381ac4827f0b5ee0df8c1332115963790ec450e0cc2945a6d\";s:70:\"public/assets/assets/svg/navigation/ic_arrow_drop_down_circle_24px.svg\";s:64:\"5c0648308c3cfc9d831728f7db8a8a290d8efea0fc5054eb9e02611d7b4db0c8\";s:61:\"public/assets/assets/svg/navigation/ic_arrow_drop_up_24px.svg\";s:64:\"f4e26b35598653ba5dfc0076ff043cb7210470046e975b20b6c9823ca36a24b9\";s:61:\"public/assets/assets/svg/navigation/ic_arrow_drop_up_36px.svg\";s:64:\"6ed7a19564036353f945265c0ad098660dd5b391ab26e7c4d768f5b069543f57\";s:61:\"public/assets/assets/svg/navigation/ic_arrow_forward_24px.svg\";s:64:\"a56f4833cc71247f85a97f4b29eb98e86061d0550736061b584e3a2b157da64c\";s:61:\"public/assets/assets/svg/navigation/ic_arrow_forward_36px.svg\";s:64:\"6b9cc0d066941fb9c53ad214fc29cf15feda380a2fe38a487d6c65c846d7b25f\";s:60:\"public/assets/assets/svg/navigation/ic_arrow_upward_24px.svg\";s:64:\"76d31a5591d1044d0461ee6dc482580e9797101dc96a47bbd53cef9930777f85\";s:54:\"public/assets/assets/svg/navigation/ic_cancel_24px.svg\";s:64:\"0ea7671d0b99f8245208eda58e3bc3c633f715bc8ceb9fb2cf60ea5eeda9bda9\";s:54:\"public/assets/assets/svg/navigation/ic_cancel_36px.svg\";s:64:\"7fc96469cbc28e2caa5953f1ded91f3be05ade1bc7823a45030eda3968f05017\";s:53:\"public/assets/assets/svg/navigation/ic_check_24px.svg\";s:64:\"86ece4b96d4a170c2ad15d07ab2ccf33fcbf4524bbee09e441fec8d5770cc78d\";s:53:\"public/assets/assets/svg/navigation/ic_check_36px.svg\";s:64:\"4bc96e11a03467805bbf9f11d171bfa48816fa9ba9ed770e9dab3c77994520e6\";s:60:\"public/assets/assets/svg/navigation/ic_chevron_left_24px.svg\";s:64:\"ad918f7ec0ff89298e84586b5b98cdf628c8457cd067dc592031fae783f71a1d\";s:60:\"public/assets/assets/svg/navigation/ic_chevron_left_36px.svg\";s:64:\"dc3d0b54480835cf5912005be8893af846ef23f7c1f07e39c3f68256e8930a13\";s:61:\"public/assets/assets/svg/navigation/ic_chevron_right_24px.svg\";s:64:\"83f0da9735a4e475b0eca23b708ba09b2b7411e7d711b2d6be24bc2371d67ec8\";s:61:\"public/assets/assets/svg/navigation/ic_chevron_right_36px.svg\";s:64:\"6aad996be11d984d5897c044cdeb74038b9c742e4e8ac19b708dbfdd056c8123\";s:53:\"public/assets/assets/svg/navigation/ic_close_24px.svg\";s:64:\"6d4ccf520d400755057a1739a66c0feda3c98bbc34e8e7f79afa630b2e43f87e\";s:53:\"public/assets/assets/svg/navigation/ic_close_36px.svg\";s:64:\"b8a5a6694734dea198ca4b7784aa675785a4d643e809dae49a1e53dddfd1d8a7\";s:59:\"public/assets/assets/svg/navigation/ic_expand_less_24px.svg\";s:64:\"e52d4acf9d020f85e9fc674479d3ed60ccdd1aa1e6ef3b75f8cd75f1c2284030\";s:59:\"public/assets/assets/svg/navigation/ic_expand_less_36px.svg\";s:64:\"4c18f894185ddc77351e5c61b523a8595847bfc8701006b3e368eba4eaa1f970\";s:59:\"public/assets/assets/svg/navigation/ic_expand_more_24px.svg\";s:64:\"f83d9a4e6a9af95c9321a34f2564e9d45483834fa17f5da5a3a403500636360a\";s:59:\"public/assets/assets/svg/navigation/ic_expand_more_36px.svg\";s:64:\"157af90b3af01c2f1abd4bfc3fdfefc5ec530e064876e0073ccd8628010e091e\";s:58:\"public/assets/assets/svg/navigation/ic_fullscreen_24px.svg\";s:64:\"258698b2e9e9f51626a59775e645a294128fd03efdc77664721bfbb202dacf61\";s:58:\"public/assets/assets/svg/navigation/ic_fullscreen_36px.svg\";s:64:\"59f546b013c18ba1ce00152a25844a9720b47444dba202d41fba13ce480b3b41\";s:63:\"public/assets/assets/svg/navigation/ic_fullscreen_exit_24px.svg\";s:64:\"b2564cb9d5f26ff700138df661467c100d08ab77ba71c865262e0bfc7a255588\";s:63:\"public/assets/assets/svg/navigation/ic_fullscreen_exit_36px.svg\";s:64:\"7f1ff197ca0b288051726acb8b5cb85592d66ea405a9b75c42fafaca4ee9698b\";s:52:\"public/assets/assets/svg/navigation/ic_menu_24px.svg\";s:64:\"caa8cc99e1be32ab478ebbe12f4515de429a57573bd718a80ffad6d37307368b\";s:52:\"public/assets/assets/svg/navigation/ic_menu_36px.svg\";s:64:\"e5e098b0ecf050285e46970f7fad066749330f2f77b8569db0392d8c0c0d6302\";s:58:\"public/assets/assets/svg/navigation/ic_more_horiz_24px.svg\";s:64:\"02f1d5a094ca801a1894b768a61fea2294bdb00e3c9770939b141d42cbd5c40d\";s:58:\"public/assets/assets/svg/navigation/ic_more_horiz_36px.svg\";s:64:\"838b27ffbc33501ddbd8b707e0fc8e6b13bf1b58a7a10896da1a752cc99e1be4\";s:57:\"public/assets/assets/svg/navigation/ic_more_vert_24px.svg\";s:64:\"6c7113da4bf372feb6c320a461f0c510fa8b92626a52b08cdeda3063070b3570\";s:57:\"public/assets/assets/svg/navigation/ic_more_vert_36px.svg\";s:64:\"9d0f32dc9d3c6aba915462ae6adf46f5a54cbb6aabb4473f3d9bdd0e6b6a6b7d\";s:55:\"public/assets/assets/svg/navigation/ic_refresh_24px.svg\";s:64:\"b4d30acd39de79f490eff59d72fb1f06502c117c8815359d539e4f20515494de\";s:55:\"public/assets/assets/svg/navigation/ic_refresh_36px.svg\";s:64:\"48ea4ac2eaefee7852891b5dfc92d46a4fca3a1cc147663ba61922601c3b65ad\";s:71:\"public/assets/assets/svg/navigation/ic_subdirectory_arrow_left_24px.svg\";s:64:\"137d2667f061fbfb52b38287d7bed7a918dddf13760b02f475c0464dd5aebaa0\";s:72:\"public/assets/assets/svg/navigation/ic_subdirectory_arrow_right_24px.svg\";s:64:\"a76af3d9a4a1122abf3d3150deaacdc9af4ec7f4472c623d98531cdd20f9977e\";s:59:\"public/assets/assets/svg/navigation/ic_unfold_less_24px.svg\";s:64:\"d2917fac8d78d65417ee51e4cc3464177b34a1e926d85e0cc2e27f23bb2c5c6d\";s:59:\"public/assets/assets/svg/navigation/ic_unfold_less_36px.svg\";s:64:\"f75b5b645f3beaa444f464e406f4eece7e81436cb5f8a73a6ecf4ba558054cdb\";s:59:\"public/assets/assets/svg/navigation/ic_unfold_more_24px.svg\";s:64:\"75b32d01d02abe6918e2c7f9dbadbd4251a4ebac04029c0e0a80d98fa686b2f2\";s:59:\"public/assets/assets/svg/navigation/ic_unfold_more_36px.svg\";s:64:\"28c460ce61e5231b92a7ee941d4f7977bce2f72100609b7763f254a94334a088\";s:53:\"public/assets/assets/svg/notification/ic_adb_24px.svg\";s:64:\"57742bad57f3e1caef545d2bb02eb64ba6b6264484245205964e3b44d9813954\";s:67:\"public/assets/assets/svg/notification/ic_airline_seat_flat_24px.svg\";s:64:\"0207a40e4cc3a1bcaf007ed27567adb7dc9f4244fe4410b77fbe7a926b5c82a6\";s:74:\"public/assets/assets/svg/notification/ic_airline_seat_flat_angled_24px.svg\";s:64:\"dea3962488758c18826bfab8659cfa819f56437b5db855c9a83a6f92f940de55\";s:79:\"public/assets/assets/svg/notification/ic_airline_seat_individual_suite_24px.svg\";s:64:\"3c7385ee8637236b7ec433c511de320743b4f17eb62d7c1326b4149eed4e8271\";s:76:\"public/assets/assets/svg/notification/ic_airline_seat_legroom_extra_24px.svg\";s:64:\"dc05fb697a75db2a6097f1b5b6bb173953c5d219cad9173be5215ceca2f89816\";s:77:\"public/assets/assets/svg/notification/ic_airline_seat_legroom_normal_24px.svg\";s:64:\"fef9f446181e41a2bc20d039fa1b98b4869baa4e1e868db4bc5adfe27fe0aca5\";s:78:\"public/assets/assets/svg/notification/ic_airline_seat_legroom_reduced_24px.svg\";s:64:\"b1be07066946cc32ce7931116776cc3371f89e47eb5b6122c5b64916fad514f1\";s:76:\"public/assets/assets/svg/notification/ic_airline_seat_recline_extra_24px.svg\";s:64:\"4826c12e47f559bed671f3c2a30eb87e61124849aa31249d1d3c07efc56f80bb\";s:77:\"public/assets/assets/svg/notification/ic_airline_seat_recline_normal_24px.svg\";s:64:\"367d631d822b7bbd704afcfc737eca91e7b1d5a27a776d56c69ff7859ebc9656\";s:65:\"public/assets/assets/svg/notification/ic_bluetooth_audio_24px.svg\";s:64:\"e6cc41bdf18f24f7f9dd00899ebc5e91e10268b2ec4c5426e84fc6b99539c27a\";s:69:\"public/assets/assets/svg/notification/ic_confirmation_number_24px.svg\";s:64:\"0d8e1e89708789afb596efaa3b61127208bc05fd019235b6acbc0c9b905cfb15\";s:59:\"public/assets/assets/svg/notification/ic_disc_full_24px.svg\";s:64:\"4af8e28fb9b73f1b62ba5c23ed1e6c46c01b3c01a7d4194c78b2015ce46c18e3\";s:64:\"public/assets/assets/svg/notification/ic_do_not_disturb_24px.svg\";s:64:\"1e87a9fc6d4fc9f66fa9eef5726764ab9a7afd32cc7eda04106bf8308007ed24\";s:68:\"public/assets/assets/svg/notification/ic_do_not_disturb_alt_24px.svg\";s:64:\"8c8126f2d347353820a76c680621ea35086b534a29d2bc605e14df75a29cea78\";s:59:\"public/assets/assets/svg/notification/ic_drive_eta_24px.svg\";s:64:\"1934626cab4bba2052ee003b226a6dc47026724a8da2a7c1b039af0095fc9ea6\";s:69:\"public/assets/assets/svg/notification/ic_enhanced_encryption_24px.svg\";s:64:\"317afd6384dca1e028843ecf978bd5d17839bf7e11974dc7db8e81b53adec70c\";s:65:\"public/assets/assets/svg/notification/ic_event_available_24px.svg\";s:64:\"4926ebf928d1ae5f6cd48493e383d838ae5187e6f301ed5a74fc0c6a7838ff7f\";s:60:\"public/assets/assets/svg/notification/ic_event_busy_24px.svg\";s:64:\"785f09db3b2e75f24c52f790972103d99059c9359fdd75001c37c86231307bae\";s:60:\"public/assets/assets/svg/notification/ic_event_note_24px.svg\";s:64:\"33d33c7817ff1c93add85d8121f802e949d76d93201bd4b40a5c33b185020e10\";s:64:\"public/assets/assets/svg/notification/ic_folder_special_24px.svg\";s:64:\"97da3ee3627726046cc9aa1dcf2ce9a607730f986f5eb37b9d2458a2a57a00f4\";s:57:\"public/assets/assets/svg/notification/ic_live_tv_24px.svg\";s:64:\"f56d36488b62417c06dcbcf0b06a4352f435177e53c4d2af46588613ecb001f0\";s:53:\"public/assets/assets/svg/notification/ic_mms_24px.svg\";s:64:\"de3c9f1230b7919cc9d9c944c426cb5bbefab1240bda15bbfafaf489e92ec901\";s:54:\"public/assets/assets/svg/notification/ic_more_24px.svg\";s:64:\"fab3c9939451898de27e76d871d7578253e112c06c49ccf022fc49fc58ac0025\";s:63:\"public/assets/assets/svg/notification/ic_network_check_24px.svg\";s:64:\"2fa319fd293a63aa641f5c7e91884ada4c8c66d56eccb744a63f0f84921386b9\";s:64:\"public/assets/assets/svg/notification/ic_network_locked_24px.svg\";s:64:\"6b435b0e033283ebc6f5736fb0ed6d898ad28d88ea8bbeafc2720b46655f81ea\";s:63:\"public/assets/assets/svg/notification/ic_no_encryption_24px.svg\";s:64:\"7ba0371db7fe10b3e6ea2eec340cf2cb6307a47579b1e10016da158c9d4178cb\";s:64:\"public/assets/assets/svg/notification/ic_ondemand_video_24px.svg\";s:64:\"4a2a449975c26d9048af2ae1f59421600959b93225d0bfa1cc3779fd6a5a867c\";s:64:\"public/assets/assets/svg/notification/ic_personal_video_24px.svg\";s:64:\"596a4e549512ae5fef4f81428d215d3b4e3f755a425c4725bb1b72945eeab717\";s:73:\"public/assets/assets/svg/notification/ic_phone_bluetooth_speaker_24px.svg\";s:64:\"c931e2d1a5888be8e5e7e846b3aff76831ee74ba3df8d2282643ff91643ecb65\";s:65:\"public/assets/assets/svg/notification/ic_phone_forwarded_24px.svg\";s:64:\"762b74421577d0dafc7d5b668722ddcdfb02181f78ad9123fdf4d47c130722f0\";s:63:\"public/assets/assets/svg/notification/ic_phone_in_talk_24px.svg\";s:64:\"fb76ccb286a0c152c4d41908554f0bbda206d657db45e82c80065a7d26f5079b\";s:62:\"public/assets/assets/svg/notification/ic_phone_locked_24px.svg\";s:64:\"43c9a07d5ceeef8c471d950bd3504e1d531f3023bc701a6cda7a77ed64a4d9c0\";s:62:\"public/assets/assets/svg/notification/ic_phone_missed_24px.svg\";s:64:\"b452651c07bc5c03a02fa689d63227dddff2e5eb5a32a9af2f9ab6f7c8b9ef93\";s:62:\"public/assets/assets/svg/notification/ic_phone_paused_24px.svg\";s:64:\"db524aabd3000d6b7eafe9d4feefa551c15b6d2b6f4037c91cf55941318405cd\";s:55:\"public/assets/assets/svg/notification/ic_power_24px.svg\";s:64:\"0b8b2a2e69e7f05bb2cb5b0c273762b558d160c76a2e17b143306aef47bb451a\";s:59:\"public/assets/assets/svg/notification/ic_rv_hookup_24px.svg\";s:64:\"ecc2730db3f9082d9fef02cd888e729f240735c8e325ef3fedfa32406d100e96\";s:57:\"public/assets/assets/svg/notification/ic_sd_card_24px.svg\";s:64:\"9f4cd0b97e1106e9016f54bcc3d02159cd0bf275110575f4d4497fdbbd2936e4\";s:64:\"public/assets/assets/svg/notification/ic_sim_card_alert_24px.svg\";s:64:\"3136d5bcd4c6d662913e22d6c2e5048c2d54324102c03f07bf22a700c556821b\";s:53:\"public/assets/assets/svg/notification/ic_sms_24px.svg\";s:64:\"df528d71ba49e60b247601e7d24dd171f3d803e978b4615e0e01a16a6ec1bcf7\";s:60:\"public/assets/assets/svg/notification/ic_sms_failed_24px.svg\";s:64:\"595ba91ca31e088440162257d23e9088e10d5e275d14723a54c0bebcf7675af1\";s:54:\"public/assets/assets/svg/notification/ic_sync_24px.svg\";s:64:\"d9efa9690a6a43ddb127ce41d3b5b05305c174e24776937718fe55eafe85d498\";s:63:\"public/assets/assets/svg/notification/ic_sync_disabled_24px.svg\";s:64:\"da659ba5ce01b77a5dc461a7f851df23344f203e26ebfc91eb3e0c09606b9ec2\";s:62:\"public/assets/assets/svg/notification/ic_sync_problem_24px.svg\";s:64:\"0bed029dcb98e0f7f7ab75750b385c567c409b93666f5403e7dbf28a5f993afc\";s:63:\"public/assets/assets/svg/notification/ic_system_update_24px.svg\";s:64:\"43c6fb6e5e577e53a3c9ac9f7efe043534f42b0f37333907648013f8d6c9ae47\";s:62:\"public/assets/assets/svg/notification/ic_tap_and_play_24px.svg\";s:64:\"9aaa7bb86e9bd46d3e9310f9adc89d1a099b86cb3577e3f0208e101cb0afde34\";s:63:\"public/assets/assets/svg/notification/ic_time_to_leave_24px.svg\";s:64:\"1934626cab4bba2052ee003b226a6dc47026724a8da2a7c1b039af0095fc9ea6\";s:59:\"public/assets/assets/svg/notification/ic_vibration_24px.svg\";s:64:\"dcc1994765a71d41e8906dd391e10be02e52a259a4e69b92aa3b4580f18fa076\";s:60:\"public/assets/assets/svg/notification/ic_voice_chat_24px.svg\";s:64:\"6d4a1b98a723a460a9a32b095da9bc5df749df39b6b9e0d50fb88b677fb57b3d\";s:58:\"public/assets/assets/svg/notification/ic_vpn_lock_24px.svg\";s:64:\"8e5a74342b8ba307072876895848e01e1e14ee1ecbbf38f695daa2f013b089d7\";s:52:\"public/assets/assets/svg/notification/ic_wc_24px.svg\";s:64:\"7c287b67fad3ff447e813efba3c83052bcf843cc3ba8d9de1420c4444f28be5d\";s:54:\"public/assets/assets/svg/notification/ic_wifi_24px.svg\";s:64:\"89b4ab6b61b4582f9a4bbd4f1f079a1eed09f4f8bfdb1d223d74401b14c225c7\";s:51:\"public/assets/assets/svg/places/ic_ac_unit_24px.svg\";s:64:\"8328495d30929ba2c4c7a392e1e3c0f834898ca468e4cacd361add0711253358\";s:59:\"public/assets/assets/svg/places/ic_airport_shuttle_24px.svg\";s:64:\"0615b389117c71a99d1ac6d3d22d4c4e299f106ae5307d2fbeecab1b300040d4\";s:57:\"public/assets/assets/svg/places/ic_all_inclusive_24px.svg\";s:64:\"4eeef528914c1bc78720fe1b5c7f32139166bd0d8c8d50c1494079da166e1813\";s:56:\"public/assets/assets/svg/places/ic_beach_access_24px.svg\";s:64:\"8de6baf2279778b827c9b91c4922a2768d6247e063101d969094f4fb667847e9\";s:59:\"public/assets/assets/svg/places/ic_business_center_24px.svg\";s:64:\"0b0a3b719761637240c05495f1b621bd033c48af368d70b8c3a4ecbc4be0cd00\";s:50:\"public/assets/assets/svg/places/ic_casino_24px.svg\";s:64:\"1eea8acf884ebefec936fca0bde9e6ecb235f6d1b54aed8728b0cc6bdcd76711\";s:54:\"public/assets/assets/svg/places/ic_child_care_24px.svg\";s:64:\"fd500c24ebcf200e699080c177c08ded5d607c35a8fe5051f79fef2c5bafa9f6\";s:58:\"public/assets/assets/svg/places/ic_child_friendly_24px.svg\";s:64:\"21ca7da9f2342241511e66b41acb43296e832e99a0f2eea8115dd3b817c52d8a\";s:58:\"public/assets/assets/svg/places/ic_fitness_center_24px.svg\";s:64:\"a189a5a954c1dd8a2689bb2bb620e617f1ae1f8ba2177c2eea12d5cdd56f4f15\";s:58:\"public/assets/assets/svg/places/ic_free_breakfast_24px.svg\";s:64:\"4559ed7ae22c215c73bdc839bae5adde38eab54a3318cb7b1bddc01b1b9eb17c\";s:55:\"public/assets/assets/svg/places/ic_golf_course_24px.svg\";s:64:\"a11a04580d76a17ef8e966f1ea02fbe2342ce2f1a5fb1c35bbba7a8ee64c15a6\";s:51:\"public/assets/assets/svg/places/ic_hot_tub_24px.svg\";s:64:\"1611b82df600962652d050bf2e1563895301761012a8769b77af56bf7fb0de92\";s:51:\"public/assets/assets/svg/places/ic_kitchen_24px.svg\";s:64:\"fcfa9a3d4ee79efc0e03e9f96bb95311be8341feea591e0809f88fb97dd24f0c\";s:48:\"public/assets/assets/svg/places/ic_pool_24px.svg\";s:64:\"c15f987c3543385951182fd0b525af4b00e01fccecf857111d8415eae8143c65\";s:56:\"public/assets/assets/svg/places/ic_room_service_24px.svg\";s:64:\"0b2b7982f481c6de35ca7b6913789c343be3a808bc8cf7bbd5149739edda3b03\";s:54:\"public/assets/assets/svg/places/ic_smoke_free_24px.svg\";s:64:\"91d969a9e8c3b490906e73201c5228bbff1229f40e547e4dd3c3eb7b1d65e68c\";s:57:\"public/assets/assets/svg/places/ic_smoking_rooms_24px.svg\";s:64:\"57863fc6c1c21834b1c416e43f419a243c85ddac3f390ca10370e0f7436251fe\";s:47:\"public/assets/assets/svg/places/ic_spa_24px.svg\";s:64:\"c87063487bcaaec840c542f11709144da26145b0381eeacd0ac5b08c68a66d8f\";s:48:\"public/assets/assets/svg/social/ic_cake_24px.svg\";s:64:\"7807dc4716aa3aeb1074e28bd546375c419d5ac7421d39db1ebc39877c730526\";s:50:\"public/assets/assets/svg/social/ic_domain_24px.svg\";s:64:\"8e9c8f7a170c7c8e31e3f3e2012a8e9d8ba63e99617b9e2f5a6064ab52ec89c2\";s:49:\"public/assets/assets/svg/social/ic_group_24px.svg\";s:64:\"c110bea10dff2f63fa3bd2da9e295be19721475e0848ca0a79422eb4b06f651e\";s:53:\"public/assets/assets/svg/social/ic_group_add_24px.svg\";s:64:\"99e7f96a91227e99b63914c6414e8fdf5f9f249343731c2367debea12b9174ba\";s:57:\"public/assets/assets/svg/social/ic_location_city_24px.svg\";s:64:\"e21ef38072992511457bf66f7539d193348ce9c90ddefa0db38448bc1239c408\";s:48:\"public/assets/assets/svg/social/ic_mood_24px.svg\";s:64:\"975c5664d2b367f8a033b4eba9f34c6aafbad9b0b4cd25d5e5a1b122758a848a\";s:52:\"public/assets/assets/svg/social/ic_mood_bad_24px.svg\";s:64:\"53dbf304a72ba6af32e34c5f2b6e1e79b2ddd040f4d41729c3340f1b9e165aa3\";s:57:\"public/assets/assets/svg/social/ic_notifications_24px.svg\";s:64:\"4c0f4c122621be3e94054e8146950bc1d925786d5ece13ab48cb3305e504ab34\";s:64:\"public/assets/assets/svg/social/ic_notifications_active_24px.svg\";s:64:\"831d99cb456fd15e7bba1b45e5cd8217c07b5df677e773b5b348ebd443f9ef9a\";s:62:\"public/assets/assets/svg/social/ic_notifications_none_24px.svg\";s:64:\"d3d47d3e3832b2be80ff2b96b014a8464eb1329e1f69c3f7443710d771ac634e\";s:61:\"public/assets/assets/svg/social/ic_notifications_off_24px.svg\";s:64:\"80ce6ff54e8587412b4888693b736523433daad7c073ea27b6cd56a96025f456\";s:64:\"public/assets/assets/svg/social/ic_notifications_paused_24px.svg\";s:64:\"52864efef61df051f7c7eaf21e51a70ec7a5c73eb732aa22d6a5c4a35b4fa100\";s:49:\"public/assets/assets/svg/social/ic_pages_24px.svg\";s:64:\"9e0c77ad7dde4bb3df66c9b6e8144852ebbda101ecdb75acc44a05a03ecb1649\";s:54:\"public/assets/assets/svg/social/ic_party_mode_24px.svg\";s:64:\"6ffeb0bafeb03d590ce975b59801c7be420e6adfab274d44ff09911a8dde15aa\";s:50:\"public/assets/assets/svg/social/ic_people_24px.svg\";s:64:\"c110bea10dff2f63fa3bd2da9e295be19721475e0848ca0a79422eb4b06f651e\";s:58:\"public/assets/assets/svg/social/ic_people_outline_24px.svg\";s:64:\"0627ad1ec839929e39e41f75405b04eb54060d114a5d16f34de570c0247aa2f9\";s:50:\"public/assets/assets/svg/social/ic_person_24px.svg\";s:64:\"ffdea6f91108e42ea3a7773a58789a4ae00d17fc16951c67c02361cd29aacfbf\";s:54:\"public/assets/assets/svg/social/ic_person_add_24px.svg\";s:64:\"0f54e3a55b97dc50b28150464605ed898796458d02befcfe0fcaef748e8a91ef\";s:58:\"public/assets/assets/svg/social/ic_person_outline_24px.svg\";s:64:\"4898e25f97f9ec192a657033130950a2501d4d9e3035591b0aee07cdff009d6f\";s:52:\"public/assets/assets/svg/social/ic_plus_one_24px.svg\";s:64:\"9e1c16a7396feed1c68333a54da3255f6297c9ceecde51f7887c7189476c7468\";s:48:\"public/assets/assets/svg/social/ic_poll_24px.svg\";s:64:\"251b8d550df4665af92dd66a774ae43f0f002826a4b091b86c1310a28e9e8c87\";s:50:\"public/assets/assets/svg/social/ic_public_24px.svg\";s:64:\"248fd4e58679a1adf37fe84451200807d8165ac3f2205cf8012e7a7d1454093c\";s:50:\"public/assets/assets/svg/social/ic_school_24px.svg\";s:64:\"dc1fd5e849487a9fe12feb5a3ffa4e5673a7a3872970bb9165b8a3ddd7b1ed35\";s:49:\"public/assets/assets/svg/social/ic_share_24px.svg\";s:64:\"b9661b194d213f72676b7e558f22a5470997b4f1e909cd4c103a7626149d1d57\";s:52:\"public/assets/assets/svg/social/ic_whatshot_24px.svg\";s:64:\"bceb20a8e489c7b415f2f0b73e818434d06992f247182a4ef8394faa20180b87\";s:53:\"public/assets/assets/svg/toggle/ic_check_box_24px.svg\";s:64:\"1b24ce514b9197e1fa046ee3cd440d4e90fdc2939c55f031bf19b6fa18fd090e\";s:67:\"public/assets/assets/svg/toggle/ic_check_box_outline_blank_24px.svg\";s:64:\"3080f6ead1244d6c0ed79481f7467109f1a6648e1c7d03f090715d8c828ce8b2\";s:67:\"public/assets/assets/svg/toggle/ic_indeterminate_check_box_24px.svg\";s:64:\"fc5d4fb68f3c9e0687bbc424194d61ce9902725d36cb3d647a8107eb898e7f8b\";s:64:\"public/assets/assets/svg/toggle/ic_radio_button_checked_24px.svg\";s:64:\"378662ea874451111a91a69b0df9b6c598e9f9408bc101a95ae44147223c6805\";s:66:\"public/assets/assets/svg/toggle/ic_radio_button_unchecked_24px.svg\";s:64:\"86b71e4b7190e7e4f11baf8fa051c9924154947e9512d4a4f3b41589337cae45\";s:48:\"public/assets/assets/svg/toggle/ic_star_24px.svg\";s:64:\"831a2d3bc08e707d81bcc14c883e3142e7fc0c29237aa18efd0942f5477de5f3\";s:55:\"public/assets/assets/svg/toggle/ic_star_border_24px.svg\";s:64:\"2b11172c0bc99e56230843bafd585be7f6fe24a2ac965a8838ef7542da3a1e2a\";s:53:\"public/assets/assets/svg/toggle/ic_star_half_24px.svg\";s:64:\"cd04fe9f671c9b1384b6908bac60ea2b7bb8da2ea265d2e52b62eea9a4a2adc5\";s:39:\"public/assets/css/captions-original.css\";s:64:\"8cb3f52aecde43da5f8e7a35916b85490c02f7d2dbcaef9324e8f75fbacf30d2\";s:32:\"public/assets/css/closedhand.cur\";s:64:\"d367ee0a4c16c7cebfdbf92c97a72ff63878e7f8be176ac8c5ede75a2265ec52\";s:27:\"public/assets/css/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:30:\"public/assets/css/openhand.cur\";s:64:\"080627fa359156339e79f118fa66a6937f09ff679fe87e8afa473b95c8168d35\";s:25:\"public/assets/css/rs6.css\";s:64:\"9883e503c2916e2bfa5aff13d031f28e0ca6124cf47ac81dc8013efe4e5d702c\";s:29:\"public/assets/fonts/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:42:\"public/assets/fonts/font-awesome/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:53:\"public/assets/fonts/font-awesome/css/font-awesome.css\";s:64:\"7cfd0c8f8464a7b46db267b79a793db18abed3247065a29933440eab1db6a8f9\";s:54:\"public/assets/fonts/font-awesome/fonts/FontAwesome.otf\";s:64:\"444dd4366615ffc4a16d012b2fa90137065d3ccb410fa6fd5e4ddd7b5e4ffcd5\";s:62:\"public/assets/fonts/font-awesome/fonts/fontawesome-webfont.eot\";s:64:\"7bfcab6db99d5cfbf1705ca0536ddc78585432cc5fa41bbd7ad0f009033b2979\";s:62:\"public/assets/fonts/font-awesome/fonts/fontawesome-webfont.svg\";s:64:\"ad6157926c1622ba4e1d03d478f1541368524bfc46f51e42fe0d945f7ef323e4\";s:62:\"public/assets/fonts/font-awesome/fonts/fontawesome-webfont.ttf\";s:64:\"aa58f33f239a0fb02f5c7a6c45c043d7a9ac9a093335806694ecd6d4edc0d6a8\";s:63:\"public/assets/fonts/font-awesome/fonts/fontawesome-webfont.woff\";s:64:\"ba0c59deb5450f5cb41b3f93609ee2d0d995415877ddfa223e8a8a7533474f07\";s:64:\"public/assets/fonts/font-awesome/fonts/fontawesome-webfont.woff2\";s:64:\"2adefcbc041e7d18fcf2d417879dc5a09997aa64d675b7a3c4b6ce33da13f3fe\";s:54:\"public/assets/fonts/material/MaterialIcons-Regular.eot\";s:64:\"8c998b4a9c0acbb9fe5dd572c206a5a33fdd5ca2b58db87fc3b893beac85068d\";s:56:\"public/assets/fonts/material/MaterialIcons-Regular.ijmap\";s:64:\"88182029715624355dbc49c97b3af61e311538ddd33d31c6f4d13b2937411d1d\";s:54:\"public/assets/fonts/material/MaterialIcons-Regular.svg\";s:64:\"8b922129360ee12051269278e95ccff05ab4a60ccd39b9117f8216ede63a91c0\";s:54:\"public/assets/fonts/material/MaterialIcons-Regular.ttf\";s:64:\"b7f4a3ab562048f28dd1fa691601bc43363a61d0f876d16d8316c52e4f32d696\";s:55:\"public/assets/fonts/material/MaterialIcons-Regular.woff\";s:64:\"c4a1baec300d09e03a8380b85918267ee80faae8e00c6c56b48e2e74b1d9b38d\";s:56:\"public/assets/fonts/material/MaterialIcons-Regular.woff2\";s:64:\"a87d66c91b2e7dc5530aef76c03bd6a3d25ea5826110bf4803b561b811cc8726\";s:38:\"public/assets/fonts/material/README.md\";s:64:\"402d2770ce34261fff627b7ca12775ad286be2d1e49a934d4bb9383139761ad2\";s:39:\"public/assets/fonts/material/codepoints\";s:64:\"dc0a89e73a83c4a4eeb14b9ae5a7bccb76f01fee1b13b243bfe9b266a249fc2d\";s:47:\"public/assets/fonts/material/material-icons.css\";s:64:\"afb727c828f3957ada8e546f9bce9c9c733bc1d2f09a83eb47f2114302cd9f2b\";s:46:\"public/assets/fonts/pe-icon-7-stroke/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:51:\"public/assets/fonts/pe-icon-7-stroke/css/helper.css\";s:64:\"9f41a375c19572ca63f812b33972ab31a732dc51a3e2a2995d7ef4ac54a48542\";s:50:\"public/assets/fonts/pe-icon-7-stroke/css/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:61:\"public/assets/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css\";s:64:\"2121cf9366471712b8e93a1556848845b41507038288a68a667858d7a6a1178d\";s:63:\"public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.eot\";s:64:\"d9896922379aeb729a67c4bc12f2a51ee970c37ea079ee30f856fd2807fd3e9c\";s:63:\"public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.svg\";s:64:\"c869015d0bb7dc8dcc4bb372e60bee655a14199f6d370d12d762295ac7de721b\";s:63:\"public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.ttf\";s:64:\"99620ded1c4d61277630422146e2488b1afaef9be2dc0924ff3f75e2ecd71820\";s:64:\"public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.woff\";s:64:\"6fb4217048f333e23e0fd0ba2ab05e05fd7500f86a5a80a7cf04a2f94b257bec\";s:52:\"public/assets/fonts/pe-icon-7-stroke/fonts/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:38:\"public/assets/fonts/revicons/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:41:\"public/assets/fonts/revicons/revicons.eot\";s:64:\"9e4d4c6813568fdf70c61eca9446d1bb80f84e79e8f2e5ed177365b6d5de5fbf\";s:41:\"public/assets/fonts/revicons/revicons.svg\";s:64:\"80576a94aba7e5b97d33a3ebb50c0e656b2d8458a0ca38978216687f07d7a575\";s:41:\"public/assets/fonts/revicons/revicons.ttf\";s:64:\"4ca02b8a5c8034de8ddb76e33e50e8398758a83bd18a5073493cace46362780a\";s:42:\"public/assets/fonts/revicons/revicons.woff\";s:64:\"f7b9c3065e55fa3b9e320093612e7b30dcb14355a44ec461247b495a3e729686\";s:26:\"public/assets/js/index.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:40:\"public/assets/js/revolution.tools.min.js\";s:64:\"b7d24689b53d1b6aaf85a6aba13c1b9cd5bf0134c8cb0f8e666a0e71307961cf\";s:27:\"public/assets/js/rs6.min.js\";s:64:\"af3b949552b097c081fa4e8eef83f48fa62626b632de0d0027332733159c1c54\";s:42:\"public/includes/functions-public.class.php\";s:64:\"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855\";s:40:\"public/views/revslider-page-template.php\";s:64:\"955ddf273779cb261daf7e20ed4559986e2f4299c0c4644131aded0e367dc65b\";}s:4:\"time\";i:1581254182;}', 0),
 ('_activated', 0, 'a:3:{s:7:\"Version\";s:5:\"8.5.8\";s:4:\"time\";i:1581253928;s:4:\"user\";i:1;}', 0),
 ('cerber_user', 1, 'a:2:{s:10:\"last_login\";a:2:{s:2:\"ip\";s:13:\"190.75.83.206\";s:2:\"ua\";s:40:\"9f5da5cbbed810ff927fd5644f943514eb5a2e6d\";}s:11:\"2fa_history\";a:2:{i:0;i:7;i:1;i:1583409905;}}', 0),
 ('garbage_collector', 0, '1597163483', 0),
 ('cerber_admin_wide', 0, '', 0),
 ('refresh_add_on_list', 0, '0', 0),
 ('boot_cerber_addons', 0, 'a:0:{}', 0);

/* INSERT TABLE DATA: wp8b_cerber_uss */
INSERT INTO `wp8b_cerber_uss` VALUES(1, '186.167.250.237', '', 1597070585, 1597243385, 'w7ZpzASQUagKVdmCfjI6nbBu', 'b3c51eecdf892119f1305a2d40f43e5c9068aea8642578317dd20b9142d3916d'),
 (1, '190.75.83.206', '', 1597160241, 1597333041, 'fagAwJ5cskuKC721mEdIMNUq', 'c0413d98d51b1172459159e8ec41010d585c9919b40ce4d59d968f24fab8648c');

/* INSERT TABLE DATA: wp8b_comments */
INSERT INTO `wp8b_comments` VALUES(1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2020-01-06 12:44:36', '2020-01-06 12:44:36', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.', 0, '1', '', '', 0, 0);

/* INSERT TABLE DATA: wp8b_duplicator_pro_entities */
INSERT INTO `wp8b_duplicator_pro_entities` VALUES(1, 'DUP_PRO_Global_Entity', '{\"uninstall_settings\":false,\"uninstall_packages\":false,\"uninstall_tables\":true,\"wpfront_integrate\":false,\"package_ui_created\":1,\"package_mysqldump\":0,\"package_mysqldump_path\":\"\",\"package_phpdump_mode\":0,\"package_phpdump_qrylimit\":500,\"package_php_chunking\":null,\"archive_build_mode\":2,\"archive_compression\":true,\"ziparchive_validation\":null,\"ziparchive_mode\":0,\"ziparchive_chunk_size_in_mb\":6,\"archive_build_mode_schedule\":-1,\"archive_compression_schedule\":true,\"server_load_reduction\":0,\"max_package_runtime_in_min\":90,\"php_max_worker_time_in_sec\":18,\"lock_mode\":1,\"json_mode\":0,\"ajax_protocol\":\"https\",\"custom_ajax_url\":\"http:\\/\\/modelox.vico.digital\\/wp-admin\\/admin-ajax.php\",\"server_kick_off_sslverify\":true,\"clientside_kickoff\":false,\"basic_auth_enabled\":false,\"basic_auth_user\":\"\",\"basic_auth_password\":\"\",\"installer_base_name\":\"installer.php\",\"chunk_size\":2048,\"skip_archive_scan\":false,\"send_email_on_build_mode\":1,\"notification_email_address\":\"\",\"storage_htaccess_off\":false,\"max_storage_retries\":10,\"max_default_store_files\":20,\"purge_default_package_record\":false,\"dropbox_upload_chunksize_in_kb\":2000,\"dropbox_transfer_mode\":1,\"gdrive_upload_chunksize_in_kb\":1000,\"s3_upload_part_size_in_kb\":6000,\"manual_mode_storage_ids\":[\"7\"],\"license_status\":0,\"license_expiration_time\":1578315559,\"license_no_activations_left\":false,\"license_key_visible\":true,\"lkp\":\"\",\"license_limit\":-1,\"last_edd_api_response\":null,\"last_edd_api_timestamp\":0,\"last_system_check_timestamp\":1597159999,\"initial_activation_timestamp\":1578315569,\"ssl_useservercerts\":true,\"ssl_disableverify\":true,\"ipv4_only\":false,\"debug_on\":false,\"trace_profiler_on\":false,\"profile_idea\":false,\"profile_beta\":false,\"dupHidePackagesGiftFeatures\":true,\"type\":\"DUP_PRO_Global_Entity\",\"notices\":{\"dupArchiveSwitch\":true}}'),
 (2, 'DUP_PRO_Secure_Global_Entity', '{\"basic_auth_password\":null,\"lkp\":\"\",\"type\":\"DUP_PRO_Secure_Global_Entity\"}'),
 (3, 'DUP_PRO_System_Global_Entity', '{\"recommended_fixes\":[],\"schedule_failed\":false,\"package_check_ts\":1597163482,\"type\":\"DUP_PRO_System_Global_Entity\"}'),
 (4, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}'),
 (5, 'DUP_PRO_Package_Template_Entity', '{\"name\":\"[Manual Mode]\",\"notes\":\"\",\"filter_sites\":\"\",\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":\"\",\"installer_opts_secure_on\":0,\"installer_opts_secure_pass\":\"\",\"installer_opts_skip_scan\":0,\"installer_opts_db_host\":\"\",\"installer_opts_db_name\":\"\",\"installer_opts_db_user\":\"\",\"installer_opts_cpnl_enable\":0,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":false,\"is_manual\":true,\"type\":\"DUP_PRO_Package_Template_Entity\"}'),
 (6, 'DUP_PRO_Storage_Entity', '{\"name\":\"Servidor Compralo\",\"notes\":\"\",\"storage_type\":\"2\",\"editable\":true,\"local_storage_folder\":\"\",\"local_max_files\":\"10\",\"local_filter_protection\":true,\"dropbox_access_token\":\"\",\"dropbox_access_token_secret\":\"\",\"dropbox_v2_access_token\":\"\",\"dropbox_storage_folder\":\"modelox.vico.digital\\/\",\"dropbox_max_files\":\"10\",\"dropbox_authorization_state\":0,\"onedrive_endpoint_url\":\"\",\"onedrive_resource_id\":\"\",\"onedrive_access_token\":\"\",\"onedrive_refresh_token\":\"\",\"onedrive_token_obtained\":\"\",\"onedrive_user_id\":\"\",\"onedrive_storage_folder\":\"modelox.vico.digital\\/\",\"onedrive_max_files\":\"10\",\"onedrive_storage_folder_id\":\"\",\"onedrive_authorization_state\":0,\"onedrive_storage_folder_web_url\":\"\",\"ftp_server\":\"51.91.128.199\",\"ftp_port\":\"21\",\"ftp_username\":\"compralo\",\"ftp_password\":\"WEBnet2020&%$\",\"ftp_storage_folder\":\"\\/desde_modelox\\/\",\"ftp_max_files\":\"10\",\"ftp_timeout_in_secs\":\"15\",\"ftp_ssl\":false,\"ftp_passive_mode\":false,\"sftp_server\":\"\",\"sftp_port\":22,\"sftp_username\":\"\",\"sftp_password\":\"\",\"sftp_private_key\":\"\",\"sftp_private_key_password\":\"\",\"sftp_storage_folder\":\"\\/\",\"sftp_timeout_in_secs\":15,\"sftp_max_files\":10,\"gdrive_access_token_set_json\":\"\",\"gdrive_refresh_token\":\"\",\"gdrive_storage_folder\":\"Duplicator Backups\\/modelox.vico.digital\\/\",\"gdrive_max_files\":\"10\",\"gdrive_authorization_state\":0,\"quick_connect\":false,\"s3_access_key\":\"\",\"s3_bucket\":\"\",\"s3_max_files\":\"10\",\"s3_provider\":\"amazon\",\"s3_region\":\"us-east-1\",\"s3_endpoint\":\"\",\"s3_secret_key\":\"\",\"s3_storage_class\":\"STANDARD\",\"s3_storage_folder\":\"Duplicator Backups\\/modelox.vico.digital\\/\",\"type\":\"DUP_PRO_Storage_Entity\"}'),
 (7, 'DUP_PRO_Storage_Entity', '{\"name\":\"iglesia uni\",\"notes\":\"\",\"storage_type\":\"2\",\"editable\":true,\"local_storage_folder\":\"\",\"local_max_files\":\"10\",\"local_filter_protection\":true,\"dropbox_access_token\":\"\",\"dropbox_access_token_secret\":\"\",\"dropbox_v2_access_token\":\"\",\"dropbox_storage_folder\":\"modelox.vico.digital\\/\",\"dropbox_max_files\":\"10\",\"dropbox_authorization_state\":0,\"onedrive_endpoint_url\":\"\",\"onedrive_resource_id\":\"\",\"onedrive_access_token\":\"\",\"onedrive_refresh_token\":\"\",\"onedrive_token_obtained\":\"\",\"onedrive_user_id\":\"\",\"onedrive_storage_folder\":\"modelox.vico.digital\\/\",\"onedrive_max_files\":\"10\",\"onedrive_storage_folder_id\":\"\",\"onedrive_authorization_state\":0,\"onedrive_storage_folder_web_url\":\"\",\"ftp_server\":\"51.91.128.199\",\"ftp_port\":\"21\",\"ftp_username\":\"promo\",\"ftp_password\":\"WEBnet2020$%&\",\"ftp_storage_folder\":\"\\/archivoiglesia\\/\",\"ftp_max_files\":\"10\",\"ftp_timeout_in_secs\":\"15\",\"ftp_ssl\":false,\"ftp_passive_mode\":false,\"sftp_server\":\"\",\"sftp_port\":22,\"sftp_username\":\"\",\"sftp_password\":\"\",\"sftp_private_key\":\"\",\"sftp_private_key_password\":\"\",\"sftp_storage_folder\":\"\\/\",\"sftp_timeout_in_secs\":15,\"sftp_max_files\":10,\"gdrive_access_token_set_json\":\"\",\"gdrive_refresh_token\":\"\",\"gdrive_storage_folder\":\"Duplicator Backups\\/modelox.vico.digital\\/\",\"gdrive_max_files\":\"10\",\"gdrive_authorization_state\":0,\"quick_connect\":false,\"s3_access_key\":\"\",\"s3_bucket\":\"\",\"s3_max_files\":\"10\",\"s3_provider\":\"amazon\",\"s3_region\":\"us-east-1\",\"s3_endpoint\":\"\",\"s3_secret_key\":\"\",\"s3_storage_class\":\"STANDARD\",\"s3_storage_folder\":\"Duplicator Backups\\/modelox.vico.digital\\/\",\"type\":\"DUP_PRO_Storage_Entity\"}'),
 (8, 'DUP_PRO_DupArchive_Expand_State_Entity', '{\"package_id\":\"1\",\"basePath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\\/validate\",\"archivePath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\\/20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_archive.daf\",\"isCompressed\":true,\"currentFileOffset\":0,\"archiveOffset\":75181799,\"timeSliceInSecs\":10,\"working\":false,\"startTimestamp\":-1,\"throttleDelayInUs\":0,\"timeoutTimestamp\":1597161481,\"timerEnabled\":true,\"archiveHeaderString\":\"{\\\"version\\\":\\\"3.8.3.4\\\",\\\"isCompressed\\\":true}\",\"currentFileHeaderString\":null,\"failuresString\":\"[]\",\"validateOnly\":true,\"validationType\":1,\"fileWriteCount\":11482,\"directoryWriteCount\":1669,\"expectedFileCount\":11482,\"expectedDirectoryCount\":1669,\"isRobust\":false,\"type\":\"DUP_PRO_DupArchive_Expand_State_Entity\",\"currentFileHeader\":null,\"filteredDirectories\":[],\"filteredFiles\":[],\"includedFiles\":[],\"fileRenames\":[],\"directoryModeOverride\":-1,\"fileModeOverride\":-1,\"lastHeaderOffset\":-1,\"failures\":[]}');

/* INSERT TABLE DATA: wp8b_duplicator_pro_packages */
INSERT INTO `wp8b_duplicator_pro_packages` VALUES(1, '20200811_iglesiauniversitaria', 'ef8410f93c0e1aad7216_20200811155327', 100, '2020-08-11 15:54:32', 'unknown', '{\"Created\":\"2020-08-11 15:53:27\",\"Version\":\"3.8.3.4\",\"VersionWP\":\"5.4.2\",\"VersionDB\":\"5.7.31\",\"VersionPHP\":\"7.2.32\",\"VersionOS\":\"Linux\",\"ID\":\"1\",\"Name\":\"20200811_iglesiauniversitaria\",\"Hash\":\"ef8410f93c0e1aad7216_20200811155327\",\"NameHash\":\"20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/modelox.vico.digital\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_scan.json\",\"timer_start\":1597161288.3775470256805419921875,\"Runtime\":\"185.605 sec.\",\"ExeSize\":\"225.33KB\",\"ZipSize\":\"71.7MB\",\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/ai1wm-backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backupwordpress\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/contents\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/managewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/old-cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/updraft\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wfcache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wishlist-backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/zn_fonts\\/icomoon\\/icomoon\\/selection.json\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_archive.daf\",\"Format\":\"DAF\",\"PackDir\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"Size\":75181799,\"Dirs\":null,\"DirCount\":1649,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":11325,\"file_count\":12974,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/ai1wm-backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backupwordpress\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/contents\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/managewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/old-cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/updraft\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wishlist-backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wfcache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/zn_fonts\\/icomoon\\/icomoon\\/selection.json\"],\"Size\":[],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"modelox\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"isDir\":true,\"childs\":{\"wp-blog-header.php\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"error_log\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-signup.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"cgi-bin\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"wp-config.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\"},\"TreeWarning\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"modelox\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"isDir\":true,\"childs\":{\"wp-blog-header.php\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"error_log\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-signup.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"cgi-bin\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"wp-config.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\"}},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false,\"wpContentDirNormalizePath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/\"},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_installer.php\",\"Size\":230742,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":156,\"numDirsAdded\":21},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8_general_ci\",\"utf8mb4_unicode_520_ci\",\"utf8mb4_unicode_ci\",\"latin1_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"vicodigi_wp642\",\"tablesBaseCount\":110,\"tablesFinalCount\":110,\"tablesRowCount\":31219,\"tablesSizeOnDisk\":8942363,\"varLowerCaseTables\":\"0\",\"version\":\"5.7.31\",\"versionComment\":\"MySQL Community Server - (GPL)\",\"tableWiseRowCounts\":{\"cerber_acl\":\"1\",\"cerber_blocks\":\"0\",\"cerber_countries\":\"0\",\"cerber_lab\":\"0\",\"cerber_lab_ip\":\"0\",\"cerber_lab_net\":\"0\",\"cerber_log\":\"31\",\"cerber_qmem\":\"0\",\"cerber_traffic\":\"321\",\"wp8b_actionscheduler_actions\":\"1\",\"wp8b_actionscheduler_claims\":\"0\",\"wp8b_actionscheduler_groups\":\"1\",\"wp8b_actionscheduler_logs\":\"3\",\"wp8b_booking\":\"1\",\"wp8b_bookingdates\":\"3\",\"wp8b_cerber_files\":\"0\",\"wp8b_cerber_sets\":\"11\",\"wp8b_cerber_uss\":\"2\",\"wp8b_commentmeta\":\"0\",\"wp8b_comments\":\"1\",\"wp8b_cuteslider\":\"0\",\"wp8b_duplicator_pro_entities\":\"7\",\"wp8b_duplicator_pro_packages\":\"1\",\"wp8b_hotel_booking_order_itemmeta\":\"0\",\"wp8b_hotel_booking_order_items\":\"0\",\"wp8b_hotel_booking_plans\":\"0\",\"wp8b_links\":\"0\",\"wp8b_mailchimp_carts\":\"0\",\"wp8b_mailchimp_jobs\":\"0\",\"wp8b_mp_timetable_data\":\"0\",\"wp8b_mphb_sync_logs\":\"0\",\"wp8b_mphb_sync_queue\":\"0\",\"wp8b_mphb_sync_stats\":\"0\",\"wp8b_mphb_sync_urls\":\"0\",\"wp8b_options\":\"443\",\"wp8b_postmeta\":\"559\",\"wp8b_posts\":\"48\",\"wp8b_revslider_css\":\"116\",\"wp8b_revslider_css_bkp\":\"47\",\"wp8b_revslider_layer_animations\":\"1\",\"wp8b_revslider_layer_animations_bkp\":\"1\",\"wp8b_revslider_navigations\":\"0\",\"wp8b_revslider_navigations_bkp\":\"5\",\"wp8b_revslider_sliders\":\"1\",\"wp8b_revslider_sliders_bkp\":\"1\",\"wp8b_revslider_slides\":\"9\",\"wp8b_revslider_slides_bkp\":\"2\",\"wp8b_revslider_static_slides\":\"1\",\"wp8b_revslider_static_slides_bkp\":\"4\",\"wp8b_sbi_instagram_feeds_posts\":\"0\",\"wp8b_sbi_instagram_posts\":\"0\",\"wp8b_term_relationships\":\"36\",\"wp8b_term_taxonomy\":\"24\",\"wp8b_termmeta\":\"10\",\"wp8b_terms\":\"24\",\"wp8b_tinvwl_analytics\":\"0\",\"wp8b_tinvwl_items\":\"0\",\"wp8b_tinvwl_lists\":\"1\",\"wp8b_usermeta\":\"24\",\"wp8b_users\":\"1\",\"wp8b_wc_admin_note_actions\":\"5\",\"wp8b_wc_admin_notes\":\"5\",\"wp8b_wc_category_lookup\":\"1\",\"wp8b_wc_customer_lookup\":\"1\",\"wp8b_wc_download_log\":\"0\",\"wp8b_wc_order_coupon_lookup\":\"0\",\"wp8b_wc_order_product_lookup\":\"1\",\"wp8b_wc_order_stats\":\"1\",\"wp8b_wc_order_tax_lookup\":\"0\",\"wp8b_wc_product_meta_lookup\":\"0\",\"wp8b_wc_reserved_stock\":\"0\",\"wp8b_wc_tax_rate_classes\":\"2\",\"wp8b_wc_webhooks\":\"0\",\"wp8b_wdi_feeds\":\"0\",\"wp8b_wdi_themes\":\"2\",\"wp8b_wfblockediplog\":\"0\",\"wp8b_wfblocks7\":\"0\",\"wp8b_wfconfig\":\"253\",\"wp8b_wfcrawlers\":\"0\",\"wp8b_wffilechanges\":\"0\",\"wp8b_wffilemods\":\"14077\",\"wp8b_wfhits\":\"3\",\"wp8b_wfhoover\":\"0\",\"wp8b_wfissues\":\"0\",\"wp8b_wfknownfilelist\":\"14077\",\"wp8b_wflivetraffichuman\":\"0\",\"wp8b_wflocs\":\"1\",\"wp8b_wflogins\":\"12\",\"wp8b_wfls_2fa_secrets\":\"0\",\"wp8b_wfls_settings\":\"19\",\"wp8b_wfnotifications\":\"11\",\"wp8b_wfpendingissues\":\"0\",\"wp8b_wfreversecache\":\"1\",\"wp8b_wfsnipcache\":\"0\",\"wp8b_wfstatus\":\"1007\",\"wp8b_wftrafficrates\":\"0\",\"wp8b_woocommerce_api_keys\":\"0\",\"wp8b_woocommerce_attribute_taxonomies\":\"0\",\"wp8b_woocommerce_downloadable_product_permissions\":\"0\",\"wp8b_woocommerce_log\":\"0\",\"wp8b_woocommerce_order_itemmeta\":\"0\",\"wp8b_woocommerce_order_items\":\"0\",\"wp8b_woocommerce_payment_tokenmeta\":\"0\",\"wp8b_woocommerce_payment_tokens\":\"0\",\"wp8b_woocommerce_sessions\":\"1\",\"wp8b_woocommerce_shipping_zone_locations\":\"0\",\"wp8b_woocommerce_shipping_zone_methods\":\"0\",\"wp8b_woocommerce_shipping_zones\":\"0\",\"wp8b_woocommerce_tax_rate_locations\":\"0\",\"wp8b_woocommerce_tax_rates\":\"0\"}},\"Type\":\"MySQL\",\"Size\":8283761,\"File\":\"20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":\"\",\"Comments\":\"MySQL Community Server - (GPL)\",\"dbStorePathPublic\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\\/20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,2100,3124,4148,5172,6196,7220,14984,16008,128096,147760,150846,160102,164974,167222,169336,171384,390724,393032,397128,405640,406664,422960,444960,445984,447008,448032,449056,451104,452128,453152,454176,455200,456224,457248,3037500,3259584,3291812,3391864,3407856,3410072,3412292,3413316,3427264,3440644,3449208,3494804,3546008,3568428,3570704,3572752,3573776,3577604,3582712,3593372,3607536,3608560,3609584,3611680,3623820,3632120,3635848,3639204,3641269,3647493,3648517,3649541,3655783,3667115,3668139,3670187,3671211,3680499,3681523,3682547,3689167,3690191,3691215,4369823,4370847,4371871,7269823,7275763,7276787,7286015,8752863,8753887,8756071,8762187,8794955,8811339,8815111,8816135,8818279,8819303,8943547,8944571,8946619,8947643,8948667,8949691,8950715,8951739,8952763,8953787,8958219,8959243,8960267,8961291,8962315]},\"Status\":100,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1597161473,\"initialized\":true,\"installer_built\":true,\"archive_started\":true,\"archive_has_database\":false,\"archive_built\":true,\"database_script_built\":true,\"failed\":false,\"next_archive_file_index\":11327,\"next_archive_dir_index\":1650,\"retries\":0,\"current_build_mode\":3,\"current_build_compression\":true,\"custom_data\":{\"archive_path\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\\/20200811_iglesiauniversitaria_ef8410f93c0e1aad7216_20200811155327_archive.daf\",\"time_slice_in_secs\":10,\"base_path\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"glob_size\":1048576,\"archive_offset\":73574173,\"failures\":[{\"type\":1,\"description\":\"Couldn\'t open \",\"subject\":\"\",\"isCritical\":false}],\"working\":false,\"is_compressed\":true,\"current_file_offset\":0,\"throttle_delay_in_us\":0,\"skipped_directory_count\":2,\"skipped_file_count\":1},\"warnings\":[\" : Couldn\'t open \"]},\"db_build_progress\":{\"tableIndex\":109,\"tableOffset\":0,\"totalRowOffset\":31222,\"chunkIndex\":1,\"validationStage1\":true,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":true,\"tablesToProcess\":[\"cerber_acl\",\"cerber_blocks\",\"cerber_countries\",\"cerber_lab\",\"cerber_lab_ip\",\"cerber_lab_net\",\"cerber_log\",\"cerber_qmem\",\"cerber_traffic\",\"wp8b_actionscheduler_actions\",\"wp8b_actionscheduler_claims\",\"wp8b_actionscheduler_groups\",\"wp8b_actionscheduler_logs\",\"wp8b_booking\",\"wp8b_bookingdates\",\"wp8b_cerber_files\",\"wp8b_cerber_sets\",\"wp8b_cerber_uss\",\"wp8b_commentmeta\",\"wp8b_comments\",\"wp8b_cuteslider\",\"wp8b_duplicator_pro_entities\",\"wp8b_duplicator_pro_packages\",\"wp8b_hotel_booking_order_itemmeta\",\"wp8b_hotel_booking_order_items\",\"wp8b_hotel_booking_plans\",\"wp8b_links\",\"wp8b_mailchimp_carts\",\"wp8b_mailchimp_jobs\",\"wp8b_mp_timetable_data\",\"wp8b_mphb_sync_logs\",\"wp8b_mphb_sync_queue\",\"wp8b_mphb_sync_stats\",\"wp8b_mphb_sync_urls\",\"wp8b_options\",\"wp8b_postmeta\",\"wp8b_posts\",\"wp8b_revslider_css\",\"wp8b_revslider_css_bkp\",\"wp8b_revslider_layer_animations\",\"wp8b_revslider_layer_animations_bkp\",\"wp8b_revslider_navigations\",\"wp8b_revslider_navigations_bkp\",\"wp8b_revslider_sliders\",\"wp8b_revslider_sliders_bkp\",\"wp8b_revslider_slides\",\"wp8b_revslider_slides_bkp\",\"wp8b_revslider_static_slides\",\"wp8b_revslider_static_slides_bkp\",\"wp8b_sbi_instagram_feeds_posts\",\"wp8b_sbi_instagram_posts\",\"wp8b_term_relationships\",\"wp8b_term_taxonomy\",\"wp8b_termmeta\",\"wp8b_terms\",\"wp8b_tinvwl_analytics\",\"wp8b_tinvwl_items\",\"wp8b_tinvwl_lists\",\"wp8b_usermeta\",\"wp8b_users\",\"wp8b_wc_admin_note_actions\",\"wp8b_wc_admin_notes\",\"wp8b_wc_category_lookup\",\"wp8b_wc_customer_lookup\",\"wp8b_wc_download_log\",\"wp8b_wc_order_coupon_lookup\",\"wp8b_wc_order_product_lookup\",\"wp8b_wc_order_stats\",\"wp8b_wc_order_tax_lookup\",\"wp8b_wc_product_meta_lookup\",\"wp8b_wc_reserved_stock\",\"wp8b_wc_tax_rate_classes\",\"wp8b_wc_webhooks\",\"wp8b_wdi_feeds\",\"wp8b_wdi_themes\",\"wp8b_wfblockediplog\",\"wp8b_wfblocks7\",\"wp8b_wfconfig\",\"wp8b_wfcrawlers\",\"wp8b_wffilechanges\",\"wp8b_wffilemods\",\"wp8b_wfhits\",\"wp8b_wfhoover\",\"wp8b_wfissues\",\"wp8b_wfknownfilelist\",\"wp8b_wflivetraffichuman\",\"wp8b_wflocs\",\"wp8b_wflogins\",\"wp8b_wfls_2fa_secrets\",\"wp8b_wfls_settings\",\"wp8b_wfnotifications\",\"wp8b_wfpendingissues\",\"wp8b_wfreversecache\",\"wp8b_wfsnipcache\",\"wp8b_wfstatus\",\"wp8b_wftrafficrates\",\"wp8b_woocommerce_api_keys\",\"wp8b_woocommerce_attribute_taxonomies\",\"wp8b_woocommerce_downloadable_product_permissions\",\"wp8b_woocommerce_log\",\"wp8b_woocommerce_order_itemmeta\",\"wp8b_woocommerce_order_items\",\"wp8b_woocommerce_payment_tokenmeta\",\"wp8b_woocommerce_payment_tokens\",\"wp8b_woocommerce_sessions\",\"wp8b_woocommerce_shipping_zone_locations\",\"wp8b_woocommerce_shipping_zone_methods\",\"wp8b_woocommerce_shipping_zones\",\"wp8b_woocommerce_tax_rate_locations\",\"wp8b_woocommerce_tax_rates\"],\"startTime\":1597161288.384251117706298828125,\"fileOffset\":8283761,\"wasInterrupted\":false,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":8963339,\"tablesSchemaSizes\":{\"cerber_acl\":2100,\"cerber_blocks\":1024,\"cerber_countries\":1024,\"cerber_lab\":1024,\"cerber_lab_ip\":1024,\"cerber_lab_net\":1024,\"cerber_log\":7764,\"cerber_qmem\":1024,\"cerber_traffic\":112088,\"wp8b_actionscheduler_actions\":19664,\"wp8b_actionscheduler_claims\":3086,\"wp8b_actionscheduler_groups\":9256,\"wp8b_actionscheduler_logs\":4872,\"wp8b_booking\":2248,\"wp8b_bookingdates\":2114,\"wp8b_cerber_files\":2048,\"wp8b_cerber_sets\":219340,\"wp8b_cerber_uss\":2308,\"wp8b_commentmeta\":4096,\"wp8b_comments\":8512,\"wp8b_cuteslider\":1024,\"wp8b_duplicator_pro_entities\":16296,\"wp8b_duplicator_pro_packages\":22000,\"wp8b_hotel_booking_order_itemmeta\":1024,\"wp8b_hotel_booking_order_items\":1024,\"wp8b_hotel_booking_plans\":1024,\"wp8b_links\":1024,\"wp8b_mailchimp_carts\":2048,\"wp8b_mailchimp_jobs\":1024,\"wp8b_mp_timetable_data\":1024,\"wp8b_mphb_sync_logs\":1024,\"wp8b_mphb_sync_queue\":1024,\"wp8b_mphb_sync_stats\":1024,\"wp8b_mphb_sync_urls\":1024,\"wp8b_options\":2580252,\"wp8b_postmeta\":222084,\"wp8b_posts\":32228,\"wp8b_revslider_css\":100052,\"wp8b_revslider_css_bkp\":15992,\"wp8b_revslider_layer_animations\":2216,\"wp8b_revslider_layer_animations_bkp\":2220,\"wp8b_revslider_navigations\":1024,\"wp8b_revslider_navigations_bkp\":13948,\"wp8b_revslider_sliders\":13380,\"wp8b_revslider_sliders_bkp\":8564,\"wp8b_revslider_slides\":45596,\"wp8b_revslider_slides_bkp\":51204,\"wp8b_revslider_static_slides\":22420,\"wp8b_revslider_static_slides_bkp\":2276,\"wp8b_sbi_instagram_feeds_posts\":2048,\"wp8b_sbi_instagram_posts\":1024,\"wp8b_term_relationships\":3828,\"wp8b_term_taxonomy\":5108,\"wp8b_termmeta\":10660,\"wp8b_terms\":14164,\"wp8b_tinvwl_analytics\":1024,\"wp8b_tinvwl_items\":1024,\"wp8b_tinvwl_lists\":2096,\"wp8b_usermeta\":12140,\"wp8b_users\":8300,\"wp8b_wc_admin_note_actions\":3728,\"wp8b_wc_admin_notes\":3356,\"wp8b_wc_category_lookup\":2065,\"wp8b_wc_customer_lookup\":6224,\"wp8b_wc_download_log\":1024,\"wp8b_wc_order_coupon_lookup\":1024,\"wp8b_wc_order_product_lookup\":6242,\"wp8b_wc_order_stats\":11332,\"wp8b_wc_order_tax_lookup\":1024,\"wp8b_wc_product_meta_lookup\":2048,\"wp8b_wc_reserved_stock\":1024,\"wp8b_wc_tax_rate_classes\":9288,\"wp8b_wc_webhooks\":1024,\"wp8b_wdi_feeds\":1024,\"wp8b_wdi_themes\":6620,\"wp8b_wfblockediplog\":1024,\"wp8b_wfblocks7\":1024,\"wp8b_wfconfig\":678608,\"wp8b_wfcrawlers\":1024,\"wp8b_wffilechanges\":1024,\"wp8b_wffilemods\":2897952,\"wp8b_wfhits\":5940,\"wp8b_wfhoover\":1024,\"wp8b_wfissues\":9228,\"wp8b_wfknownfilelist\":1466848,\"wp8b_wflivetraffichuman\":1024,\"wp8b_wflocs\":2184,\"wp8b_wflogins\":6116,\"wp8b_wfls_2fa_secrets\":32768,\"wp8b_wfls_settings\":16384,\"wp8b_wfnotifications\":3772,\"wp8b_wfpendingissues\":1024,\"wp8b_wfreversecache\":2144,\"wp8b_wfsnipcache\":1024,\"wp8b_wfstatus\":124244,\"wp8b_wftrafficrates\":1024,\"wp8b_woocommerce_api_keys\":2048,\"wp8b_woocommerce_attribute_taxonomies\":1024,\"wp8b_woocommerce_downloadable_product_permissions\":1024,\"wp8b_woocommerce_log\":1024,\"wp8b_woocommerce_order_itemmeta\":1024,\"wp8b_woocommerce_order_items\":1024,\"wp8b_woocommerce_payment_tokenmeta\":1024,\"wp8b_woocommerce_payment_tokens\":1024,\"wp8b_woocommerce_sessions\":4432,\"wp8b_woocommerce_shipping_zone_locations\":1024,\"wp8b_woocommerce_shipping_zone_methods\":1024,\"wp8b_woocommerce_shipping_zones\":1024,\"wp8b_woocommerce_tax_rate_locations\":1024,\"wp8b_woocommerce_tax_rates\":1024}},\"upload_infos\":[{\"storage_id\":\"7\",\"archive_offset\":75181799,\"copied_installer\":true,\"copied_archive\":true,\"progress\":100,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":true,\"status_message_details\":\"\",\"started_timestamp\":1597161475,\"stopped_timestamp\":1597161488}],\"active_storage_id\":7,\"template_id\":5}'),
 (2, '20200811_iglesiauniversitaria', '555d1b2a652911102415_20200811162716', 20, '2020-08-11 16:28:50', 'unknown', '{\"Created\":\"2020-08-11 16:27:16\",\"Version\":\"3.8.3.4\",\"VersionWP\":\"5.4.2\",\"VersionDB\":\"5.7.31\",\"VersionPHP\":\"7.2.32\",\"VersionOS\":\"Linux\",\"ID\":\"2\",\"Name\":\"20200811_iglesiauniversitaria\",\"Hash\":\"555d1b2a652911102415_20200811162716\",\"NameHash\":\"20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716\",\"Type\":0,\"Notes\":\"\",\"StorePath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\",\"StoreURL\":\"https:\\/\\/modelox.vico.digital\\/wp-content\\/backups-dup-pro\\/\",\"ScanFile\":\"20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716_scan.json\",\"timer_start\":1597163485.6333959102630615234375,\"Runtime\":null,\"ExeSize\":null,\"ZipSize\":0,\"Brand\":\"Default\",\"Brand_ID\":-2,\"ziparchive_mode\":0,\"Archive\":{\"ExportOnlyDB\":0,\"FilterDirs\":\"\",\"FilterExts\":\"\",\"FilterFiles\":\"\",\"FilterDirsAll\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/ai1wm-backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backupwordpress\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/contents\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/managewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/old-cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/updraft\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backup-guard\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wfcache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wishlist-backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-snapshots\"],\"FilterExtsAll\":[],\"FilterFilesAll\":[\".DS_Store\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/zn_fonts\\/icomoon\\/icomoon\\/selection.json\",\"dbcache\",\"debug_log\",\"error.log\",\"error_log\",\"objectcache\",\"pgcache\",\"ws_ftp.log\"],\"FilterOn\":0,\"File\":\"20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716_archive.zip\",\"Format\":\"ZIP\",\"PackDir\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"Size\":200536945,\"Dirs\":null,\"DirCount\":1649,\"RecursiveLinks\":[],\"Files\":null,\"FileCount\":11325,\"file_count\":-1,\"FilterInfo\":{\"Dirs\":{\"Warning\":[],\"Unreadable\":[],\"AddonSites\":[],\"Core\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\"],\"Global\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/ai1wm-backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backupwordpress\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/contents\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/infinitewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/managewp\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/old-cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/updraft\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wishlist-backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/wfcache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/plugins\\/wordfence\\/tmp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/cache\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/aiowps_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_temp\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backupbuddy_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/mainwp\\/backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/pb_backupbuddy\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/snapshots\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/sucuri\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp-clone\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wp_all_backup\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/wpbackitup_backups\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/backup-guard\"],\"Instance\":[]},\"Files\":{\"Warning\":[],\"Unreadable\":[\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/uploads\\/zn_fonts\\/icomoon\\/icomoon\\/selection.json\"],\"Size\":[],\"Core\":[],\"Global\":[\"error_log\",\"error.log\",\"debug_log\",\"ws_ftp.log\",\"dbcache\",\"pgcache\",\"objectcache\",\".DS_Store\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\"],\"Instance\":[]},\"Exts\":{\"Core\":[],\"Global\":[],\"Instance\":[]},\"TreeSize\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"modelox\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"isDir\":true,\"childs\":{\"wp-blog-header.php\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"error_log\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-signup.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"cgi-bin\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"wp-config.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\"},\"TreeWarning\":{\"tree\":{\"id\":\"0\",\"parentId\":\"\",\"name\":\"modelox\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\",\"isDir\":true,\"childs\":{\"wp-blog-header.php\":{\"id\":\"0_0\",\"parentId\":\"0\",\"name\":\"wp-blog-header.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-blog-header.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".well-known\":{\"id\":\"0_1\",\"parentId\":\"0\",\"name\":\".well-known\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.well-known\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"error_log\":{\"id\":\"0_2\",\"parentId\":\"0\",\"name\":\"error_log\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/error_log\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-content\":{\"id\":\"0_3\",\"parentId\":\"0\",\"name\":\"wp-content\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"wp-signup.php\":{\"id\":\"0_4\",\"parentId\":\"0\",\"name\":\"wp-signup.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-signup.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".htaccess\":{\"id\":\"0_5\",\"parentId\":\"0\",\"name\":\".htaccess\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.htaccess\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"cgi-bin\":{\"id\":\"0_6\",\"parentId\":\"0\",\"name\":\"cgi-bin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/cgi-bin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":false},\"wp-config.php\":{\"id\":\"0_7\",\"parentId\":\"0\",\"name\":\"wp-config.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-admin\":{\"id\":\"0_8\",\"parentId\":\"0\",\"name\":\"wp-admin\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-admin\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true},\"php.ini\":{\"id\":\"0_9\",\"parentId\":\"0\",\"name\":\"php.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/php.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-mail.php\":{\"id\":\"0_10\",\"parentId\":\"0\",\"name\":\"wp-mail.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-mail.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"index.php\":{\"id\":\"0_11\",\"parentId\":\"0\",\"name\":\"index.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/index.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"xmlrpc.php\":{\"id\":\"0_12\",\"parentId\":\"0\",\"name\":\"xmlrpc.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/xmlrpc.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-config-sample.php\":{\"id\":\"0_13\",\"parentId\":\"0\",\"name\":\"wp-config-sample.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-config-sample.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-trackback.php\":{\"id\":\"0_14\",\"parentId\":\"0\",\"name\":\"wp-trackback.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-trackback.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\".user.ini\":{\"id\":\"0_15\",\"parentId\":\"0\",\"name\":\".user.ini\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/.user.ini\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-login.php\":{\"id\":\"0_16\",\"parentId\":\"0\",\"name\":\"wp-login.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-login.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-settings.php\":{\"id\":\"0_17\",\"parentId\":\"0\",\"name\":\"wp-settings.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-settings.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-comments-post.php\":{\"id\":\"0_18\",\"parentId\":\"0\",\"name\":\"wp-comments-post.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-comments-post.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-load.php\":{\"id\":\"0_19\",\"parentId\":\"0\",\"name\":\"wp-load.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-load.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-links-opml.php\":{\"id\":\"0_20\",\"parentId\":\"0\",\"name\":\"wp-links-opml.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-links-opml.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"readme.html\":{\"id\":\"0_21\",\"parentId\":\"0\",\"name\":\"readme.html\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/readme.html\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"license.txt\":{\"id\":\"0_22\",\"parentId\":\"0\",\"name\":\"license.txt\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/license.txt\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-cron.php\":{\"id\":\"0_23\",\"parentId\":\"0\",\"name\":\"wp-cron.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-cron.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-activate.php\":{\"id\":\"0_24\",\"parentId\":\"0\",\"name\":\"wp-activate.php\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-activate.php\",\"isDir\":false,\"childs\":[],\"data\":[],\"haveChildren\":null},\"wp-includes\":{\"id\":\"0_25\",\"parentId\":\"0\",\"name\":\"wp-includes\",\"fullPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-includes\",\"isDir\":true,\"childs\":[],\"data\":[],\"haveChildren\":true}},\"data\":[],\"haveChildren\":true},\"rootPath\":\"\\/home\\/vicodigi\\/public_html\\/modelox\"}},\"ListDelimiter\":\";\\n\",\"isOuterWPContentDir\":false},\"Multisite\":{\"FilterSites\":\"\"},\"Installer\":{\"File\":\"20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716_installer.php\",\"Size\":0,\"OptsSecureOn\":0,\"OptsSecurePass\":\"\",\"OptsSkipScan\":0,\"OptsDBHost\":\"\",\"OptsDBName\":\"\",\"OptsDBUser\":\"\",\"OptsCPNLHost\":\"\",\"OptsCPNLUser\":\"\",\"OptsCPNLPass\":\"\",\"OptsCPNLEnable\":0,\"OptsCPNLConnect\":false,\"OptsCPNLDBAction\":\"create\",\"OptsCPNLDBHost\":\"\",\"OptsCPNLDBName\":\"\",\"OptsCPNLDBUser\":\"\",\"numFilesAdded\":0,\"numDirsAdded\":0},\"Database\":{\"info\":{\"buildMode\":\"PHPCHUNKING\",\"collationList\":[\"utf8_general_ci\",\"utf8mb4_unicode_520_ci\",\"utf8mb4_unicode_ci\",\"latin1_general_ci\"],\"isTablesUpperCase\":0,\"isNameUpperCase\":0,\"name\":\"vicodigi_wp642\",\"tablesBaseCount\":110,\"tablesFinalCount\":110,\"tablesRowCount\":31245,\"tablesSizeOnDisk\":8991903,\"varLowerCaseTables\":\"0\",\"version\":\"5.7.31\",\"versionComment\":\"MySQL Community Server - (GPL)\",\"tableWiseRowCounts\":{\"cerber_acl\":\"1\",\"cerber_blocks\":\"0\",\"cerber_countries\":\"0\",\"cerber_lab\":\"0\",\"cerber_lab_ip\":\"0\",\"cerber_lab_net\":\"0\",\"cerber_log\":\"31\",\"cerber_qmem\":\"0\",\"cerber_traffic\":\"346\",\"wp8b_actionscheduler_actions\":\"1\",\"wp8b_actionscheduler_claims\":\"0\",\"wp8b_actionscheduler_groups\":\"1\",\"wp8b_actionscheduler_logs\":\"3\",\"wp8b_booking\":\"1\",\"wp8b_bookingdates\":\"3\",\"wp8b_cerber_files\":\"0\",\"wp8b_cerber_sets\":\"11\",\"wp8b_cerber_uss\":\"2\",\"wp8b_commentmeta\":\"0\",\"wp8b_comments\":\"1\",\"wp8b_cuteslider\":\"0\",\"wp8b_duplicator_pro_entities\":\"8\",\"wp8b_duplicator_pro_packages\":\"2\"}},\"Type\":\"MySQL\",\"Size\":null,\"File\":\"20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716_database.sql\",\"FilterTables\":\"\",\"FilterOn\":0,\"DBMode\":\"PHPCHUNKING\",\"Compatible\":\"\",\"Comments\":\"MySQL Community Server - (GPL)\",\"dbStorePathPublic\":\"\\/home\\/vicodigi\\/public_html\\/modelox\\/wp-content\\/backups-dup-pro\\/tmp\\/20200811_iglesiauniversitaria_555d1b2a652911102415_20200811162716_database.sql\",\"sameNameTableExists\":false,\"indexProcessedSchemaSize\":[0,2100,3124,4148,5172,6196,7220,14984,16008,137768,157432,160518,169774,174646,176894,179008,181056,400396,402704,406800,415312,416336,433704],\"intFieldsStruct\":{\"cerber_acl\":{\"ip_long_begin\":\"0\",\"ip_long_end\":\"0\",\"acl_slice\":\"0\",\"ver6\":\"0\"},\"cerber_blocks\":{\"block_until\":\"NULL\",\"reason_id\":\"0\"},\"cerber_countries\":[],\"cerber_lab\":{\"reason_id\":\"0\",\"stamp\":\"NULL\"},\"cerber_lab_ip\":{\"reputation\":\"NULL\",\"expires\":\"NULL\"},\"cerber_lab_net\":{\"ip_long_begin\":\"0\",\"ip_long_end\":\"0\",\"expires\":\"0\"},\"cerber_log\":{\"ip_long\":\"0\",\"user_id\":\"0\",\"activity\":\"0\"},\"cerber_qmem\":{\"http_code\":\"NULL\",\"stamp\":\"NULL\"},\"cerber_traffic\":{\"ip_long\":\"0\",\"user_id\":\"0\",\"processing\":\"0\",\"http_code\":\"NULL\",\"wp_id\":\"0\",\"wp_type\":\"0\",\"is_bot\":\"0\",\"blog_id\":\"0\",\"req_status\":\"0\"},\"wp8b_actionscheduler_actions\":{\"action_id\":\"NULL\",\"group_id\":\"0\",\"attempts\":\"0\",\"claim_id\":\"0\"},\"wp8b_actionscheduler_claims\":{\"claim_id\":\"NULL\"},\"wp8b_actionscheduler_groups\":{\"group_id\":\"NULL\"},\"wp8b_actionscheduler_logs\":{\"log_id\":\"NULL\",\"action_id\":\"NULL\"},\"wp8b_booking\":{\"booking_id\":\"NULL\",\"trash\":\"0\",\"is_new\":\"1\",\"booking_type\":\"1\"},\"wp8b_bookingdates\":{\"booking_id\":\"NULL\",\"approved\":\"0\"},\"wp8b_cerber_files\":{\"scan_id\":\"NULL\",\"scan_type\":\"1\",\"scan_mode\":\"0\",\"scan_status\":\"0\",\"file_status\":\"0\",\"file_type\":\"0\",\"hash_match\":\"0\",\"file_size\":\"0\",\"file_perms\":\"0\",\"file_writable\":\"0\",\"file_mtime\":\"0\"},\"wp8b_cerber_sets\":{\"the_id\":\"0\",\"expires\":\"0\"},\"wp8b_cerber_uss\":{\"user_id\":\"NULL\",\"started\":\"NULL\",\"expires\":\"NULL\"},\"wp8b_commentmeta\":{\"meta_id\":\"NULL\",\"comment_id\":\"0\"},\"wp8b_comments\":{\"comment_ID\":\"NULL\",\"comment_post_ID\":\"0\",\"comment_karma\":\"0\",\"comment_parent\":\"0\",\"user_id\":\"0\"},\"wp8b_cuteslider\":{\"id\":\"NULL\",\"date_c\":\"NULL\",\"date_m\":\"NULL\",\"flag_hidden\":\"0\",\"flag_deleted\":\"0\"},\"wp8b_duplicator_pro_entities\":{\"id\":\"NULL\"}}},\"Status\":20,\"schedule_id\":-1,\"build_progress\":{\"thread_start_time\":1597163491,\"initialized\":true,\"installer_built\":false,\"archive_started\":false,\"archive_has_database\":false,\"archive_built\":false,\"database_script_built\":false,\"failed\":false,\"next_archive_file_index\":0,\"next_archive_dir_index\":0,\"retries\":0,\"current_build_mode\":2,\"current_build_compression\":true,\"custom_data\":null,\"warnings\":[]},\"db_build_progress\":{\"tableIndex\":0,\"tableOffset\":0,\"totalRowOffset\":0,\"chunkIndex\":null,\"validationStage1\":false,\"bulkOffset\":0,\"bulkSizeOffset\":0,\"doneInit\":true,\"doneFiltering\":true,\"doneCreates\":true,\"completed\":false,\"tablesToProcess\":[\"cerber_acl\",\"cerber_blocks\",\"cerber_countries\",\"cerber_lab\",\"cerber_lab_ip\",\"cerber_lab_net\",\"cerber_log\",\"cerber_qmem\",\"cerber_traffic\",\"wp8b_actionscheduler_actions\",\"wp8b_actionscheduler_claims\",\"wp8b_actionscheduler_groups\",\"wp8b_actionscheduler_logs\",\"wp8b_booking\",\"wp8b_bookingdates\",\"wp8b_cerber_files\",\"wp8b_cerber_sets\",\"wp8b_cerber_uss\",\"wp8b_commentmeta\",\"wp8b_comments\",\"wp8b_cuteslider\",\"wp8b_duplicator_pro_entities\",\"wp8b_duplicator_pro_packages\",\"wp8b_hotel_booking_order_itemmeta\",\"wp8b_hotel_booking_order_items\",\"wp8b_hotel_booking_plans\",\"wp8b_links\",\"wp8b_mailchimp_carts\",\"wp8b_mailchimp_jobs\",\"wp8b_mp_timetable_data\",\"wp8b_mphb_sync_logs\",\"wp8b_mphb_sync_queue\",\"wp8b_mphb_sync_stats\",\"wp8b_mphb_sync_urls\",\"wp8b_options\",\"wp8b_postmeta\",\"wp8b_posts\",\"wp8b_revslider_css\",\"wp8b_revslider_css_bkp\",\"wp8b_revslider_layer_animations\",\"wp8b_revslider_layer_animations_bkp\",\"wp8b_revslider_navigations\",\"wp8b_revslider_navigations_bkp\",\"wp8b_revslider_sliders\",\"wp8b_revslider_sliders_bkp\",\"wp8b_revslider_slides\",\"wp8b_revslider_slides_bkp\",\"wp8b_revslider_static_slides\",\"wp8b_revslider_static_slides_bkp\",\"wp8b_sbi_instagram_feeds_posts\",\"wp8b_sbi_instagram_posts\",\"wp8b_term_relationships\",\"wp8b_term_taxonomy\",\"wp8b_termmeta\",\"wp8b_terms\",\"wp8b_tinvwl_analytics\",\"wp8b_tinvwl_items\",\"wp8b_tinvwl_lists\",\"wp8b_usermeta\",\"wp8b_users\",\"wp8b_wc_admin_note_actions\",\"wp8b_wc_admin_notes\",\"wp8b_wc_category_lookup\",\"wp8b_wc_customer_lookup\",\"wp8b_wc_download_log\",\"wp8b_wc_order_coupon_lookup\",\"wp8b_wc_order_product_lookup\",\"wp8b_wc_order_stats\",\"wp8b_wc_order_tax_lookup\",\"wp8b_wc_product_meta_lookup\",\"wp8b_wc_reserved_stock\",\"wp8b_wc_tax_rate_classes\",\"wp8b_wc_webhooks\",\"wp8b_wdi_feeds\",\"wp8b_wdi_themes\",\"wp8b_wfblockediplog\",\"wp8b_wfblocks7\",\"wp8b_wfconfig\",\"wp8b_wfcrawlers\",\"wp8b_wffilechanges\",\"wp8b_wffilemods\",\"wp8b_wfhits\",\"wp8b_wfhoover\",\"wp8b_wfissues\",\"wp8b_wfknownfilelist\",\"wp8b_wflivetraffichuman\",\"wp8b_wflocs\",\"wp8b_wflogins\",\"wp8b_wfls_2fa_secrets\",\"wp8b_wfls_settings\",\"wp8b_wfnotifications\",\"wp8b_wfpendingissues\",\"wp8b_wfreversecache\",\"wp8b_wfsnipcache\",\"wp8b_wfstatus\",\"wp8b_wftrafficrates\",\"wp8b_woocommerce_api_keys\",\"wp8b_woocommerce_attribute_taxonomies\",\"wp8b_woocommerce_downloadable_product_permissions\",\"wp8b_woocommerce_log\",\"wp8b_woocommerce_order_itemmeta\",\"wp8b_woocommerce_order_items\",\"wp8b_woocommerce_payment_tokenmeta\",\"wp8b_woocommerce_payment_tokens\",\"wp8b_woocommerce_sessions\",\"wp8b_woocommerce_shipping_zone_locations\",\"wp8b_woocommerce_shipping_zone_methods\",\"wp8b_woocommerce_shipping_zones\",\"wp8b_woocommerce_tax_rate_locations\",\"wp8b_woocommerce_tax_rates\"],\"startTime\":1597163485.6400089263916015625,\"fileOffset\":79041,\"wasInterrupted\":true,\"errorOut\":false,\"failureCount\":0,\"totalSchemaSize\":9003559,\"tablesSchemaSizes\":{\"cerber_acl\":2100,\"cerber_blocks\":1024,\"cerber_countries\":1024,\"cerber_lab\":1024,\"cerber_lab_ip\":1024,\"cerber_lab_net\":1024,\"cerber_log\":7764,\"cerber_qmem\":1024,\"cerber_traffic\":121760,\"wp8b_actionscheduler_actions\":19664,\"wp8b_actionscheduler_claims\":3086,\"wp8b_actionscheduler_groups\":9256,\"wp8b_actionscheduler_logs\":4872,\"wp8b_booking\":2248,\"wp8b_bookingdates\":2114,\"wp8b_cerber_files\":2048,\"wp8b_cerber_sets\":219340,\"wp8b_cerber_uss\":2308,\"wp8b_commentmeta\":4096,\"wp8b_comments\":8512,\"wp8b_cuteslider\":1024,\"wp8b_duplicator_pro_entities\":17368,\"wp8b_duplicator_pro_packages\":51476,\"wp8b_hotel_booking_order_itemmeta\":1024,\"wp8b_hotel_booking_order_items\":1024,\"wp8b_hotel_booking_plans\":1024,\"wp8b_links\":1024,\"wp8b_mailchimp_carts\":2048,\"wp8b_mailchimp_jobs\":1024,\"wp8b_mp_timetable_data\":1024,\"wp8b_mphb_sync_logs\":1024,\"wp8b_mphb_sync_queue\":1024,\"wp8b_mphb_sync_stats\":1024,\"wp8b_mphb_sync_urls\":1024,\"wp8b_options\":2580252,\"wp8b_postmeta\":222084,\"wp8b_posts\":32228,\"wp8b_revslider_css\":100052,\"wp8b_revslider_css_bkp\":15992,\"wp8b_revslider_layer_animations\":2216,\"wp8b_revslider_layer_animations_bkp\":2220,\"wp8b_revslider_navigations\":1024,\"wp8b_revslider_navigations_bkp\":13948,\"wp8b_revslider_sliders\":13380,\"wp8b_revslider_sliders_bkp\":8564,\"wp8b_revslider_slides\":45596,\"wp8b_revslider_slides_bkp\":51204,\"wp8b_revslider_static_slides\":22420,\"wp8b_revslider_static_slides_bkp\":2276,\"wp8b_sbi_instagram_feeds_posts\":2048,\"wp8b_sbi_instagram_posts\":1024,\"wp8b_term_relationships\":3828,\"wp8b_term_taxonomy\":5108,\"wp8b_termmeta\":10660,\"wp8b_terms\":14164,\"wp8b_tinvwl_analytics\":1024,\"wp8b_tinvwl_items\":1024,\"wp8b_tinvwl_lists\":2096,\"wp8b_usermeta\":12140,\"wp8b_users\":8300,\"wp8b_wc_admin_note_actions\":3728,\"wp8b_wc_admin_notes\":3356,\"wp8b_wc_category_lookup\":2065,\"wp8b_wc_customer_lookup\":6224,\"wp8b_wc_download_log\":1024,\"wp8b_wc_order_coupon_lookup\":1024,\"wp8b_wc_order_product_lookup\":6242,\"wp8b_wc_order_stats\":11332,\"wp8b_wc_order_tax_lookup\":1024,\"wp8b_wc_product_meta_lookup\":2048,\"wp8b_wc_reserved_stock\":1024,\"wp8b_wc_tax_rate_classes\":9288,\"wp8b_wc_webhooks\":1024,\"wp8b_wdi_feeds\":1024,\"wp8b_wdi_themes\":6620,\"wp8b_wfblockediplog\":1024,\"wp8b_wfblocks7\":1024,\"wp8b_wfconfig\":678608,\"wp8b_wfcrawlers\":1024,\"wp8b_wffilechanges\":1024,\"wp8b_wffilemods\":2897952,\"wp8b_wfhits\":5940,\"wp8b_wfhoover\":1024,\"wp8b_wfissues\":9228,\"wp8b_wfknownfilelist\":1466848,\"wp8b_wflivetraffichuman\":1024,\"wp8b_wflocs\":2184,\"wp8b_wflogins\":6116,\"wp8b_wfls_2fa_secrets\":32768,\"wp8b_wfls_settings\":16384,\"wp8b_wfnotifications\":3772,\"wp8b_wfpendingissues\":1024,\"wp8b_wfreversecache\":2144,\"wp8b_wfsnipcache\":1024,\"wp8b_wfstatus\":124244,\"wp8b_wftrafficrates\":1024,\"wp8b_woocommerce_api_keys\":2048,\"wp8b_woocommerce_attribute_taxonomies\":1024,\"wp8b_woocommerce_downloadable_product_permissions\":1024,\"wp8b_woocommerce_log\":1024,\"wp8b_woocommerce_order_itemmeta\":1024,\"wp8b_woocommerce_order_items\":1024,\"wp8b_woocommerce_payment_tokenmeta\":1024,\"wp8b_woocommerce_payment_tokens\":1024,\"wp8b_woocommerce_sessions\":4432,\"wp8b_woocommerce_shipping_zone_locations\":1024,\"wp8b_woocommerce_shipping_zone_methods\":1024,\"wp8b_woocommerce_shipping_zones\":1024,\"wp8b_woocommerce_tax_rate_locations\":1024,\"wp8b_woocommerce_tax_rates\":1024}},\"upload_infos\":[{\"storage_id\":\"7\",\"archive_offset\":0,\"copied_installer\":false,\"copied_archive\":false,\"progress\":0,\"num_failures\":0,\"failed\":false,\"cancelled\":false,\"upload_id\":null,\"failure_count\":0,\"data\":\"\",\"data2\":\"\",\"has_started\":false,\"status_message_details\":\"\",\"started_timestamp\":null,\"stopped_timestamp\":null}],\"active_storage_id\":-1,\"template_id\":5}');

/* INSERT TABLE DATA: wp8b_options */
INSERT INTO `wp8b_options` VALUES(1, 'siteurl', 'https://modelox.vico.digital', 'yes'),
 (2, 'home', 'https://modelox.vico.digital', 'yes'),
 (3, 'blogname', 'Sitio Demo', 'yes'),
 (4, 'blogdescription', 'Demostraci&oacute;n', 'yes'),
 (5, 'users_can_register', '0', 'yes'),
 (6, 'admin_email', 'vicosolutions.com@gmail.com', 'yes'),
 (7, 'start_of_week', '1', 'yes'),
 (8, 'use_balanceTags', '0', 'yes'),
 (9, 'use_smilies', '1', 'yes'),
 (10, 'require_name_email', '1', 'yes'),
 (11, 'comments_notify', '1', 'yes'),
 (12, 'posts_per_rss', '10', 'yes'),
 (13, 'rss_use_excerpt', '0', 'yes'),
 (14, 'mailserver_url', 'mail.example.com', 'yes'),
 (15, 'mailserver_login', 'login@example.com', 'yes'),
 (16, 'mailserver_pass', 'password', 'yes'),
 (17, 'mailserver_port', '110', 'yes'),
 (18, 'default_category', '1', 'yes'),
 (19, 'default_comment_status', 'open', 'yes'),
 (20, 'default_ping_status', 'open', 'yes'),
 (21, 'default_pingback_flag', '1', 'yes'),
 (22, 'posts_per_page', '10', 'yes'),
 (23, 'date_format', 'F j, Y', 'yes'),
 (24, 'time_format', 'g:i a', 'yes'),
 (25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
 (26, 'comment_moderation', '0', 'yes'),
 (27, 'moderation_notify', '1', 'yes'),
 (28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
 (29, 'rewrite_rules', 'a:266:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:16:\"documentation/?$\";s:33:\"index.php?post_type=documentation\";s:46:\"documentation/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=documentation&feed=$matches[1]\";s:41:\"documentation/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=documentation&feed=$matches[1]\";s:33:\"documentation/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=documentation&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:63:\"documentation_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?documentation_category=$matches[1]&feed=$matches[2]\";s:58:\"documentation_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?documentation_category=$matches[1]&feed=$matches[2]\";s:39:\"documentation_category/([^/]+)/embed/?$\";s:55:\"index.php?documentation_category=$matches[1]&embed=true\";s:51:\"documentation_category/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?documentation_category=$matches[1]&paged=$matches[2]\";s:33:\"documentation_category/([^/]+)/?$\";s:44:\"index.php?documentation_category=$matches[1]\";s:57:\"project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:52:\"project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:33:\"project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:45:\"project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:27:\"project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:57:\"categoria-producto/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:52:\"categoria-producto/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:33:\"categoria-producto/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:45:\"categoria-producto/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:27:\"categoria-producto/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiqueta-producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiqueta-producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiqueta-producto/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiqueta-producto/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiqueta-producto/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:32:\"shop/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"shop/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"shop/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"shop/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"shop/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"shop/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"shop/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:25:\"shop/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:45:\"shop/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:40:\"shop/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:33:\"shop/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:40:\"shop/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:30:\"shop/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:36:\"shop/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"shop/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"shop/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:21:\"shop/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"shop/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"shop/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"shop/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"shop/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"shop/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"layout_manager/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"layout_manager/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"layout_manager/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"layout_manager/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"layout_manager/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"layout_manager/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"layout_manager/([^/]+)/embed/?$\";s:42:\"index.php?zn_layout=$matches[1]&embed=true\";s:35:\"layout_manager/([^/]+)/trackback/?$\";s:36:\"index.php?zn_layout=$matches[1]&tb=1\";s:43:\"layout_manager/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?zn_layout=$matches[1]&paged=$matches[2]\";s:50:\"layout_manager/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?zn_layout=$matches[1]&cpage=$matches[2]\";s:40:\"layout_manager/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?zn_layout=$matches[1]&wc-api=$matches[3]\";s:46:\"layout_manager/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"layout_manager/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"layout_manager/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?zn_layout=$matches[1]&page=$matches[2]\";s:31:\"layout_manager/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"layout_manager/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"layout_manager/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"layout_manager/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"layout_manager/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"layout_manager/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"documentation/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"documentation/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"documentation/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"documentation/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"documentation/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"documentation/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"documentation/([^/]+)/embed/?$\";s:46:\"index.php?documentation=$matches[1]&embed=true\";s:34:\"documentation/([^/]+)/trackback/?$\";s:40:\"index.php?documentation=$matches[1]&tb=1\";s:54:\"documentation/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?documentation=$matches[1]&feed=$matches[2]\";s:49:\"documentation/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?documentation=$matches[1]&feed=$matches[2]\";s:42:\"documentation/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?documentation=$matches[1]&paged=$matches[2]\";s:49:\"documentation/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?documentation=$matches[1]&cpage=$matches[2]\";s:39:\"documentation/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?documentation=$matches[1]&wc-api=$matches[3]\";s:45:\"documentation/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"documentation/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"documentation/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?documentation=$matches[1]&page=$matches[2]\";s:30:\"documentation/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"documentation/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"documentation/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"documentation/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"documentation/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"documentation/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"znpb_template_mngr/([^/]+)/embed/?$\";s:51:\"index.php?znpb_template_mngr=$matches[1]&embed=true\";s:39:\"znpb_template_mngr/([^/]+)/trackback/?$\";s:45:\"index.php?znpb_template_mngr=$matches[1]&tb=1\";s:47:\"znpb_template_mngr/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?znpb_template_mngr=$matches[1]&paged=$matches[2]\";s:54:\"znpb_template_mngr/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?znpb_template_mngr=$matches[1]&cpage=$matches[2]\";s:44:\"znpb_template_mngr/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?znpb_template_mngr=$matches[1]&wc-api=$matches[3]\";s:50:\"znpb_template_mngr/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"znpb_template_mngr/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"znpb_template_mngr/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?znpb_template_mngr=$matches[1]&page=$matches[2]\";s:35:\"znpb_template_mngr/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"znpb_template_mngr/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"znpb_template_mngr/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"znpb_template_mngr/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"znpb_template_mngr/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"znpb_template_mngr/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=149&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}', 'yes'),
 (30, 'hack_file', '0', 'yes'),
 (31, 'blog_charset', 'UTF-8', 'yes'),
 (32, 'moderation_keys', '', 'no'),
 (33, 'active_plugins', 'a:7:{i:0;s:33:\"duplicator-pro/duplicator-pro.php\";i:1;s:37:\"login-customizer/login-customizer.php\";i:2;s:23:\"revslider/revslider.php\";i:3;s:27:\"updraftplus/updraftplus.php\";i:4;s:27:\"woocommerce/woocommerce.php\";i:5;s:23:\"wordfence/wordfence.php\";i:6;s:23:\"wp-cerber/wp-cerber.php\";}', 'yes'),
 (34, 'category_base', '', 'yes'),
 (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
 (36, 'comment_max_links', '2', 'yes'),
 (37, 'gmt_offset', '0', 'yes'),
 (38, 'default_email_category', '1', 'yes'),
 (39, 'recently_edited', '', 'no'),
 (40, 'template', 'kallyas', 'yes'),
 (41, 'stylesheet', 'kallyas-child', 'yes'),
 (42, 'comment_whitelist', '1', 'yes'),
 (43, 'blacklist_keys', '', 'no'),
 (44, 'comment_registration', '0', 'yes'),
 (45, 'html_type', 'text/html', 'yes'),
 (46, 'use_trackback', '0', 'yes'),
 (47, 'default_role', 'subscriber', 'yes'),
 (48, 'db_version', '47018', 'yes'),
 (49, 'uploads_use_yearmonth_folders', '1', 'yes'),
 (50, 'upload_path', '', 'yes'),
 (51, 'blog_public', '1', 'yes'),
 (52, 'default_link_category', '2', 'yes'),
 (53, 'show_on_front', 'page', 'yes'),
 (54, 'tag_base', '', 'yes'),
 (55, 'show_avatars', '1', 'yes'),
 (56, 'avatar_rating', 'G', 'yes'),
 (57, 'upload_url_path', '', 'yes'),
 (58, 'thumbnail_size_w', '150', 'yes'),
 (59, 'thumbnail_size_h', '150', 'yes'),
 (60, 'thumbnail_crop', '1', 'yes'),
 (61, 'medium_size_w', '300', 'yes'),
 (62, 'medium_size_h', '300', 'yes'),
 (63, 'avatar_default', 'mystery', 'yes'),
 (64, 'large_size_w', '1024', 'yes'),
 (65, 'large_size_h', '1024', 'yes'),
 (66, 'image_default_link_type', 'none', 'yes'),
 (67, 'image_default_size', '', 'yes'),
 (68, 'image_default_align', '', 'yes'),
 (69, 'close_comments_for_old_posts', '0', 'yes'),
 (70, 'close_comments_days_old', '14', 'yes'),
 (71, 'thread_comments', '1', 'yes'),
 (72, 'thread_comments_depth', '5', 'yes'),
 (73, 'page_comments', '0', 'yes'),
 (74, 'comments_per_page', '50', 'yes'),
 (75, 'default_comments_page', 'newest', 'yes'),
 (76, 'comment_order', 'asc', 'yes'),
 (77, 'sticky_posts', 'a:0:{}', 'yes'),
 (78, 'widget_categories', 'a:3:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (79, 'widget_text', 'a:0:{}', 'yes'),
 (80, 'widget_rss', 'a:0:{}', 'yes'),
 (81, 'uninstall_plugins', 'a:1:{s:23:\"wp-cerber/wp-cerber.php\";s:13:\"cerber_finito\";}', 'no'),
 (82, 'timezone_string', '', 'yes'),
 (83, 'page_for_posts', '0', 'yes'),
 (84, 'page_on_front', '149', 'yes'),
 (85, 'default_post_format', '0', 'yes'),
 (86, 'link_manager_enabled', '0', 'yes'),
 (87, 'finished_splitting_shared_terms', '1', 'yes'),
 (88, 'site_icon', '0', 'yes'),
 (89, 'medium_large_size_w', '768', 'yes'),
 (90, 'medium_large_size_h', '0', 'yes'),
 (91, 'wp_page_for_privacy_policy', '3', 'yes'),
 (92, 'show_comments_cookies_opt_in', '1', 'yes'),
 (93, 'admin_email_lifespan', '1612712266', 'yes'),
 (94, 'initial_db_version', '45805', 'yes'),
 (95, 'wp8b_user_roles', 'a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:117:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}', 'yes'),
 (96, 'fresh_site', '0', 'yes'),
 (97, 'widget_search', 'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (98, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (99, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (100, 'widget_archives', 'a:3:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (101, 'widget_meta', 'a:3:{i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
 (102, 'sidebars_widgets', 'a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:14:\"defaultsidebar\";a:11:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-3\";i:4;s:12:\"categories-3\";i:5;s:6:\"meta-3\";i:6;s:32:\"woocommerce_product_categories-1\";i:7;s:28:\"woocommerce_product_search-1\";i:8;s:26:\"woocommerce_price_filter-1\";i:9;s:25:\"woocommerce_widget_cart-1\";i:10;s:38:\"woocommerce_recently_viewed_products-1\";}s:19:\"hiddenpannelsidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:8:\"znfooter\";a:0:{}s:10:\"znfooter-2\";a:0:{}s:10:\"znfooter-3\";a:0:{}s:10:\"znfooter-4\";a:0:{}s:10:\"znfooter-5\";a:0:{}s:13:\"array_version\";i:3;}', 'yes'),
 (103, 'cron', 'a:28:{i:1597163511;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1597163529;a:1:{s:18:\"cerber_bg_launcher\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:8:\"crb_five\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1597164115;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597164160;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1597164171;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597164183;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597164277;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597165200;a:1:{s:15:\"cerber_hourly_1\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597165542;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597165800;a:1:{s:15:\"cerber_hourly_2\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1597171360;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597182160;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1597190400;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597193076;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1597236276;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597236367;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597236368;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597242000;a:1:{s:12:\"cerber_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597243300;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597243315;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597246970;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597246971;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1597282200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"41adb985f99061351822e8c3a556c7f3\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1597282200;}}}}i:1597413048;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1597541400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"bda009ff82d4c0931441bdfb5e64a617\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1597541400;}}}}i:1597680000;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1598456620;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}', 'yes'),
 (1541, '_site_transient_timeout_cerber_hourly_1', '1597168834', 'no'),
 (1542, '_site_transient_cerber_hourly_1', 'a:2:{i:0;i:1597161634;i:1;i:1597161634;}', 'no'),
 (467, 'recovery_mode_email_last_sent', '1597070562', 'yes'),
 (104, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (105, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (106, 'widget_media_audio', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (107, 'widget_media_image', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (108, 'widget_media_gallery', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (109, 'widget_media_video', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (110, 'widget_tag_cloud', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (111, 'widget_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (112, 'widget_custom_html', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (113, 'recovery_keys', 'a:1:{s:22:\"Lzso8kHx73ljEklSq37z58\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BMl3AqvjhfadoPa6QHLCbSec6dRcTI.\";s:10:\"created_at\";i:1597070562;}}', 'yes'),
 (114, 'theme_mods_twentytwenty', 'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1578315308;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}', 'yes'),
 (1550, '_site_transient_timeout_theme_roots', '1597161810', 'no'),
 (1551, '_site_transient_theme_roots', 'a:2:{s:13:\"kallyas-child\";s:7:\"/themes\";s:7:\"kallyas\";s:7:\"/themes\";}', 'no'),
 (122, 'WPLANG', 'es_ES', 'yes'),
 (177, 'login_customizer_options', 'a:26:{i:0;s:14:\"logincust_logo\";i:1;s:20:\"logincust_logo_width\";i:2;s:21:\"logincust_logo_height\";i:3;s:22:\"logincust_logo_padding\";i:4;s:18:\"logincust_bg_image\";i:5;s:18:\"logincust_bg_color\";i:6;s:17:\"logincust_bg_size\";i:7;s:23:\"logincust_form_bg_image\";i:8;s:23:\"logincust_form_bg_color\";i:9;s:20:\"logincust_form_width\";i:10;s:21:\"logincust_form_height\";i:11;s:22:\"logincust_form_padding\";i:12;s:21:\"logincust_field_width\";i:13;s:22:\"logincust_field_margin\";i:14;s:18:\"logincust_field_bg\";i:15;s:21:\"logincust_field_color\";i:16;s:21:\"logincust_field_label\";i:17;s:19:\"logincust_button_bg\";i:18;s:23:\"logincust_button_border\";i:19;s:23:\"logincust_button_shadow\";i:20;s:22:\"logincust_button_color\";i:21;s:25:\"logincust_button_hover_bg\";i:22;s:29:\"logincust_button_hover_border\";i:23;s:21:\"logincust_other_color\";i:24;s:27:\"logincust_other_color_hover\";i:25;s:19:\"logincust_other_css\";}', 'yes'),
 (178, 'login_customizer_settings', 'a:2:{s:4:\"page\";i:8;s:7:\"version\";s:5:\"2.0.1\";}', 'yes'),
 (183, 'kallyas_hg_dash_api_key', '71B72-0084B-A0EAD-61066-8930C', 'yes'),
 (723, 'db_upgraded', '', 'yes'),
 (293, 'revslider-templates-check', '1597070494', 'yes'),
 (294, 'revslider-templates-hash', 'd18c36e2537bd40f9c1fd848b227cfb1', 'yes'),
 (295, 'rs-templates-new', '', 'no'),
 (358, 'theme_mods_colibri-wp', 'a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1580384436;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:17:\"colibri-sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:21:\"colibri-sidebar-woo-1\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}', 'yes'),
 (624, 'revslider-valid', 'true', 'yes'),
 (625, 'revslider-code', '527f6eb2-6f47-405e-9fed-cd587c5ba0d7', 'yes'),
 (626, 'revslider-update-check', '1597070486', 'yes'),
 (627, 'revslider_update_info', 'O:8:\"stdClass\":3:{s:7:\"checked\";i:1597070486;s:5:\"basic\";O:8:\"stdClass\":7:{s:4:\"slug\";s:9:\"revslider\";s:7:\"version\";s:6:\"6.2.17\";s:7:\"package\";s:102:\"http://updates.themepunch-ext-b.tools/revslider/download.php?code=527f6eb2-6f47-405e-9fed-cd587c5ba0d7\";s:6:\"tested\";s:5:\"5.4.3\";s:5:\"icons\";a:1:{s:2:\"1x\";s:62:\"//updates.themepunch-ext-b.tools/revslider/logo.png?rev=6.2.17\";}s:3:\"url\";s:60:\"https://www.themepunch.com/links/slider_revolution_wordpress\";s:11:\"new_version\";s:6:\"6.2.17\";}s:4:\"full\";O:8:\"stdClass\":19:{s:7:\"banners\";a:2:{s:3:\"low\";s:64:\"//updates.themepunch-ext-b.tools/revslider/banner.png?rev=6.2.17\";s:4:\"high\";s:64:\"//updates.themepunch-ext-b.tools/revslider/banner.png?rev=6.2.17\";}s:4:\"name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:6:\"stable\";s:3:\"4.2\";s:7:\"version\";s:6:\"6.2.17\";s:6:\"tested\";s:5:\"5.4.3\";s:14:\"upgrade_notice\";a:0:{}s:11:\"last_update\";s:10:\"2020-07-17\";s:12:\"last_updated\";s:10:\"2020-07-17\";s:8:\"requires\";s:3:\"3.6\";s:6:\"author\";s:51:\"<a href=\"https://www.themepunch.com\">ThemePunch</a>\";s:7:\"package\";s:102:\"http://updates.themepunch-ext-b.tools/revslider/download.php?code=527f6eb2-6f47-405e-9fed-cd587c5ba0d7\";s:13:\"download_link\";s:102:\"http://updates.themepunch-ext-b.tools/revslider/download.php?code=527f6eb2-6f47-405e-9fed-cd587c5ba0d7\";s:9:\"file_name\";s:13:\"revslider.zip\";s:15:\"active_installs\";i:7000100;s:8:\"homepage\";s:33:\"https://revolution.themepunch.com\";s:8:\"sections\";a:3:{s:11:\"description\";s:497:\"<h4>Slider Revolution WordPress Builder Plugin</h4>\n	<p>Slider Revolution 6 is a new way to build rich & dynamic content for your websites. With our powerful visual editor, you can create modern designs in no time, and with no coding experience required.</p><p>Create Sliders & Carousels, Hero Headers, Content Modules, Full Websites, Dynamic Solutions and Special FX with our amazing Add-Ons.</p>\n	<p>200+ templates are included in our online library. Cutting edge designs. Easily customized.</p>\";s:9:\"changelog\";s:151:\"<p>For Slider Revolution\'s changelog, please visit <a href=\"https://www.themepunch.com/slider-revolution/changelog/\" target=\"_blank\">this</a> site!</p>\";s:3:\"faq\";s:2178:\"<div class=\"tp-faq-content\"><div class=\"tp-faq-column tp-faq-recent\"><h4>Recent Solutions</h4><ul class=\"tp-faq-recent-content ready\"><li><a href=\"https://www.youtube.com/watch?v=sCcnw5bZqYY&amp;list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_&amp;index=2&amp;t=111s\" target=\"_blank\" title=\"Video Tutorials\">Video Tutorials</a></li><li><a href=\"https://www.themepunch.com/faq/responsive-content/\" target=\"_blank\" title=\"Responsive Content Setup\">Responsive Content Setup</a></li><li><a href=\"https://www.themepunch.com/faq/video-content-mobile/\" target=\"_blank\" title=\"Video Content &amp; Mobile Considerations\">Video Content &amp; Mobile Considerations</a></li><li><a href=\"https://www.themepunch.com/faq/how-to-change-the-timing-of-slides/\" target=\"_blank\" title=\"How to change the timing of Slides\">How to change the timing of Slides</a></li><li><a href=\"https://www.themepunch.com/faq/mouse-hovers-for-layer-content/\" target=\"_blank\" title=\"Mouse Hovers for Layer Content\"> Mouse Hovers for Layer Content</a></li></ul></div><div class=\"tp-faq-column tp-faq-popular\"><h4>Popular Solutions</h4><ul class=\"tp-faq-popular-content ready\"><li><a href=\"https://www.themepunch.com/faq/after-updating-make-sure-to-clear-all-caches/\" target=\"_blank\" title=\"After updating – Make sure to clear all caches\">After updating – Make sure to clear all caches</a></li><li><a href=\"https://www.themepunch.com/faq/purchase-code-registration-faqs/\" target=\"_blank\" title=\"Purchase Code Registration FAQ’s\">Purchase Code Registration FAQ’s</a></li><li><a href=\"https://www.themepunch.com/faq/ideal-image-size/\" target=\"_blank\" title=\"Ideal Image Size\">Ideal Image Size</a></li><li><a href=\"https://www.themepunch.com/faq/add-links-to-slides-and-layers/\" target=\"_blank\" title=\"How to Hyperlink Slides and Layers\">How to Hyperlink Slides and Layers</a></li><li><a href=\"https://www.themepunch.com/faq/where-to-find-the-purchase-code/\" target=\"_blank\" title=\"Where to find the Purchase Code\">Where to find the Purchase Code</a></li></ul></div><div style=\"clear: both\"></div><p><a class=\"button button-primary\" href=\"https://themepunch.com/support-center\"><strong>See All Faq\'s</strong></a></p></div>\";}s:3:\"url\";s:60:\"https://www.themepunch.com/links/slider_revolution_wordpress\";s:8:\"external\";i:1;}}', 'yes'),
 (146, 'recently_activated', 'a:0:{}', 'yes'),
 (149, 'current_theme', 'Kallyas Child Theme', 'yes'),
 (150, 'theme_mods_kallyas', 'a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1585837054;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:14:\"defaultsidebar\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:19:\"hiddenpannelsidebar\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}s:8:\"znfooter\";a:0:{}s:10:\"znfooter-2\";a:0:{}s:10:\"znfooter-3\";a:0:{}s:10:\"znfooter-4\";a:0:{}s:10:\"znfooter-5\";a:0:{}}}}', 'yes'),
 (151, 'theme_switched', '', 'yes'),
 (152, 'widget_sbs_nav_menu', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (153, 'widget_tp_widget_recent_tweets', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (154, 'widget_text_contact', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (155, 'widget_zn_mailchimp', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (156, 'widget_social_buttons', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (157, 'widget_zn_flickr', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
 (160, 'znhgfw_current_domain', 'latigid.ociv.xoledom//:sptth', 'no'),
 (161, 'zn_kallyas_optionsv4', 'a:375:{i:0;a:7:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"GENERAL SETTINGS\";s:11:\"description\";s:49:\"These settings below are related to theme itself.\";s:2:\"id\";s:11:\"info_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:1;a:8:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Use page preloader?\";s:11:\"description\";s:48:\"Choose yes if you want to show a page preloader.\";s:2:\"id\";s:14:\"page_preloader\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:7:{s:2:\"no\";s:2:\"No\";s:3:\"yes\";s:26:\"Pulsating-circle animation\";s:11:\"yes_spinner\";s:17:\"Spinner animation\";s:9:\"yes_persp\";s:28:\"Perspective-square animation\";s:13:\"yes_img_persp\";s:36:\"Custom Image & perspective animation\";s:14:\"yes_img_breath\";s:31:\"Custom Image & breath animation\";s:7:\"yes_img\";s:27:\"Custom Image & no animation\";}s:4:\"type\";s:6:\"select\";}i:2;a:9:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Preloader overlay background color\";s:11:\"description\";s:193:\"Please choose a default color for the preloader\'s overlay background color. Please remember, if you\'re using large images or too many external resources, the preloader will take longer to hide.\";s:2:\"id\";s:17:\"page_preloader_bg\";s:5:\"alpha\";s:4:\"true\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:14:\"page_preloader\";s:5:\"value\";a:6:{i:0;s:3:\"yes\";i:1;s:11:\"yes_spinner\";i:2;s:9:\"yes_persp\";i:3;s:13:\"yes_img_persp\";i:4;s:14:\"yes_img_breath\";i:5;s:7:\"yes_img\";}}}i:3;a:8:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:41:\"Preloader Custom Image (.jpg, .gif, .svg)\";s:11:\"description\";s:55:\"Please choose image to be displayed into the preloader.\";s:2:\"id\";s:18:\"page_preloader_img\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";s:10:\"dependency\";a:2:{s:7:\"element\";s:14:\"page_preloader\";s:5:\"value\";a:3:{i:0;s:7:\"yes_img\";i:1;s:13:\"yes_img_persp\";i:2;s:14:\"yes_img_breath\";}}}i:4;a:8:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Enable Smooth Scroll?\";s:11:\"description\";s:181:\"This option will hijack the page default scroll and add an ease effect. It\'s very appealing with parallax scrolls and general navigation. Do though that it\'s a performance consumer.\";s:2:\"id\";s:13:\"smooth_scroll\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:7:{s:3:\"0.1\";s:40:\"Yes - Ultra Fast speed (almost disabled)\";s:4:\"0.25\";s:16:\"Yes - Fast speed\";s:3:\"yes\";s:20:\"Yes - Moderate speed\";s:2:\"no\";s:13:\"No - Disabled\";s:4:\"0.75\";s:16:\"Yes - Slow speed\";i:1;s:22:\"Yes - Super Slow speed\";s:3:\"1.6\";s:17:\"Yes - Snail speed\";}s:4:\"type\";s:6:\"select\";}i:5;a:10:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:37:\"Disable Trackpad/Magic Mouse Support?\";s:11:\"description\";s:132:\"On *some* Macs the mouse wheel is recognized as a trackpad, therefore if this is disabled, it might not work at all. Use carefully! \";s:2:\"id\";s:17:\"smooth_scroll_osx\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:2:{s:3:\"yes\";s:3:\"Yes\";s:2:\"no\";s:2:\"No\";}s:4:\"type\";s:8:\"zn_radio\";s:5:\"class\";s:15:\"zn_radio--yesno\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"smooth_scroll\";s:5:\"value\";a:6:{i:0;s:3:\"0.1\";i:1;s:4:\"0.25\";i:2;s:3:\"yes\";i:3;s:4:\"0.75\";i:4;s:1:\"1\";i:5;s:3:\"1.6\";}}}i:6;a:7:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:8:\"go_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:7;a:7:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#u0uQWA-kJOY\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:8;a:7:{s:4:\"slug\";s:15:\"general_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:9;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:28:\"HEADER CUSTOMIZATION OPTIONS\";s:11:\"description\";s:53:\"These are header advanced options for customisations.\";s:2:\"id\";s:11:\"info_title2\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:10;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Header over Subheader / Slideshow?\";s:11:\"description\";s:216:\"This will basically toggle the header\'s css position, from \'absolute\' to \'relative\'. If this option is disabled, the subheader or slideshow will go after the header. Don\'t foget to style the background of the header.\";s:2:\"id\";s:13:\"head_position\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:11;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:14:\"STYLES OPTIONS\";s:11:\"description\";s:81:\"These options are dedicated to customizing the header background and text colors.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:12;a:8:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"Header Style\";s:11:\"description\";s:39:\"Select the desired style for the header\";s:2:\"id\";s:12:\"header_style\";s:3:\"std\";s:7:\"default\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:11:\"image_color\";s:40:\"Custom ( Background Image, Color, Font )\";}}i:13;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:23:\"Header Background Image\";s:11:\"description\";s:59:\"Please choose your desired image to be used as a background\";s:2:\"id\";s:18:\"header_style_image\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";}s:4:\"type\";s:10:\"background\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"header_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}}i:14;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Background Color\";s:11:\"description\";s:58:\"Please choose your desired background color for the header\";s:2:\"id\";s:18:\"header_style_color\";s:5:\"alpha\";s:1:\"1\";s:3:\"std\";s:4:\"#000\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"header_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}}i:15;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Header Text Color\";s:11:\"description\";s:166:\"Please choose a text color scheme. This helps in case you add a dark background and you want light colors, or in case of light background - dark colors for the texts.\";s:2:\"id\";s:18:\"header_text_scheme\";s:3:\"std\";s:7:\"default\";s:7:\"options\";a:4:{s:7:\"default\";s:20:\"Header style default\";s:5:\"light\";s:11:\"Light color\";s:4:\"gray\";s:14:\"Grayish colors\";s:4:\"dark\";s:13:\"Darken colors\";}s:4:\"type\";s:6:\"select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"header_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}}i:16;a:10:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:32:\"Sticky Header - Background Color\";s:11:\"description\";s:79:\"Please choose your desired background color for the header when in sticky mode.\";s:2:\"id\";s:25:\"sticky_header_style_color\";s:5:\"alpha\";s:1:\"1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:5:\"class\";s:22:\"zn-top-separator--thin\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"header_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}i:1;a:2:{s:7:\"element\";s:11:\"menu_follow\";s:5:\"value\";a:1:{i:0;s:6:\"sticky\";}}}}i:17;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:33:\"Sticky Header - Header Text Color\";s:11:\"description\";s:54:\"Please choose a text color scheme when in sticky mode.\";s:2:\"id\";s:25:\"sticky_header_text_scheme\";s:3:\"std\";s:7:\"default\";s:7:\"options\";a:4:{s:7:\"default\";s:20:\"Header style default\";s:5:\"light\";s:11:\"Light color\";s:4:\"gray\";s:14:\"Grayish colors\";s:4:\"dark\";s:13:\"Darken colors\";}s:4:\"type\";s:6:\"select\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"header_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}i:1;a:2:{s:7:\"element\";s:11:\"menu_follow\";s:5:\"value\";a:1:{i:0;s:6:\"sticky\";}}}}i:18;a:10:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:22:\"Header\'s TOP Bar Style\";s:11:\"description\";s:50:\"Select the desired style for the header\'s top bar.\";s:2:\"id\";s:12:\"topbar_style\";s:3:\"std\";s:7:\"default\";s:4:\"type\";s:8:\"zn_radio\";s:5:\"class\";s:16:\"zn-non-dependent\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";s:30:\"Custom Size & Background Color\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:9:{i:0;s:6:\"style7\";i:1;s:6:\"style8\";i:2;s:6:\"style9\";i:3;s:7:\"style10\";i:4;s:7:\"style11\";i:5;s:7:\"style12\";i:6;s:7:\"style13\";i:7;s:7:\"style14\";i:8;s:7:\"style15\";}}}i:19;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"Top Bar Width\";s:11:\"description\";s:55:\"Please choose if you want the Top Bar to be full-width.\";s:2:\"id\";s:11:\"topbar_size\";s:3:\"std\";s:7:\"default\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:7:\"default\";s:20:\"Header style default\";s:6:\"normal\";s:6:\"Normal\";s:4:\"full\";s:10:\"Full width\";}s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"topbar_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}i:1;a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:9:{i:0;s:6:\"style7\";i:1;s:6:\"style8\";i:2;s:6:\"style9\";i:3;s:7:\"style10\";i:4;s:7:\"style11\";i:5;s:7:\"style12\";i:6;s:7:\"style13\";i:7;s:7:\"style14\";i:8;s:7:\"style15\";}}}}i:20;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:26:\"Top Bar - Background Color\";s:11:\"description\";s:68:\"Please choose your desired background color for the header\'s Top Bar\";s:2:\"id\";s:15:\"topbar_bg_color\";s:5:\"alpha\";s:1:\"1\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"topbar_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}i:1;a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:9:{i:0;s:6:\"style7\";i:1;s:6:\"style8\";i:2;s:6:\"style9\";i:3;s:7:\"style10\";i:4;s:7:\"style11\";i:5;s:7:\"style12\";i:6;s:7:\"style13\";i:7;s:7:\"style14\";i:8;s:7:\"style15\";}}}}i:21;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Top Bar - Text Color\";s:11:\"description\";s:166:\"Please choose a text color scheme. This helps in case you add a dark background and you want light colors, or in case of light background - dark colors for the texts.\";s:2:\"id\";s:18:\"topbar_text_scheme\";s:3:\"std\";s:7:\"default\";s:7:\"options\";a:4:{s:7:\"default\";s:20:\"Header style default\";s:5:\"light\";s:11:\"Light color\";s:4:\"gray\";s:14:\"Grayish colors\";s:4:\"dark\";s:13:\"Darken colors\";}s:4:\"type\";s:6:\"select\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"topbar_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}i:1;a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:9:{i:0;s:6:\"style7\";i:1;s:6:\"style8\";i:2;s:6:\"style9\";i:3;s:7:\"style10\";i:4;s:7:\"style11\";i:5;s:7:\"style12\";i:6;s:7:\"style13\";i:7;s:7:\"style14\";i:8;s:7:\"style15\";}}}}i:22;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Header Font\";s:11:\"description\";s:40:\"Override the default font of the header.\";s:2:\"id\";s:11:\"topbar_font\";s:3:\"std\";s:0:\"\";s:8:\"supports\";a:1:{i:0;s:4:\"font\";}s:4:\"type\";s:4:\"font\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:12:\"topbar_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}i:1;a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:9:{i:0;s:6:\"style7\";i:1;s:6:\"style8\";i:2;s:6:\"style9\";i:3;s:7:\"style10\";i:4;s:7:\"style11\";i:5;s:7:\"style12\";i:6;s:7:\"style13\";i:7;s:7:\"style14\";i:8;s:7:\"style15\";}}}}i:23;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"SIZE OPTIONS\";s:11:\"description\";s:60:\"These options are dedicated to customizing the header sizes.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:24;a:10:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:15:\"header_width_v2\";s:4:\"name\";s:12:\"Header Width\";s:11:\"description\";s:104:\"Choose the desired width for the header\'s container. It will be applied on Large breakpoints ( 1200px );\";s:4:\"type\";s:12:\"smart_slider\";s:3:\"std\";a:9:{s:11:\"breakpoints\";s:1:\"1\";s:2:\"lg\";s:4:\"1170\";s:7:\"unit_lg\";s:2:\"px\";s:2:\"md\";s:3:\"100\";s:7:\"unit_md\";s:1:\"%\";s:2:\"sm\";s:3:\"100\";s:7:\"unit_sm\";s:1:\"%\";s:2:\"xs\";s:3:\"100\";s:7:\"unit_xs\";s:1:\"%\";}s:8:\"supports\";a:1:{i:0;s:11:\"breakpoints\";}s:5:\"units\";a:2:{i:0;s:2:\"px\";i:1;s:1:\"%\";}s:7:\"helpers\";a:2:{s:3:\"min\";s:2:\"20\";s:3:\"max\";s:4:\"1900\";}}i:25;a:8:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"Header Height\";s:11:\"description\";s:38:\"You can customize the header\'s height.\";s:2:\"id\";s:18:\"zn_head_height_enb\";s:3:\"std\";s:7:\"default\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";a:2:{s:5:\"title\";s:13:\"Custom Height\";s:3:\"tip\";s:32:\"It will maintain vertical ratio.\";}s:11:\"custom_rows\";a:2:{s:5:\"title\";s:22:\"Custom height per Rows\";s:3:\"tip\";s:42:\"Advanced options for full customisability.\";}}}i:26;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Header Height (in px)\";s:11:\"description\";s:88:\"Header\'s height. By default it\'s 100px. <strong>Leave empty if you\'re not sure!</strong>\";s:2:\"id\";s:14:\"zn_head_height\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:11:\"placeholder\";s:9:\"ex: 100px\";s:10:\"dependency\";a:2:{s:7:\"element\";s:18:\"zn_head_height_enb\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:27;a:9:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:22:\"Custom height per Rows\";s:11:\"description\";s:39:\"You can customize any row of the header\";s:2:\"id\";s:19:\"zn_head_height_rows\";s:10:\"dependency\";a:2:{s:7:\"element\";s:18:\"zn_head_height_enb\";s:5:\"value\";a:1:{i:0;s:11:\"custom_rows\";}}s:4:\"type\";s:10:\"group_text\";s:3:\"std\";a:1:{s:6:\"others\";s:1:\"0\";}s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span3\";s:7:\"options\";a:4:{i:0;a:3:{s:4:\"name\";s:7:\"TOP ROW\";s:2:\"id\";s:3:\"top\";s:11:\"placeholder\";s:8:\"eg: 50px\";}i:1;a:3:{s:4:\"name\";s:8:\"MAIN ROW\";s:2:\"id\";s:4:\"main\";s:11:\"placeholder\";s:8:\"eg: 70px\";}i:2;a:3:{s:4:\"name\";s:10:\"BOTTOM ROW\";s:2:\"id\";s:6:\"bottom\";s:11:\"placeholder\";s:8:\"eg: 50px\";}i:3;a:3:{s:4:\"name\";s:6:\"OTHERS\";s:2:\"id\";s:6:\"others\";s:11:\"placeholder\";s:8:\"eg: 10px\";}}}}i:28;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"OTHER OPTIONS\";s:11:\"description\";s:42:\"These are various header advanced options.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:29;a:10:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Page Scrolling - Custom Top Offset\";s:11:\"description\";s:158:\"You can adjust the top offset of the page when using a scroll to anchor functionality, such as one page scrolling. You can add 0 and it will reset the offset.\";s:2:\"id\";s:20:\"top_offset_tolerance\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:11:\"zn_input_xs\";s:7:\"numeric\";s:1:\"1\";s:7:\"helpers\";a:3:{s:3:\"min\";s:4:\"-100\";s:3:\"max\";s:3:\"100\";s:4:\"step\";s:1:\"1\";}}i:30;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:8:\"ho_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:31;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#TuXcJu9jl7c\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:32;a:7:{s:4:\"slug\";s:16:\"head_adv_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:33;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"LOGO OPTIONS\";s:11:\"description\";s:155:\"These options below are related to site\'s logo. ( <a href=\"http://hogash.d.pr/108qR\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title3\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:34;a:9:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Show LOGO in header\";s:11:\"description\";s:53:\"Please choose if you want to display the logo or not.\";s:2:\"id\";s:14:\"head_show_logo\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:35;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Logo Upload\";s:11:\"description\";s:380:\"Upload your logo. <br><br> <span class=\'dashicons dashicons-editor-help\'></span> <strong>Logo not changing?</strong> Check if there\'s any <a href=\"https://modelox.vico.digital/wp-admin/edit.php?post_type=zn_layout\">page layout</a> assigned to the page you\'re working on, or <a href=\"https://my.hogash.com/documentation/logo-is-not-changing/\" target=\"_blank\">read this article</a>.\";s:2:\"id\";s:11:\"logo_upload\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";}i:36;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Logo Size :\";s:11:\"description\";s:194:\"Auto resize logo will use the image dimensions, Custom size let\'s you set the desired logo size and Contain in header will select the proper logo size so that it will be displayed in the header.\";s:2:\"id\";s:9:\"logo_size\";s:3:\"std\";s:7:\"contain\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{s:3:\"yes\";s:16:\"Auto resize logo\";s:2:\"no\";s:11:\"Custom size\";s:7:\"contain\";s:17:\"Contain in header\";}}i:37;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Logo manual sizes\";s:11:\"description\";s:67:\"Please insert your desired logo size in pixels ( for example \"35\" )\";s:2:\"id\";s:16:\"logo_manual_size\";s:3:\"std\";a:2:{s:6:\"height\";s:2:\"55\";s:5:\"width\";s:3:\"125\";}s:4:\"type\";s:10:\"image_size\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"logo_size\";s:5:\"value\";a:1:{i:0;s:2:\"no\";}}}i:38;a:9:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Sticky Logo\";s:11:\"description\";s:162:\"Will display a secondary logo when header is sticky and scrolling the page. <strong>ONLY</strong> available if you have Sticky Header enabled in General Options. \";s:2:\"id\";s:11:\"logo_sticky\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";s:10:\"dependency\";a:2:{s:7:\"element\";s:11:\"menu_follow\";s:5:\"value\";a:1:{i:0;s:6:\"sticky\";}}s:5:\"class\";s:16:\"zn-non-dependent\";}i:39;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:14:\"Logo on Mobile\";s:11:\"description\";s:88:\"Upload your logo for displaying on viewports smaller than 767px (smartphones, phablets).\";s:2:\"id\";s:18:\"logo_upload_mobile\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";}i:40;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:22:\"Logo TEXT Link Options\";s:11:\"description\";s:88:\"Specify the logo typography properties. Will only work if you don\'t upload a logo image.\";s:2:\"id\";s:9:\"logo_font\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"36px\";s:11:\"font-family\";s:9:\"Open Sans\";s:10:\"font-style\";s:6:\"normal\";s:5:\"color\";s:4:\"#000\";s:11:\"line-height\";s:4:\"40px\";}s:8:\"supports\";a:6:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:5:\"color\";i:4;s:4:\"line\";i:5;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:41;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:26:\"Logo TEXT Link Hover Color\";s:11:\"description\";s:79:\"Specify the logo hover color. Will only work if you don\'t upload a logo image. \";s:2:\"id\";s:10:\"logo_hover\";s:3:\"std\";a:1:{s:5:\"color\";s:7:\"#CD2122\";}s:8:\"supports\";a:1:{i:0;s:5:\"color\";}s:4:\"type\";s:4:\"font\";}i:42;a:9:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Logo Background\";s:11:\"description\";s:43:\"Choose the logo container background color.\";s:2:\"id\";s:7:\"logo_bg\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:5:\"alpha\";s:4:\"true\";s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"zn_header_layout\";s:5:\"value\";a:1:{i:0;s:7:\"style14\";}}}i:43;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"LOGO INFOCARD OPTIONS\";s:11:\"description\";s:165:\"These options below are related to logo\'s info card panel. ( <a href=\"http://hogash.d.pr/TiFZ\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title5\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:44;a:9:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:43:\"Show Info Card when you hover over the logo\";s:11:\"description\";s:58:\"Please choose if you want to display the info card or not.\";s:2:\"id\";s:23:\"infocard_display_status\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:45;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Set a background for the Info Card\";s:11:\"description\";s:45:\"Choose the background color for the Info Card\";s:2:\"id\";s:17:\"infocard_bg_color\";s:3:\"std\";s:7:\"#cd2122\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:46;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Set a text color for the Info Card\";s:11:\"description\";s:39:\"Choose the text color for the Info Card\";s:2:\"id\";s:19:\"infocard_text_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:47;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Choose company logo\";s:11:\"description\";s:55:\"Choose your company logo which will appear in info card\";s:2:\"id\";s:17:\"infocard_logo_url\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:48;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Company Description\";s:11:\"description\";s:47:\"Please type a small description of your company\";s:2:\"id\";s:28:\"infocard_company_description\";s:3:\"std\";s:71:\"Kallyas is an ultra-premium, responsive theme built for today websites.\";s:4:\"type\";s:8:\"textarea\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:49;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"Company phone\";s:11:\"description\";s:37:\"Please type your company phone number\";s:2:\"id\";s:22:\"infocard_company_phone\";s:3:\"std\";s:17:\"T (212) 555 55 00\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:50;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"Company email\";s:11:\"description\";s:30:\"Please type your company email\";s:2:\"id\";s:22:\"infocard_company_email\";s:3:\"std\";s:21:\"sales@yourwebsite.com\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:51;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"Company name\";s:11:\"description\";s:27:\"Type your company name here\";s:2:\"id\";s:21:\"infocard_company_name\";s:3:\"std\";s:16:\"Your Company LTD\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:52;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Company address\";s:11:\"description\";s:30:\"Type your company address here\";s:2:\"id\";s:24:\"infocard_company_address\";s:3:\"std\";s:35:\"Street nr 100, 4536534, Chicago, US\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:53;a:8:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Company map link\";s:11:\"description\";s:33:\"Please enter you company map link\";s:2:\"id\";s:18:\"infocard_gmap_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:54;a:10:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:47:\"Show or hide the Social icons in the info card.\";s:11:\"description\";s:72:\"Please select the visibility status of the Social Icons in the Info card\";s:2:\"id\";s:33:\"social_icons_info_card_visibility\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";s:10:\"dependency\";a:2:{s:7:\"element\";s:23:\"infocard_display_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:55;a:9:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:22:\"Show \"Hover Me\" text .\";s:11:\"description\";s:65:\"Choose to display or hide the \'hover me\' text right next to logo.\";s:2:\"id\";s:16:\"infocard_hoverme\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:56;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"lgo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:57;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:235:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#m2dbZdeciZs\" target=\"_blank\">Click here to access video tutorial for LOGO OPTIONS.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:58;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:244:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#TuXcJu9jl7c\" target=\"_blank\">Click here to access video tutorial for LOGO INFOCARD OPTIONS.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:59;a:7:{s:4:\"slug\";s:12:\"logo_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:60;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:14:\"HEADER OPTIONS\";s:11:\"description\";s:156:\"These options below are related to site\'s header ( <a href=\"http://hogash.d.pr/1cv3m\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title2\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:61;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:13:\"Header Layout\";s:11:\"description\";s:40:\"Please choose the desired header layout.\";s:2:\"id\";s:16:\"zn_header_layout\";s:3:\"std\";s:6:\"style2\";s:4:\"type\";s:11:\"radio_image\";s:5:\"class\";s:37:\"zn_full ri-hover-line ri-5 ri-maxover\";s:7:\"options\";a:16:{i:0;a:3:{s:5:\"value\";s:6:\"style1\";s:4:\"name\";s:14:\"Style 1.1 (#1)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style1.svg\";}i:1;a:3:{s:5:\"value\";s:6:\"style2\";s:4:\"name\";s:14:\"Style 1.2 (#2)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style2.svg\";}i:2;a:3:{s:5:\"value\";s:6:\"style3\";s:4:\"name\";s:14:\"Style 1.3 (#3)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style3.svg\";}i:3;a:3:{s:5:\"value\";s:6:\"style4\";s:4:\"name\";s:14:\"Style 1.4 (#4)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style4.svg\";}i:4;a:3:{s:5:\"value\";s:6:\"style5\";s:4:\"name\";s:14:\"Style 1.5 (#5)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style5.svg\";}i:5;a:3:{s:5:\"value\";s:6:\"style6\";s:4:\"name\";s:14:\"Style 1.6 (#6)\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style6.svg\";}i:6;a:3:{s:5:\"value\";s:6:\"style7\";s:4:\"name\";s:7:\"Style 7\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style7.svg\";}i:7;a:3:{s:5:\"value\";s:6:\"style8\";s:4:\"name\";s:7:\"Style 8\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style8.svg\";}i:8;a:3:{s:5:\"value\";s:6:\"style9\";s:4:\"name\";s:7:\"Style 9\";s:5:\"image\";s:92:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style9.svg\";}i:9;a:3:{s:5:\"value\";s:7:\"style10\";s:4:\"name\";s:8:\"Style 10\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style10.svg\";}i:10;a:3:{s:5:\"value\";s:7:\"style11\";s:4:\"name\";s:8:\"Style 11\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style11.png\";}i:11;a:3:{s:5:\"value\";s:7:\"style12\";s:4:\"name\";s:8:\"Style 12\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style12.png\";}i:12;a:3:{s:5:\"value\";s:7:\"style13\";s:4:\"name\";s:15:\"Style 13 (11.1)\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style13.png\";}i:13;a:3:{s:5:\"value\";s:7:\"style14\";s:4:\"name\";s:8:\"Style 14\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style14.png\";}i:14;a:3:{s:5:\"value\";s:7:\"style15\";s:4:\"name\";s:8:\"Style 15\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style15.png\";}i:15;a:3:{s:5:\"value\";s:7:\"style16\";s:4:\"name\";s:8:\"Style 16\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-styles/style16.png\";}}}i:62;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:27:\"Header state on page scroll\";s:11:\"description\";s:191:\"The scrolling menu will only display a simple cloned main navigation, upon scrolling.<br> The Sticky header, upon scrolling, will fix the entire menu to top even when scrolling to the bottom.\";s:2:\"id\";s:11:\"menu_follow\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:4:{i:0;a:4:{s:5:\"value\";s:3:\"yes\";s:4:\"name\";s:44:\"Scrolling Menu (a.k.a. Chaser / Follow menu)\";s:4:\"desc\";s:94:\"Upon scrolling, will display a bar aligned at the top of the website displaying the main menu.\";s:5:\"image\";s:110:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/scrolling-menu-1.gif\";}i:1;a:4:{s:5:\"value\";s:6:\"sticky\";s:4:\"name\";s:13:\"Sticky Header\";s:4:\"desc\";s:106:\"The entire site-header will be fixed to the top of the website when scrolling, and in some cases, resized.\";s:5:\"image\";s:110:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/scrolling-menu-2.gif\";}i:2;a:3:{s:5:\"value\";s:5:\"fixed\";s:4:\"name\";s:12:\"Fixed Header\";s:4:\"desc\";s:102:\"The entire site-header will be fixed to the top of the website when scrolling without resizing itself.\";}i:3;a:3:{s:5:\"value\";s:2:\"no\";s:4:\"name\";s:3:\"No.\";s:5:\"image\";s:110:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/scrolling-menu-3.gif\";}}s:4:\"type\";s:12:\"smart_select\";}i:63;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:25:\"Language selector options\";s:11:\"description\";s:63:\"These options are dedicated to the language selector in header.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:64;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Show WPML languages ?\";s:11:\"description\";s:106:\"Choose yes if you want to show WPML languages in header. Please note that you will\r\n		need WPML installed.\";s:2:\"id\";s:15:\"head_show_flags\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:65;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:23:\"Language selector style\";s:11:\"description\";s:52:\"Choose the style of the multi-language selector box.\";s:2:\"id\";s:16:\"head_flags_style\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:5:{i:0;a:3:{s:5:\"value\";s:0:\"\";s:4:\"name\";s:7:\"Inherit\";s:4:\"desc\";s:34:\"Will inherit from header\'s layout.\";}i:1;a:3:{s:5:\"value\";s:3:\"def\";s:4:\"name\";s:7:\"Default\";s:5:\"image\";s:112:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/smart_select/languages/languages_default.png\";}i:2;a:3:{s:5:\"value\";s:3:\"alt\";s:4:\"name\";s:11:\"Alternative\";s:5:\"image\";s:116:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/smart_select/languages/languages_alternative.png\";}i:3;a:3:{s:5:\"value\";s:5:\"flags\";s:4:\"name\";s:10:\"Just flags\";s:5:\"image\";s:110:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/smart_select/languages/languages_flags.png\";}i:4;a:3:{s:5:\"value\";s:4:\"text\";s:4:\"name\";s:11:\"Text Inline\";s:5:\"image\";s:109:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/smart_select/languages/languages_text.png\";}}s:4:\"type\";s:12:\"smart_select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"head_show_flags\";s:5:\"value\";a:1:{i:0;s:1:\"1\";}}}i:66;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:28:\"Login button & panel options\";s:11:\"description\";s:120:\"These options are dedicated to the login button link in the header, but also Login/Register/Forgot password popup forms.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:67;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:27:\"Show \"Login\" link in Header\";s:11:\"description\";s:420:\"Choose yes if you want to show a link that will let users login/register or retrieve their lost password. Please note that in order to show the registration page, you need to allow user registration from General settings. <br> You can select the 3rd option, to hide the button, but enable the modal window to load. For example in case you want to link the hidden login panel from elsewhere (Main menu or Call to action).\";s:2:\"id\";s:15:\"head_show_login\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";i:2;s:42:\"Hide Button, but load Login Modal (Hidden)\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:68;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:40:\"Show \"Register / Sign up\" link in Header\";s:11:\"description\";s:423:\"Choose yes if you want to show a link that will let users login/register or retrieve their lost password. Please note that in order to show the registration page, you need to allow user registration from General settings. <br> You can select the 3rd option, to hide the button, but enable the modal window to load. For example in case you want to link the hidden register panel from elsewhere (Main menu or Call to action).\";s:2:\"id\";s:18:\"head_show_register\";s:3:\"std\";s:1:\"2\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";i:2;s:45:\"Hide Button, but load Register Modal (Hidden)\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:69;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Search Box in Header\";s:11:\"description\";s:56:\"These options are dedicated to the search box in header.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:70;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Show SEARCH in header\";s:11:\"description\";s:62:\"Please choose if you want to display the search button or not.\";s:2:\"id\";s:16:\"head_show_search\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:71;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Search Box style\";s:11:\"description\";s:55:\"Choose the style of the search box component in header.\";s:2:\"id\";s:17:\"head_search_style\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:6:{i:0;a:3:{s:5:\"value\";s:0:\"\";s:4:\"name\";s:7:\"Inherit\";s:4:\"desc\";s:34:\"Will inherit from header\'s layout.\";}i:1;a:4:{s:5:\"value\";s:3:\"def\";s:4:\"name\";s:7:\"Compact\";s:4:\"desc\";s:20:\"Click-to-open button\";s:5:\"image\";s:111:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/searchbox-compact.gif\";}i:2;a:3:{s:5:\"value\";s:3:\"inp\";s:4:\"name\";s:12:\"Input Layout\";s:5:\"image\";s:109:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/searchbox-input.gif\";}i:3;a:3:{s:5:\"value\";s:4:\"bord\";s:4:\"name\";s:23:\"Bottom Bordered Minimal\";s:5:\"image\";s:127:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/searchbox-bottom-bordered-minimal.gif\";}i:4;a:3:{s:5:\"value\";s:5:\"bord2\";s:4:\"name\";s:25:\"Bottom Bordered Minimal 2\";s:5:\"image\";s:127:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/searchbox-bottom-bordered-minimal.gif\";}i:5;a:4:{s:5:\"value\";s:3:\"min\";s:4:\"name\";s:7:\"Minimal\";s:4:\"desc\";s:45:\"Loupe Icon that will expand the search field.\";s:5:\"image\";s:122:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/searchbox-minimal-loupe-icon.gif\";}}s:4:\"type\";s:12:\"smart_select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"head_show_search\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:72;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Custom Text in Header\";s:11:\"description\";s:138:\"These options are dedicated to the header text in header. Please know that this text is only available for certain types of Header layouts\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:73;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Top header text\";s:11:\"description\";s:41:\"Will display any text (ex: phone number).\";s:2:\"id\";s:18:\"zn_head_s7_toptext\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:11:\"zn_input_xl\";}i:74;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:41:\"Hidden Panel options ( \"SUPPORT\" button )\";s:11:\"description\";s:428:\"<span class=\"dashicons dashicons-warning\"></span> <strong>To add content in the \"Support\" - Hidden panel, follow these steps:</strong><br> Go to <a href=\"https://modelox.vico.digital/wp-admin/widgets.php\">Appearance > Widgets</a> and inside the widgets position called \"Hidden panel sidebar\", make sure it has the Text widget inside, or add a new Text Widget ( <a href=\"http://hogash.d.pr/ypNB\" target=\"_blank\">screenshot</a> ).\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:75;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:28:\"Show SUPPORT panel in header\";s:11:\"description\";s:270:\"Please choose if you want to display the call to action button or not.<br> If you want to open the panel through the main menu, choose <strong>\'Load panel (closed), but Hide Button\'</strong> and add the class <code>show-top-hidden-panel</code> to the menu item you want.\";s:2:\"id\";s:21:\"head_show_support_pnl\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";s:4:\"load\";s:36:\"Load panel (closed), but Hide Button\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:76;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Support content type\";s:11:\"description\";s:65:\"Select what type of content you want to show in the hidden panel.\";s:2:\"id\";s:25:\"hidden_panel_content_type\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:6:\"widget\";s:36:\"Widget area ( Hidden Panel Sidebar )\";s:11:\"pb_template\";s:22:\"Pagebuilder Smart Area\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:21:\"head_show_support_pnl\";s:5:\"value\";a:2:{i:0;s:3:\"yes\";i:1;s:4:\"load\";}}}i:77;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:24:\"hidden_panel_pb_template\";s:4:\"name\";s:29:\"Select Pagebuilder Smart Area\";s:11:\"description\";s:99:\"Using this option you can select a pre-built template made at Admin > Pagebuilder Smart Areas page.\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:1:{s:0:\"\";s:25:\"-- Select a smart area --\";}s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:21:\"head_show_support_pnl\";s:5:\"value\";a:2:{i:0;s:3:\"yes\";i:1;s:4:\"load\";}}i:1;a:2:{s:7:\"element\";s:25:\"hidden_panel_content_type\";s:5:\"value\";a:1:{i:0;s:11:\"pb_template\";}}}}i:78;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Support button text\";s:11:\"description\";s:131:\"Enter the desired button text that will appear for the support button in header. If left blank, the Support word will be displayed.\";s:2:\"id\";s:18:\"hidden_panel_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:10:\"dependency\";a:2:{s:7:\"element\";s:21:\"head_show_support_pnl\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:79;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:23:\"Select background color\";s:11:\"description\";s:45:\"Select background color for the hidden panel.\";s:2:\"id\";s:15:\"hidden_panel_bg\";s:3:\"std\";s:7:\"#F0F0F0\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:21:\"head_show_support_pnl\";s:5:\"value\";a:2:{i:0;s:3:\"yes\";i:1;s:4:\"load\";}}}i:80;a:8:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Select font color\";s:11:\"description\";s:39:\"Select font color for the hidden panel.\";s:2:\"id\";s:15:\"hidden_panel_fg\";s:3:\"std\";s:7:\"#000000\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:21:\"head_show_support_pnl\";s:5:\"value\";a:2:{i:0;s:3:\"yes\";i:1;s:4:\"load\";}}}i:81;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:22:\"Social Icons in Header\";s:11:\"description\";s:64:\"These options are dedicated to the social icons group in header.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:82;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:44:\"Show or hide the Social icons in the header.\";s:11:\"description\";s:135:\"Please select the visibility status of the Social Icons(this setting will not affect the visibility of Social Icons from the info Card)\";s:2:\"id\";s:30:\"social_icons_visibility_status\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:83;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:35:\"Use normal or colored social icons?\";s:11:\"description\";s:90:\"Here you can choose to use the normal social icons or the colored version of each\r\n		icon.\";s:2:\"id\";s:22:\"header_which_icons_set\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:4:{i:0;a:3:{s:5:\"value\";s:6:\"normal\";s:4:\"name\";s:12:\"Normal Icons\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-social-icons/normal.png\";}i:1;a:3:{s:5:\"value\";s:7:\"colored\";s:4:\"name\";s:13:\"Colored icons\";s:5:\"image\";s:99:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-social-icons/colored.png\";}i:2;a:3:{s:5:\"value\";s:11:\"colored_hov\";s:4:\"name\";s:22:\"Colored on Hover icons\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-social-icons/colored_hov.png\";}i:3;a:3:{s:5:\"value\";s:5:\"clean\";s:4:\"name\";s:11:\"Clean icons\";s:5:\"image\";s:97:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-social-icons/clean.png\";}}s:4:\"type\";s:12:\"smart_select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:30:\"social_icons_visibility_status\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:84;a:12:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"Social Icons\";s:11:\"description\";s:83:\"Here you can configure what social icons to appear on the right side of the header.\";s:2:\"id\";s:19:\"header_social_icons\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:13:\"element_title\";s:19:\"header_social_title\";s:8:\"add_text\";s:11:\"Social Icon\";s:11:\"remove_text\";s:11:\"Social Icon\";s:11:\"subelements\";a:4:{i:0;a:5:{s:4:\"name\";s:10:\"Icon title\";s:11:\"description\";s:149:\"Here you can enter a title for this social icon.Please note that this is just\r\n				for your information as this text will not be visible on the site.\";s:2:\"id\";s:19:\"header_social_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:1;a:6:{s:4:\"name\";s:16:\"Social icon link\";s:11:\"description\";s:114:\"Please enter your desired link for the social icon. If this field is left\r\n				blank, the icon will not be linked.\";s:2:\"id\";s:18:\"header_social_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"link\";s:7:\"options\";a:2:{s:6:\"_blank\";s:10:\"New window\";s:5:\"_self\";s:11:\"Same window\";}}i:2;a:5:{s:4:\"name\";s:28:\"Social icon Background color\";s:11:\"description\";s:126:\"Select a background color for the icon (if you selected <strong>Colored</strong> or <strong>Colored on hover</strong> options)\";s:2:\"id\";s:19:\"header_social_color\";s:3:\"std\";s:4:\"#000\";s:4:\"type\";s:11:\"colorpicker\";}i:3;a:6:{s:4:\"name\";s:11:\"Social icon\";s:11:\"description\";s:32:\"Select your desired social icon.\";s:2:\"id\";s:18:\"header_social_icon\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:9:\"icon_list\";s:5:\"class\";s:7:\"zn_full\";}}s:5:\"class\";s:0:\"\";}i:85;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:37:\"Settings for mobiles (small viewport)\";s:11:\"description\";s:51:\"These options are applied to the header on mobiles.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:86;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:34:\"Header Background Color on Mobiles\";s:11:\"description\";s:129:\"This will change the existing <strong>background color</strong> on Mobile devices, more exactly for device width less than 480px.\";s:2:\"id\";s:20:\"zn_header_resp_color\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";}i:87;a:9:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:24:\"header_components_mobile\";s:4:\"name\";s:32:\"HIDE Header Components on Mobile\";s:11:\"description\";s:125:\"Select which components from the header you want to hide on mobiles or better said, viewports of maximum 767px (smartphones).\";s:4:\"type\";s:8:\"checkbox\";s:7:\"options\";a:10:{s:13:\"header-search\";s:10:\"Search Box\";s:12:\"topnav--lang\";s:17:\"Language selector\";s:11:\"topnav--log\";s:12:\"Login button\";s:11:\"topnav--reg\";s:15:\"Register button\";s:17:\"kl-header-toptext\";s:11:\"Custom Text\";s:21:\"topnav--sliding-panel\";s:29:\"Hidden Panel (Support Button)\";s:12:\"social-icons\";s:12:\"Social Icons\";s:25:\"zn_header_top_nav-wrapper\";s:22:\"Header Menu Navigation\";s:9:\"ctabutton\";s:21:\"Call To Action Button\";s:12:\"topnav--cart\";s:26:\"Shopping Cart Button/Panel\";}s:3:\"std\";s:0:\"\";s:5:\"class\";s:7:\"zn_full\";}i:88;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:8:\"ho_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:89;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#TuXcJu9jl7c\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:90;a:7:{s:4:\"slug\";s:14:\"header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:91;a:7:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:38:\"HEADER\'S CALL TO ACTION BUTTON OPTIONS\";s:11:\"description\";s:182:\"These options below are related to site\'s call to action button in header. ( <a href=\"http://hogash.d.pr/1leyL\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title6\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:92;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:36:\"Show Call to Action button in header\";s:11:\"description\";s:70:\"Please choose if you want to display the call to action button or not.\";s:2:\"id\";s:13:\"head_show_cta\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:93;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:27:\"Call to Action button style\";s:11:\"description\";s:15:\"Select a style.\";s:2:\"id\";s:19:\"head_show_cta_style\";s:3:\"std\";s:6:\"ribbon\";s:7:\"options\";a:3:{i:0;a:4:{s:5:\"value\";s:6:\"ribbon\";s:4:\"name\";s:12:\"Ribbon style\";s:4:\"desc\";s:38:\"Nice button which looks like a ribbon.\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-calltoaction/ribbon.png\";}i:1;a:4:{s:5:\"value\";s:6:\"custom\";s:4:\"name\";s:19:\"Custom Button Style\";s:4:\"desc\";s:64:\"Supports up to 3 buttons and they can all be different in style.\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/header-calltoaction/custom.png\";}i:2;a:3:{s:5:\"value\";s:5:\"lined\";s:4:\"name\";s:12:\"Lined button\";s:4:\"desc\";s:43:\"Not recommended, use Custom button instead.\";}}s:4:\"type\";s:12:\"smart_select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:94;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:52:\"Set the link for the Call to Action button in header\";s:11:\"description\";s:49:\"Set the URL to link the Call to Action button to.\";s:2:\"id\";s:17:\"head_add_cta_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"link\";s:7:\"options\";a:6:{s:5:\"_self\";s:11:\"Same window\";s:6:\"_blank\";s:10:\"New window\";s:5:\"modal\";s:11:\"Modal Image\";s:12:\"modal_iframe\";s:12:\"Modal Iframe\";s:12:\"modal_inline\";s:20:\"Modal Inline content\";s:12:\"smoothscroll\";s:23:\"Smooth Scroll to Anchor\";}s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:95;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:42:\"Set the text for the Call to Action button\";s:11:\"description\";s:66:\"Select the text you want to display int the call to action button.\";s:2:\"id\";s:17:\"head_set_text_cta\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:11:\"zn_input_xl\";s:3:\"std\";s:26:\"<strong>FREE</strong>QUOTE\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:96;a:8:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:23:\"Select background color\";s:11:\"description\";s:54:\"Select Call to action (ribbon style) background color.\";s:2:\"id\";s:15:\"wpk_cs_bg_color\";s:3:\"std\";s:7:\"#cd2122\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:97;a:8:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Select text color\";s:11:\"description\";s:18:\"Select text color.\";s:2:\"id\";s:15:\"wpk_cs_fg_color\";s:3:\"std\";s:4:\"#fff\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:98;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:23:\"Hide button on mobiles?\";s:11:\"description\";s:68:\"Do you want to hide this button on mobile screens (-767px and below)\";s:2:\"id\";s:11:\"cta_hide_xs\";s:3:\"std\";s:0:\"\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:7:\"toggle2\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:99;a:9:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:26:\"Button display permissions\";s:11:\"description\";s:78:\"Using this option you can show/hide the button for different type of visitors.\";s:2:\"id\";s:8:\"cta_perm\";s:3:\"std\";s:3:\"all\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:3:\"all\";s:12:\"Show for all\";s:8:\"loggedin\";s:29:\"Show only for logged in users\";s:7:\"visitor\";s:40:\"Show only for visitors ( not logged in )\";}s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:2:{i:0;s:6:\"ribbon\";i:1;s:5:\"lined\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}}i:100;a:14:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:7:\"Buttons\";s:11:\"description\";s:50:\"Here you can add up to <strong>3 Buttons</strong>.\";s:2:\"id\";s:10:\"cta_custom\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:9:\"max_items\";s:1:\"3\";s:13:\"element_title\";s:8:\"cta_text\";s:8:\"add_text\";s:6:\"Button\";s:11:\"remove_text\";s:6:\"Button\";s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:19:\"head_show_cta_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}i:1;a:2:{s:7:\"element\";s:13:\"head_show_cta\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}s:11:\"subelements\";a:13:{i:0;a:6:{s:4:\"name\";s:4:\"Text\";s:11:\"description\";s:22:\"Text inside the button\";s:2:\"id\";s:8:\"cta_text\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:11:\"zn_input_xl\";}i:1;a:6:{s:4:\"name\";s:4:\"Link\";s:11:\"description\";s:27:\"Attach a link to the button\";s:2:\"id\";s:8:\"cta_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"link\";s:7:\"options\";a:6:{s:5:\"_self\";s:11:\"Same window\";s:6:\"_blank\";s:10:\"New window\";s:5:\"modal\";s:11:\"Modal Image\";s:12:\"modal_iframe\";s:12:\"Modal Iframe\";s:12:\"modal_inline\";s:20:\"Modal Inline content\";s:12:\"smoothscroll\";s:23:\"Smooth Scroll to Anchor\";}}i:2;a:6:{s:4:\"name\";s:5:\"Style\";s:11:\"description\";s:29:\"Select a style for the button\";s:2:\"id\";s:9:\"cta_style\";s:3:\"std\";s:13:\"btn-fullcolor\";s:4:\"type\";s:12:\"smart_select\";s:7:\"options\";a:31:{i:0;a:3:{s:5:\"value\";s:13:\"btn-fullcolor\";s:4:\"name\";s:17:\"Flat (main color)\";s:5:\"image\";s:101:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/01.flatmaincolor.jpg\";}i:1;a:3:{s:5:\"value\";s:30:\"btn-fullcolor btn-custom-color\";s:4:\"name\";s:19:\"Flat (custom color)\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/02.flatcustomcolor.jpg\";}i:2;a:3:{s:5:\"value\";s:13:\"btn-fullwhite\";s:4:\"name\";s:12:\"Flat (white)\";s:5:\"image\";s:97:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/03.flatwhite.jpg\";}i:3;a:3:{s:5:\"value\";s:13:\"btn-fullblack\";s:4:\"name\";s:12:\"Flat (black)\";s:5:\"image\";s:97:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/04.flatblack.jpg\";}i:4;a:3:{s:5:\"value\";s:9:\"btn-lined\";s:4:\"name\";s:13:\"Lined (light)\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/05.linedlight.jpg\";}i:5;a:3:{s:5:\"value\";s:20:\"btn-lined lined-dark\";s:4:\"name\";s:12:\"Lined (dark)\";s:5:\"image\";s:97:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/06.lineddark.jpg\";}i:6;a:3:{s:5:\"value\";s:20:\"btn-lined lined-gray\";s:4:\"name\";s:12:\"Lined (gray)\";s:5:\"image\";s:97:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/07.linedgrey.jpg\";}i:7;a:3:{s:5:\"value\";s:22:\"btn-lined lined-custom\";s:4:\"name\";s:18:\"Lined (main color)\";s:5:\"image\";s:102:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/08.linedmaincolor.jpg\";}i:8;a:3:{s:5:\"value\";s:26:\"btn-lined btn-custom-color\";s:4:\"name\";s:20:\"Lined (custom color)\";s:5:\"image\";s:104:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/09.linedcustomcolor.jpg\";}i:9;a:3:{s:5:\"value\";s:26:\"btn-lined lined-full-light\";s:4:\"name\";s:18:\"Lined-Full (light)\";s:5:\"image\";s:102:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/10.linedfulllight.jpg\";}i:10;a:3:{s:5:\"value\";s:25:\"btn-lined lined-full-dark\";s:4:\"name\";s:17:\"Lined-Full (dark)\";s:5:\"image\";s:101:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/11.linedfulldark.jpg\";}i:11;a:3:{s:5:\"value\";s:20:\"btn-lined btn-skewed\";s:4:\"name\";s:20:\"Lined-Skewed (light)\";s:5:\"image\";s:104:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/12.linedskewedlight.jpg\";}i:12;a:3:{s:5:\"value\";s:31:\"btn-lined btn-skewed lined-dark\";s:4:\"name\";s:19:\"Lined-Skewed (dark)\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/13.linedskeweddark.jpg\";}i:13;a:3:{s:5:\"value\";s:31:\"btn-lined btn-skewed lined-gray\";s:4:\"name\";s:19:\"Lined-Skewed (gray)\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/14.linedskewedgrey.jpg\";}i:14;a:3:{s:5:\"value\";s:24:\"btn-fullcolor btn-skewed\";s:4:\"name\";s:24:\"Flat-Skewed (main color)\";s:5:\"image\";s:107:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/15.flatskewedmaincolor.jpg\";}i:15;a:3:{s:5:\"value\";s:41:\"btn-fullcolor btn-skewed btn-custom-color\";s:4:\"name\";s:26:\"Flat-Skewed (custom color)\";s:5:\"image\";s:109:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/16.flatskewedcustomcolor.jpg\";}i:16;a:3:{s:5:\"value\";s:24:\"btn-fullwhite btn-skewed\";s:4:\"name\";s:19:\"Flat-Skewed (white)\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/17.flatskewedwhite.jpg\";}i:17;a:3:{s:5:\"value\";s:24:\"btn-fullblack btn-skewed\";s:4:\"name\";s:19:\"Flat-Skewed (black)\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/18.flatskewedblack.jpg\";}i:18;a:3:{s:5:\"value\";s:26:\"btn-fullcolor btn-bordered\";s:4:\"name\";s:26:\"Flat Bordered (main color)\";s:5:\"image\";s:108:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/19.flatborderdmaincolor.jpg\";}i:19;a:3:{s:5:\"value\";s:43:\"btn-fullcolor btn-bordered btn-custom-color\";s:4:\"name\";s:28:\"Flat Bordered (custom color)\";s:5:\"image\";s:110:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/20.flatborderdcustomcolor.jpg\";}i:20;a:3:{s:5:\"value\";s:11:\"btn-default\";s:4:\"name\";s:19:\"Bootstrap - Default\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/21.boostrapdefault.jpg\";}i:21;a:3:{s:5:\"value\";s:11:\"btn-primary\";s:4:\"name\";s:19:\"Bootstrap - Primary\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/22.boostrapprimary.jpg\";}i:22;a:3:{s:5:\"value\";s:11:\"btn-success\";s:4:\"name\";s:19:\"Bootstrap - Success\";s:5:\"image\";s:100:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/23.boostrapinfo.jpg\";}i:23;a:3:{s:5:\"value\";s:8:\"btn-info\";s:4:\"name\";s:16:\"Bootstrap - Info\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/24.boostrapsuccess.jpg\";}i:24;a:3:{s:5:\"value\";s:11:\"btn-warning\";s:4:\"name\";s:19:\"Bootstrap - Warning\";s:5:\"image\";s:103:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/25.boostrapwarning.jpg\";}i:25;a:3:{s:5:\"value\";s:10:\"btn-danger\";s:4:\"name\";s:18:\"Bootstrap - Danger\";s:5:\"image\";s:102:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/26.boostrapdanger.jpg\";}i:26;a:3:{s:5:\"value\";s:8:\"btn-link\";s:4:\"name\";s:16:\"Bootstrap - Link\";s:5:\"image\";s:100:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/27.boostraplink.jpg\";}i:27;a:3:{s:5:\"value\";s:8:\"btn-text\";s:4:\"name\";s:18:\"Simple linked text\";s:5:\"image\";s:102:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/28.simplelinktext.jpg\";}i:28;a:3:{s:5:\"value\";s:25:\"btn-text btn-custom-color\";s:4:\"name\";s:33:\"Simple linked text (Custom Color)\";s:5:\"image\";s:108:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/29.simplelinktextcustom.jpg\";}i:29;a:3:{s:5:\"value\";s:33:\"btn-underline btn-underline--thin\";s:4:\"name\";s:21:\"Simple Underline Thin\";s:5:\"image\";s:107:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/30.simpleunderlinethin.jpg\";}i:30;a:3:{s:5:\"value\";s:34:\"btn-underline btn-underline--thick\";s:4:\"name\";s:22:\"Simple Underline Thick\";s:5:\"image\";s:108:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/button_icons/31.simpleunderlinethick.jpg\";}}}i:3;a:7:{s:4:\"name\";s:19:\"Button Custom Color\";s:11:\"description\";s:27:\"Select button custom color.\";s:2:\"id\";s:16:\"cta_custom_color\";s:3:\"std\";s:7:\"#cd2122\";s:5:\"alpha\";s:1:\"1\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cta_style\";s:5:\"value\";a:4:{i:0;s:30:\"btn-fullcolor btn-custom-color\";i:1;s:26:\"btn-lined btn-custom-color\";i:2;s:41:\"btn-fullcolor btn-skewed btn-custom-color\";i:3;s:43:\"btn-fullcolor btn-bordered btn-custom-color\";}}}i:4;a:7:{s:4:\"name\";s:25:\"Button Custom Color HOVER\";s:11:\"description\";s:133:\"Select button custom color on hover. If not specified, the normal state color will be used with a 20% color adjustment in brightness.\";s:2:\"id\";s:20:\"cta_custom_color_hov\";s:3:\"std\";s:0:\"\";s:5:\"alpha\";s:1:\"1\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cta_style\";s:5:\"value\";a:4:{i:0;s:30:\"btn-fullcolor btn-custom-color\";i:1;s:26:\"btn-lined btn-custom-color\";i:2;s:41:\"btn-fullcolor btn-skewed btn-custom-color\";i:3;s:43:\"btn-fullcolor btn-bordered btn-custom-color\";}}}i:5;a:6:{s:4:\"name\";s:4:\"Size\";s:11:\"description\";s:28:\"Select a size for the button\";s:2:\"id\";s:8:\"cta_size\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:4:{s:0:\"\";s:7:\"Default\";s:6:\"btn-md\";s:6:\"Medium\";s:6:\"btn-sm\";s:5:\"Small\";s:6:\"btn-xs\";s:11:\"Extra small\";}}i:6;a:6:{s:4:\"name\";s:14:\"Button Corners\";s:11:\"description\";s:46:\"Select the button corners type for this button\";s:2:\"id\";s:11:\"cta_corners\";s:3:\"std\";s:12:\"btn--rounded\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:12:\"btn--rounded\";s:21:\"Smooth rounded corner\";s:10:\"btn--round\";s:13:\"Round corners\";s:11:\"btn--square\";s:14:\"Square corners\";}}i:7;a:6:{s:4:\"name\";s:19:\"Button text Options\";s:11:\"description\";s:49:\"Specify the typography properties for the button.\";s:2:\"id\";s:11:\"button_typo\";s:3:\"std\";s:0:\"\";s:8:\"supports\";a:8:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";i:5;s:5:\"color\";i:6;s:7:\"spacing\";i:7;s:4:\"case\";}s:4:\"type\";s:4:\"font\";}i:8;a:7:{s:4:\"name\";s:9:\"Add icon?\";s:11:\"description\";s:26:\"Add an icon to the button?\";s:2:\"id\";s:15:\"cta_icon_enable\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";s:2:\"no\";s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:9;a:7:{s:4:\"name\";s:13:\"Icon position\";s:11:\"description\";s:31:\"Select the position of the icon\";s:2:\"id\";s:12:\"cta_icon_pos\";s:3:\"std\";s:6:\"before\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:6:\"before\";s:11:\"Before text\";s:5:\"after\";s:10:\"After text\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"cta_icon_enable\";s:5:\"value\";a:1:{i:0;s:1:\"1\";}}}i:10;a:8:{s:4:\"name\";s:11:\"Select icon\";s:11:\"description\";s:35:\"Select an icon to add to the button\";s:2:\"id\";s:8:\"cta_icon\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:9:\"icon_list\";s:5:\"class\";s:12:\"zn_icon_list\";s:7:\"compact\";s:1:\"1\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"cta_icon_enable\";s:5:\"value\";a:1:{i:0;s:1:\"1\";}}}i:11;a:6:{s:4:\"name\";s:26:\"Button display permissions\";s:11:\"description\";s:78:\"Using this option you can show/hide the button for different type of visitors.\";s:2:\"id\";s:8:\"cta_perm\";s:3:\"std\";s:3:\"all\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:3:\"all\";s:12:\"Show for all\";s:8:\"loggedin\";s:29:\"Show only for logged in users\";s:7:\"visitor\";s:40:\"Show only for visitors ( not logged in )\";}}i:12;a:6:{s:4:\"name\";s:23:\"Hide button on mobiles?\";s:11:\"description\";s:68:\"Do you want to hide this button on mobile screens (-767px and below)\";s:2:\"id\";s:11:\"cta_hide_xs\";s:3:\"std\";s:1:\"0\";s:5:\"value\";s:9:\"hidden-xs\";s:4:\"type\";s:7:\"toggle2\";}}s:5:\"class\";s:0:\"\";}i:101;a:7:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"cto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:102;a:7:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#TuXcJu9jl7c\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:103;a:7:{s:4:\"slug\";s:11:\"cta_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:104;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"NAVIGATION OPTIONS\";s:11:\"description\";s:149:\"These options below are related to site\'s navigations. For example the header contains 2 registered menus: \"Main Navigation\" and \"Header Navigation\".\";s:2:\"id\";s:11:\"info_title7\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:105;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:29:\"Header Dropdowns color scheme\";s:11:\"description\";s:114:\"Select the color scheme for the dropdown menus in the site header (topnav, cart container, language dropdown etc.)\";s:2:\"id\";s:15:\"nav_color_theme\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:0:\"\";s:63:\"Inherit from Kallyas options > Color Options [Requires refresh]\";s:5:\"light\";s:15:\"Light (default)\";s:4:\"dark\";s:4:\"Dark\";}s:4:\"type\";s:6:\"select\";}i:106;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:9:\"Main Menu\";s:11:\"description\";s:66:\"These options are dedicated to the Main Menu navigation in Header.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:107;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:35:\"Menu style for 1st level menu items\";s:11:\"description\";s:55:\"Specify the style of the Main Menu\'s first level links.\";s:2:\"id\";s:10:\"menu_style\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:4:{i:0;a:3:{s:5:\"value\";s:0:\"\";s:4:\"name\";s:7:\"Inherit\";s:4:\"desc\";s:34:\"Will inherit from header\'s layout.\";}i:1;a:3:{s:5:\"value\";s:9:\"active-bg\";s:4:\"name\";s:32:\"Background Color on hover/active\";s:5:\"image\";s:123:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/nav-options-menustyle-bgcolor.gif\";}i:2;a:3:{s:5:\"value\";s:11:\"active-text\";s:4:\"name\";s:26:\"Text Color on hover/active\";s:5:\"image\";s:125:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/nav-options-menustyle-textcolor.gif\";}i:3;a:3:{s:5:\"value\";s:12:\"active-uline\";s:4:\"name\";s:30:\"Text Underline on hover/active\";s:5:\"image\";s:129:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/nav-options-menustyle-textunderline.gif\";}}s:4:\"type\";s:12:\"smart_select\";}i:108;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:42:\"Menu Font Options for 1st level menu items\";s:11:\"description\";s:72:\"Specify the typography properties for the Main Menu\'s first level links.\";s:2:\"id\";s:9:\"menu_font\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"14px\";s:11:\"font-family\";s:4:\"Lato\";s:11:\"line-height\";s:4:\"14px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"700\";}s:8:\"supports\";a:8:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:4:\"line\";i:3;s:5:\"color\";i:4;s:5:\"style\";i:5;s:6:\"weight\";i:6;s:7:\"spacing\";i:7;s:4:\"case\";}s:4:\"type\";s:4:\"font\";}i:109;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:45:\"Hover / Active color for 1st level menu items\";s:11:\"description\";s:71:\"Specify the hover or active color of the Main Menu\'s first level links.\";s:2:\"id\";s:16:\"menu_font_active\";s:3:\"std\";s:7:\"#cd2122\";s:5:\"alpha\";s:1:\"1\";s:4:\"type\";s:11:\"colorpicker\";}i:110;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:29:\"Main menu - Sub-menus options\";s:11:\"description\";s:76:\"These options are dedicated to the main menu\'s submenu navigation in Header.\";s:2:\"id\";s:9:\"hd_title3\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:29:\"zn_full zn-custom-title-large\";}i:111;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Sub-Menu Font Options\";s:11:\"description\";s:56:\"Specify the typography properties for the Main sub-menu.\";s:2:\"id\";s:13:\"menu_font_sub\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"14px\";s:11:\"font-family\";s:4:\"Lato\";s:11:\"line-height\";s:4:\"14px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"700\";}s:8:\"supports\";a:7:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:4:\"line\";i:3;s:5:\"color\";i:4;s:5:\"style\";i:5;s:6:\"weight\";i:6;s:4:\"case\";}s:4:\"type\";s:4:\"font\";}i:112;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:32:\"Main menu Dropdowns color scheme\";s:11:\"description\";s:60:\"Select the color scheme for the MAIN MENU in the site header\";s:2:\"id\";s:19:\"navmain_color_theme\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:0:\"\";s:63:\"Inherit from Kallyas options > Color Options [Requires refresh]\";s:5:\"light\";s:15:\"Light (default)\";s:4:\"dark\";s:4:\"Dark\";}s:4:\"type\";s:6:\"select\";}i:113;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Mobile Navigation\";s:11:\"description\";s:75:\"These options are dedicated to the main menu\'s mobile navigation in Header.\";s:2:\"id\";s:9:\"hd_title3\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:29:\"zn_full zn-custom-title-large\";}i:114;a:9:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:16:\"header_res_width\";s:4:\"name\";s:34:\"Header responsive breakpoint-width\";s:11:\"description\";s:104:\"Choose the desired browser width (viewport) when the Mobile-menu and Hamburger-Icon should be displayed.\";s:4:\"type\";s:6:\"slider\";s:5:\"class\";s:7:\"zn_full\";s:3:\"std\";s:3:\"992\";s:7:\"helpers\";a:2:{s:3:\"min\";s:2:\"50\";s:3:\"max\";s:4:\"2561\";}}i:115;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:17:\"mobile_menu_theme\";s:4:\"name\";s:24:\"Mobile-Menu Colors Theme\";s:11:\"description\";s:201:\"Choose the theming colors style for the side menu theme eg: <a href=\"http://hogash.d.pr/xCqo\" target=\"_blank\">Light version</a> and <a href=\"http://hogash.d.pr/15l83\" target=\"_blank\">Dark version</a>. \";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:5:\"light\";s:11:\"Light theme\";s:4:\"dark\";s:10:\"Dark theme\";}}i:116;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:12:\"burger_style\";s:4:\"name\";s:20:\"Hamburger-Icon Style\";s:11:\"description\";s:32:\"Choose the hamburger icon style.\";s:3:\"std\";s:4:\"3--s\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:8:{s:4:\"1--s\";s:15:\"Small 1px lines\";s:4:\"2--s\";s:15:\"Small 2px lines\";s:4:\"3--s\";s:15:\"Small 3px lines\";s:4:\"4--s\";s:15:\"Small 4px lines\";s:4:\"1--m\";s:16:\"Medium 1px lines\";s:4:\"2--m\";s:16:\"Medium 2px lines\";s:4:\"3--m\";s:16:\"Medium 3px lines\";s:4:\"4--m\";s:16:\"Medium 4px lines\";}}i:117;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:11:\"burger_anim\";s:4:\"name\";s:24:\"Hamburger-Icon Animation\";s:11:\"description\";s:37:\"Choose the hamburger animation style.\";s:3:\"std\";s:5:\"anim1\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:5:\"anim1\";s:13:\"Animation #1.\";s:5:\"anim2\";s:13:\"Animation #2.\";s:5:\"anim3\";s:13:\"Animation #3.\";}}i:118;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:12:\"burger_color\";s:4:\"name\";s:20:\"Hamburger-Icon Color\";s:11:\"description\";s:28:\"Choose the hamburger colors.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:0:\"\";s:38:\"Inherit from Header\'s built-in styles.\";s:6:\"custom\";s:18:\"Force Custom Color\";}}i:119;a:9:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:29:\"Hamburger-Icon - Custom Color\";s:11:\"description\";s:15:\"Select a color.\";s:2:\"id\";s:19:\"burger_color_custom\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:5:\"alpha\";s:4:\"true\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"burger_color\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:120;a:9:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:47:\"Hamburger-Icon - Custom Color for Sticky Header\";s:11:\"description\";s:65:\"Select a color for the hamburger icon when in sticky header mode.\";s:2:\"id\";s:19:\"burger_color_sticky\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:5:\"alpha\";s:4:\"true\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"burger_color\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:121;a:9:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:55:\"Hamburger-Icon - Custom Color for Mobiles (under 767px)\";s:11:\"description\";s:61:\"Force a custom color for the hamburger icon, when on mobiles.\";s:2:\"id\";s:19:\"burger_color_mobile\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:5:\"alpha\";s:4:\"true\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"burger_color\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:122;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Top-Header Menu\";s:11:\"description\";s:67:\"These options are dedicated to the Header-Navigation in TOP-Header.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:123;a:8:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:40:\"Enable dropdown Top Header Navigation? .\";s:11:\"description\";s:229:\"Only available for smartphones and tablets. This option will enable a dropdown menu for the header-navigation (not main-menu!). If you have for example lots of menu items in header, this option will fallback nicely in the header.\";s:2:\"id\";s:16:\"header_topnav_dd\";s:3:\"std\";s:3:\"yes\";s:5:\"value\";s:3:\"yes\";s:4:\"type\";s:7:\"toggle2\";}i:124;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"nvo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:125;a:7:{s:4:\"slug\";s:11:\"nav_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:126;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"SITE FOOTER OPTIONS\";s:11:\"description\";s:157:\"These options below are related to site\'s footer. ( <a href=\"http://hogash.d.pr/10mXd\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title8\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:127;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Show Footer\";s:11:\"description\";s:62:\"Using this option you can choose to display the footer or not.\";s:2:\"id\";s:11:\"footer_show\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:128;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Footer Rows Setup\";s:11:\"description\";s:70:\"These settings below will configure the 2 rows included in the footer.\";s:2:\"id\";s:13:\"footer_title3\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:129;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Show Row 1 widgets ?\";s:11:\"description\";s:56:\"Select yes if you want to show the first row of widgets.\";s:2:\"id\";s:16:\"footer_row1_show\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:130;a:10:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:29:\"Footer Row 1 Widget positions\";s:11:\"description\";s:165:\"Here you can select how your footer row 1 widgets will be displayed. You can select to\r\n		                            use up to 4 widgets positions in various sizes.\";s:2:\"id\";s:28:\"footer_row1_widget_positions\";s:3:\"std\";s:21:\"{\"3\":[[\"4\",\"4\",\"4\"]]}\";s:4:\"type\";s:16:\"widget_positions\";s:17:\"number_of_columns\";s:1:\"4\";s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"footer_row1_show\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}s:17:\"columns_positions\";a:4:{i:1;a:1:{i:0;a:1:{i:0;s:2:\"12\";}}i:2;a:1:{i:0;a:2:{i:0;s:1:\"6\";i:1;s:1:\"6\";}}i:3;a:7:{i:0;a:3:{i:0;s:1:\"4\";i:1;s:1:\"4\";i:2;s:1:\"4\";}i:1;a:3:{i:0;s:1:\"5\";i:1;s:1:\"4\";i:2;s:1:\"3\";}i:2;a:3:{i:0;s:1:\"5\";i:1;s:1:\"3\";i:2;s:1:\"4\";}i:3;a:3:{i:0;s:1:\"4\";i:1;s:1:\"5\";i:2;s:1:\"3\";}i:4;a:3:{i:0;s:1:\"4\";i:1;s:1:\"3\";i:2;s:1:\"5\";}i:5;a:3:{i:0;s:1:\"3\";i:1;s:1:\"4\";i:2;s:1:\"5\";}i:6;a:3:{i:0;s:1:\"3\";i:1;s:1:\"5\";i:2;s:1:\"4\";}}i:4;a:2:{i:0;a:4:{i:0;s:1:\"3\";i:1;s:1:\"3\";i:2;s:1:\"3\";i:3;s:1:\"3\";}i:1;a:4:{i:0;s:1:\"5\";i:1;s:1:\"4\";i:2;s:1:\"2\";i:3;s:1:\"1\";}}}}i:131;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Show Row 2 widgets ?\";s:11:\"description\";s:57:\"Select yes if you want to show the second row of widgets.\";s:2:\"id\";s:16:\"footer_row2_show\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:132;a:10:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:29:\"Footer Row 2 Widget positions\";s:11:\"description\";s:138:\"Here you can select how your footer row 2 widgets will be displayed. You can select to\r\n		 use up to 4 widgets positions in various sizes.\";s:2:\"id\";s:28:\"footer_row2_widget_positions\";s:3:\"std\";s:17:\"{\"2\":[[\"6\",\"6\"]]}\";s:4:\"type\";s:16:\"widget_positions\";s:17:\"number_of_columns\";s:1:\"4\";s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"footer_row2_show\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}s:17:\"columns_positions\";a:4:{i:1;a:1:{i:0;a:1:{i:0;s:2:\"12\";}}i:2;a:1:{i:0;a:2:{i:0;s:1:\"6\";i:1;s:1:\"6\";}}i:3;a:7:{i:0;a:3:{i:0;s:1:\"4\";i:1;s:1:\"4\";i:2;s:1:\"4\";}i:1;a:3:{i:0;s:1:\"5\";i:1;s:1:\"4\";i:2;s:1:\"3\";}i:2;a:3:{i:0;s:1:\"5\";i:1;s:1:\"3\";i:2;s:1:\"4\";}i:3;a:3:{i:0;s:1:\"4\";i:1;s:1:\"5\";i:2;s:1:\"3\";}i:4;a:3:{i:0;s:1:\"4\";i:1;s:1:\"3\";i:2;s:1:\"5\";}i:5;a:3:{i:0;s:1:\"3\";i:1;s:1:\"4\";i:2;s:1:\"5\";}i:6;a:3:{i:0;s:1:\"3\";i:1;s:1:\"5\";i:2;s:1:\"4\";}}i:4;a:2:{i:0;a:4:{i:0;s:1:\"3\";i:1;s:1:\"3\";i:2;s:1:\"3\";i:3;s:1:\"3\";}i:1;a:4:{i:0;s:1:\"5\";i:1;s:1:\"4\";i:2;s:1:\"2\";i:3;s:1:\"1\";}}}}i:133;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Footer Styles Options\";s:11:\"description\";s:49:\"These settings below are for the footer\'s styles.\";s:2:\"id\";s:13:\"footer_title2\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:134;a:8:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:5:\"Style\";s:11:\"description\";s:39:\"Select the desired style for the footer\";s:2:\"id\";s:12:\"footer_style\";s:3:\"std\";s:7:\"default\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:11:\"image_color\";s:24:\"Background Image & color\";}}i:135;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Background Image\";s:11:\"description\";s:59:\"Please choose your desired image to be used as a background\";s:2:\"id\";s:18:\"footer_style_image\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";}s:4:\"type\";s:10:\"background\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"footer_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}}i:136;a:8:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Background Color\";s:11:\"description\";s:58:\"Please choose your desired background color for the footer\";s:2:\"id\";s:18:\"footer_style_color\";s:3:\"std\";s:4:\"#000\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:12:\"footer_style\";s:5:\"value\";a:1:{i:0;s:11:\"image_color\";}}}i:137;a:8:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:25:\"Footer\'s Top Border Color\";s:11:\"description\";s:177:\"Please choose your desired color for the footer top border-color. To hide it, try matching the background color of the footer or just add some custom css into advanced settings.\";s:2:\"id\";s:23:\"footer_border_color_top\";s:3:\"std\";s:7:\"#FFFFFF\";s:5:\"alpha\";s:1:\"1\";s:4:\"type\";s:11:\"colorpicker\";}i:138;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:28:\"Bottom Footer\'s Border Color\";s:11:\"description\";s:181:\"Please choose your desired color for the bottom-footer area\'s border. To hide it, try matching the background color of the footer or just add some custom css into advanced settings.\";s:2:\"id\";s:19:\"footer_border_color\";s:3:\"std\";s:7:\"#484848\";s:4:\"type\";s:11:\"colorpicker\";}i:139;a:8:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:25:\"Footer\'s Top Padding (px)\";s:11:\"description\";s:48:\"Please add the top padding (px) for the footer. \";s:2:\"id\";s:18:\"footer_top_padding\";s:3:\"std\";s:2:\"60\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:11:\"zn_input_xs\";}i:140;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:21:\"Bottom Footer Options\";s:11:\"description\";s:77:\"These settings below are for the bottom non-widget part of the site\'s footer.\";s:2:\"id\";s:13:\"footer_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:141;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Copyright Logo image\";s:11:\"description\";s:96:\"Upload your desired logo image that will appear on the left side of the copyright\r\n        text.\";s:2:\"id\";s:11:\"footer_logo\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";}i:142;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:14:\"Copyright text\";s:11:\"description\";s:101:\"Enter your desired copyright text. Please note that you can copy \' &copy; \' and place it in the text.\";s:2:\"id\";s:14:\"copyright_text\";s:3:\"std\";s:151:\"&copy; 2015. All rights reserved. Buy <a href=\"http://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658/\">Kallyas Theme</a>.\";s:4:\"type\";s:8:\"textarea\";}i:143;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:44:\"Show or hide the Social icons in the footer.\";s:11:\"description\";s:41:\"Display the social icons list in footer?.\";s:2:\"id\";s:26:\"footer_social_icons_enable\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:144;a:9:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:35:\"Use normal or colored social icons?\";s:11:\"description\";s:87:\"Here you can choose to use the normal social icons or the colored version of each icon.\";s:2:\"id\";s:22:\"footer_which_icons_set\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:4:{s:6:\"normal\";s:12:\"Normal Icons\";s:7:\"colored\";s:13:\"Colored icons\";s:11:\"colored_hov\";s:22:\"Colored on Hover icons\";s:5:\"clean\";s:11:\"Clean icons\";}s:5:\"class\";s:0:\"\";}i:145;a:12:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:12:\"Social Icons\";s:11:\"description\";s:94:\"Here you can configure what social icons to appear on the right side of the copyright\r\n		text.\";s:2:\"id\";s:19:\"footer_social_icons\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:13:\"element_title\";s:19:\"footer_social_title\";s:8:\"add_text\";s:11:\"Social Icon\";s:11:\"remove_text\";s:11:\"Social Icon\";s:11:\"subelements\";a:4:{i:0;a:5:{s:4:\"name\";s:10:\"Icon title\";s:11:\"description\";s:149:\"Here you can enter a title for this social icon.Please note that this is just\r\n				for your information as this text will not be visible on the site.\";s:2:\"id\";s:19:\"footer_social_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:1;a:6:{s:4:\"name\";s:16:\"Social icon link\";s:11:\"description\";s:114:\"Please enter your desired link for the social icon. If this field is left\r\n				blank, the icon will not be linked.\";s:2:\"id\";s:18:\"footer_social_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"link\";s:7:\"options\";a:2:{s:6:\"_blank\";s:10:\"New window\";s:5:\"_self\";s:11:\"Same window\";}}i:2;a:5:{s:4:\"name\";s:28:\"Social icon Background color\";s:11:\"description\";s:126:\"Select a background color for the icon (if you selected <strong>Colored</strong> or <strong>Colored on hover</strong> options)\";s:2:\"id\";s:19:\"footer_social_color\";s:3:\"std\";s:4:\"#000\";s:4:\"type\";s:11:\"colorpicker\";}i:3;a:6:{s:4:\"name\";s:11:\"Social icon\";s:11:\"description\";s:32:\"Select your desired social icon.\";s:2:\"id\";s:18:\"footer_social_icon\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:9:\"icon_list\";s:5:\"class\";s:7:\"zn_full\";}}s:5:\"class\";s:0:\"\";}i:146;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"fto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:147;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#-jvG4qzNbBY\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:148;a:7:{s:4:\"slug\";s:14:\"footer_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:149;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:26:\"DEFAULT SUB-HEADER OPTIONS\";s:11:\"description\";s:175:\"These options below are related to site\'s default sub-header block. ( <a href=\"http://hogash.d.pr/14aJa\" target=\"_blank\" title=\"Click to open screenshot\">Open screenshot</a>).\";s:2:\"id\";s:11:\"info_title9\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:150;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"Hide page subheader?\";s:11:\"description\";s:139:\"Choose yes if you want to hide the page subheader ( including sliders ). Please note that this option can be overridden from each page/post\";s:2:\"id\";s:20:\"zn_disable_subheader\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:3:{s:3:\"yes\";s:11:\"Yes for all\";s:5:\"yespb\";s:33:\"Yes. only for dynamic sub-headers\";s:2:\"no\";s:2:\"No\";}s:4:\"type\";s:8:\"zn_radio\";}i:151;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"Background options\";s:11:\"description\";s:61:\"These options are applied to the background of the subheader.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:152;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:27:\"Sub-Header Background image\";s:11:\"description\";s:52:\"Upload your desired background image for the header.\";s:2:\"id\";s:17:\"def_header_bg_new\";s:3:\"std\";a:1:{s:5:\"image\";b:0;}s:4:\"type\";s:10:\"background\";s:7:\"options\";a:4:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";s:4:\"size\";s:1:\"1\";}}i:153;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:27:\"Sub-Header Background Color\";s:11:\"description\";s:131:\"Here you can choose a default color for your header.If you do not select a background image, this color will be used as background.\";s:2:\"id\";s:16:\"def_header_color\";s:3:\"std\";s:7:\"#AAAAAA\";s:5:\"alpha\";s:1:\"1\";s:4:\"type\";s:11:\"colorpicker\";}i:154;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:24:\"Add gradient over color?\";s:11:\"description\";s:61:\"Select yes if you want add a gradient over the selected color\";s:2:\"id\";s:11:\"def_grad_bg\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:155;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Use animated header\";s:11:\"description\";s:66:\"Select if you want to add an animation on top of your image/color.\";s:2:\"id\";s:18:\"def_header_animate\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:156;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Add Glare effect?\";s:11:\"description\";s:64:\"Select yes if you want to add a glare effect over the background\";s:2:\"id\";s:9:\"def_glare\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:157;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:11:\"Bottom mask\";s:11:\"description\";s:57:\"The new masks are svg based, vectorial and color adapted.\";s:2:\"id\";s:16:\"def_bottom_style\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:20:{s:4:\"none\";s:5:\"None.\";s:6:\"custom\";s:6:\"Custom\";s:13:\"shadow_simple\";s:9:\"Shadow Up\";s:18:\"shadow_simple_down\";s:11:\"Shadow Down\";s:6:\"shadow\";s:39:\"Shadow Up (with border and small arrow)\";s:9:\"shadow_ud\";s:18:\"Shadow Up and down\";s:5:\"mask3\";s:20:\"Vector Mask 3 CENTER\";s:12:\"mask3 mask3l\";s:18:\"Vector Mask 3 LEFT\";s:12:\"mask3 mask3r\";s:19:\"Vector Mask 3 RIGHT\";s:5:\"mask4\";s:20:\"Vector Mask 4 CENTER\";s:12:\"mask4 mask4l\";s:18:\"Vector Mask 4 LEFT\";s:12:\"mask4 mask4r\";s:19:\"Vector Mask 4 RIGHT\";s:5:\"mask5\";s:13:\"Vector Mask 5\";s:5:\"mask6\";s:13:\"Vector Mask 6\";s:12:\"mask7 mask7l\";s:18:\"Mask 7 - Skew Left\";s:12:\"mask7 mask7r\";s:19:\"Mask 7 - Skew Right\";s:21:\"mask7 mask7big mask7l\";s:25:\"Mask 7 Bigger - Skew Left\";s:21:\"mask7 mask7big mask7r\";s:26:\"Mask 7 Bigger - Skew Right\";s:12:\"mask8 mask8s\";s:17:\"Mask 8 - V shaped\";s:12:\"mask8 mask8b\";s:24:\"Mask 8 Bigger - V shaped\";}}i:158;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:28:\"Bottom Mask Background Image\";s:11:\"description\";s:30:\"Select the image for the mask.\";s:2:\"id\";s:20:\"bottom_mask_bg_image\";s:4:\"type\";s:10:\"background\";s:7:\"options\";a:4:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";s:4:\"size\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"def_bottom_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:159;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:30:\"Custom Mask height (in pixels)\";s:11:\"description\";s:39:\"Specify the height for the custom mask.\";s:2:\"id\";s:21:\"bottom_mask_bg_height\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:3:\"100\";s:7:\"helpers\";a:2:{s:3:\"min\";s:1:\"1\";s:3:\"max\";s:3:\"200\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"def_bottom_style\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:160;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:19:\"def_bottom_style_bg\";s:4:\"name\";s:28:\"Bottom Mask Background Color\";s:11:\"description\";s:203:\"If you need the mask to have a different color than the main site background, please choose the color. Usually this color is needed when the next section, under this one has a different background color.\";s:4:\"type\";s:11:\"colorpicker\";s:3:\"std\";s:0:\"\";s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"def_bottom_style\";s:5:\"value\";a:14:{i:0;s:5:\"mask3\";i:1;s:12:\"mask3 mask3l\";i:2;s:12:\"mask3 mask3r\";i:3;s:5:\"mask4\";i:4;s:12:\"mask4 mask4l\";i:5;s:12:\"mask4 mask4r\";i:6;s:5:\"mask5\";i:7;s:5:\"mask6\";i:8;s:12:\"mask7 mask7l\";i:9;s:12:\"mask7 mask7r\";i:10;s:21:\"mask7 mask7big mask7l\";i:11;s:21:\"mask7 mask7big mask7r\";i:12;s:12:\"mask8 mask8s\";i:13;s:12:\"mask8 mask8b\";}}}i:161;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"Components options\";s:11:\"description\";s:59:\"These options are applied to the contents of the subheader.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:162;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:16:\"Show Breadcrumbs\";s:11:\"description\";s:50:\"Select if you want to show the breadcrumbs or not.\";s:2:\"id\";s:16:\"def_header_bread\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:163;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Breadcrumbs style\";s:11:\"description\";s:25:\"Select Breadcrumbs style.\";s:2:\"id\";s:18:\"def_subh_bread_stl\";s:3:\"std\";s:5:\"black\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:5:\"black\";s:9:\"Black Bar\";s:7:\"minimal\";s:7:\"Minimal\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:16:\"def_header_bread\";s:5:\"value\";a:1:{i:0;s:1:\"1\";}}}i:164;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:9:\"Show Date\";s:11:\"description\";s:69:\"Select if you want to show the current date under breadcrumbs or not.\";s:2:\"id\";s:15:\"def_header_date\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:165;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Show Page Title\";s:11:\"description\";s:49:\"Select if you want to show the page title or not.\";s:2:\"id\";s:16:\"def_header_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:166;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"Show Page Subtitle\";s:11:\"description\";s:52:\"Select if you want to show the page subtitle or not.\";s:2:\"id\";s:19:\"def_header_subtitle\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:4:\"Show\";i:0;s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:167;a:9:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:31:\"Title & Subtitle text alignment\";s:11:\"description\";s:176:\"If you have disabled both Breadcrumbs & Date, you can choose to custom align the title and subtitle in subheader. You can override this setting in the Custom Subheader Element.\";s:2:\"id\";s:23:\"def_subheader_alignment\";s:3:\"std\";s:5:\"right\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:4:\"left\";s:4:\"Left\";s:6:\"center\";s:6:\"Center\";s:5:\"right\";s:5:\"Right\";}s:10:\"dependency\";a:2:{i:0;a:2:{s:7:\"element\";s:16:\"def_header_bread\";s:5:\"value\";a:1:{i:0;s:1:\"0\";}}i:1;a:2:{s:7:\"element\";s:15:\"def_header_date\";s:5:\"value\";a:1:{i:0;s:1:\"0\";}}}}i:168;a:8:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Text Color Scheme\";s:11:\"description\";s:29:\"Select the text color scheme.\";s:2:\"id\";s:18:\"def_subh_textcolor\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}}i:169;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:24:\"Height / Padding options\";s:11:\"description\";s:73:\"These options are applied to the height and top padding of the subheader.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:170;a:10:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:25:\"Default Sub-Header Height\";s:11:\"description\";s:59:\"Please enter your desired height in pixels for this header.\";s:2:\"id\";s:27:\"def_header_custom_height_v2\";s:4:\"type\";s:12:\"smart_slider\";s:3:\"std\";a:9:{s:11:\"breakpoints\";i:0;s:2:\"lg\";s:3:\"300\";s:7:\"unit_lg\";s:2:\"px\";s:2:\"md\";s:3:\"300\";s:7:\"unit_md\";s:2:\"px\";s:2:\"sm\";s:3:\"300\";s:7:\"unit_sm\";s:2:\"px\";s:2:\"xs\";s:3:\"300\";s:7:\"unit_xs\";s:2:\"px\";}s:8:\"supports\";a:1:{i:0;s:11:\"breakpoints\";}s:5:\"units\";a:1:{i:0;s:2:\"px\";}s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"1\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}}i:171;a:10:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:2:\"id\";s:25:\"def_header_top_padding_v2\";s:4:\"name\";s:11:\"Top padding\";s:11:\"description\";s:56:\"Select the top padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:12:\"smart_slider\";s:3:\"std\";a:9:{s:11:\"breakpoints\";i:0;s:2:\"lg\";s:3:\"170\";s:7:\"unit_lg\";s:2:\"px\";s:2:\"md\";s:3:\"170\";s:7:\"unit_md\";s:2:\"px\";s:2:\"sm\";s:3:\"170\";s:7:\"unit_sm\";s:2:\"px\";s:2:\"xs\";s:3:\"170\";s:7:\"unit_xs\";s:2:\"px\";}s:8:\"supports\";a:1:{i:0;s:11:\"breakpoints\";}s:5:\"units\";a:1:{i:0;s:2:\"px\";}s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"1\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}}i:172;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"dfho_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:173;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#1olr-Oy_RD0\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:174;a:7:{s:4:\"slug\";s:22:\"default_header_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:175;a:7:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:24:\"GOOGLE ANALYTICS OPTIONS\";s:11:\"description\";s:95:\"The options below are related to Google Analytics / Google Tag Manager integration in Kallyas. \";s:2:\"id\";s:12:\"info_title11\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:176;a:8:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:42:\"Google Analytics / Google Tag Manager Code\";s:11:\"description\";s:158:\"Paste your Google Analytics generated Tracking code (or Google Tag Manager code) below. Don\'t forget to paste the to include the wrapping &lt;script&gt; tags.\";s:2:\"id\";s:16:\"google_analytics\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";s:5:\"class\";s:7:\"zn_full\";}i:177;a:7:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"gao_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:178;a:7:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#zxQaeY_bFxY\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:179;a:7:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:230:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/google-analytics/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:180;a:7:{s:4:\"slug\";s:16:\"google_analytics\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:181;a:7:{s:4:\"slug\";s:11:\"google_maps\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"GOOGLE MAPS OPTIONS\";s:11:\"description\";s:77:\"The options below are related to Google Maps API key integration in Kallyas. \";s:2:\"id\";s:12:\"info_title11\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:182;a:8:{s:4:\"slug\";s:11:\"google_maps\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:19:\"Google Maps API Key\";s:11:\"description\";s:284:\"Add a Google Map Api Key. This key will be used by Page Builder elements that require a Google Map API Key, for example the Google Map element. More on <a target=\"_blank\" href=\"https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key\">Google Maps Key</a>\";s:2:\"id\";s:15:\"google_maps_key\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";s:5:\"class\";s:7:\"zn_full\";}i:183;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"MAILCHIMP OPTIONS\";s:11:\"description\";s:101:\"The options below are related to Mailchimp (Online email marketing) platform integration in Kallyas. \";s:2:\"id\";s:12:\"info_title12\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:184;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Mailchimp API KEY\";s:11:\"description\";s:71:\"Paste your mailchimp api key that will be used by the mailchimp widget.\";s:2:\"id\";s:13:\"mailchimp_api\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:185;a:8:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"Secure Connection\";s:11:\"description\";s:209:\"In rare cases this needs to be enabled. MailChimp\'s API does supporting connecting via SSL for those worried about Man-in-the-Middle attacks/data collection. To use it in the MCAPI wrapper, simply enable this.\";s:2:\"id\";s:16:\"mailchimp_secure\";s:3:\"std\";s:2:\"no\";s:5:\"value\";s:3:\"yes\";s:4:\"type\";s:7:\"toggle2\";}i:186;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"mco_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:187;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#4zt7-E985Xw\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:188;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:233:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/configure-mailchimp/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:189;a:7:{s:4:\"slug\";s:17:\"mailchimp_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:190;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:17:\"RECAPTCHA OPTIONS\";s:11:\"description\";s:151:\"The options below are related to <a href=\"http://www.google.com/recaptcha\" target=\"_blank\">Google ReCaptcha</a> security integration in Kallyas forms. \";s:2:\"id\";s:12:\"info_title13\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:47:\"zn_full zn-custom-title-large zn-toptabs-margin\";}i:191;a:8:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:15:\"Recaptcha style\";s:11:\"description\";s:35:\"Choose the desired recapthca style.\";s:2:\"id\";s:9:\"rec_theme\";s:3:\"std\";s:3:\"red\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:5:\"light\";s:11:\"Light theme\";s:4:\"dark\";s:10:\"Dark theme\";}}i:192;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"reCaptcha Site Key\";s:11:\"description\";s:73:\"Please enter the Site Key you\'ve got from http://www.google.com/recaptcha\";s:2:\"id\";s:11:\"rec_pub_key\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:193;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:20:\"reCaptcha Secret Key\";s:11:\"description\";s:75:\"Please enter the Secret Key you\'ve got from http://www.google.com/recaptcha\";s:2:\"id\";s:12:\"rec_priv_key\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"textarea\";}i:194;a:9:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:31:\"Use ReCaptcha for registration?\";s:11:\"description\";s:69:\"Choose yes if you want to display ReCaptcha on the registration form.\";s:2:\"id\";s:18:\"recaptcha_register\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:2:{s:3:\"yes\";s:3:\"Yes\";s:2:\"no\";s:2:\"No\";}s:4:\"type\";s:8:\"zn_radio\";s:5:\"class\";s:15:\"zn_radio--yesno\";}i:195;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:18:\"ReCaptcha language\";s:11:\"description\";s:166:\"Please specify the language to display the ReCaptcha in. You can get it from  <a href=\"https://developers.google.com/recaptcha/docs/language\" target=\"_blank\">here</a>\";s:2:\"id\";s:14:\"recaptcha_lang\";s:3:\"std\";s:2:\"en\";s:4:\"type\";s:4:\"text\";}i:196;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"rco_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:197;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#MXRAmRVaOaY\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:198;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:233:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/configure-recaptcha/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:199;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:200;a:8:{s:4:\"slug\";s:11:\"gfont_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:2:\"id\";s:21:\"zn_google_fonts_setup\";s:4:\"name\";s:18:\"Google Fonts Setup\";s:11:\"description\";s:126:\"Here you can setup the <a href=\"//www.google.com/fonts\" target=\"blank\">Google web fonts</a> that you want to use in your site.\";s:4:\"type\";s:21:\"zn_google_fonts_setup\";s:3:\"std\";a:1:{s:6:\"Roboto\";a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:13:\"font_variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"900\";}}}s:5:\"class\";s:7:\"zn_full\";}i:201;a:9:{s:4:\"slug\";s:11:\"gfont_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:2:\"id\";s:23:\"zn_google_fonts_subsets\";s:4:\"name\";s:19:\"Google Fonts Subset\";s:11:\"description\";s:59:\"Select which subsets you want to load for the Google fonts.\";s:4:\"type\";s:8:\"checkbox\";s:7:\"options\";a:8:{s:5:\"latin\";s:5:\"Latin\";s:9:\"latin-ext\";s:9:\"Latin Ext\";s:5:\"greek\";s:5:\"Greek\";s:8:\"cyrillic\";s:8:\"Cyrillic\";s:12:\"cyrillic-ext\";s:12:\"Cyrillic Ext\";s:5:\"khmer\";s:5:\"Khmer\";s:9:\"greek-ext\";s:9:\"Greek Ext\";s:10:\"vietnamese\";s:10:\"Vietnamese\";}s:3:\"std\";s:0:\"\";s:5:\"class\";s:7:\"zn_full\";}i:202;a:8:{s:4:\"slug\";s:17:\"custom_font_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:2:\"id\";s:15:\"zn_custom_fonts\";s:4:\"name\";s:18:\"Custom Fonts Setup\";s:11:\"description\";s:65:\"Using this option you can add your own custom fonts to the theme.\";s:4:\"type\";s:5:\"group\";s:13:\"element_title\";s:7:\"cf_name\";s:11:\"subelements\";a:6:{i:0;a:5:{s:4:\"name\";s:9:\"Font Name\";s:11:\"description\";s:50:\"Here you can type the font name that will be used.\";s:2:\"id\";s:7:\"cf_name\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:1;a:6:{s:4:\"name\";s:11:\"Font Weight\";s:11:\"description\";s:34:\"Assign a font weight to this font.\";s:2:\"id\";s:13:\"cf_fontweight\";s:3:\"std\";s:3:\"400\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:9:{i:100;s:3:\"100\";i:200;s:3:\"200\";i:300;s:3:\"300\";i:400;s:3:\"400\";i:500;s:3:\"500\";i:600;s:3:\"600\";i:700;s:3:\"700\";i:800;s:3:\"800\";i:900;s:3:\"900\";}}i:2;a:6:{s:4:\"name\";s:17:\"Custom font .woff\";s:11:\"description\";s:27:\"Upload the .woff font file.\";s:2:\"id\";s:7:\"cf_woff\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_media\";s:4:\"data\";a:10:{s:12:\"button_title\";s:14:\"Add .woff font\";s:10:\"media_type\";s:18:\"media_field_upload\";s:12:\"insert_title\";s:11:\"Select font\";s:5:\"title\";s:15:\"Add Custom Font\";s:4:\"type\";s:21:\"application/font-woff\";s:5:\"state\";s:7:\"library\";s:5:\"frame\";s:6:\"select\";s:5:\"class\";s:26:\"zn-media-video media-frame\";s:10:\"value_type\";s:3:\"url\";s:7:\"preview\";s:4:\"text\";}}i:3;a:6:{s:4:\"name\";s:16:\"Custom font .ttf\";s:11:\"description\";s:26:\"Upload the .ttf font file.\";s:2:\"id\";s:6:\"cf_ttf\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_media\";s:4:\"data\";a:10:{s:12:\"button_title\";s:13:\"Add .ttf font\";s:10:\"media_type\";s:18:\"media_field_upload\";s:12:\"insert_title\";s:11:\"Select font\";s:5:\"title\";s:15:\"Add Custom Font\";s:4:\"type\";s:8:\"font/ttf\";s:5:\"state\";s:7:\"library\";s:5:\"frame\";s:6:\"select\";s:5:\"class\";s:26:\"zn-media-video media-frame\";s:10:\"value_type\";s:3:\"url\";s:7:\"preview\";s:4:\"text\";}}i:4;a:6:{s:4:\"name\";s:16:\"Custom font .svg\";s:11:\"description\";s:26:\"Upload the .svg font file.\";s:2:\"id\";s:6:\"cf_svg\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_media\";s:4:\"data\";a:10:{s:12:\"button_title\";s:13:\"Add .svg font\";s:10:\"media_type\";s:18:\"media_field_upload\";s:12:\"insert_title\";s:11:\"Select font\";s:5:\"title\";s:15:\"Add Custom Font\";s:4:\"type\";s:13:\"image/svg+xml\";s:5:\"state\";s:7:\"library\";s:5:\"frame\";s:6:\"select\";s:5:\"class\";s:26:\"zn-media-video media-frame\";s:10:\"value_type\";s:3:\"url\";s:7:\"preview\";s:4:\"text\";}}i:5;a:6:{s:4:\"name\";s:16:\"Custom font .eot\";s:11:\"description\";s:26:\"Upload the .eot font file.\";s:2:\"id\";s:6:\"cf_eot\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_media\";s:4:\"data\";a:10:{s:12:\"button_title\";s:13:\"Add .eot font\";s:10:\"media_type\";s:18:\"media_field_upload\";s:12:\"insert_title\";s:11:\"Select font\";s:5:\"title\";s:15:\"Add Custom Font\";s:4:\"type\";s:29:\"application/vnd.ms-fontobject\";s:5:\"state\";s:7:\"library\";s:5:\"frame\";s:6:\"select\";s:5:\"class\";s:26:\"zn-media-video media-frame\";s:10:\"value_type\";s:3:\"url\";s:7:\"preview\";s:4:\"text\";}}}}i:203;a:7:{s:4:\"slug\";s:17:\"custom_font_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"gfto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:204;a:7:{s:4:\"slug\";s:17:\"custom_font_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#ffnXlhSxpaI\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:205;a:7:{s:4:\"slug\";s:17:\"custom_font_setup\";s:6:\"parent\";s:19:\"google_font_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:206;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H1 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h1_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"36px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"40px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:207;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:16:\"Force Page-Title\";s:11:\"description\";s:166:\"Force page-title (eg: blog posts) to use <strong style=\'color:#000;\'>H1\'s font-family</strong> (options above), otherwise it\'ll use <strong>Alternative font</strong>.\";s:2:\"id\";s:10:\"h1_pgtitle\";s:3:\"std\";s:0:\"\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:7:\"toggle2\";}i:208;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H2 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h2_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"30px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"40px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:209;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H3 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h3_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"24px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"40px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:210;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H4 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h4_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"14px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"20px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:211;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H5 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h5_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"12px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"20px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:212;a:8:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:13:\"H6 Typography\";s:11:\"description\";s:47:\"Specify the typography properties for headings.\";s:2:\"id\";s:7:\"h6_typo\";s:3:\"std\";a:5:{s:9:\"font-size\";s:4:\"12px\";s:11:\"font-family\";s:9:\"Open Sans\";s:11:\"line-height\";s:4:\"20px\";s:10:\"font-style\";s:6:\"normal\";s:11:\"font-weight\";s:3:\"400\";}s:8:\"supports\";a:5:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:5:\"style\";i:3;s:4:\"line\";i:4;s:6:\"weight\";}s:4:\"type\";s:4:\"font\";}i:213;a:7:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"hdfo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:214;a:7:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#p-YITyC1ROU\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:215;a:7:{s:4:\"slug\";s:21:\"headings_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:216;a:8:{s:4:\"slug\";s:17:\"body_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:17:\"Body Font Options\";s:11:\"description\";s:376:\"Specify the typography properties for the body section ( this will apply to all the content on the page ). <br><br><strong>* Note:</strong> Don\'t use the colorpicker!! There is another color option in Kallyas options > Color Options > Text color. Make sure that one is used. We\'ll keep this one just for backwards compatibility only, but it will be removed in future versions.\";s:2:\"id\";s:9:\"body_font\";s:3:\"std\";a:3:{s:9:\"font-size\";s:4:\"13px\";s:11:\"font-family\";s:9:\"Open Sans\";s:5:\"color\";s:0:\"\";}s:8:\"supports\";a:4:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:4:\"line\";i:3;s:5:\"color\";}s:4:\"type\";s:4:\"font\";}i:217;a:8:{s:4:\"slug\";s:17:\"body_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:19:\"Footer Font Options\";s:11:\"description\";s:49:\"Specify the typography properties for the Footer.\";s:2:\"id\";s:11:\"footer_font\";s:3:\"std\";a:3:{s:9:\"font-size\";s:4:\"13px\";s:11:\"font-family\";s:9:\"Open Sans\";s:5:\"color\";s:0:\"\";}s:8:\"supports\";a:4:{i:0;s:4:\"size\";i:1;s:4:\"font\";i:2;s:4:\"line\";i:3;s:5:\"color\";}s:4:\"type\";s:4:\"font\";}i:218;a:7:{s:4:\"slug\";s:17:\"body_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"bfto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:219;a:7:{s:4:\"slug\";s:17:\"body_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#p-YITyC1ROU\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:220;a:7:{s:4:\"slug\";s:17:\"body_font_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:221;a:8:{s:4:\"slug\";s:25:\"alternative_fonts_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:24:\"Custom Selectors Options\";s:11:\"description\";s:227:\"This font is used by various elements in the theme. To add other selectors using this font, use the Custom CSS feature in the page builder or CAREFULLY edit /css/dynamic_css.php file, by searching for \'alternative_font\' string.\";s:2:\"id\";s:16:\"alternative_font\";s:3:\"std\";a:1:{s:11:\"font-family\";s:4:\"Lato\";}s:8:\"supports\";a:1:{i:0;s:4:\"font\";}s:4:\"type\";s:4:\"font\";}i:222;a:7:{s:4:\"slug\";s:25:\"alternative_fonts_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"afo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:223;a:7:{s:4:\"slug\";s:25:\"alternative_fonts_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#p-YITyC1ROU\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:224;a:7:{s:4:\"slug\";s:25:\"alternative_fonts_options\";s:6:\"parent\";s:12:\"font_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:225;a:6:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:21:\"Blog Layout and style\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:226;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:11:\"Blog Layout\";s:11:\"description\";s:23:\"Select the blog layout.\";s:2:\"id\";s:11:\"blog_layout\";s:3:\"std\";s:11:\"def_classic\";s:7:\"options\";a:3:{i:0;a:3:{s:5:\"value\";s:11:\"def_classic\";s:4:\"name\";s:28:\"Generic Blog - Classic Style\";s:5:\"image\";s:88:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/blog_layouts/def.gif\";}i:1;a:3:{s:5:\"value\";s:10:\"def_modern\";s:4:\"name\";s:27:\"Generic Blog - Modern Style\";s:5:\"image\";s:95:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/blog_layouts/def-modern.gif\";}i:2;a:3:{s:5:\"value\";s:4:\"cols\";s:4:\"name\";s:18:\"Multi-columns blog\";s:5:\"image\";s:94:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/blog_layouts/multicols.gif\";}}s:4:\"type\";s:11:\"radio_image\";s:5:\"class\";s:18:\"ri-hover-line ri-3\";}i:227;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:12:\"Blog Columns\";s:11:\"description\";s:45:\"Select the number of columns you want to use.\";s:2:\"id\";s:17:\"blog_style_layout\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:6:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";i:4;s:1:\"4\";i:5;s:1:\"5\";i:6;s:1:\"6\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:11:\"blog_layout\";s:5:\"value\";a:1:{i:0;s:4:\"cols\";}}}i:228;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:15:\"Content to show\";s:11:\"description\";s:84:\"Choose what content you want to show <b>Important : This only works for 1 column</b>\";s:2:\"id\";s:23:\"sb_archive_content_type\";s:3:\"std\";s:4:\"full\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:7:\"excerpt\";s:7:\"Excerpt\";s:4:\"full\";s:12:\"Full content\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:11:\"blog_layout\";s:5:\"value\";a:2:{i:0;s:11:\"def_classic\";i:1;s:10:\"def_modern\";}}}i:229;a:8:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:2:\"id\";s:10:\"blog_style\";s:4:\"name\";s:17:\"Blog color scheme\";s:11:\"description\";s:28:\"Select the style of the blog\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:0:\"\";s:35:\"Inherit from Global (Color options)\";s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}}i:230;a:6:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:13:\"Image options\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:29:\"zn_full zn-custom-title-large\";}i:231;a:8:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:20:\"Use full width image\";s:11:\"description\";s:114:\"Choose Use full width image option if you want the images to be full width rather then\r\n        the default layout\";s:2:\"id\";s:25:\"sb_archive_use_full_image\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:3:\"yes\";s:20:\"Use full width image\";s:2:\"no\";s:18:\"Use default layout\";}}i:232;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:24:\"Image Maximum Width (px)\";s:11:\"description\";s:103:\"Add a custom maximum width for the blog-post images in the blog archive. Leave blank for default value.\";s:2:\"id\";s:21:\"sb_archive_def_cwidth\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:11:\"placeholder\";s:9:\"eg: 400px\";s:10:\"dependency\";a:2:{s:7:\"element\";s:25:\"sb_archive_use_full_image\";s:5:\"value\";a:1:{i:0;s:2:\"no\";}}}i:233;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:26:\"Use first attached image ?\";s:11:\"description\";s:105:\"Choose yes if you want the theme to display the first image inside a page if no featured image is present\";s:2:\"id\";s:18:\"zn_use_first_image\";s:3:\"std\";s:3:\"yes\";s:7:\"options\";a:2:{s:3:\"yes\";s:3:\"Yes\";s:2:\"no\";s:2:\"No\";}s:4:\"type\";s:8:\"zn_radio\";s:5:\"class\";s:15:\"zn_radio--yesno\";}i:234;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:15:\"Blog Sub-header\";s:11:\"description\";s:57:\"These options are applied to the subheader in blog pages.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:235;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:18:\"Archive Page Title\";s:11:\"description\";s:55:\"Enter the desired page title for the blog archive page.\";s:2:\"id\";s:18:\"archive_page_title\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:13:\"BLOG & Gossip\";s:14:\"translate_name\";s:18:\"Archive Page Title\";s:5:\"class\";s:0:\"\";}i:236;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:21:\"Archive page subtitle\";s:11:\"description\";s:58:\"Enter the desired page subtitle for the blog archive page.\";s:2:\"id\";s:21:\"archive_page_subtitle\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:36:\"This would be the blog category page\";s:14:\"translate_name\";s:21:\"Archive Page Subtitle\";s:5:\"class\";s:0:\"\";}i:237;a:9:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:31:\"Header Style for main blog page\";s:11:\"description\";s:150:\"Select the background style you want to use.Please note that the styles can be created from the \"Unlimited Headers\" options in the theme admin\'s page.\";s:2:\"id\";s:15:\"blog_sub_header\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:0;s:4:\"None\";s:19:\"zn_def_header_style\";s:13:\"Default style\";}s:5:\"class\";s:0:\"\";}i:238;a:6:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:13:\"Other options\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:239;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:16:\"Blog date format\";s:11:\"description\";s:168:\"Enter your desired date format. More info about formatting the date can be found <a target=\"_blank\" href=\"https://codex.wordpress.org/Formatting_Date_and_Time\">here</a>\";s:2:\"id\";s:16:\"blog_date_format\";s:4:\"type\";s:11:\"date_format\";s:3:\"std\";s:8:\"l, d F Y\";}i:240;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"bgao_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:241;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#Kd0a0kDrg1s\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:242;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:229:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/setting-up-blog/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:243;a:7:{s:4:\"slug\";s:20:\"blog_archive_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:244;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:14:\"Article layout\";s:11:\"description\";s:35:\"Choose the blog item\'s page layout.\";s:2:\"id\";s:9:\"sg_layout\";s:3:\"std\";s:7:\"classic\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:7:\"classic\";s:31:\"Classic Layout (Older versions)\";s:6:\"modern\";s:13:\"Modern Layout\";}}i:245;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:18:\"Show author info ?\";s:11:\"description\";s:71:\"Choose if you want to show the author info section on single post item.\";s:2:\"id\";s:19:\"zn_show_author_info\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:7:\"toggle2\";s:5:\"value\";s:3:\"yes\";}i:246;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:20:\"Show related posts ?\";s:11:\"description\";s:49:\"Choose if you want to show related posts section.\";s:2:\"id\";s:21:\"zn_show_related_posts\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:7:\"toggle2\";s:5:\"value\";s:3:\"yes\";}i:247;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:26:\"Show Social Share Buttons?\";s:11:\"description\";s:78:\"Choose if you want to show the social share buttons bellow the post\'s content.\";s:2:\"id\";s:11:\"show_social\";s:3:\"std\";s:4:\"show\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:4:\"show\";s:46:\"Show Generic social buttons (Performance cost)\";s:11:\"show_custom\";s:26:\"Show Custom social buttons\";s:4:\"hide\";s:26:\"Do not show social buttons\";}}i:248;a:7:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:13:\"Image options\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:14:\"sbo_title_main\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:249;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:20:\"Use full width image\";s:11:\"description\";s:105:\"Choose Use full width image option if you want the images to be full widht rather then the default layout\";s:2:\"id\";s:17:\"sb_use_full_image\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:3:\"yes\";s:20:\"Use full width image\";s:2:\"no\";s:18:\"Use default layout\";}}i:250;a:9:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:24:\"Image Maximum Width (px)\";s:11:\"description\";s:89:\"Add a custom maximum width for the image in the blog post. Leave blank for default value.\";s:2:\"id\";s:16:\"sb_bp_def_cwidth\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:11:\"placeholder\";s:9:\"eg: 400px\";s:10:\"dependency\";a:2:{s:7:\"element\";s:17:\"sb_use_full_image\";s:5:\"value\";a:1:{i:0;s:2:\"no\";}}}i:251;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:45:\"Open post\'s \"linked\" images with modal popup?\";s:11:\"description\";s:76:\"Choose if you want to open post\'s images with a lightbox modal image opener.\";s:2:\"id\";s:16:\"sb_link_post_img\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:7:\"toggle2\";s:5:\"value\";s:3:\"yes\";}i:252;a:7:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:13:\"Other options\";s:11:\"description\";s:0:\"\";s:2:\"id\";s:14:\"sbo_title_main\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:253;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:34:\"Display posts on multiple columns?\";s:11:\"description\";s:78:\"Please select if you want to display the single blog post on multiple columns.\";s:2:\"id\";s:16:\"sbo_multicolumns\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:1;s:18:\"1 Column (default)\";i:2;s:9:\"2 Columns\";}}i:254;a:8:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:21:\"Override page title ?\";s:11:\"description\";s:108:\"Choose if you want to show a custom title in the sub-header. Normally, the current post title will be shown.\";s:2:\"id\";s:24:\"zn_override_single_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:7:\"toggle2\";s:5:\"value\";s:3:\"yes\";}i:255;a:9:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:17:\"Single Page Title\";s:11:\"description\";s:55:\"Enter the desired page title for the blog single pages.\";s:2:\"id\";s:17:\"single_page_title\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:13:\"BLOG & Gossip\";s:5:\"class\";s:0:\"\";s:10:\"dependency\";a:2:{s:7:\"element\";s:24:\"zn_override_single_title\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:256;a:7:{s:4:\"slug\";s:19:\"single_blog_options\";s:6:\"parent\";s:12:\"blog_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"sbio_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:257;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#Kd0a0kDrg1s\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:258;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:229:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/setting-up-blog/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:259;a:7:{s:4:\"slug\";s:17:\"recaptcha_options\";s:6:\"parent\";s:15:\"general_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:260;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:24:\"Portfolio page (Archive)\";s:11:\"description\";s:58:\"These options are dedicated to the portfolio archive page.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:261;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:23:\"Portfolio Archive style\";s:11:\"description\";s:57:\"Select the desired style for the portfolio archive pages.\";s:2:\"id\";s:15:\"portfolio_style\";s:3:\"std\";s:18:\"portfolio_sortable\";s:7:\"options\";a:3:{i:0;a:3:{s:5:\"value\";s:18:\"portfolio_category\";s:4:\"name\";s:18:\"Portfolio Category\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/portfolio_layouts/category.gif\";}i:1;a:3:{s:5:\"value\";s:18:\"portfolio_sortable\";s:4:\"name\";s:18:\"Portfolio Sortable\";s:5:\"image\";s:98:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/portfolio_layouts/sortable.gif\";}i:2;a:3:{s:5:\"value\";s:18:\"portfolio_carousel\";s:4:\"name\";s:19:\"Portfolio Carousels\";s:5:\"image\";s:99:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/portfolio_layouts/carousels.gif\";}}s:4:\"type\";s:11:\"radio_image\";s:5:\"class\";s:18:\"ri-hover-line ri-3\";}i:262;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:31:\"Active Button in Portfolio Menu\";s:11:\"description\";s:74:\"Choose the active category or wether all should be displayed on page load.\";s:2:\"id\";s:21:\"ptf_sort_activebutton\";s:3:\"std\";s:1:\"*\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:0:{}s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_sortable\";}}}i:263;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:21:\"Show load more button\";s:11:\"description\";s:55:\"Choose if you want to show the load more button or not.\";s:2:\"id\";s:17:\"ptf_sort_loadmore\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:7:\"toggle2\";s:5:\"value\";s:3:\"yes\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_sortable\";}}}i:264;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:17:\"Number of columns\";s:11:\"description\";s:68:\"Please select on how many columns the portfolio should be displayed.\";s:2:\"id\";s:17:\"ports_num_columns\";s:3:\"std\";s:1:\"4\";s:7:\"options\";a:6:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";i:4;s:1:\"4\";i:5;s:1:\"5\";i:6;s:1:\"6\";}s:4:\"type\";s:6:\"select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:2:{i:0;s:18:\"portfolio_category\";i:1;s:18:\"portfolio_sortable\";}}}i:265;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:12:\"Images Width\";s:11:\"description\";s:188:\"This option will resize and cache the images in your portfolio listing page\'s items. Not specifying a width will result in full-width images that would slow down the loading of your page. \";s:2:\"id\";s:18:\"ptf_sort_img_width\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:11:\"placeholder\";s:9:\"eg: 600px\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_sortable\";}}}i:266;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:11:\"Frame Style\";s:11:\"description\";s:41:\"Please choose which frame style to apply.\";s:2:\"id\";s:11:\"frame_style\";s:3:\"std\";s:7:\"classic\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:7:\"classic\";s:7:\"Classic\";s:6:\"modern\";s:6:\"Modern\";s:7:\"minimal\";s:7:\"Minimal\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_carousel\";}}}i:267;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:39:\"Number of columns (Portfolio Carousels)\";s:11:\"description\";s:68:\"Please select on how many columns the portfolio should be displayed.\";s:2:\"id\";s:22:\"ports_carousel_columns\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:3:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";}s:4:\"type\";s:6:\"select\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_carousel\";}}}i:268;a:10:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:37:\"Show item details bellow post content\";s:11:\"description\";s:150:\"Here, you can choose to show the portfolio item details like CLIENt, YEAR, etc. <b> Important : Will only work when you select 1 column layout </b> ).\";s:2:\"id\";s:19:\"ports_extra_content\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";s:4:\"type\";s:8:\"zn_radio\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"portfolio_style\";s:5:\"value\";a:1:{i:0;s:18:\"portfolio_category\";}}}i:269;a:8:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:20:\"Link Portfolio Media\";s:11:\"description\";s:124:\"Select Yes if you want your portfolio images to be linked to the portfolio item as\r\n		opposed to open the image in lightbox.\";s:2:\"id\";s:17:\"zn_link_portfolio\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:3:{s:3:\"yes\";s:26:\"Link all to portfolio item\";s:2:\"no\";s:57:\"Open the image in lightbox, title links to portfolio item\";s:6:\"no_all\";s:45:\"Open the image in lightbox, title is unlinked\";}s:4:\"type\";s:6:\"select\";}i:270;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:24:\"Portfolio items per page\";s:11:\"description\";s:84:\"Please enter the desired number of portfolio items that will be displayed on a page.\";s:2:\"id\";s:23:\"portfolio_per_page_show\";s:3:\"std\";s:1:\"4\";s:4:\"type\";s:4:\"text\";}i:271;a:8:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:2:\"id\";s:16:\"portfolio_scheme\";s:4:\"name\";s:22:\"Portfolio color scheme\";s:11:\"description\";s:40:\"Select the color scheme of the Portfolio\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:0:\"\";s:35:\"Inherit from Global (Color options)\";s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}}i:272;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:28:\"Portfolio item page (Single)\";s:11:\"description\";s:55:\"These options are dedicated to the portfolio item page.\";s:2:\"id\";s:9:\"hd_title1\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:46:\"zn_full zn-custom-title-large zn-top-separator\";}i:273;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:32:\"Text content (description) style\";s:11:\"description\";s:54:\"Display the text content either collapsed or expanded.\";s:2:\"id\";s:22:\"portfolio_single_style\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:0:\"\";s:26:\"Show compacted description\";s:9:\"full_desc\";s:21:\"Show full description\";}s:5:\"class\";s:0:\"\";}i:274;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:27:\"Portfolio Images Width (px)\";s:11:\"description\";s:88:\"The width of the portfolio item images to resize, in pixels. Adding \'0\' means no resize.\";s:2:\"id\";s:24:\"portfolio_item_img_width\";s:3:\"std\";s:3:\"700\";s:4:\"type\";s:4:\"text\";s:6:\"dragup\";a:1:{s:3:\"min\";s:3:\"100\";}s:5:\"class\";s:11:\"zn_input_xs\";}i:275;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:29:\"Show related portfolio items?\";s:11:\"description\";s:118:\"Here, you can choose to show the portfolio related items or not. The related items are based on the portfolio tags. ).\";s:2:\"id\";s:18:\"ports_show_related\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";s:4:\"type\";s:8:\"zn_radio\";}i:276;a:9:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:20:\"Show portfolio tags?\";s:11:\"description\";s:55:\"Here, you can choose to show the portfolio tags or not.\";s:2:\"id\";s:15:\"ports_show_tags\";s:3:\"std\";s:2:\"no\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";s:4:\"type\";s:8:\"zn_radio\";}i:277;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"ptfo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:278;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#rVA576HZaYA\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:279;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:234:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/setting-up-portfolio/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:280;a:7:{s:4:\"slug\";s:17:\"portfolio_options\";s:6:\"parent\";s:17:\"portfolio_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:281;a:9:{s:4:\"slug\";s:21:\"documentation_options\";s:6:\"parent\";s:21:\"documentation_options\";s:4:\"name\";s:12:\"Header Style\";s:11:\"description\";s:135:\"Select the header style you want to use for this page. Please note that\r\n					header styles can be created from the theme\'s admin page.\";s:2:\"id\";s:19:\"zn_doc_header_style\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:0;s:4:\"None\";s:19:\"zn_def_header_style\";s:13:\"Default style\";}s:5:\"class\";s:0:\"\";}i:282;a:7:{s:4:\"slug\";s:21:\"documentation_options\";s:6:\"parent\";s:21:\"documentation_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"dcmo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:283;a:7:{s:4:\"slug\";s:21:\"documentation_options\";s:6:\"parent\";s:21:\"documentation_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:284;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:18:\"Choose Site Layout\";s:11:\"description\";s:52:\"Choose the type of layout you want pages to display.\";s:2:\"id\";s:15:\"zn_boxed_layout\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:11:\"radio_image\";s:5:\"class\";s:24:\"zn_full ri-2 ri-bg-hover\";s:7:\"options\";a:2:{i:0;a:3:{s:5:\"value\";s:2:\"no\";s:4:\"name\";s:10:\"Full-Width\";s:5:\"image\";s:93:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/site-layout/fullwidth.svg\";}i:1;a:3:{s:5:\"value\";s:3:\"yes\";s:4:\"name\";s:5:\"Boxed\";s:5:\"image\";s:89:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/site-layout/boxed.svg\";}}}i:285;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:16:\"Background Image\";s:11:\"description\";s:59:\"Please choose your desired image to be used as a background\";s:2:\"id\";s:17:\"boxed_style_image\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:3:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";}s:4:\"type\";s:10:\"background\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"zn_boxed_layout\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:286;a:8:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:16:\"Background Color\";s:11:\"description\";s:43:\"Please choose your desired background color\";s:2:\"id\";s:17:\"boxed_style_color\";s:3:\"std\";s:4:\"#fff\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:15:\"zn_boxed_layout\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:287;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:21:\"Homepage Boxed Layout\";s:11:\"description\";s:108:\"Here you can choose a specific layout setting for the homepage that will override the\r\n		setting from above.\";s:2:\"id\";s:20:\"zn_home_boxed_layout\";s:3:\"std\";s:3:\"def\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:3:{s:3:\"def\";s:7:\"Default\";s:2:\"no\";s:2:\"No\";s:3:\"yes\";s:3:\"Yes\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:288;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:12:\"Content size\";s:11:\"description\";s:55:\"Please choose the desired default size for the content.\";s:2:\"id\";s:8:\"zn_width\";s:3:\"std\";s:4:\"1170\";s:7:\"options\";a:4:{i:0;a:3:{s:5:\"value\";s:4:\"1170\";s:4:\"name\";s:6:\"1170px\";s:5:\"image\";s:117:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/layout-contentsize-1170.gif\";}i:1;a:3:{s:5:\"value\";s:3:\"960\";s:4:\"name\";s:5:\"960px\";s:5:\"image\";s:116:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/layout-contentsize-960.gif\";}i:2;a:3:{s:5:\"value\";s:6:\"custom\";s:4:\"name\";s:12:\"Custom Width\";s:5:\"image\";s:119:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/layout-contentsize-custom.gif\";}i:3;a:3:{s:5:\"value\";s:11:\"custom_perc\";s:4:\"name\";s:23:\"Custom Percentage Width\";s:5:\"image\";s:124:\"https://modelox.vico.digital/wp-content/themes/kallyas/images/admin/various-theme-options/layout-contentsize-custom-perc.gif\";}}s:4:\"type\";s:11:\"radio_image\";s:5:\"class\";s:18:\"ri-hover-line ri-4\";}i:289;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:2:\"id\";s:12:\"custom_width\";s:4:\"name\";s:51:\"Site Container Width (on Large breakpoints, 1200px)\";s:11:\"description\";s:50:\"Choose the desired width for the site\'s container.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:4:\"1170\";s:7:\"helpers\";a:2:{s:3:\"min\";s:4:\"1170\";s:3:\"max\";s:4:\"1900\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:8:\"zn_width\";s:5:\"value\";a:1:{i:0;s:6:\"custom\";}}}i:290;a:11:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:2:\"id\";s:17:\"custom_perc_width\";s:4:\"name\";s:33:\"Site Container Percentage % Width\";s:11:\"description\";s:50:\"Choose the desired width for the site\'s container.\";s:4:\"type\";s:12:\"smart_slider\";s:3:\"std\";s:3:\"100\";s:8:\"supports\";a:1:{i:0;s:11:\"breakpoints\";}s:5:\"units\";a:1:{i:0;s:1:\"%\";}s:7:\"helpers\";a:2:{s:3:\"min\";s:2:\"10\";s:3:\"max\";s:3:\"100\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:8:\"zn_width\";s:5:\"value\";a:1:{i:0;s:11:\"custom_perc\";}}}i:291;a:9:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:31:\"Extend Element Entry Animations\";s:11:\"description\";s:243:\"Choose yes if you want to extend elements entry/reveal animations on page scroll. Each element will have Animation options in the Misc. tab. Please remember that it affects website performance and will load animate.css which is around 60-70kb.\";s:2:\"id\";s:13:\"zn_animations\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:3:\"Yes\";s:2:\"no\";s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:292;a:7:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"lto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:293;a:7:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#X6qGyb6Bmaw\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:294;a:7:{s:4:\"slug\";s:14:\"layout_options\";s:6:\"parent\";s:14:\"layout_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:295;a:7:{s:4:\"slug\";s:19:\"general_pb_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:40:\"PageBuilder Smart Areas on GENERAL PAGES\";s:11:\"description\";s:88:\"Using these options you can replace some of the site areas with pagebuilder smart areas.\";s:2:\"id\";s:14:\"pbtmpl_general\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on subheader\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:3:{s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on footer\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:296;a:7:{s:4:\"slug\";s:21:\"single_pages_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:43:\"PageBuilder Smart Area on SINGLE BLOG PAGES\";s:11:\"description\";s:87:\"Using these options you can replace some of the site areas with pagebuilder smart area.\";s:2:\"id\";s:11:\"pbtmpl_post\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on SUBHEADER\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on FOOTER\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:297;a:7:{s:4:\"slug\";s:21:\"single_pages_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:48:\"PageBuilder Smart Area on SINGLE PORTFOLIO PAGES\";s:11:\"description\";s:87:\"Using these options you can replace some of the site areas with pagebuilder smart area.\";s:2:\"id\";s:16:\"pbtmpl_portfolio\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on SUBHEADER\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on FOOTER\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:298;a:7:{s:4:\"slug\";s:21:\"single_pages_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:43:\"PageBuilder Smart Area on SINGLE SHOP PAGES\";s:11:\"description\";s:87:\"Using these options you can replace some of the site areas with pagebuilder smart area.\";s:2:\"id\";s:14:\"pbtmpl_product\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on SUBHEADER\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on FOOTER\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:299;a:7:{s:4:\"slug\";s:22:\"archive_pages_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:55:\"PageBuilder Smart Area on BLOG ARCHIVE (Category) PAGES\";s:11:\"description\";s:87:\"Using these options you can replace some of the site areas with pagebuilder smart area.\";s:2:\"id\";s:15:\"pbtmpl_category\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on SUBHEADER\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on FOOTER\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:300;a:7:{s:4:\"slug\";s:22:\"archive_pages_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:55:\"PageBuilder Smart Area on SHOP ARCHIVE (Category) PAGES\";s:11:\"description\";s:87:\"Using these options you can replace some of the site areas with pagebuilder smart area.\";s:2:\"id\";s:18:\"pbtmpl_product_cat\";s:4:\"type\";s:12:\"group_select\";s:6:\"config\";a:2:{s:4:\"size\";s:8:\"zn_span6\";s:7:\"options\";a:6:{i:0;a:3:{s:4:\"name\";s:29:\"Smart Area location on header\";s:2:\"id\";s:15:\"header_location\";s:7:\"options\";a:3:{s:6:\"before\";s:13:\"Before header\";s:5:\"after\";s:12:\"After header\";s:7:\"replace\";s:14:\"Replace header\";}}i:1;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"header_template\";s:7:\"options\";a:1:{s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:2;a:3:{s:4:\"name\";s:32:\"Smart Area location on SUBHEADER\";s:2:\"id\";s:18:\"subheader_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:16:\"Before subheader\";s:5:\"after\";s:15:\"After subheader\";s:7:\"replace\";s:17:\"Replace subheader\";}}i:3;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:18:\"subheader_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}i:4;a:3:{s:4:\"name\";s:29:\"Smart Area location on FOOTER\";s:2:\"id\";s:15:\"footer_location\";s:7:\"options\";a:4:{s:0:\"\";s:25:\"-- Use general setting --\";s:6:\"before\";s:13:\"Before footer\";s:5:\"after\";s:12:\"After footer\";s:7:\"replace\";s:14:\"Replace footer\";}}i:5;a:3:{s:4:\"name\";s:17:\"Smart Area to use\";s:2:\"id\";s:15:\"footer_template\";s:7:\"options\";a:2:{s:0:\"\";s:28:\"-- Use general smart area --\";s:11:\"no_template\";s:19:\"-- No smart-area --\";}}}}}i:301;a:7:{s:4:\"slug\";s:19:\"general_pb_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"lto_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:302;a:7:{s:4:\"slug\";s:19:\"general_pb_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:238:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/page-builder-smart-areas/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:303;a:7:{s:4:\"slug\";s:19:\"general_pb_settings\";s:6:\"parent\";s:10:\"pb_layouts\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:304;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:10:\"MAIN COLOR\";s:11:\"description\";s:163:\"Please choose a main color for your site. This color will be used for various elements within the site, as text color (and hover) and background color (and hover).\";s:2:\"id\";s:13:\"zn_main_color\";s:3:\"std\";s:7:\"#cd2122\";s:4:\"type\";s:11:\"colorpicker\";}i:305;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:21:\"MAIN COLOR (Contrast)\";s:11:\"description\";s:308:\"This color is used exclusively where it\'s over or depends on the MAIN COLOR. For example default color is Red, this White color will be over it, for example active menu item in main menu, Full-Colored button, etc. This comes in need when you\'re using a main color that\'s too bright and it becomes unreadable.\";s:2:\"id\";s:22:\"zn_main_color_contrast\";s:3:\"std\";s:4:\"#fff\";s:4:\"type\";s:11:\"colorpicker\";}i:306;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:18:\"Global Site Colors\";s:11:\"description\";s:40:\"These are the global site color options.\";s:2:\"id\";s:14:\"clo_title_main\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:44:\"zn_full zn-custom-title-md zn-top-separator \";}i:307;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:10:\"THEME SKIN\";s:11:\"description\";s:233:\"Please select the skin of the theme, wether light or dark. <br>* Please know that customisations are still needed and most elements have their own customisation options (eg: colorprickers or even text color scheme light/dark preset).\";s:2:\"id\";s:13:\"zn_main_style\";s:3:\"std\";s:5:\"light\";s:7:\"options\";a:2:{s:5:\"light\";s:23:\"Light Style ( Default )\";s:4:\"dark\";s:10:\"Dark Style\";}s:4:\"type\";s:6:\"select\";}i:308;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:31:\"TEXT COLOR (Light - Theme Skin)\";s:11:\"description\";s:271:\"Please choose a default color for the site\'s general text color. <br>* Note: There is another color option in Kallyas options > Font options > Body Options. Make sure that option is empty. We\'ll keep that one just for backwards compatibility only, but it will be removed.\";s:2:\"id\";s:21:\"zn_body_def_textcolor\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:5:\"light\";}}}i:309;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:33:\"LINKS COLORS (Light - Theme Skin)\";s:11:\"description\";s:89:\"Please choose a default color for the site\'s general links color (mostly in post content)\";s:2:\"id\";s:22:\"zn_body_def_linkscolor\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:5:\"light\";}}}i:310;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:38:\"HOVER LINKS COLOR (Light - Theme Skin)\";s:11:\"description\";s:96:\"Please choose a default color for the site\'s general hover links color (mostly in post content).\";s:2:\"id\";s:26:\"zn_body_def_linkscolor_hov\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:5:\"light\";}}}i:311;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:30:\"TEXT COLOR (Dark - Theme Skin)\";s:11:\"description\";s:271:\"Please choose a default color for the site\'s general text color. <br>* Note: There is another color option in Kallyas options > Font options > Body Options. Make sure that option is empty. We\'ll keep that one just for backwards compatibility only, but it will be removed.\";s:2:\"id\";s:26:\"zn_body_def_textcolor_dark\";s:3:\"std\";s:7:\"#dcdcdc\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:4:\"dark\";}}}i:312;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:32:\"LINKS COLORS (Dark - Theme Skin)\";s:11:\"description\";s:90:\"Please choose a default color for the site\'s general links color (mostly in post content).\";s:2:\"id\";s:27:\"zn_body_def_linkscolor_dark\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:4:\"dark\";}}}i:313;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:37:\"HOVER LINKS COLOR (Dark - Theme Skin)\";s:11:\"description\";s:96:\"Please choose a default color for the site\'s general hover links color (mostly in post content).\";s:2:\"id\";s:31:\"zn_body_def_linkscolor_hov_dark\";s:3:\"std\";s:4:\"#eee\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"zn_main_style\";s:5:\"value\";a:1:{i:0;s:4:\"dark\";}}}i:314;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:16:\"BACKGROUND COLOR\";s:11:\"description\";s:50:\"Please choose a default color for the site\'s body.\";s:2:\"id\";s:17:\"zn_body_def_color\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";}i:315;a:8:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:16:\"BACKGROUND IMAGE\";s:11:\"description\";s:66:\"Please choose your desired image to be used as as body background.\";s:2:\"id\";s:15:\"body_back_image\";s:3:\"std\";s:0:\"\";s:7:\"options\";a:4:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";s:4:\"size\";s:1:\"1\";}s:4:\"type\";s:10:\"background\";}i:316;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:21:\"Various Color Options\";s:11:\"description\";s:59:\"These are various colors for different parts from the site.\";s:2:\"id\";s:17:\"clo_title_various\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:44:\"zn_full zn-custom-title-md zn-top-separator \";}i:317;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:21:\"Top Nav default Color\";s:11:\"description\";s:54:\"Please choose a color for the top nav links in header.\";s:2:\"id\";s:16:\"zn_top_nav_color\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";}i:318;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:19:\"Top Nav Hover Color\";s:11:\"description\";s:78:\"Please choose a color for the top nav links in header when hovering over them.\";s:2:\"id\";s:18:\"zn_top_nav_h_color\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";}i:319;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"clmo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:320;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#MkYR_3PYbXU\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:321;a:7:{s:4:\"slug\";s:13:\"color_options\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:322;a:12:{s:4:\"slug\";s:21:\"color_options_palette\";s:6:\"parent\";s:13:\"color_options\";s:4:\"name\";s:22:\"Add Colors for Palette\";s:11:\"description\";s:401:\"Here you can add colors that will be displayed in the <strong style=\"color:#121212\">bottom\'s colorpicker palette</strong>:<br><br> <img width=\"140\" src=\"https://modelox.vico.digital/wp-content/themes/kallyas/images/zn_add_pallette_lq.png\" alt=\"\">. <br><br>Color resources:<br><a href=\"http://colorhunt.co/tab/\" title=\"\">ColorHunt</a><br><a href=\"http://www.colourlovers.com/\" title=\"\">ColourLovers</a>\";s:2:\"id\";s:13:\"zn_add_colors\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:13:\"element_title\";s:8:\"zn_color\";s:8:\"add_text\";s:5:\"Color\";s:11:\"remove_text\";s:5:\"Color\";s:11:\"subelements\";a:1:{i:0;a:5:{s:4:\"name\";s:9:\"Add Color\";s:11:\"description\";s:16:\"Choose the color\";s:2:\"id\";s:8:\"zn_color\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"colorpicker\";}}s:5:\"class\";s:11:\"zn_not_full\";}i:323;a:13:{s:4:\"slug\";s:24:\"unlimited_header_options\";s:6:\"parent\";s:24:\"unlimited_header_options\";s:4:\"name\";s:23:\"Header Styles Generator\";s:11:\"description\";s:74:\"Here you can create unlimited header styles to be used on different pages.\";s:2:\"id\";s:16:\"header_generator\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:8:\"add_text\";s:12:\"Header Style\";s:11:\"remove_text\";s:12:\"Header Style\";s:13:\"element_title\";s:13:\"uh_style_name\";s:14:\"group_sortable\";b:0;s:11:\"subelements\";a:23:{i:0;a:6:{s:4:\"name\";s:17:\"Header Style Name\";s:11:\"description\";s:156:\"The name of this header style.Please note that all names must be unique. You can only use alphanumeric characters. Other character types can cause problems.\";s:2:\"id\";s:13:\"uh_style_name\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:8:\"supports\";s:5:\"block\";}i:1;a:6:{s:4:\"name\";s:15:\"Background Type\";s:11:\"description\";s:48:\"Please select the source type of the background.\";s:2:\"id\";s:10:\"uh_bg_type\";s:3:\"std\";s:9:\"simple_bg\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:9:\"simple_bg\";s:23:\"Simple Background Image\";s:11:\"advanced_bg\";s:34:\"Advanced Settings Background Image\";}}i:2;a:6:{s:2:\"id\";s:19:\"uh_background_image\";s:4:\"name\";s:16:\"Background image\";s:11:\"description\";s:128:\"Select a background image for your Sub-header. It will automatically be resized to fully stretch inside the subheader boundries.\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"media\";s:10:\"dependency\";a:2:{s:7:\"element\";s:10:\"uh_bg_type\";s:5:\"value\";a:1:{i:0;s:9:\"simple_bg\";}}}i:3;a:7:{s:2:\"id\";s:28:\"uh_background_image_advanced\";s:4:\"name\";s:16:\"Background image\";s:11:\"description\";s:80:\"Please choose a background image for this Subheader and select advanced options.\";s:4:\"type\";s:10:\"background\";s:7:\"options\";a:4:{s:6:\"repeat\";s:1:\"1\";s:8:\"position\";s:1:\"1\";s:10:\"attachment\";s:1:\"1\";s:4:\"size\";s:1:\"1\";}s:5:\"class\";s:7:\"zn_full\";s:10:\"dependency\";a:2:{s:7:\"element\";s:10:\"uh_bg_type\";s:5:\"value\";a:1:{i:0;s:11:\"advanced_bg\";}}}i:4;a:5:{s:4:\"name\";s:23:\"Header Background Color\";s:11:\"description\";s:136:\"Here you can choose a default color for your header.If you do not select a\r\n				background image, this color will be used as background.\";s:2:\"id\";s:15:\"uh_header_color\";s:3:\"std\";s:7:\"#AAAAAA\";s:4:\"type\";s:11:\"colorpicker\";}i:5;a:7:{s:4:\"name\";s:24:\"Add gradient over color?\";s:11:\"description\";s:61:\"Select yes if you want add a gradient over the selected color\";s:2:\"id\";s:10:\"uh_grad_bg\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:6;a:7:{s:4:\"name\";s:19:\"Animate Background?\";s:11:\"description\";s:55:\"Select yes if you want to make your background animated\";s:2:\"id\";s:10:\"uh_anim_bg\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:7;a:7:{s:4:\"name\";s:17:\"Add Glare effect?\";s:11:\"description\";s:64:\"Select yes if you want to add a glare effect over the background\";s:2:\"id\";s:8:\"uh_glare\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{i:1;s:3:\"Yes\";i:0;s:2:\"No\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:8;a:6:{s:4:\"name\";s:17:\"Text Color Scheme\";s:11:\"description\";s:29:\"Select the text color scheme.\";s:2:\"id\";s:12:\"uh_textcolor\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:0:\"\";s:36:\"- Default - Set from theme options -\";s:5:\"light\";s:5:\"Light\";s:4:\"dark\";s:4:\"Dark\";}}i:9;a:6:{s:4:\"name\";s:11:\"Bottom mask\";s:11:\"description\";s:57:\"The new masks are svg based, vectorial and color adapted.\";s:2:\"id\";s:15:\"uh_bottom_style\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:13:{s:4:\"none\";s:5:\"None.\";s:6:\"shadow\";s:9:\"Shadow Up\";s:9:\"shadow_ud\";s:18:\"Shadow Up and down\";s:5:\"mask1\";s:36:\"Raster Mask 1 (Old, not recommended)\";s:5:\"mask2\";s:36:\"Raster Mask 2 (Old, not recommended)\";s:5:\"mask3\";s:37:\"Vector Mask 3 CENTER (New! From v4.0)\";s:12:\"mask3 mask3l\";s:35:\"Vector Mask 3 LEFT (New! From v4.0)\";s:12:\"mask3 mask3r\";s:36:\"Vector Mask 3 RIGHT (New! From v4.0)\";s:5:\"mask4\";s:37:\"Vector Mask 4 CENTER (New! From v4.0)\";s:12:\"mask4 mask4l\";s:35:\"Vector Mask 4 LEFT (New! From v4.0)\";s:12:\"mask4 mask4r\";s:36:\"Vector Mask 4 RIGHT (New! From v4.0)\";s:5:\"mask5\";s:30:\"Vector Mask 5 (New! From v4.0)\";s:5:\"mask6\";s:30:\"Vector Mask 6 (New! From v4.0)\";}}i:10;a:7:{s:4:\"name\";s:50:\"Edit height and padding for each device breakpoint\";s:11:\"description\";s:233:\"Edit the height and padding options for each breakpoint (device). This will enable you to have more control over the subheader on each device. For example you might want the subheader to be shorter on mobiles, but taller on desktops.\";s:2:\"id\";s:13:\"uh_br_options\";s:3:\"std\";s:2:\"lg\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:4:{s:2:\"lg\";s:5:\"LARGE\";s:2:\"md\";s:6:\"MEDIUM\";s:2:\"sm\";s:5:\"SMALL\";s:2:\"xs\";s:11:\"EXTRA SMALL\";}s:5:\"class\";s:22:\"zn_full zn_breakpoints\";}i:11;a:8:{s:2:\"id\";s:16:\"uh_header_height\";s:4:\"name\";s:36:\"Height on LARGE DEVICES ( Desktops )\";s:11:\"description\";s:59:\"Please enter your desired height in pixels for this header.\";s:3:\"std\";s:3:\"300\";s:4:\"type\";s:6:\"slider\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:3:\"150\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"lg\";}}}i:12;a:8:{s:2:\"id\";s:14:\"uh_top_padding\";s:4:\"name\";s:41:\"Top Padding on LARGE DEVICES ( Desktops )\";s:11:\"description\";s:56:\"Select the top padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:3:\"170\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:2:\"50\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"lg\";}}}i:13;a:8:{s:2:\"id\";s:17:\"uh_bottom_padding\";s:4:\"name\";s:44:\"Bottom Padding on LARGE DEVICES ( Desktops )\";s:11:\"description\";s:59:\"Select the bottom padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"lg\";}}}i:14;a:8:{s:2:\"id\";s:19:\"uh_header_height_md\";s:4:\"name\";s:45:\"Height on MEDIUM DEVICES (Tablets, wide mode)\";s:11:\"description\";s:59:\"Please enter your desired height in pixels for this header.\";s:3:\"std\";s:3:\"300\";s:4:\"type\";s:6:\"slider\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:3:\"150\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"md\";}}}i:15;a:8:{s:2:\"id\";s:17:\"uh_top_padding_md\";s:4:\"name\";s:50:\"Top Padding on MEDIUM DEVICES (Tablets, wide mode)\";s:11:\"description\";s:56:\"Select the top padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:3:\"170\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:2:\"50\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"md\";}}}i:16;a:8:{s:2:\"id\";s:20:\"uh_bottom_padding_md\";s:4:\"name\";s:53:\"Bottom Padding on MEDIUM DEVICES (Tablets, wide mode)\";s:11:\"description\";s:59:\"Select the bottom padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"md\";}}}i:17;a:8:{s:2:\"id\";s:19:\"uh_header_height_sm\";s:4:\"name\";s:48:\"Height on SMALL DEVICES (Tablets, portrait mode)\";s:11:\"description\";s:59:\"Please enter your desired height in pixels for this header.\";s:3:\"std\";s:3:\"300\";s:4:\"type\";s:6:\"slider\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:3:\"150\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"sm\";}}}i:18;a:8:{s:2:\"id\";s:17:\"uh_top_padding_sm\";s:4:\"name\";s:53:\"Top Padding on SMALL DEVICES (Tablets, portrait mode)\";s:11:\"description\";s:56:\"Select the top padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:3:\"170\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:2:\"50\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"sm\";}}}i:19;a:8:{s:2:\"id\";s:20:\"uh_bottom_padding_sm\";s:4:\"name\";s:56:\"Bottom Padding on SMALL DEVICES (Tablets, portrait mode)\";s:11:\"description\";s:59:\"Select the bottom padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"sm\";}}}i:20;a:8:{s:2:\"id\";s:19:\"uh_header_height_xs\";s:4:\"name\";s:45:\"Height on EXTRA SMALL DEVICES ( SmartPhones )\";s:11:\"description\";s:59:\"Please enter your desired height in pixels for this header.\";s:3:\"std\";s:3:\"300\";s:4:\"type\";s:6:\"slider\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:3:\"150\";s:3:\"max\";s:4:\"1280\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"xs\";}}}i:21;a:8:{s:2:\"id\";s:17:\"uh_top_padding_xs\";s:4:\"name\";s:50:\"Top Padding on EXTRA SMALL DEVICES ( SmartPhones )\";s:11:\"description\";s:56:\"Select the top padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:3:\"170\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:2:\"50\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"xs\";}}}i:22;a:8:{s:2:\"id\";s:20:\"uh_bottom_padding_xs\";s:4:\"name\";s:53:\"Bottom Padding on EXTRA SMALL DEVICES ( SmartPhones )\";s:11:\"description\";s:59:\"Select the bottom padding ( in pixels ) for this Subheader.\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:7:\"zn_full\";s:7:\"helpers\";a:3:{s:3:\"min\";s:1:\"0\";s:3:\"max\";s:3:\"350\";s:4:\"step\";s:1:\"1\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:13:\"uh_br_options\";s:5:\"value\";a:1:{i:0;s:2:\"xs\";}}}}s:5:\"class\";s:0:\"\";}i:324;a:7:{s:4:\"slug\";s:24:\"unlimited_header_options\";s:6:\"parent\";s:24:\"unlimited_header_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:9:\"uho_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:325;a:7:{s:4:\"slug\";s:24:\"unlimited_header_options\";s:6:\"parent\";s:24:\"unlimited_header_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#6T0VYHCS9mA\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:326;a:7:{s:4:\"slug\";s:24:\"unlimited_header_options\";s:6:\"parent\";s:24:\"unlimited_header_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:327;a:7:{s:4:\"slug\";s:15:\"sidebar_options\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:12:\"sidebar_size\";s:4:\"name\";s:12:\"Sidebar Size\";s:11:\"description\";s:32:\"Select the desired sidebar size.\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:3;s:4:\"3/12\";i:4;s:4:\"4/12\";}}i:328;a:9:{s:4:\"slug\";s:18:\"unlimited_sidebars\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:18:\"unlimited_sidebars\";s:4:\"name\";s:18:\"Unlimited Sidebars\";s:11:\"description\";s:75:\"Here you can create unlimited sidebars that you can use all over the theme.\";s:4:\"type\";s:5:\"group\";s:8:\"sortable\";b:0;s:13:\"element_title\";s:12:\"sidebar_name\";s:11:\"subelements\";a:1:{i:0;a:5:{s:2:\"id\";s:12:\"sidebar_name\";s:4:\"name\";s:12:\"Sidebar Name\";s:11:\"description\";s:107:\"Please enter a name for this sidebar. Please note that the name should only contain alphanumeric characters\";s:4:\"type\";s:4:\"text\";s:8:\"supports\";s:5:\"block\";}}}i:329;a:7:{s:4:\"slug\";s:18:\"unlimited_sidebars\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"usbo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:330;a:7:{s:4:\"slug\";s:18:\"unlimited_sidebars\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#M7TcpipwAKw\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:331;a:7:{s:4:\"slug\";s:18:\"unlimited_sidebars\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:332;a:9:{s:4:\"slug\";s:16:\"sidebar_settings\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:15:\"archive_sidebar\";s:4:\"name\";s:24:\"Sidebar on archive pages\";s:11:\"description\";s:57:\"Please choose the sidebar position for the archive pages.\";s:4:\"type\";s:7:\"sidebar\";s:5:\"class\";s:7:\"zn_full\";s:3:\"std\";a:2:{s:6:\"layout\";s:13:\"sidebar_right\";s:7:\"sidebar\";s:15:\"default_sidebar\";}s:8:\"supports\";a:2:{s:15:\"default_sidebar\";s:14:\"defaultsidebar\";s:15:\"sidebar_options\";a:3:{s:13:\"right_sidebar\";s:13:\"Right sidebar\";s:12:\"left_sidebar\";s:12:\"Left sidebar\";s:10:\"no_sidebar\";s:10:\"No sidebar\";}}}i:333;a:9:{s:4:\"slug\";s:16:\"sidebar_settings\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:12:\"blog_sidebar\";s:4:\"name\";s:15:\"Sidebar on Blog\";s:11:\"description\";s:53:\"Please choose the sidebar position for the blog page.\";s:4:\"type\";s:7:\"sidebar\";s:5:\"class\";s:7:\"zn_full\";s:3:\"std\";a:2:{s:6:\"layout\";s:13:\"sidebar_right\";s:7:\"sidebar\";s:15:\"default_sidebar\";}s:8:\"supports\";a:2:{s:15:\"default_sidebar\";s:14:\"defaultsidebar\";s:15:\"sidebar_options\";a:3:{s:13:\"right_sidebar\";s:13:\"Right sidebar\";s:12:\"left_sidebar\";s:12:\"Left sidebar\";s:10:\"no_sidebar\";s:10:\"No sidebar\";}}}i:334;a:9:{s:4:\"slug\";s:16:\"sidebar_settings\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:14:\"single_sidebar\";s:4:\"name\";s:27:\"Sidebar on single blog post\";s:11:\"description\";s:61:\"Please choose the sidebar position for the single blog posts.\";s:4:\"type\";s:7:\"sidebar\";s:5:\"class\";s:7:\"zn_full\";s:3:\"std\";a:2:{s:6:\"layout\";s:13:\"sidebar_right\";s:7:\"sidebar\";s:15:\"default_sidebar\";}s:8:\"supports\";a:2:{s:15:\"default_sidebar\";s:14:\"defaultsidebar\";s:15:\"sidebar_options\";a:3:{s:13:\"right_sidebar\";s:13:\"Right sidebar\";s:12:\"left_sidebar\";s:12:\"Left sidebar\";s:10:\"no_sidebar\";s:10:\"No sidebar\";}}}i:335;a:9:{s:4:\"slug\";s:16:\"sidebar_settings\";s:6:\"parent\";s:18:\"unlimited_sidebars\";s:2:\"id\";s:12:\"page_sidebar\";s:4:\"name\";s:16:\"Sidebar on pages\";s:11:\"description\";s:49:\"Please choose the sidebar position for the pages.\";s:4:\"type\";s:7:\"sidebar\";s:5:\"class\";s:7:\"zn_full\";s:3:\"std\";a:2:{s:6:\"layout\";s:13:\"sidebar_right\";s:7:\"sidebar\";s:15:\"default_sidebar\";}s:8:\"supports\";a:2:{s:15:\"default_sidebar\";s:14:\"defaultsidebar\";s:15:\"sidebar_options\";a:3:{s:13:\"right_sidebar\";s:13:\"Right sidebar\";s:12:\"left_sidebar\";s:12:\"Left sidebar\";s:10:\"no_sidebar\";s:10:\"No sidebar\";}}}i:336;a:9:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:19:\"Enable Coming Soon?\";s:11:\"description\";s:141:\"If enabled, the visitors will be displayed the coming soon page. Please note that\r\n		all logged in users will still be able to see your site.\";s:2:\"id\";s:9:\"cs_enable\";s:3:\"std\";s:2:\"no\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:6:\"Enable\";s:2:\"no\";s:7:\"Disable\";}s:5:\"class\";s:15:\"zn_radio--yesno\";}i:337;a:9:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:11:\"Description\";s:11:\"description\";s:63:\"Enter a description that will appear above the countdown clock.\";s:2:\"id\";s:7:\"cs_desc\";s:3:\"std\";s:142:\"We are currently working on a new website and won\'t take long. Please don\'t forget to check\r\n		out our tweets and to subscribe to be notified!\";s:4:\"type\";s:8:\"textarea\";s:14:\"translate_name\";s:28:\"Coming Soon Page Description\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:338;a:8:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:11:\"Launch date\";s:11:\"description\";s:56:\"Please select the date when your site will be available.\";s:2:\"id\";s:7:\"cs_date\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:11:\"date_picker\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:339;a:9:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:15:\"Select template\";s:11:\"description\";s:62:\"Please select the template to use or use the default template.\";s:2:\"id\";s:16:\"cs_page_template\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:11:\"data-source\";s:5:\"pages\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:340;a:9:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:17:\"Mailchimp List ID\";s:11:\"description\";s:210:\"Please select the mailchimp list ID you want to use. Please note that in order for the theme to display your list id\'s ,you will need to enter your Mailchimp API id in the General options > Mailchimp API option\";s:2:\"id\";s:10:\"cs_lsit_id\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:1:{s:0:\"\";s:14:\"Select List ID\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:341;a:10:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:29:\"Show or hide the Social icons\";s:11:\"description\";s:51:\"Display the social icons list in coming soon page?.\";s:2:\"id\";s:22:\"cs_social_icons_enable\";s:3:\"std\";s:3:\"yes\";s:4:\"type\";s:8:\"zn_radio\";s:7:\"options\";a:2:{s:3:\"yes\";s:4:\"Show\";s:2:\"no\";s:4:\"Hide\";}s:5:\"class\";s:15:\"zn_radio--yesno\";s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:342;a:9:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:35:\"Use normal or colored social icons?\";s:11:\"description\";s:87:\"Here you can choose to use the normal social icons or the colored version of each icon.\";s:2:\"id\";s:18:\"cs_which_icons_set\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:4:{s:6:\"normal\";s:12:\"Normal Icons\";s:7:\"colored\";s:13:\"Colored icons\";s:11:\"colored_hov\";s:22:\"Colored on Hover icons\";s:5:\"clean\";s:11:\"Clean icons\";}s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:343;a:12:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:12:\"Social Icons\";s:11:\"description\";s:94:\"Here you can configure what social icons to appear on the right side of the MailChimp\r\n		form.\";s:2:\"id\";s:15:\"cs_social_icons\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:5:\"group\";s:13:\"element_title\";s:15:\"cs_social_title\";s:8:\"add_text\";s:11:\"Social Icon\";s:11:\"remove_text\";s:11:\"Social Icon\";s:11:\"subelements\";a:4:{i:0;a:5:{s:4:\"name\";s:10:\"Icon title\";s:11:\"description\";s:149:\"Here you can enter a title for this social icon.Please note that this is just\r\n				for your information as this text will not be visible on the site.\";s:2:\"id\";s:15:\"cs_social_title\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";}i:1;a:6:{s:4:\"name\";s:16:\"Social icon link\";s:11:\"description\";s:114:\"Please enter your desired link for the social icon. If this field is left\r\n				blank, the icon will not be linked.\";s:2:\"id\";s:14:\"cs_social_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"link\";s:7:\"options\";a:2:{s:6:\"_blank\";s:10:\"New window\";s:5:\"_self\";s:11:\"Same window\";}}i:2;a:5:{s:4:\"name\";s:28:\"Social icon Background color\";s:11:\"description\";s:126:\"Select a background color for the icon (if you selected <strong>Colored</strong> or <strong>Colored on hover</strong> options)\";s:2:\"id\";s:15:\"cs_social_color\";s:3:\"std\";s:4:\"#000\";s:4:\"type\";s:11:\"colorpicker\";}i:3;a:6:{s:4:\"name\";s:11:\"Social icon\";s:11:\"description\";s:32:\"Select your desired social icon.\";s:2:\"id\";s:14:\"cs_social_icon\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:9:\"icon_list\";s:5:\"class\";s:7:\"zn_full\";}}s:10:\"dependency\";a:2:{s:7:\"element\";s:9:\"cs_enable\";s:5:\"value\";a:1:{i:0;s:3:\"yes\";}}}i:344;a:7:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"cmso_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:345;a:7:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:249:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#7-u8q7VwPaA\" target=\"_blank\">Click here to access the video tutorial for this section\'s options.</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:346;a:7:{s:4:\"slug\";s:19:\"coming_soon_options\";s:6:\"parent\";s:19:\"coming_soon_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:347;a:8:{s:4:\"slug\";s:14:\"zn_404_options\";s:6:\"parent\";s:14:\"zn_404_options\";s:4:\"name\";s:13:\"404 page type\";s:11:\"description\";s:62:\"Select what type of content you want to display as a 404 page.\";s:2:\"id\";s:16:\"404_content_type\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:0:\"\";s:45:\"Standard ( will display header and 404 word )\";s:11:\"pb_template\";s:22:\"Pagebuilder Smart Area\";}}i:348;a:8:{s:4:\"slug\";s:14:\"zn_404_options\";s:6:\"parent\";s:14:\"zn_404_options\";s:2:\"id\";s:14:\"404_smart_area\";s:4:\"name\";s:29:\"Select Pagebuilder Smart Area\";s:11:\"description\";s:99:\"Using this option you can select a pre-built template made at Admin > Pagebuilder Smart Areas page.\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:1:{s:0:\"\";s:25:\"-- Select a smart area --\";}s:10:\"dependency\";a:1:{i:0;a:2:{s:7:\"element\";s:16:\"404_content_type\";s:5:\"value\";a:1:{i:0;s:11:\"pb_template\";}}}}i:349;a:10:{s:4:\"slug\";s:14:\"zn_404_options\";s:6:\"parent\";s:14:\"zn_404_options\";s:4:\"name\";s:12:\"Header Style\";s:11:\"description\";s:150:\"Select the background style you want to use.Please note that the styles can be created from the \"Unlimited Headers\" options in the theme admin\'s page.\";s:2:\"id\";s:16:\"404_header_style\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:0;s:4:\"None\";s:19:\"zn_def_header_style\";s:13:\"Default style\";}s:5:\"class\";s:0:\"\";s:10:\"dependency\";a:1:{i:0;a:2:{s:7:\"element\";s:16:\"404_content_type\";s:5:\"value\";a:1:{i:0;s:0:\"\";}}}}i:350;a:7:{s:4:\"slug\";s:14:\"zn_404_options\";s:6:\"parent\";s:14:\"zn_404_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:11:\"zn404_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:351;a:7:{s:4:\"slug\";s:14:\"zn_404_options\";s:6:\"parent\";s:14:\"zn_404_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:352;a:7:{s:4:\"slug\";s:16:\"advanced_options\";s:6:\"parent\";s:16:\"advanced_options\";s:2:\"id\";s:13:\"font_uploader\";s:4:\"name\";s:18:\"Icon Font uploader\";s:11:\"description\";s:88:\"Please select a zip archive containing the font (generate it using http://fontello.com).\";s:4:\"type\";s:6:\"upload\";s:8:\"supports\";a:2:{s:14:\"file_extension\";s:3:\"zip\";s:9:\"file_type\";s:41:\"application/octet-stream, application/zip\";}}i:353;a:7:{s:4:\"slug\";s:16:\"advanced_options\";s:6:\"parent\";s:16:\"advanced_options\";s:2:\"id\";s:13:\"zn_refresh_pb\";s:4:\"name\";s:19:\"Clear Kallyas Cache\";s:11:\"description\";s:156:\"If you have made changes to the theme\'s page builder folder or files, you will need to press this button in order to refresh their css and folder structure.\";s:4:\"type\";s:12:\"zn_ajax_call\";s:15:\"ajax_call_setup\";a:2:{s:6:\"action\";s:13:\"zn_refresh_pb\";s:11:\"button_text\";s:19:\"Clear Kallyas Cache\";}}i:354;a:7:{s:4:\"slug\";s:16:\"advanced_options\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:10:\"advo_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:355;a:7:{s:4:\"slug\";s:16:\"advanced_options\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:201:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#F5bYMHBcHO0\" target=\"_blank\">Icon fonts uploader</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:356;a:7:{s:4:\"slug\";s:16:\"advanced_options\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:357;a:7:{s:4:\"slug\";s:10:\"custom_css\";s:6:\"parent\";s:16:\"advanced_options\";s:2:\"id\";s:10:\"custom_css\";s:4:\"name\";s:10:\"Custom css\";s:11:\"description\";s:66:\"Here you can enter your custom css that will be used by the theme.\";s:4:\"type\";s:10:\"custom_css\";s:5:\"class\";s:7:\"zn_full\";}i:358;a:7:{s:4:\"slug\";s:10:\"custom_css\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:15:\"adv_css_o_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:359;a:7:{s:4:\"slug\";s:10:\"custom_css\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:196:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#d4D9lAV8NEs\" target=\"_blank\">Add custom CSS</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:360;a:7:{s:4:\"slug\";s:10:\"custom_css\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:231:\"<span class=\"dashicons dashicons-format-aside u-v-mid\"></span> Written Documentation: <a href=\"https://my.hogash.com/documentation/adding-custom-css/\" target=\"_blank\">Click here to access documentation for this options section.</a>\";s:2:\"id\";s:9:\"docs_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:361;a:7:{s:4:\"slug\";s:10:\"custom_css\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}i:362;a:8:{s:4:\"slug\";s:9:\"custom_js\";s:6:\"parent\";s:16:\"advanced_options\";s:2:\"id\";s:9:\"custom_js\";s:4:\"name\";s:17:\"Custom Javascript\";s:11:\"description\";s:129:\"Here you can enter your custom javascript that will be added on all pages. <strong>Do NOT include &lt;SCRIPT&gt; tags</strong>!! \";s:4:\"type\";s:9:\"custom_js\";s:11:\"editor_type\";s:10:\"javascript\";s:5:\"class\";s:7:\"zn_full\";}i:363;a:7:{s:4:\"slug\";s:9:\"custom_js\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:59:\"<span class=\"dashicons dashicons-editor-help\"></span> HELP:\";s:11:\"description\";s:91:\"Below you can find quick access to documentation, video documentation or our support forum.\";s:2:\"id\";s:14:\"adv_js_o_title\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:55:\"zn_full zn-custom-title-md zn-top-separator zn-sep-dark\";}i:364;a:7:{s:4:\"slug\";s:19:\"theme_export_import\";s:6:\"parent\";s:16:\"advanced_options\";s:2:\"id\";s:19:\"theme_export_import\";s:4:\"name\";s:33:\"Import / Export the theme options\";s:11:\"description\";s:74:\"Here you can either import or export (Backup / Restore) the theme options.\";s:4:\"type\";s:19:\"theme_import_export\";s:5:\"class\";s:7:\"zn_full\";}i:365;a:7:{s:4:\"slug\";s:9:\"custom_js\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:195:\"<span class=\"dashicons dashicons-video-alt3 u-v-mid\"></span> Video Tutorials: <a href=\"https://my.hogash.com/video_category/kallyas-wordpress-theme/#DIvUKRBQ3BM\" target=\"_blank\">Add custom JS</a>\";s:2:\"id\";s:10:\"video_link\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:37:\"zn_full zn-admin-helplink zn_nomargin\";}i:366;a:7:{s:4:\"slug\";s:9:\"custom_js\";s:6:\"parent\";s:16:\"advanced_options\";s:4:\"name\";s:908:\"<a href=\"https://my.hogash.com/support/\" target=\"_blank\"  class=\"zn-helplink zn-helplink-support\">Support Dashboard</a> &nbsp; | &nbsp; <a href=\"https://my.hogash.com/docs/\" target=\"_blank\" class=\"zn-helplink zn-helplink-docs\">Kallyas Video Tutorials & Documentation</a> &nbsp; | &nbsp; <a href=\"https://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658\" target=\"_blank\" class=\"zn-helplink zn-helplink-rate stars-yellow\">Rate Kallyas <span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span><span class=\"dashicons dashicons-star-filled\"></span></a> <a class=\"zn-helplink zn-helplink-ratehelp\" href=\"http://hogash.d.pr/11vC3\" target=\"_blank\" data-tooltip=\"How to rate?\"><span class=\"dashicons dashicons-editor-help\"></span></a>\";s:2:\"id\";s:10:\"otherlinks\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:8:\"zn_title\";s:5:\"class\";s:56:\"zn_full zn-custom-title-sm zn_nomargin zn-admin-helplink\";}s:15:\"general_options\";a:127:{s:14:\"page_preloader\";s:2:\"no\";s:17:\"page_preloader_bg\";s:7:\"#ffffff\";s:18:\"page_preloader_img\";s:0:\"\";s:13:\"smooth_scroll\";s:2:\"no\";s:17:\"smooth_scroll_osx\";s:2:\"no\";s:13:\"head_position\";s:1:\"1\";s:12:\"header_style\";s:11:\"image_color\";s:18:\"header_style_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";a:2:{s:1:\"x\";s:6:\"center\";s:1:\"y\";s:6:\"center\";}}s:18:\"header_style_color\";s:19:\"rgba(255,255,255,0)\";s:18:\"header_text_scheme\";s:7:\"default\";s:25:\"sticky_header_style_color\";s:0:\"\";s:25:\"sticky_header_text_scheme\";s:7:\"default\";s:12:\"topbar_style\";s:7:\"default\";s:11:\"topbar_size\";s:7:\"default\";s:15:\"topbar_bg_color\";s:0:\"\";s:18:\"topbar_text_scheme\";s:7:\"default\";s:11:\"topbar_font\";a:1:{s:11:\"font-family\";s:0:\"\";}s:15:\"header_width_v2\";a:9:{s:11:\"breakpoints\";s:1:\"1\";s:2:\"lg\";s:4:\"1170\";s:7:\"unit_lg\";s:2:\"px\";s:2:\"md\";s:3:\"100\";s:7:\"unit_md\";s:1:\"%\";s:2:\"sm\";s:3:\"100\";s:7:\"unit_sm\";s:1:\"%\";s:2:\"xs\";s:3:\"100\";s:7:\"unit_xs\";s:1:\"%\";}s:18:\"zn_head_height_enb\";s:7:\"default\";s:14:\"zn_head_height\";s:0:\"\";s:19:\"zn_head_height_rows\";a:4:{s:3:\"top\";s:0:\"\";s:4:\"main\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:6:\"others\";s:1:\"0\";}s:20:\"top_offset_tolerance\";s:0:\"\";s:14:\"head_show_logo\";s:3:\"yes\";s:11:\"logo_upload\";s:64:\"https://modelox.vico.digital/wp-content/uploads/2017/09/logo.png\";s:9:\"logo_size\";s:3:\"yes\";s:16:\"logo_manual_size\";a:2:{s:5:\"width\";s:3:\"125\";s:6:\"height\";s:2:\"55\";}s:11:\"logo_sticky\";s:0:\"\";s:18:\"logo_upload_mobile\";s:0:\"\";s:9:\"logo_font\";a:6:{s:11:\"font-family\";s:0:\"\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"40px\";s:11:\"font-weight\";s:0:\"\";s:5:\"color\";s:4:\"#000\";s:10:\"font-style\";s:6:\"normal\";}s:10:\"logo_hover\";a:1:{s:5:\"color\";s:7:\"#CD2122\";}s:7:\"logo_bg\";s:0:\"\";s:23:\"infocard_display_status\";s:2:\"no\";s:17:\"infocard_bg_color\";s:7:\"#cd2122\";s:19:\"infocard_text_color\";s:7:\"#ffffff\";s:17:\"infocard_logo_url\";s:0:\"\";s:28:\"infocard_company_description\";s:71:\"Kallyas is an ultra-premium, responsive theme built for today websites.\";s:22:\"infocard_company_phone\";s:17:\"T (212) 555 55 00\";s:22:\"infocard_company_email\";s:21:\"sales@yourwebsite.com\";s:21:\"infocard_company_name\";s:16:\"Your Company LTD\";s:24:\"infocard_company_address\";s:35:\"Street nr 100, 4536534, Chicago, US\";s:18:\"infocard_gmap_link\";s:0:\"\";s:33:\"social_icons_info_card_visibility\";s:3:\"yes\";s:16:\"infocard_hoverme\";s:3:\"yes\";s:16:\"zn_header_layout\";s:7:\"style13\";s:11:\"menu_follow\";s:2:\"no\";s:15:\"head_show_flags\";s:1:\"0\";s:16:\"head_flags_style\";s:0:\"\";s:15:\"head_show_login\";s:1:\"0\";s:18:\"head_show_register\";s:1:\"0\";s:16:\"head_show_search\";s:2:\"no\";s:17:\"head_search_style\";s:0:\"\";s:18:\"zn_head_s7_toptext\";s:0:\"\";s:21:\"head_show_support_pnl\";s:3:\"yes\";s:25:\"hidden_panel_content_type\";s:6:\"widget\";s:24:\"hidden_panel_pb_template\";s:0:\"\";s:18:\"hidden_panel_title\";s:0:\"\";s:15:\"hidden_panel_bg\";s:7:\"#F0F0F0\";s:15:\"hidden_panel_fg\";s:7:\"#000000\";s:30:\"social_icons_visibility_status\";s:3:\"yes\";s:22:\"header_which_icons_set\";s:6:\"normal\";s:20:\"zn_header_resp_color\";s:7:\"#ff5969\";s:13:\"head_show_cta\";s:3:\"yes\";s:19:\"head_show_cta_style\";s:6:\"custom\";s:17:\"head_add_cta_link\";a:3:{s:3:\"url\";s:1:\"#\";s:6:\"target\";s:5:\"_self\";s:5:\"title\";s:0:\"\";}s:17:\"head_set_text_cta\";s:8:\"Shop Now\";s:15:\"wpk_cs_bg_color\";s:7:\"#ff5969\";s:15:\"wpk_cs_fg_color\";s:4:\"#fff\";s:11:\"cta_hide_xs\";s:14:\"zn_dummy_value\";s:8:\"cta_perm\";s:3:\"all\";s:10:\"cta_custom\";a:1:{i:0;a:13:{s:8:\"cta_text\";s:4:\"Shop\";s:8:\"cta_link\";a:3:{s:3:\"url\";s:34:\"https://modelox.vico.digital/shop/\";s:6:\"target\";s:5:\"_self\";s:5:\"title\";s:0:\"\";}s:9:\"cta_style\";s:30:\"btn-fullcolor btn-custom-color\";s:16:\"cta_custom_color\";s:7:\"#ff5969\";s:20:\"cta_custom_color_hov\";s:7:\"#ff3a4e\";s:8:\"cta_size\";s:0:\"\";s:11:\"cta_corners\";s:12:\"btn--rounded\";s:11:\"button_typo\";a:8:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:5:\"color\";s:7:\"#ffffff\";s:10:\"font-style\";s:0:\"\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}s:15:\"cta_icon_enable\";s:2:\"no\";s:12:\"cta_icon_pos\";s:6:\"before\";s:8:\"cta_icon\";a:2:{s:6:\"family\";s:0:\"\";s:7:\"unicode\";s:0:\"\";}s:8:\"cta_perm\";s:3:\"all\";s:11:\"cta_hide_xs\";s:14:\"zn_dummy_value\";}}s:15:\"nav_color_theme\";s:0:\"\";s:10:\"menu_style\";s:0:\"\";s:9:\"menu_font\";a:8:{s:11:\"font-family\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"14px\";s:11:\"font-weight\";s:3:\"700\";s:5:\"color\";s:0:\"\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";}s:16:\"menu_font_active\";s:7:\"#ff5969\";s:13:\"menu_font_sub\";a:7:{s:11:\"font-family\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"14px\";s:11:\"font-weight\";s:3:\"700\";s:5:\"color\";s:0:\"\";s:10:\"font-style\";s:6:\"normal\";s:14:\"text-transform\";s:0:\"\";}s:19:\"navmain_color_theme\";s:0:\"\";s:16:\"header_res_width\";s:3:\"992\";s:17:\"mobile_menu_theme\";s:5:\"light\";s:12:\"burger_style\";s:4:\"3--s\";s:11:\"burger_anim\";s:5:\"anim1\";s:12:\"burger_color\";s:0:\"\";s:19:\"burger_color_custom\";s:0:\"\";s:19:\"burger_color_sticky\";s:0:\"\";s:19:\"burger_color_mobile\";s:0:\"\";s:16:\"header_topnav_dd\";s:3:\"yes\";s:11:\"footer_show\";s:3:\"yes\";s:16:\"footer_row1_show\";s:3:\"yes\";s:28:\"footer_row1_widget_positions\";s:21:\"{\"3\":[[\"4\",\"4\",\"4\"]]}\";s:16:\"footer_row2_show\";s:3:\"yes\";s:28:\"footer_row2_widget_positions\";s:17:\"{\"2\":[[\"6\",\"6\"]]}\";s:12:\"footer_style\";s:7:\"default\";s:18:\"footer_style_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";a:2:{s:1:\"x\";s:6:\"center\";s:1:\"y\";s:6:\"center\";}}s:18:\"footer_style_color\";s:4:\"#000\";s:23:\"footer_border_color_top\";s:7:\"#FFFFFF\";s:19:\"footer_border_color\";s:7:\"#484848\";s:18:\"footer_top_padding\";s:2:\"60\";s:11:\"footer_logo\";s:0:\"\";s:14:\"copyright_text\";s:147:\"© 2015. All rights reserved. Buy <a href=\"http://themeforest.net/item/kallyas-responsive-multipurpose-wordpress-theme/4091658/\">Kallyas Theme</a>.\";s:26:\"footer_social_icons_enable\";s:3:\"yes\";s:22:\"footer_which_icons_set\";s:6:\"normal\";s:20:\"zn_disable_subheader\";s:2:\"no\";s:17:\"def_header_bg_new\";a:5:{s:5:\"image\";s:79:\"https://modelox.vico.digital/wp-content/uploads/2017/10/kallyas_placeholder.png\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";a:2:{s:1:\"x\";s:6:\"center\";s:1:\"y\";s:6:\"center\";}s:4:\"size\";s:5:\"cover\";}s:16:\"def_header_color\";s:7:\"#AAAAAA\";s:11:\"def_grad_bg\";s:1:\"0\";s:18:\"def_header_animate\";s:1:\"0\";s:9:\"def_glare\";s:1:\"0\";s:16:\"def_bottom_style\";s:4:\"none\";s:20:\"bottom_mask_bg_image\";a:5:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";a:2:{s:1:\"x\";s:6:\"center\";s:1:\"y\";s:6:\"center\";}s:4:\"size\";s:5:\"cover\";}s:21:\"bottom_mask_bg_height\";s:3:\"100\";s:19:\"def_bottom_style_bg\";s:0:\"\";s:16:\"def_header_bread\";s:1:\"0\";s:18:\"def_subh_bread_stl\";s:5:\"black\";s:15:\"def_header_date\";s:1:\"0\";s:23:\"def_subheader_alignment\";s:6:\"center\";s:18:\"def_subh_textcolor\";s:5:\"light\";s:24:\"def_header_custom_height\";s:3:\"380\";s:22:\"def_header_top_padding\";s:3:\"240\";s:16:\"google_analytics\";s:0:\"\";s:15:\"google_maps_key\";s:0:\"\";s:13:\"mailchimp_api\";s:0:\"\";s:16:\"mailchimp_secure\";s:14:\"zn_dummy_value\";s:9:\"rec_theme\";s:5:\"light\";s:11:\"rec_pub_key\";s:0:\"\";s:12:\"rec_priv_key\";s:0:\"\";s:18:\"recaptcha_register\";s:2:\"no\";s:14:\"recaptcha_lang\";s:2:\"en\";s:15:\"zn_option_field\";s:15:\"general_options\";}s:22:\"zn_woocommerce_options\";a:28:{s:16:\"woo_catalog_mode\";s:2:\"no\";s:21:\"show_cart_to_visitors\";s:3:\"yes\";s:20:\"woo_site_search_type\";s:2:\"wp\";s:29:\"woo_single_product_smart_area\";s:11:\"no_template\";s:14:\"woo_sub_header\";s:19:\"zn_def_header_style\";s:19:\"woo_arch_page_title\";s:12:\"OUR PRODUCTS\";s:22:\"woo_arch_page_subtitle\";s:36:\"Shop category here with product list\";s:19:\"woo_hide_small_desc\";s:2:\"no\";s:26:\"woo_show_products_per_page\";s:1:\"9\";s:15:\"woo_num_columns\";s:1:\"3\";s:19:\"zn_use_second_image\";s:3:\"yes\";s:16:\"woo_img_lazyload\";s:2:\"no\";s:15:\"woo_prod_layout\";s:7:\"classic\";s:18:\"woo_cat_image_size\";a:2:{s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"566\";}s:20:\"woo_prod_page_layout\";s:7:\"classic\";s:29:\"zn_override_single_shop_title\";s:14:\"zn_dummy_value\";s:22:\"single_shop_page_title\";s:4:\"Shop\";s:20:\"zn_woo_enable_slider\";s:2:\"no\";s:18:\"zn_woo_enable_zoom\";s:2:\"no\";s:13:\"woo_show_cart\";s:1:\"1\";s:14:\"woo_cart_style\";s:6:\"style2\";s:16:\"woo_pages_layout\";s:7:\"classic\";s:13:\"woo_new_badge\";s:1:\"1\";s:18:\"woo_new_badge_days\";s:1:\"3\";s:14:\"woo_sale_badge\";s:1:\"1\";s:28:\"woo_show_sale_flash_discount\";s:2:\"no\";s:17:\"woo_soldout_badge\";s:2:\"no\";s:15:\"zn_option_field\";s:22:\"zn_woocommerce_options\";}s:16:\"advanced_options\";a:1:{s:15:\"zn_option_field\";s:16:\"advanced_options\";}s:19:\"google_font_options\";a:2:{s:21:\"zn_google_fonts_setup\";a:4:{s:6:\"Roboto\";a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:13:\"font_variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";i:3;s:3:\"900\";}}s:9:\"Open+Sans\";a:1:{s:11:\"font_family\";s:9:\"Open Sans\";}s:16:\"Playfair+Display\";a:1:{s:11:\"font_family\";s:16:\"Playfair Display\";}s:5:\"Prata\";a:1:{s:11:\"font_family\";s:5:\"Prata\";}}s:15:\"zn_option_field\";s:19:\"google_font_options\";}s:13:\"color_options\";a:14:{s:13:\"zn_main_color\";s:7:\"#ff5969\";s:22:\"zn_main_color_contrast\";s:4:\"#fff\";s:13:\"zn_main_style\";s:5:\"light\";s:21:\"zn_body_def_textcolor\";s:0:\"\";s:22:\"zn_body_def_linkscolor\";s:0:\"\";s:26:\"zn_body_def_linkscolor_hov\";s:0:\"\";s:26:\"zn_body_def_textcolor_dark\";s:7:\"#dcdcdc\";s:27:\"zn_body_def_linkscolor_dark\";s:7:\"#ffffff\";s:31:\"zn_body_def_linkscolor_hov_dark\";s:4:\"#eee\";s:17:\"zn_body_def_color\";s:7:\"#ffffff\";s:15:\"body_back_image\";a:5:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:6:\"scroll\";s:8:\"position\";a:2:{s:1:\"x\";s:6:\"center\";s:1:\"y\";s:6:\"center\";}s:4:\"size\";s:5:\"cover\";}s:16:\"zn_top_nav_color\";s:0:\"\";s:18:\"zn_top_nav_h_color\";s:0:\"\";s:15:\"zn_option_field\";s:13:\"color_options\";}s:10:\"pb_layouts\";a:7:{s:14:\"pbtmpl_general\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:6:\"before\";s:18:\"subheader_template\";s:11:\"no_template\";s:15:\"footer_location\";s:7:\"replace\";s:15:\"footer_template\";i:142;}s:11:\"pbtmpl_post\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:0:\"\";s:18:\"subheader_template\";s:0:\"\";s:15:\"footer_location\";s:0:\"\";s:15:\"footer_template\";s:0:\"\";}s:16:\"pbtmpl_portfolio\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:0:\"\";s:18:\"subheader_template\";s:0:\"\";s:15:\"footer_location\";s:0:\"\";s:15:\"footer_template\";s:0:\"\";}s:14:\"pbtmpl_product\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:0:\"\";s:18:\"subheader_template\";s:0:\"\";s:15:\"footer_location\";s:0:\"\";s:15:\"footer_template\";s:0:\"\";}s:15:\"pbtmpl_category\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:0:\"\";s:18:\"subheader_template\";s:0:\"\";s:15:\"footer_location\";s:0:\"\";s:15:\"footer_template\";s:0:\"\";}s:18:\"pbtmpl_product_cat\";a:6:{s:15:\"header_location\";s:6:\"before\";s:15:\"header_template\";s:11:\"no_template\";s:18:\"subheader_location\";s:0:\"\";s:18:\"subheader_template\";s:0:\"\";s:15:\"footer_location\";s:0:\"\";s:15:\"footer_template\";s:0:\"\";}s:15:\"zn_option_field\";s:10:\"pb_layouts\";}s:18:\"unlimited_sidebars\";a:8:{s:12:\"sidebar_size\";s:1:\"3\";s:15:\"archive_sidebar\";a:2:{s:6:\"layout\";s:10:\"no_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:12:\"blog_sidebar\";a:2:{s:6:\"layout\";s:10:\"no_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:14:\"single_sidebar\";a:2:{s:6:\"layout\";s:10:\"no_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:12:\"page_sidebar\";a:2:{s:6:\"layout\";s:10:\"no_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:19:\"woo_archive_sidebar\";a:2:{s:6:\"layout\";s:10:\"no_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:18:\"woo_single_sidebar\";a:2:{s:6:\"layout\";s:13:\"right_sidebar\";s:7:\"sidebar\";s:14:\"defaultsidebar\";}s:15:\"zn_option_field\";s:18:\"unlimited_sidebars\";}s:12:\"font_options\";a:11:{s:7:\"h1_typo\";a:5:{s:11:\"font-family\";s:5:\"Prata\";s:9:\"font-size\";s:4:\"36px\";s:11:\"line-height\";s:4:\"40px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:10:\"h1_pgtitle\";s:14:\"zn_dummy_value\";s:7:\"h2_typo\";a:5:{s:11:\"font-family\";s:5:\"Prata\";s:9:\"font-size\";s:4:\"30px\";s:11:\"line-height\";s:4:\"40px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:7:\"h3_typo\";a:5:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:4:\"40px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:7:\"h4_typo\";a:5:{s:11:\"font-family\";s:5:\"Prata\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"20px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:7:\"h5_typo\";a:5:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"20px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:7:\"h6_typo\";a:5:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"20px\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:6:\"normal\";}s:9:\"body_font\";a:4:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:11:\"footer_font\";a:4:{s:11:\"font-family\";s:9:\"Open Sans\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:16:\"alternative_font\";a:1:{s:11:\"font-family\";s:0:\"\";}s:15:\"zn_option_field\";s:12:\"font_options\";}}', 'yes'),
 (162, 'znb_css_compiled', '1', 'yes'),
 (163, 'kallyas_version', '4.17.5', 'no'),
 (164, 'znhgtfw_first_install_kallyas', '1', 'no'),
 (290, 'revslider-library-check', '1597070494', 'yes'),
 (291, 'revslider-library-hash', '182cddf4eb7341b26304629033cbbb48', 'yes'),
 (292, 'rs-library', 'a:3:{s:4:\"hash\";s:32:\"182cddf4eb7341b26304629033cbbb48\";s:7:\"objects\";a:417:{i:529;a:14:{s:2:\"id\";s:3:\"529\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:528;a:14:{s:2:\"id\";s:3:\"528\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:527;a:14:{s:2:\"id\";s:3:\"527\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:526;a:14:{s:2:\"id\";s:3:\"526\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:525;a:14:{s:2:\"id\";s:3:\"525\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";}i:524;a:14:{s:2:\"id\";s:3:\"524\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:523;a:14:{s:2:\"id\";s:3:\"523\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:522;a:14:{s:2:\"id\";s:3:\"522\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:521;a:14:{s:2:\"id\";s:3:\"521\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";}i:520;a:14:{s:2:\"id\";s:3:\"520\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:519;a:14:{s:2:\"id\";s:3:\"519\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:518;a:14:{s:2:\"id\";s:3:\"518\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:517;a:14:{s:2:\"id\";s:3:\"517\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:516;a:14:{s:2:\"id\";s:3:\"516\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";}i:515;a:14:{s:2:\"id\";s:3:\"515\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:514;a:14:{s:2:\"id\";s:3:\"514\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:513;a:14:{s:2:\"id\";s:3:\"513\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:512;a:14:{s:2:\"id\";s:3:\"512\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:511;a:14:{s:2:\"id\";s:3:\"511\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:510;a:14:{s:2:\"id\";s:3:\"510\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:509;a:14:{s:2:\"id\";s:3:\"509\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:508;a:14:{s:2:\"id\";s:3:\"508\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:507;a:14:{s:2:\"id\";s:3:\"507\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:506;a:14:{s:2:\"id\";s:3:\"506\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";}i:505;a:14:{s:2:\"id\";s:3:\"505\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:504;a:14:{s:2:\"id\";s:3:\"504\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:503;a:14:{s:2:\"id\";s:3:\"503\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:502;a:14:{s:2:\"id\";s:3:\"502\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";}i:501;a:14:{s:2:\"id\";s:3:\"501\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:500;a:14:{s:2:\"id\";s:3:\"500\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:499;a:14:{s:2:\"id\";s:3:\"499\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:498;a:14:{s:2:\"id\";s:3:\"498\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:497;a:14:{s:2:\"id\";s:3:\"497\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";}i:496;a:14:{s:2:\"id\";s:3:\"496\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:495;a:14:{s:2:\"id\";s:3:\"495\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:494;a:14:{s:2:\"id\";s:3:\"494\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:493;a:14:{s:2:\"id\";s:3:\"493\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:492;a:14:{s:2:\"id\";s:3:\"492\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";}i:491;a:14:{s:2:\"id\";s:3:\"491\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:490;a:14:{s:2:\"id\";s:3:\"490\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:489;a:14:{s:2:\"id\";s:3:\"489\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:488;a:14:{s:2:\"id\";s:3:\"488\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";}i:487;a:14:{s:2:\"id\";s:3:\"487\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:486;a:14:{s:2:\"id\";s:3:\"486\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:485;a:14:{s:2:\"id\";s:3:\"485\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:484;a:14:{s:2:\"id\";s:3:\"484\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:483;a:14:{s:2:\"id\";s:3:\"483\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:482;a:14:{s:2:\"id\";s:3:\"482\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:481;a:14:{s:2:\"id\";s:3:\"481\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:480;a:14:{s:2:\"id\";s:3:\"480\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";}i:479;a:13:{s:2:\"id\";s:3:\"479\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";}i:478;a:13:{s:2:\"id\";s:3:\"478\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";}i:477;a:13:{s:2:\"id\";s:3:\"477\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";}i:476;a:13:{s:2:\"id\";s:3:\"476\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:475;a:13:{s:2:\"id\";s:3:\"475\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:474;a:13:{s:2:\"id\";s:3:\"474\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:473;a:13:{s:2:\"id\";s:3:\"473\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:472;a:13:{s:2:\"id\";s:3:\"472\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";}i:471;a:13:{s:2:\"id\";s:3:\"471\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:470;a:13:{s:2:\"id\";s:3:\"470\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:469;a:13:{s:2:\"id\";s:3:\"469\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:468;a:13:{s:2:\"id\";s:3:\"468\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:467;a:13:{s:2:\"id\";s:3:\"467\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:466;a:13:{s:2:\"id\";s:3:\"466\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:465;a:13:{s:2:\"id\";s:3:\"465\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:464;a:13:{s:2:\"id\";s:3:\"464\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:463;a:13:{s:2:\"id\";s:3:\"463\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:462;a:13:{s:2:\"id\";s:3:\"462\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:461;a:13:{s:2:\"id\";s:3:\"461\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:460;a:13:{s:2:\"id\";s:3:\"460\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:459;a:13:{s:2:\"id\";s:3:\"459\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:458;a:13:{s:2:\"id\";s:3:\"458\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:457;a:13:{s:2:\"id\";s:3:\"457\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:456;a:13:{s:2:\"id\";s:3:\"456\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:455;a:13:{s:2:\"id\";s:3:\"455\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:454;a:13:{s:2:\"id\";s:3:\"454\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:453;a:13:{s:2:\"id\";s:3:\"453\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:452;a:13:{s:2:\"id\";s:3:\"452\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:451;a:13:{s:2:\"id\";s:3:\"451\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:450;a:13:{s:2:\"id\";s:3:\"450\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:449;a:13:{s:2:\"id\";s:3:\"449\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:448;a:13:{s:2:\"id\";s:3:\"448\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";}i:447;a:13:{s:2:\"id\";s:3:\"447\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:446;a:13:{s:2:\"id\";s:3:\"446\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:445;a:13:{s:2:\"id\";s:3:\"445\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:444;a:13:{s:2:\"id\";s:3:\"444\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:443;a:13:{s:2:\"id\";s:3:\"443\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:442;a:13:{s:2:\"id\";s:3:\"442\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:441;a:13:{s:2:\"id\";s:3:\"441\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:440;a:13:{s:2:\"id\";s:3:\"440\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:439;a:13:{s:2:\"id\";s:3:\"439\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:438;a:13:{s:2:\"id\";s:3:\"438\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:437;a:13:{s:2:\"id\";s:3:\"437\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:436;a:13:{s:2:\"id\";s:3:\"436\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:435;a:13:{s:2:\"id\";s:3:\"435\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:434;a:13:{s:2:\"id\";s:3:\"434\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:433;a:13:{s:2:\"id\";s:3:\"433\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:432;a:13:{s:2:\"id\";s:3:\"432\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:431;a:13:{s:2:\"id\";s:3:\"431\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:430;a:13:{s:2:\"id\";s:3:\"430\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:429;a:13:{s:2:\"id\";s:3:\"429\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:428;a:13:{s:2:\"id\";s:3:\"428\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:427;a:13:{s:2:\"id\";s:3:\"427\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:426;a:13:{s:2:\"id\";s:3:\"426\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:425;a:13:{s:2:\"id\";s:3:\"425\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:424;a:13:{s:2:\"id\";s:3:\"424\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:423;a:13:{s:2:\"id\";s:3:\"423\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";}i:422;a:13:{s:2:\"id\";s:3:\"422\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:421;a:13:{s:2:\"id\";s:3:\"421\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:420;a:13:{s:2:\"id\";s:3:\"420\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:419;a:13:{s:2:\"id\";s:3:\"419\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:418;a:13:{s:2:\"id\";s:3:\"418\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:417;a:13:{s:2:\"id\";s:3:\"417\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:416;a:13:{s:2:\"id\";s:3:\"416\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:415;a:13:{s:2:\"id\";s:3:\"415\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:414;a:13:{s:2:\"id\";s:3:\"414\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:413;a:13:{s:2:\"id\";s:3:\"413\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:412;a:13:{s:2:\"id\";s:3:\"412\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:411;a:13:{s:2:\"id\";s:3:\"411\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:410;a:13:{s:2:\"id\";s:3:\"410\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:409;a:13:{s:2:\"id\";s:3:\"409\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:408;a:13:{s:2:\"id\";s:3:\"408\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";}i:407;a:13:{s:2:\"id\";s:3:\"407\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:406;a:13:{s:2:\"id\";s:3:\"406\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:405;a:13:{s:2:\"id\";s:3:\"405\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:404;a:13:{s:2:\"id\";s:3:\"404\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:403;a:13:{s:2:\"id\";s:3:\"403\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:402;a:13:{s:2:\"id\";s:3:\"402\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:401;a:13:{s:2:\"id\";s:3:\"401\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:400;a:13:{s:2:\"id\";s:3:\"400\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:399;a:13:{s:2:\"id\";s:3:\"399\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:398;a:13:{s:2:\"id\";s:3:\"398\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:397;a:13:{s:2:\"id\";s:3:\"397\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:396;a:13:{s:2:\"id\";s:3:\"396\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:395;a:13:{s:2:\"id\";s:3:\"395\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:394;a:13:{s:2:\"id\";s:3:\"394\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:393;a:13:{s:2:\"id\";s:3:\"393\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:392;a:13:{s:2:\"id\";s:3:\"392\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:391;a:13:{s:2:\"id\";s:3:\"391\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:390;a:13:{s:2:\"id\";s:3:\"390\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";}i:389;a:13:{s:2:\"id\";s:3:\"389\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:388;a:13:{s:2:\"id\";s:3:\"388\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:387;a:13:{s:2:\"id\";s:3:\"387\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:386;a:13:{s:2:\"id\";s:3:\"386\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:385;a:13:{s:2:\"id\";s:3:\"385\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:384;a:13:{s:2:\"id\";s:3:\"384\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:383;a:13:{s:2:\"id\";s:3:\"383\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:382;a:13:{s:2:\"id\";s:3:\"382\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:381;a:13:{s:2:\"id\";s:3:\"381\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:380;a:13:{s:2:\"id\";s:3:\"380\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:379;a:13:{s:2:\"id\";s:3:\"379\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:378;a:13:{s:2:\"id\";s:3:\"378\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";}i:377;a:13:{s:2:\"id\";s:3:\"377\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:376;a:13:{s:2:\"id\";s:3:\"376\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:375;a:13:{s:2:\"id\";s:3:\"375\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:374;a:13:{s:2:\"id\";s:3:\"374\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:373;a:13:{s:2:\"id\";s:3:\"373\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:372;a:13:{s:2:\"id\";s:3:\"372\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:371;a:13:{s:2:\"id\";s:3:\"371\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:370;a:13:{s:2:\"id\";s:3:\"370\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:369;a:13:{s:2:\"id\";s:3:\"369\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:368;a:13:{s:2:\"id\";s:3:\"368\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:367;a:13:{s:2:\"id\";s:3:\"367\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:366;a:13:{s:2:\"id\";s:3:\"366\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:365;a:13:{s:2:\"id\";s:3:\"365\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:364;a:13:{s:2:\"id\";s:3:\"364\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:363;a:13:{s:2:\"id\";s:3:\"363\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:362;a:13:{s:2:\"id\";s:3:\"362\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:361;a:13:{s:2:\"id\";s:3:\"361\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:360;a:13:{s:2:\"id\";s:3:\"360\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:359;a:13:{s:2:\"id\";s:3:\"359\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:358;a:13:{s:2:\"id\";s:3:\"358\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:357;a:13:{s:2:\"id\";s:3:\"357\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:356;a:13:{s:2:\"id\";s:3:\"356\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:355;a:13:{s:2:\"id\";s:3:\"355\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";}i:354;a:13:{s:2:\"id\";s:3:\"354\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:353;a:13:{s:2:\"id\";s:3:\"353\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:352;a:13:{s:2:\"id\";s:3:\"352\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:351;a:13:{s:2:\"id\";s:3:\"351\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:350;a:13:{s:2:\"id\";s:3:\"350\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:349;a:13:{s:2:\"id\";s:3:\"349\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:348;a:13:{s:2:\"id\";s:3:\"348\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:347;a:13:{s:2:\"id\";s:3:\"347\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:346;a:13:{s:2:\"id\";s:3:\"346\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:345;a:13:{s:2:\"id\";s:3:\"345\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:344;a:13:{s:2:\"id\";s:3:\"344\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:343;a:13:{s:2:\"id\";s:3:\"343\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:342;a:13:{s:2:\"id\";s:3:\"342\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:341;a:13:{s:2:\"id\";s:3:\"341\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:340;a:13:{s:2:\"id\";s:3:\"340\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";}i:339;a:13:{s:2:\"id\";s:3:\"339\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:337;a:13:{s:2:\"id\";s:3:\"337\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:336;a:13:{s:2:\"id\";s:3:\"336\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:335;a:13:{s:2:\"id\";s:3:\"335\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";}i:334;a:13:{s:2:\"id\";s:3:\"334\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:333;a:13:{s:2:\"id\";s:3:\"333\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:332;a:13:{s:2:\"id\";s:3:\"332\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:331;a:13:{s:2:\"id\";s:3:\"331\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:330;a:13:{s:2:\"id\";s:3:\"330\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:329;a:13:{s:2:\"id\";s:3:\"329\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";}i:328;a:13:{s:2:\"id\";s:3:\"328\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";}i:327;a:13:{s:2:\"id\";s:3:\"327\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:326;a:13:{s:2:\"id\";s:3:\"326\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:325;a:13:{s:2:\"id\";s:3:\"325\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:324;a:13:{s:2:\"id\";s:3:\"324\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:322;a:13:{s:2:\"id\";s:3:\"322\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:321;a:13:{s:2:\"id\";s:3:\"321\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";}i:320;a:13:{s:2:\"id\";s:3:\"320\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:319;a:13:{s:2:\"id\";s:3:\"319\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:318;a:13:{s:2:\"id\";s:3:\"318\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:317;a:13:{s:2:\"id\";s:3:\"317\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:316;a:13:{s:2:\"id\";s:3:\"316\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:315;a:13:{s:2:\"id\";s:3:\"315\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:314;a:13:{s:2:\"id\";s:3:\"314\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:313;a:13:{s:2:\"id\";s:3:\"313\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";}i:312;a:13:{s:2:\"id\";s:3:\"312\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";}i:311;a:13:{s:2:\"id\";s:3:\"311\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:310;a:13:{s:2:\"id\";s:3:\"310\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:309;a:13:{s:2:\"id\";s:3:\"309\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:308;a:13:{s:2:\"id\";s:3:\"308\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:307;a:13:{s:2:\"id\";s:3:\"307\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:306;a:13:{s:2:\"id\";s:3:\"306\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:305;a:13:{s:2:\"id\";s:3:\"305\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:304;a:13:{s:2:\"id\";s:3:\"304\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:303;a:13:{s:2:\"id\";s:3:\"303\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:302;a:13:{s:2:\"id\";s:3:\"302\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:301;a:13:{s:2:\"id\";s:3:\"301\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:300;a:13:{s:2:\"id\";s:3:\"300\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:299;a:13:{s:2:\"id\";s:3:\"299\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:298;a:13:{s:2:\"id\";s:3:\"298\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:297;a:13:{s:2:\"id\";s:3:\"297\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:296;a:13:{s:2:\"id\";s:3:\"296\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:295;a:13:{s:2:\"id\";s:3:\"295\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:294;a:13:{s:2:\"id\";s:3:\"294\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:293;a:13:{s:2:\"id\";s:3:\"293\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:292;a:13:{s:2:\"id\";s:3:\"292\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:291;a:13:{s:2:\"id\";s:3:\"291\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:290;a:13:{s:2:\"id\";s:3:\"290\";s:4:\"type\";s:1:\"4\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";}i:238;a:14:{s:2:\"id\";s:3:\"238\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:237;a:14:{s:2:\"id\";s:3:\"237\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";s:3:\"236\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:235;a:14:{s:2:\"id\";s:3:\"235\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:234;a:14:{s:2:\"id\";s:3:\"234\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:233;a:14:{s:2:\"id\";s:3:\"233\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:232;a:14:{s:2:\"id\";s:3:\"232\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:231;a:14:{s:2:\"id\";s:3:\"231\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:230;a:14:{s:2:\"id\";s:3:\"230\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:229;a:14:{s:2:\"id\";s:3:\"229\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:198;a:13:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:13:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:13:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:13:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:13:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:13:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:13:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:13:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:13:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:13:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:13:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:13:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:13:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:13:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:13:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:13:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:13:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:13:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:13:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:13:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:13:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:13:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:13:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:13:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:13:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:13:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:13:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:13:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:13:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:13:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:13:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:13:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:13:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:13:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:13:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:13:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:13:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:13:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:13:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:13:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:13:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:13:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:13:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:13:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:13:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:13:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:13:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:13:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:13:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:13:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:13:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:13:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:13:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:13:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:13:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:13:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:13:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:13:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:13:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:13:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:13:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:13:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:13:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:13:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:14:\"plugin_version\";s:0:\"\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:13:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:14:\"plugin_version\";s:0:\"\";s:7:\